#!/bin/bash

echo "================================"
echo "Verifying TransactionController"
echo "================================"

# Check if CONCAT is in the file
echo "Checking for CONCAT in TransactionController..."
grep -n "CONCAT(transaction_date" app/Http/Controllers/Api/TransactionController.php

echo ""
echo "================================"
echo "Clearing ALL caches"
echo "================================"

# Clear all possible caches
php artisan config:clear
php artisan cache:clear
php artisan route:clear
php artisan view:clear
php artisan optimize:clear

# Clear OPcache if available
php -r "if (function_exists('opcache_reset')) { opcache_reset(); echo 'OPcache cleared'; } else { echo 'OPcache not available'; }"

echo ""
echo "================================"
echo "Restarting services"
echo "================================"

# Try to restart PHP-FPM (adjust version as needed)
if command -v systemctl &> /dev/null; then
    echo "Attempting to restart PHP-FPM..."
    sudo systemctl restart php8.2-fpm 2>/dev/null || sudo systemctl restart php8.1-fpm 2>/dev/null || sudo systemctl restart php-fpm 2>/dev/null || echo "Could not restart PHP-FPM automatically"
fi

# Try to restart Apache/Nginx
if command -v systemctl &> /dev/null; then
    echo "Attempting to restart web server..."
    sudo systemctl restart apache2 2>/dev/null || sudo systemctl restart nginx 2>/dev/null || echo "Could not restart web server automatically"
fi

echo ""
echo "================================"
echo "Done! Try accessing the API now"
echo "================================"


