<?php

require_once 'vendor/autoload.php';

use Illuminate\Support\Facades\DB;
use App\Models\User;

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "Toggle Currency Rate Access\n";
echo "==========================\n\n";

// Get command line arguments
$args = $argv ?? [];
$userId = $args[1] ?? null;
$action = $args[2] ?? null;

if (!$userId || !$action) {
    echo "Usage: php toggle_currency_access.php [USER_ID] [enable|disable]\n\n";
    
    // Show available users
    $users = User::all();
    if ($users->count() > 0) {
        echo "Available users:\n";
        foreach ($users as $user) {
            echo "ID: {$user->id}, Name: {$user->name}, Email: {$user->email}\n";
        }
    }
    exit(1);
}

$user = User::find($userId);
if (!$user) {
    echo "User with ID {$userId} not found.\n";
    exit(1);
}

$newValue = $action === 'enable' ? true : false;
$user->currency_rate_access = $newValue;
$user->save();

echo "Successfully " . ($action === 'enable' ? 'enabled' : 'disabled') . " currency rate access for user:\n";
echo "ID: {$user->id}\n";
echo "Name: {$user->name}\n";
echo "Email: {$user->email}\n";
echo "Currency Rate Access: " . ($user->currency_rate_access ? 'ENABLED' : 'DISABLED') . "\n\n";

echo "You can now test the mobile app with this user.\n";

