<?php

/**
 * Test Script for OneSignal User ID as External ID Implementation
 * This script tests that notifications are sent using user ID directly as External ID
 */

// Configuration - Update these with your actual values
$baseUrl = 'https://LA DERMA.innovation-pulsehub.com/api/mobile';
$testEmail = 'test@example.com'; // Replace with actual test email
$testPassword = 'password123'; // Replace with actual test password

// Function to make API requests
function makeApiRequest($url, $method = 'GET', $data = null, $token = null) {
    $ch = curl_init();
    
    $headers = [
        'Content-Type': 'application/json',
        'Accept: application/json'
    ];
    
    if ($token) {
        $headers[] = 'Authorization: Bearer ' . $token;
    }
    
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    if ($method === 'POST') {
        curl_setopt($ch, CURLOPT_POST, true);
        if ($data) {
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        }
    }
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    return [
        'status_code' => $httpCode,
        'body' => json_decode($response, true),
        'raw_body' => $response
    ];
}

echo "🧪 Testing OneSignal User ID as External ID Implementation\n";
echo "========================================================\n\n";

// Step 1: Login to get authentication token
echo "1️⃣ Testing Login...\n";
$loginData = [
    'email' => $testEmail,
    'password' => $testPassword
];

$loginResponse = makeApiRequest($baseUrl . '/login', 'POST', $loginData);

if ($loginResponse['status_code'] === 200 && isset($loginResponse['body']['data']['token'])) {
    $token = $loginResponse['body']['data']['token'];
    $userId = $loginResponse['body']['data']['user']['id'];
    echo "✅ Login successful! User ID: $userId\n";
    echo "🔑 Token: " . substr($token, 0, 20) . "...\n\n";
} else {
    echo "❌ Login failed!\n";
    echo "Status: " . $loginResponse['status_code'] . "\n";
    echo "Response: " . $loginResponse['raw_body'] . "\n";
    echo "\n💡 Please update the test credentials in this script:\n";
    echo "   - \$testEmail = 'your-actual-email@example.com'\n";
    echo "   - \$testPassword = 'your-actual-password'\n\n";
    exit(1);
}

// Step 2: Send Test Notification (using user ID as External ID)
echo "2️⃣ Testing Notification Sending (User ID as External ID)...\n";
echo "📱 User ID: $userId (this will be used as External ID in OneSignal)\n";

$testNotificationResponse = makeApiRequest($baseUrl . '/onesignal/test', 'POST', null, $token);

if ($testNotificationResponse['status_code'] === 200 && $testNotificationResponse['body']['success']) {
    echo "✅ Test notification sent successfully!\n";
    echo "📨 Notification sent using User ID $userId as External ID\n";
    echo "📊 Recipients: " . ($testNotificationResponse['body']['data']['recipients'] ?? 'Unknown') . "\n";
    echo "🔍 Response data: " . json_encode($testNotificationResponse['body']['data'], JSON_PRETTY_PRINT) . "\n\n";
} else {
    echo "❌ Test notification failed!\n";
    echo "Status: " . $testNotificationResponse['status_code'] . "\n";
    echo "Response: " . $testNotificationResponse['raw_body'] . "\n";
}

echo "🎉 Testing completed!\n";
echo "====================\n\n";

echo "📋 Summary:\n";
echo "- Login: " . ($loginResponse['status_code'] === 200 ? "✅ Success" : "❌ Failed") . "\n";
echo "- Test Notification: " . ($testNotificationResponse['status_code'] === 200 ? "✅ Success" : "❌ Failed") . "\n";

echo "\n💡 Key Points:\n";
echo "✅ User ID and External ID are the same in OneSignal\n";
echo "✅ No need to store separate External ID in database\n";
echo "✅ Notifications sent using user ID directly\n";
echo "✅ Simpler and more reliable approach\n";

echo "\n🔧 Implementation Status:\n";
echo "✅ OneSignal Service: Updated to use user ID directly\n";
echo "✅ OneSignal Controller: Updated to use user ID directly\n";
echo "✅ Transaction Notifications: Updated to use user ID directly\n";
echo "✅ Flutter App: Updated to send user ID as External ID\n";

?>


