<?php

echo "🔍 Testing OneSignal with Real Player ID\n";
echo "======================================\n\n";

$appId = '737941d8-27b3-49b6-82f7-fd46ab10fd74';
$restApiKey = 'YOUR_NEW_REST_API_KEY'; // Replace with your actual new key

// Using the real player ID from your database
$realPlayerId = '30a509fb-2bdb-4934-b74d-2d0a07072fd3';

echo "App ID: {$appId}\n";
echo "REST API Key: " . substr($restApiKey, 0, 10) . "...\n";
echo "Player ID: {$realPlayerId}\n";
echo "User: mohammed salm\n\n";

// Test 1: Check player status in OneSignal
echo "1. Checking player status in OneSignal...\n";

$url = "https://onesignal.com/api/v1/players/{$realPlayerId}?app_id={$appId}";
$headers = [
    'Authorization: Basic ' . $restApiKey,
    'Content-Type: application/json'
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "   ❌ cURL Error: {$error}\n";
} else {
    echo "   HTTP Code: {$httpCode}\n";
    if ($httpCode === 200) {
        $data = json_decode($response, true);
        echo "   ✅ Player found in OneSignal!\n";
        echo "   Device Type: " . ($data['device_type'] ?? 'Unknown') . "\n";
        echo "   Subscribed: " . ($data['invalid_identifier'] ? 'No' : 'Yes') . "\n";
        echo "   Last Active: " . ($data['last_active'] ?? 'Unknown') . "\n";
    } else {
        echo "   ❌ Player not found in OneSignal!\n";
        echo "   Response: {$response}\n";
    }
}

echo "\n";

// Test 2: Send notification
echo "2. Testing notification send...\n";

$url = "https://onesignal.com/api/v1/notifications";
$payload = [
    'app_id' => $appId,
    'include_player_ids' => [$realPlayerId],
    'contents' => ['en' => 'Test notification from Laravel - ' . date('Y-m-d H:i:s')],
    'data' => ['type' => 'test']
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "   ❌ cURL Error: {$error}\n";
} else {
    echo "   HTTP Code: {$httpCode}\n";
    if ($httpCode === 200) {
        $data = json_decode($response, true);
        if (isset($data['errors'])) {
            echo "   ❌ OneSignal Errors:\n";
            foreach ($data['errors'] as $error) {
                echo "      - {$error}\n";
            }
        } else {
            echo "   ✅ Success! Notification sent!\n";
            echo "   Notification ID: " . ($data['id'] ?? 'Unknown') . "\n";
            echo "   Recipients: " . ($data['recipients'] ?? 'Unknown') . "\n";
        }
    } else {
        echo "   ❌ Failed! Response: {$response}\n";
    }
}

echo "\n✅ Test completed!\n";


