<?php

echo "🔍 Testing OneSignal with Real Player ID\n";
echo "======================================\n\n";

$appId = '737941d8-27b3-49b6-82f7-fd46ab10fd74';
$restApiKey = 'YOUR_NEW_REST_API_KEY'; // Replace with your actual new key

// Replace this with a REAL player ID from your database
$realPlayerId = 'REAL_PLAYER_ID_FROM_DATABASE'; // Get this from your users table

echo "App ID: {$appId}\n";
echo "REST API Key: " . substr($restApiKey, 0, 10) . "...\n";
echo "Player ID: {$realPlayerId}\n\n";

if ($realPlayerId === 'REAL_PLAYER_ID_FROM_DATABASE') {
    echo "❌ Please replace 'REAL_PLAYER_ID_FROM_DATABASE' with an actual player ID from your database!\n";
    echo "\nTo get real player IDs:\n";
    echo "1. Run: SELECT onesignal_player_id FROM users WHERE onesignal_player_id IS NOT NULL;\n";
    echo "2. Copy one of the player IDs\n";
    echo "3. Replace 'REAL_PLAYER_ID_FROM_DATABASE' in this script\n";
    exit(1);
}

// Test notification with real player ID
echo "Testing notification with real player ID...\n";

$url = "https://onesignal.com/api/v1/notifications";
$payload = [
    'app_id' => $appId,
    'include_player_ids' => [$realPlayerId],
    'contents' => ['en' => 'Test notification from Laravel - ' . date('Y-m-d H:i:s')],
    'data' => ['type' => 'test']
];

$headers = [
    'Authorization: Basic ' . $restApiKey,
    'Content-Type: application/json'
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "❌ cURL Error: {$error}\n";
} else {
    echo "HTTP Code: {$httpCode}\n";
    if ($httpCode === 200) {
        $data = json_decode($response, true);
        if (isset($data['errors'])) {
            echo "❌ OneSignal Errors:\n";
            foreach ($data['errors'] as $error) {
                echo "   - {$error}\n";
            }
        } else {
            echo "✅ Success! Notification sent!\n";
            echo "Notification ID: " . ($data['id'] ?? 'Unknown') . "\n";
            echo "Recipients: " . ($data['recipients'] ?? 'Unknown') . "\n";
        }
    } else {
        echo "❌ Failed! Response: {$response}\n";
    }
}

echo "\n✅ Test completed!\n";


