<?php

require_once 'vendor/autoload.php';

use Illuminate\Support\Facades\DB;
use App\Models\User;

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "Testing OneSignal Player ID Update\n";
echo "==================================\n\n";

// Get user 147
$user = User::find(147);
if (!$user) {
    echo "❌ User 147 not found\n";
    exit(1);
}

echo "✅ User found: {$user->name} (ID: {$user->id})\n";
echo "Current onesignal_player_id: " . ($user->onesignal_player_id ?? 'NULL') . "\n\n";

// Update the player ID
$testPlayerId = '88226fe7-aae3-47a9-850f-1705b8b8bad4';
echo "🔄 Updating onesignal_player_id to: $testPlayerId\n";

$user->onesignal_player_id = $testPlayerId;
$result = $user->save();

if ($result) {
    echo "✅ Update successful!\n";
    
    // Refresh and check
    $user->refresh();
    echo "New onesignal_player_id: " . ($user->onesignal_player_id ?? 'NULL') . "\n";
    
    if ($user->onesignal_player_id === $testPlayerId) {
        echo "✅ Verification successful!\n";
    } else {
        echo "❌ Verification failed!\n";
    }
} else {
    echo "❌ Update failed!\n";
}

echo "\nDone!\n";


