<?php

require_once 'vendor/autoload.php';

use App\Models\User;
use App\Services\OneSignalService;

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "Testing Notification Preferences System\n";
echo "=====================================\n\n";

// Get a test user (you can change this to a specific user ID)
$user = User::first();
if (!$user) {
    echo "No users found in database. Please create a user first.\n";
    exit(1);
}

echo "Testing with user: {$user->name} (ID: {$user->id})\n";
echo "Current notification preferences:\n";
echo "- Notifications Enabled: " . ($user->notifications_enabled ? 'Yes' : 'No') . "\n";
echo "- Transaction Notifications: " . ($user->transaction_notifications ? 'Yes' : 'No') . "\n";
echo "- Currency Rate Notifications: " . ($user->currency_rate_notifications ? 'Yes' : 'No') . "\n";
echo "- Account Update Notifications: " . ($user->account_update_notifications ? 'Yes' : 'No') . "\n\n";

// Test OneSignal service
$oneSignalService = new OneSignalService();

echo "Testing OneSignal Service:\n";
echo "--------------------------\n";

// Test 1: Transaction notification
echo "1. Testing transaction notification...\n";
$result = $oneSignalService->sendTransactionNotification($user, (object)[
    'id' => 1,
    'transaction_amount' => 100,
    'from_currency_code' => (object)['code' => 'USD'],
    'transaction_type' => 'deposit',
    'transaction_date' => now()
], 'transaction_completed');

if ($result['success']) {
    echo "   ✅ Transaction notification sent successfully\n";
} else {
    echo "   ❌ Transaction notification failed: {$result['error']}\n";
    if ($result['error_type'] === 'user_preference') {
        echo "   ℹ️  This is expected if user has disabled transaction notifications\n";
    }
}

// Test 2: Currency rate notification
echo "\n2. Testing currency rate notification...\n";
$currency = (object)[
    'code' => 'USD',
    'name' => 'US Dollar'
];
$result = $oneSignalService->sendCurrencyRateNotification($user, $currency, 1.25, 1.20);

if ($result['success']) {
    echo "   ✅ Currency rate notification sent successfully\n";
} else {
    echo "   ❌ Currency rate notification failed: {$result['error']}\n";
    if ($result['error_type'] === 'user_preference') {
        echo "   ℹ️  This is expected if user has disabled currency rate notifications\n";
    }
}

// Test 3: Account update notification
echo "\n3. Testing account update notification...\n";
$account = (object)[
    'id' => 1,
    'name' => 'Test Account',
    'balance' => 1000,
    'currency_code' => 'USD'
];
$result = $oneSignalService->sendAccountUpdateNotification($user, $account, 'balance_update');

if ($result['success']) {
    echo "   ✅ Account update notification sent successfully\n";
} else {
    echo "   ❌ Account update notification failed: {$result['error']}\n";
    if ($result['error_type'] === 'user_preference') {
        echo "   ℹ️  This is expected if user has disabled account update notifications\n";
    }
}

echo "\nTest completed!\n";
echo "\nTo test with different preferences, update the user's notification settings in the database:\n";
echo "UPDATE users SET notifications_enabled = 1, transaction_notifications = 1, currency_rate_notifications = 1, account_update_notifications = 1 WHERE id = {$user->id};\n";
