<?php

require_once 'vendor/autoload.php';

// Test notification endpoints
$baseUrl = 'https://LA DERMA.innovation-pulsehub.com/api/mobile';

// You'll need to replace this with a valid token from a logged-in user
$token = 'YOUR_AUTH_TOKEN_HERE';

$headers = [
    'Authorization: Bearer ' . $token,
    'Content-Type: application/json',
    'Accept: application/json',
];

function makeRequest($url, $headers, $method = 'GET', $data = null) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
    
    if ($data && in_array($method, ['POST', 'PUT'])) {
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    }
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    return [
        'status_code' => $httpCode,
        'body' => json_decode($response, true),
        'raw_body' => $response
    ];
}

echo "Testing Notification API Endpoints\n";
echo "==================================\n\n";

// Test 1: Get notifications
echo "1. Testing GET /notifications\n";
$result = makeRequest($baseUrl . '/notifications', $headers);
echo "Status: " . $result['status_code'] . "\n";
echo "Response: " . json_encode($result['body'], JSON_PRETTY_PRINT) . "\n\n";

// Test 2: Get unread count
echo "2. Testing GET /notifications/unread-count\n";
$result = makeRequest($baseUrl . '/notifications/unread-count', $headers);
echo "Status: " . $result['status_code'] . "\n";
echo "Response: " . json_encode($result['body'], JSON_PRETTY_PRINT) . "\n\n";

// Test 3: Create a test notification
echo "3. Testing POST /notifications (create)\n";
$testNotification = [
    'type' => 'app',
    'title' => 'Test Notification',
    'body' => 'This is a test notification created via API',
    'data' => ['test' => true, 'created_via' => 'api_test']
];
$result = makeRequest($baseUrl . '/notifications', $headers, 'POST', $testNotification);
echo "Status: " . $result['status_code'] . "\n";
echo "Response: " . json_encode($result['body'], JSON_PRETTY_PRINT) . "\n\n";

if ($result['body']['success'] && isset($result['body']['data']['id'])) {
    $notificationId = $result['body']['data']['id'];
    
    // Test 4: Mark notification as read
    echo "4. Testing PUT /notifications/{id}/read\n";
    $result = makeRequest($baseUrl . '/notifications/' . $notificationId . '/read', $headers, 'PUT');
    echo "Status: " . $result['status_code'] . "\n";
    echo "Response: " . json_encode($result['body'], JSON_PRETTY_PRINT) . "\n\n";
    
    // Test 5: Delete notification
    echo "5. Testing DELETE /notifications/{id}\n";
    $result = makeRequest($baseUrl . '/notifications/' . $notificationId, $headers, 'DELETE');
    echo "Status: " . $result['status_code'] . "\n";
    echo "Response: " . json_encode($result['body'], JSON_PRETTY_PRINT) . "\n\n";
}

// Test 6: Mark all as read
echo "6. Testing PUT /notifications/read-all\n";
$result = makeRequest($baseUrl . '/notifications/read-all', $headers, 'PUT');
echo "Status: " . $result['status_code'] . "\n";
echo "Response: " . json_encode($result['body'], JSON_PRETTY_PRINT) . "\n\n";

echo "Testing completed!\n";







