<?php

require __DIR__.'/vendor/autoload.php';

$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\AccountTransaction;

echo "\n";
echo "==========================================\n";
echo " Testing Model Accessor Fix\n";
echo "==========================================\n\n";

echo "Fetching transaction 129518...\n\n";

$transaction = AccountTransaction::find(129518);

if ($transaction) {
    echo "✓ Transaction found!\n\n";
    
    echo "DIRECT ACCESS TEST:\n";
    echo "-------------------\n";
    echo "ID: {$transaction->id}\n";
    echo "Note: '{$transaction->note}'\n";
    echo "Person Name: " . ($transaction->person_name ?? 'NULL') . "\n\n";
    
    echo "JSON CONVERSION TEST:\n";
    echo "--------------------\n";
    $json = json_encode([
        'id' => $transaction->id,
        'note' => $transaction->note,
        'person_name' => $transaction->person_name,
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    echo $json . "\n\n";
    
    echo "EXPECTED RESULT:\n";
    echo "----------------\n";
    echo "Note should be: 'ئاسۆ کوی'\n";
    echo "NOT: '???? ???'\n\n";
    
    if ($transaction->note === 'ئاسۆ کوی') {
        echo "✓ SUCCESS! Model accessor is working!\n";
        echo "✓ The API should now return correct Kurdish text!\n\n";
        echo "Test in Postman:\n";
        echo "GET https://LA DERMA.innovation-pulsehub.com/api/mobile/transactions\n";
    } else {
        echo "✗ FAILED! Note is: '{$transaction->note}'\n";
        echo "Expected: 'ئاسۆ کوی'\n\n";
        echo "Debugging:\n";
        echo "- Check if accessor is being called\n";
        echo "- Verify model file is updated\n";
        echo "- Run: php artisan cache:clear\n";
    }
} else {
    echo "✗ Transaction 129518 not found!\n";
}

echo "\n==========================================\n\n";



