<?php

require_once 'vendor/autoload.php';

use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\Notification;

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

try {
    // Clear existing notifications
    DB::table('notifications')->truncate();
    echo "Cleared existing notifications\n";
    
    // Get first user
    $user = User::first();
    if (!$user) {
        echo "No users found in database\n";
        exit(1);
    }
    
    // Create test notification with Kurdish text
    $notification = Notification::create([
        'type' => 'currency_rate_update',
        'title' => 'Currency Rate Updated',
        'body' => 'ڕێژەی دراوی USD لە 140900 کەمبووەتەوە بۆ 140900',
        'user_id' => $user->id,
        'data' => [
            'type' => 'currency_rate_update',
            'currency' => 'USD',
            'old_rate' => 140900,
            'new_rate' => 140900
        ]
    ]);
    
    echo "Created test notification with ID: " . $notification->id . "\n";
    echo "Body: " . $notification->body . "\n";
    echo "Body length: " . strlen($notification->body) . "\n";
    
    // Test JSON encoding
    $jsonData = json_encode($notification->toArray(), JSON_UNESCAPED_UNICODE);
    echo "JSON: " . $jsonData . "\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}







