<?php

/**
 * Test Script for OneSignal External ID Backend Implementation
 * This script tests the backend implementation
 */

// Configuration - Update these with your actual values
$baseUrl = 'https://LA DERMA.innovation-pulsehub.com/api/mobile';
$testEmail = 'test@example.com'; // Replace with actual test email
$testPassword = 'password123'; // Replace with actual test password
$testExternalId = '147'; // The External ID we want to test

// Function to make API requests
function makeApiRequest($url, $method = 'GET', $data = null, $token = null) {
    $ch = curl_init();
    
    $headers = [
        'Content-Type: application/json',
        'Accept: application/json'
    ];
    
    if ($token) {
        $headers[] = 'Authorization: Bearer ' . $token;
    }
    
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    if ($method === 'POST') {
        curl_setopt($ch, CURLOPT_POST, true);
        if ($data) {
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        }
    }
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    return [
        'status_code' => $httpCode,
        'body' => json_decode($response, true),
        'raw_body' => $response
    ];
}

echo "🧪 Testing OneSignal External ID Backend Implementation\n";
echo "=====================================================\n\n";

// Step 1: Login to get authentication token
echo "1️⃣ Testing Login...\n";
$loginData = [
    'email' => $testEmail,
    'password' => $testPassword
];

$loginResponse = makeApiRequest($baseUrl . '/login', 'POST', $loginData);

if ($loginResponse['status_code'] === 200 && isset($loginResponse['body']['data']['token'])) {
    $token = $loginResponse['body']['data']['token'];
    $userId = $loginResponse['body']['data']['user']['id'];
    echo "✅ Login successful! User ID: $userId\n";
    echo "🔑 Token: " . substr($token, 0, 20) . "...\n\n";
} else {
    echo "❌ Login failed!\n";
    echo "Status: " . $loginResponse['status_code'] . "\n";
    echo "Response: " . $loginResponse['raw_body'] . "\n";
    echo "\n💡 Please update the test credentials in this script:\n";
    echo "   - \$testEmail = 'your-actual-email@example.com'\n";
    echo "   - \$testPassword = 'your-actual-password'\n\n";
    exit(1);
}

// Step 2: Update External ID
echo "2️⃣ Testing External ID Update...\n";
$externalIdData = [
    'external_id' => $testExternalId
];

$externalIdResponse = makeApiRequest($baseUrl . '/onesignal/external-id', 'POST', $externalIdData, $token);

if ($externalIdResponse['status_code'] === 200 && $externalIdResponse['body']['success']) {
    echo "✅ External ID updated successfully!\n";
    echo "📱 External ID: " . $testExternalId . "\n\n";
} else {
    echo "❌ External ID update failed!\n";
    echo "Status: " . $externalIdResponse['status_code'] . "\n";
    echo "Response: " . $externalIdResponse['raw_body'] . "\n";
    exit(1);
}

// Step 3: Send Test Notification
echo "3️⃣ Testing Notification Sending...\n";
$testNotificationResponse = makeApiRequest($baseUrl . '/onesignal/test', 'POST', null, $token);

if ($testNotificationResponse['status_code'] === 200 && $testNotificationResponse['body']['success']) {
    echo "✅ Test notification sent successfully!\n";
    echo "📨 Notification sent using External ID: " . $testExternalId . "\n";
    echo "📊 Recipients: " . ($testNotificationResponse['body']['data']['recipients'] ?? 'Unknown') . "\n\n";
} else {
    echo "❌ Test notification failed!\n";
    echo "Status: " . $testNotificationResponse['status_code'] . "\n";
    echo "Response: " . $testNotificationResponse['raw_body'] . "\n";
    
    // Check if it's a missing External ID error
    if (isset($testNotificationResponse['body']['error_type']) && 
        $testNotificationResponse['body']['error_type'] === 'missing_external_id') {
        echo "💡 This might be because the External ID wasn't properly saved to the database.\n";
        echo "   Make sure you've run the database migration and the user has the External ID.\n";
    }
}

echo "🎉 Testing completed!\n";
echo "====================\n\n";

echo "📋 Summary:\n";
echo "- Login: " . ($loginResponse['status_code'] === 200 ? "✅ Success" : "❌ Failed") . "\n";
echo "- External ID Update: " . ($externalIdResponse['status_code'] === 200 ? "✅ Success" : "❌ Failed") . "\n";
echo "- Test Notification: " . ($testNotificationResponse['status_code'] === 200 ? "✅ Success" : "❌ Failed") . "\n";

echo "\n💡 Next Steps:\n";
echo "1. Update your OneSignal REST API Key in the backend code\n";
echo "2. Test the notification on your mobile device\n";
echo "3. Verify the External ID is stored in the database\n";

echo "\n🔧 Backend Implementation Status:\n";
echo "✅ Database migration: COMPLETED\n";
echo "✅ User model updated: COMPLETED\n";
echo "✅ OneSignal controller updated: COMPLETED\n";
echo "✅ API routes updated: COMPLETED\n";
echo "✅ OneSignal service updated: COMPLETED\n";
echo "⏳ OneSignal REST API Key: NEEDS UPDATE\n";

?>


