<?php

require_once 'vendor/autoload.php';

use Illuminate\Support\Facades\DB;
use App\Models\User;

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "Testing Currency Rate Access Feature\n";
echo "====================================\n\n";

// Get all users
$users = User::all();

echo "Current users and their currency rate access:\n";
foreach ($users as $user) {
    echo "User ID: {$user->id}, Name: {$user->name}, Email: {$user->email}, Currency Rate Access: " . ($user->currency_rate_access ? 'YES' : 'NO') . "\n";
}

echo "\nTo test the feature:\n";
echo "1. Set currency_rate_access to true for a user:\n";
echo "   UPDATE users SET currency_rate_access = 1 WHERE id = [USER_ID];\n\n";

echo "2. Set currency_rate_access to false for a user:\n";
echo "   UPDATE users SET currency_rate_access = 0 WHERE id = [USER_ID];\n\n";

echo "3. Test in the mobile app:\n";
echo "   - Login with a user that has currency_rate_access = true\n";
echo "   - You should see the Currency Rates tab in the bottom navigation\n";
echo "   - Login with a user that has currency_rate_access = false\n";
echo "   - You should NOT see the Currency Rates tab in the bottom navigation\n\n";

echo "Example SQL commands:\n";
if ($users->count() > 0) {
    $firstUser = $users->first();
    echo "Enable currency access for user {$firstUser->id}:\n";
    echo "UPDATE users SET currency_rate_access = 1 WHERE id = {$firstUser->id};\n\n";
    
    echo "Disable currency access for user {$firstUser->id}:\n";
    echo "UPDATE users SET currency_rate_access = 0 WHERE id = {$firstUser->id};\n\n";
}

echo "API Endpoints to test:\n";
echo "- POST /api/mobile/login (check user.currency_rate_access in response)\n";
echo "- GET /api/mobile/user (check user.currency_rate_access in response)\n";
echo "- GET /api/mobile/currency-rates (should work regardless of user access)\n\n";

echo "Flutter App Changes:\n";
echo "- User model now includes currencyRateAccess field\n";
echo "- Main screen conditionally shows Currency Rates tab\n";
echo "- Navigation indices are adjusted based on user permissions\n\n";

echo "Test completed successfully!\n";

