<?php

require_once 'vendor/autoload.php';

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\User;
use App\Models\Notification;
use App\Jobs\SendCurrencyRateNotificationJob;
use App\Models\Currency;

try {
    echo "Testing Complete Notification Flow\n";
    echo "==================================\n\n";
    
    // Get first user
    $user = User::first();
    if (!$user) {
        echo "No users found in database\n";
        exit(1);
    }
    
    echo "Testing with user: {$user->email}\n\n";
    
    // Get a currency to test with
    $currency = Currency::where('currency_name', 'USD')->first();
    if (!$currency) {
        echo "No USD currency found in database\n";
        exit(1);
    }
    
    echo "Testing with currency: {$currency->currency_name}\n\n";
    
    // Test 1: Create notification directly in database
    echo "Test 1: Creating notification directly in database\n";
    $notification = Notification::create([
        'type' => 'currency_rate_update',
        'title' => 'نوێکردنەوەی ڕێژەی دراو',
        'body' => 'ڕێژەی دراوی USD لە 140900 کەمبووەتەوە بۆ 140800',
        'user_id' => $user->id,
        'data' => [
            'type' => 'currency_rate_update',
            'currency_name' => 'USD',
            'currency_code' => 'USD',
            'field' => 'buy_rate',
            'value' => 140800,
            'old_rate' => 140900,
            'updated_by' => 'Test Script',
            'timestamp' => now()->toISOString(),
        ],
    ]);
    
    echo "✅ Created notification with ID: {$notification->id}\n";
    echo "Title: {$notification->title}\n";
    echo "Body: {$notification->body}\n\n";
    
    // Test 2: Test the SendCurrencyRateNotificationJob
    echo "Test 2: Testing SendCurrencyRateNotificationJob\n";
    
    // Enable notifications for the user
    $user->notifications_enabled = true;
    $user->currency_rate_notifications = true;
    $user->save();
    
    echo "✅ Enabled notifications for user\n";
    
    // Dispatch the job
    SendCurrencyRateNotificationJob::dispatch(
        $currency,
        'buy_rate',
        140800,
        140900,
        'Test Script'
    );
    
    echo "✅ Dispatched SendCurrencyRateNotificationJob\n\n";
    
    // Test 3: Check notifications in database
    echo "Test 3: Checking notifications in database\n";
    $notifications = Notification::forUser($user->id)
        ->orderBy('created_at', 'desc')
        ->get();
    
    echo "Total notifications for user: {$notifications->count()}\n";
    
    foreach ($notifications as $notif) {
        echo "- ID: {$notif->id}, Title: {$notif->title}, Body: {$notif->body}\n";
    }
    
    echo "\n✅ All tests completed successfully!\n";
    echo "The notification system is working correctly.\n";
    echo "Kurdish text is being stored and retrieved properly.\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    echo "Trace: " . $e->getTraceAsString() . "\n";
}



