#!/bin/bash

# App Version Update System - Quick Test Script
# This script tests if the app version system is working correctly

echo "🧪 Testing App Version Update System"
echo "======================================"
echo ""

# Colors for output
GREEN='\033[0;32m'
RED='\033[0;31m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

API_URL="https://LA DERMA.innovation-pulsehub.com/api/mobile/app-version"

echo "📱 Testing Android Version..."
echo "------------------------------"
ANDROID_RESPONSE=$(curl -s -w "\n%{http_code}" -X GET "$API_URL" \
  -H "Content-Type: application/json" \
  -H "Accept: application/json" \
  -H "X-Platform: android" \
  -H "X-App-Version: 1.0.0")

HTTP_CODE=$(echo "$ANDROID_RESPONSE" | tail -n1)
RESPONSE_BODY=$(echo "$ANDROID_RESPONSE" | sed '$d')

if [ "$HTTP_CODE" -eq 200 ]; then
    echo -e "${GREEN}✅ Android endpoint: SUCCESS (HTTP $HTTP_CODE)${NC}"
    echo "Response:"
    echo "$RESPONSE_BODY" | python3 -m json.tool 2>/dev/null || echo "$RESPONSE_BODY"
else
    echo -e "${RED}❌ Android endpoint: FAILED (HTTP $HTTP_CODE)${NC}"
    echo "Response: $RESPONSE_BODY"
    echo ""
    echo -e "${YELLOW}💡 Fix: Run the seeder to populate app_versions table:${NC}"
    echo "   php artisan db:seed --class=AppVersionSeeder"
fi

echo ""
echo "📱 Testing iOS Version..."
echo "------------------------------"
IOS_RESPONSE=$(curl -s -w "\n%{http_code}" -X GET "$API_URL" \
  -H "Content-Type: application/json" \
  -H "Accept: application/json" \
  -H "X-Platform: ios" \
  -H "X-App-Version: 1.0.0")

HTTP_CODE=$(echo "$IOS_RESPONSE" | tail -n1)
RESPONSE_BODY=$(echo "$IOS_RESPONSE" | sed '$d')

if [ "$HTTP_CODE" -eq 200 ]; then
    echo -e "${GREEN}✅ iOS endpoint: SUCCESS (HTTP $HTTP_CODE)${NC}"
    echo "Response:"
    echo "$RESPONSE_BODY" | python3 -m json.tool 2>/dev/null || echo "$RESPONSE_BODY"
else
    echo -e "${RED}❌ iOS endpoint: FAILED (HTTP $HTTP_CODE)${NC}"
    echo "Response: $RESPONSE_BODY"
    echo ""
    echo -e "${YELLOW}💡 Fix: Run the seeder to populate app_versions table:${NC}"
    echo "   php artisan db:seed --class=AppVersionSeeder"
fi

echo ""
echo "======================================"
echo "🏁 Test Complete"
echo ""

# Check if both passed
if [[ "$ANDROID_RESPONSE" == *"200"* ]] && [[ "$IOS_RESPONSE" == *"200"* ]]; then
    echo -e "${GREEN}✅ All tests passed! App version system is working correctly.${NC}"
    exit 0
else
    echo -e "${RED}❌ Some tests failed. Please check the errors above.${NC}"
    exit 1
fi

