<?php

require_once 'vendor/autoload.php';

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\User;
use App\Models\Notification;
use Illuminate\Support\Facades\Auth;

try {
    // Get first user
    $user = User::first();
    if (!$user) {
        echo "No users found in database\n";
        exit(1);
    }
    
    // Create a test notification with Kurdish text
    $notification = Notification::create([
        'type' => 'currency_rate_update',
        'title' => 'نوێکردنەوەی ڕێژەی دراو',
        'body' => 'ڕێژەی دراوی USD لە 140900 کەمبووەتەوە بۆ 140800',
        'user_id' => $user->id,
        'data' => [
            'type' => 'currency_rate_update',
            'currency' => 'USD',
            'old_rate' => 140900,
            'new_rate' => 140800
        ]
    ]);
    
    echo "Created notification with ID: " . $notification->id . "\n";
    echo "Title: " . $notification->title . "\n";
    echo "Body: " . $notification->body . "\n\n";
    
    // Test the controller response format
    $notifications = Notification::forUser($user->id)
        ->orderBy('created_at', 'desc')
        ->get();

    // Transform notifications to match mobile app format (same as controller)
    $formattedNotifications = $notifications->map(function ($notification) {
        return [
            'id' => $notification->id,
            'title' => $notification->title,
            'body' => $notification->body,
            'image_url' => $notification->image_url,
            'data' => $notification->data,
            'action_url' => $notification->action_url,
            'is_read' => $notification->is_read,
            'created_at' => $notification->created_at->toISOString(),
        ];
    });

    $response = [
        'success' => true,
        'data' => $formattedNotifications,
        'total' => $notifications->count(),
        'unread_count' => $notifications->where('is_read', false)->count(),
    ];
    
    echo "API Response (with JSON_UNESCAPED_UNICODE):\n";
    echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT) . "\n\n";
    
    echo "API Response (without JSON_UNESCAPED_UNICODE):\n";
    echo json_encode($response, JSON_PRETTY_PRINT) . "\n\n";
    
    // Test HTTP headers
    echo "Testing HTTP response headers:\n";
    echo "Content-Type: application/json; charset=utf-8\n";
    echo "Content-Length: " . strlen(json_encode($response, JSON_UNESCAPED_UNICODE)) . "\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "Trace: " . $e->getTraceAsString() . "\n";
}