<?php

require_once 'vendor/autoload.php';

use Illuminate\Support\Facades\DB;
use App\Models\Notification;
use App\Models\User;
use App\Http\Controllers\Api\NotificationController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

try {
    echo "Testing API response directly...\n\n";
    
    // Get a user for testing
    $user = User::first();
    if (!$user) {
        echo "No users found in database\n";
        exit(1);
    }
    
    echo "Using user: {$user->email} (ID: {$user->id})\n\n";
    
    // Create a mock request
    $request = new Request();
    
    // Mock the Auth facade
    Auth::shouldReceive('user')->andReturn($user);
    
    // Get notifications for the user
    $notifications = Notification::where('user_id', $user->id)
        ->orderBy('created_at', 'desc')
        ->get();
    
    echo "Found {$notifications->count()} notifications for user\n\n";
    
    foreach ($notifications as $notification) {
        echo "=== Notification ID: {$notification->id} ===\n";
        echo "Database body: {$notification->body}\n";
        echo "Database body length: " . strlen($notification->body) . "\n";
        echo "Database body bytes: " . implode(', ', array_map('ord', str_split($notification->body))) . "\n";
        
        // Test the exact same formatting as the API
        $formattedNotification = [
            'id' => $notification->id,
            'title' => $notification->title,
            'body' => $notification->body,
            'image_url' => $notification->image_url,
            'data' => $notification->data,
            'action_url' => $notification->action_url,
            'is_read' => $notification->is_read,
            'created_at' => $notification->created_at->toISOString(),
        ];
        
        $jsonResponse = json_encode([
            'success' => true,
            'data' => [$formattedNotification],
            'total' => 1,
            'unread_count' => $notifications->where('is_read', false)->count(),
        ], JSON_UNESCAPED_UNICODE);
        
        echo "JSON response body field: ";
        $decoded = json_decode($jsonResponse, true);
        if (isset($decoded['data'][0]['body'])) {
            echo $decoded['data'][0]['body'] . "\n";
            echo "Decoded body length: " . strlen($decoded['data'][0]['body']) . "\n";
            echo "Decoded body bytes: " . implode(', ', array_map('ord', str_split($decoded['data'][0]['body']))) . "\n";
        }
        echo "\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "Trace: " . $e->getTraceAsString() . "\n";
}







