import 'dart:convert';
import 'package:http/http.dart' as http;

void main() async {
  const String baseUrl = 'https://LA DERMA.innovation-pulsehub.com/api/mobile';
  
  print('🔍 Testing LA DERMA API Connection...');
  print('API URL: $baseUrl');
  print('');
  
  // Test 1: Check if API endpoint is accessible
  print('📡 Test 1: Checking API endpoint accessibility...');
  try {
    final response = await http.get(Uri.parse(baseUrl));
    print('Status Code: ${response.statusCode}');
    print('Response: ${response.body}');
  } catch (e) {
    print('❌ Error: $e');
  }
  
  print('');
  
  // Test 2: Try to register a test user
  print('📝 Test 2: Testing user registration...');
  final timestamp = DateTime.now().millisecondsSinceEpoch;
  final testUser = {
    'name': 'Test User $timestamp',
    'email': 'test$timestamp@example.com',
    'password': 'password123',
    'password_confirmation': 'password123',
    'phone_number': '+1234567890',
    'address': 'Test Address',
  };
  
  try {
    final response = await http.post(
      Uri.parse('$baseUrl/register'),
      headers: {
        'Content-Type': 'application/json',
        'Accept': 'application/json',
      },
      body: jsonEncode(testUser),
    );
    
    print('Status Code: ${response.statusCode}');
    print('Response: ${response.body}');
    
    if (response.statusCode == 201 || response.statusCode == 200) {
      print('✅ Registration successful!');
      
      // Test 3: Try to login with the created user
      print('');
      print('🔐 Test 3: Testing user login...');
      
      final loginResponse = await http.post(
        Uri.parse('$baseUrl/login'),
        headers: {
          'Content-Type': 'application/json',
          'Accept': 'application/json',
        },
        body: jsonEncode({
          'email': testUser['email'],
          'password': testUser['password'],
        }),
      );
      
      print('Status Code: ${loginResponse.statusCode}');
      print('Response: ${loginResponse.body}');
      
      if (loginResponse.statusCode == 200) {
        print('✅ Login successful!');
        
        // Parse token and test protected endpoint
        final loginData = jsonDecode(loginResponse.body);
        if (loginData['success'] == true && loginData['data']['token'] != null) {
          final token = loginData['data']['token'];
          print('');
          print('🔒 Test 4: Testing protected endpoint...');
          
          final userResponse = await http.get(
            Uri.parse('$baseUrl/user'),
            headers: {
              'Content-Type': 'application/json',
              'Accept': 'application/json',
              'Authorization': 'Bearer $token',
            },
          );
          
          print('Status Code: ${userResponse.statusCode}');
          print('Response: ${userResponse.body}');
          
          if (userResponse.statusCode == 200) {
            print('✅ Protected endpoint access successful!');
          } else {
            print('❌ Protected endpoint access failed');
          }
        }
      } else {
        print('❌ Login failed');
      }
    } else {
      print('❌ Registration failed');
    }
  } catch (e) {
    print('❌ Error: $e');
  }
  
  print('');
  print('🏁 API testing completed!');
}

























