<?php

// Bootstrap Laravel
$app = require_once __DIR__.'/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\Customer;
use App\Models\Account;

echo "=== TESTING ACCOUNTS API ===\n\n";

try {
    // Get a user to test with
    $user = User::whereHas('customer')->first();
    
    if (!$user) {
        echo "❌ No users found with customer relationship\n";
        exit;
    }
    
    echo "✅ Found user: {$user->email}\n";
    echo "✅ Customer ID: {$user->customer->id}\n\n";
    
    // Simulate the accounts API call
    $customer = $user->customer;
    $accounts = $customer->accounts()->with('currency:id,currency_name,code')->get();
    
    echo "✅ Found " . $accounts->count() . " accounts for customer\n\n";
    
    // Group accounts by currency and calculate total balance for each currency
    $currencyBalances = $accounts->groupBy('currency_id')->map(function ($currencyAccounts) {
        $currency = $currencyAccounts->first()->currency;
        $totalBalance = $currencyAccounts->sum(function ($account) {
            return $account->calculateTotalBalance();
        });

        return [
            'id' => $currency->id,
            'currency_name' => $currency->currency_name,
            'currency_code' => $currency->code ?? 'USD',
            'total_balance' => $totalBalance,
            'account_count' => $currencyAccounts->count()
        ];
    });
    
    echo "✅ Currency balances calculated:\n";
    foreach ($currencyBalances as $balance) {
        echo "   - {$balance['currency_name']}: {$balance['total_balance']} ({$balance['account_count']} accounts)\n";
    }
    
    echo "\n✅ Final API response structure:\n";
    $response = [
        'success' => true,
        'data' => $currencyBalances->values()->toArray()
    ];
    
    echo json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "\n";

} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    echo "Stack trace: " . $e->getTraceAsString() . "\n";
}

echo "\n=== TEST COMPLETE ===\n";


