<?php
$configData = Helper::appClasses();
$user = Auth::user();
$isSuperAdmin = $user->hasRole('super-admin');
$isUser = $user->hasRole('user');
?>

<style>
/* Modern Vertical Menu Design */
#layout-menu {
  background: linear-gradient(180deg, #f8f9fa 0%, #ffffff 100%) !important;
  border-right: 1px solid rgba(0, 0, 0, 0.05) !important;
  box-shadow: 2px 0 20px rgba(0, 0, 0, 0.05) !important;
  transition: all 0.3s ease !important;
}

.dark-style #layout-menu {
  background: linear-gradient(180deg, #1e2028 0%, #2b2d3a 100%) !important;
  border-right-color: rgba(255, 255, 255, 0.05) !important;
  box-shadow: 2px 0 20px rgba(0, 0, 0, 0.3) !important;
}

/* Override theme CSS */
.layout-menu.menu-vertical.menu.bg-menu-theme {
  background: linear-gradient(180deg, #f8f9fa 0%, #ffffff 100%) !important;
}

.dark-style .layout-menu.menu-vertical.menu.bg-menu-theme {
  background: linear-gradient(180deg, #1e2028 0%, #2b2d3a 100%) !important;
}

/* Force override for all possible selectors */
aside#layout-menu.layout-menu.menu-vertical.menu.bg-menu-theme {
  background: linear-gradient(180deg, #f8f9fa 0%, #ffffff 100%) !important;
}

.dark-style aside#layout-menu.layout-menu.menu-vertical.menu.bg-menu-theme {
  background: linear-gradient(180deg, #1e2028 0%, #2b2d3a 100%) !important;
}

/* Force dark mode for body and html */
.dark-style body,
.dark-style html {
  background-color: #1e2028 !important;
}

/* Override bg-menu-theme class */
.bg-menu-theme {
  background: linear-gradient(180deg, #f8f9fa 0%, #ffffff 100%) !important;
}

.dark-style .bg-menu-theme {
  background: linear-gradient(180deg, #1e2028 0%, #2b2d3a 100%) !important;
}

/* Override any theme-specific backgrounds */
.menu.bg-menu-theme {
  background: linear-gradient(180deg, #f8f9fa 0%, #ffffff 100%) !important;
}

.dark-style .menu.bg-menu-theme {
  background: linear-gradient(180deg, #1e2028 0%, #2b2d3a 100%) !important;
}

/* Additional override for menu container */
.menu-vertical {
  background: linear-gradient(180deg, #f8f9fa 0%, #ffffff 100%) !important;
}

.dark-style .menu-vertical {
  background: linear-gradient(180deg, #1e2028 0%, #2b2d3a 100%) !important;
}

/* Dark mode for menu container */
.dark-style .layout-menu {
  background: linear-gradient(180deg, #1e2028 0%, #2b2d3a 100%) !important;
}

/* Dark mode for menu inner */
.dark-style .menu-inner {
  background: transparent !important;
}

/* Dark mode for menu items */
.dark-style .menu-item {
  background: transparent !important;
}

.dark-style .menu-item .menu-link {
  color: #ddd !important;
  background: transparent !important;
}

.dark-style .menu-item .menu-link:hover {
  background: rgba(176, 154, 96, 0.15) !important;
  color: white !important;
}

/* Dark Mode Menu Item Hover */
.dark-style .menu-item .menu-link:hover {
  background: rgba(176, 154, 96, 0.15) !important;
}

/* Dark Mode Active Menu Item */
.dark-style .menu-item.active .menu-link {
  background: linear-gradient(90deg, rgba(176, 154, 96, 0.2) 0%, rgba(176, 154, 96, 0.1) 100%) !important;
}

/* Dark Mode Menu Header Text */
.dark-style .menu-header-text {
  color: #6d301e !important;
}

/* Dark mode for menu headers */
.dark-style .menu-header {
  background: rgba(176, 154, 96, 0.2) !important;
  border-left-color: #6d301e !important;
}

/* Dark mode for menu icons */
.dark-style .menu-icon {
  color: #6d301e !important;
}

/* Dark mode for active menu items */
.dark-style .menu-item.active {
  background: #6d301e !important;
}

.dark-style .menu-item.active .menu-link {
  color: white !important;
}

.dark-style .menu-item.active .menu-icon {
  color: white !important;
}

/* Dark Mode App Brand */
.dark-style .app-brand {
  background: linear-gradient(135deg, rgba(176, 154, 96, 0.1) 0%, rgba(176, 154, 96, 0.05) 100%) !important;
}

/* Dark mode for app brand text */
.dark-style .app-brand-text {
  color: white !important;
}

.dark-style .app-brand-link {
  color: white !important;
}

.dark-style .app-brand-link * {
  color: white !important;
}

/* Dark Mode Menu Shadow */
.dark-style .menu-inner-shadow {
  background: linear-gradient(180deg, rgba(47,51,73,0.8) 0%, transparent 100%);
}

/* Dark Mode Menu Divider */
.menu-divider {
  height: 1px;
  background: linear-gradient(90deg, transparent, #e0e0e0, transparent);
  margin: 0.75rem 1.25rem;
}

.dark-style .menu-divider {
  background: linear-gradient(90deg, transparent, #3e4054, transparent);
}

/* App Brand Styling */
.app-brand {
  background: #2b2d3a;
  border-radius: 0 0 20px 20px;
  margin: 0 10px 20px 10px;
  padding: 20px;
  box-shadow: 0 4px 20px rgba(43, 45, 58, 0.3);
  transition: all 0.3s ease;
}

.app-brand:hover {
  transform: translateY(-2px);
  box-shadow: 0 8px 30px rgba(43, 45, 58, 0.4);
}

.app-brand-link {
  text-decoration: none;
  color: white !important;
  display: flex;
  align-items: center;
  gap: 12px;
}

.app-brand-link * {
  color: white !important;
}

/* Override any theme colors */
.app-brand-text.demo.menu-text.fw-bolder.ms-2.text-white {
  color: white !important;
  text-shadow: none !important;
}

span.app-brand-text.demo.menu-text.fw-bolder.ms-2.text-white {
  color: white !important;
  text-shadow: none !important;
}

.app-brand-logo {
  width: 40px;
  height: 40px;
  border-radius: 10px;
  overflow: hidden;
  background: rgba(255, 255, 255, 0.2);
  padding: 5px;
  transition: transform 0.3s ease;
}

.app-brand:hover .app-brand-logo {
  transform: scale(1.1);
}

.app-brand-text {
  font-size: 1.25rem;
  font-weight: 700;
  color: white !important;
  text-shadow: none !important;
}

.app-brand-text.text-white {
  color: white !important;
  text-shadow: none !important;
}

.app-brand-text.demo {
  color: white !important;
  text-shadow: none !important;
}

.app-brand-text.demo.text-white {
  color: white !important;
  text-shadow: none !important;
}

.layout-menu-toggle {
  background: rgba(255, 255, 255, 0.2);
  border-radius: 8px;
  padding: 8px;
  color: white;
  transition: all 0.3s ease;
}

.layout-menu-toggle:hover {
  background: rgba(255, 255, 255, 0.3);
  transform: scale(1.05);
}

/* Menu Items Styling */
.menu-inner {
  padding: 0 15px 20px 15px;
}

.menu-item {
  margin-bottom: 4px;
  border-radius: 12px;
  overflow: hidden;
  transition: all 0.3s ease;
}

.menu-item:hover {
  transform: translateX(5px);
  box-shadow: 0 4px 15px rgba(176, 154, 96, 0.15);
}

.menu-item.active {
  background: #6d301e;
  box-shadow: 0 4px 20px rgba(176, 154, 96, 0.3);
  transform: translateX(8px);
}

.menu-item.active .menu-link {
  color: white;
}

.menu-item.active .menu-icon {
  color: white;
  transform: scale(1.1);
}

.menu-link {
  padding: 12px 16px;
  border-radius: 12px;
  display: flex;
  align-items: center;
  gap: 12px;
  color: #333;
  text-decoration: none;
  transition: all 0.3s ease;
  position: relative;
  overflow: hidden;
}

.dark-style .menu-link {
  color: #ddd;
}

.menu-link::before {
  content: '';
  position: absolute;
  left: 0;
  top: 0;
  height: 100%;
  width: 4px;
  background: #6d301e;
  transform: scaleY(0);
  transition: transform 0.3s ease;
}

.menu-item:hover .menu-link::before {
  transform: scaleY(1);
}

.menu-item.active .menu-link::before {
  background: rgba(255, 255, 255, 0.3);
  transform: scaleY(1);
}

.menu-icon {
  font-size: 1.25rem;
  color: #6d301e;
  transition: all 0.3s ease;
  min-width: 20px;
}

.menu-item:hover .menu-icon {
  color: #ffffff;
  transform: scale(1.1);
}

.menu-link div {
  font-weight: 500;
  font-size: 0.95rem;
  transition: all 0.3s ease;
}

.menu-item:hover .menu-link div {
  font-weight: 600;
}

/* Menu Headers */
.menu-header {
  margin: 25px 0 15px 0;
  padding: 8px 16px;
  background: rgba(176, 154, 96, 0.1);
  border-radius: 8px;
  border-left: 4px solid #6d301e;
  position: relative;
}

.dark-style .menu-header {
  background: rgba(176, 154, 96, 0.2);
}

.menu-header-text {
  font-weight: 600;
  font-size: 0.8rem;
  color: #6d301e;
  letter-spacing: 0.5px;
}

.dark-style .menu-header-text {
  color: #6d301e;
}

/* Submenu Styling */
.menu-sub {
  background: rgba(176, 154, 96, 0.05);
  border-radius: 8px;
  margin: 8px 0 8px 20px;
  padding: 8px 0;
  border-left: 2px solid rgba(176, 154, 96, 0.2);
}

.dark-style .menu-sub {
  background: rgba(176, 154, 96, 0.1);
  border-left-color: rgba(176, 154, 96, 0.3);
}

.menu-sub .menu-item {
  margin: 2px 8px;
}

.menu-sub .menu-link {
  padding: 8px 12px;
  font-size: 0.9rem;
}

.menu-sub .menu-icon {
  font-size: 1rem;
}

/* Menu Toggle Animation */
.menu-toggle-icon {
  transition: transform 0.3s ease;
}

.menu-item.open .menu-toggle-icon {
  transform: rotate(90deg);
}

/* Menu Shadow */
.menu-inner-shadow {
  background: linear-gradient(180deg, rgba(0, 0, 0, 0.1) 0%, transparent 100%);
  height: 20px;
  margin: 0 -15px;
  border-radius: 0 0 15px 15px;
}

.dark-style .menu-inner-shadow {
  background: linear-gradient(180deg, rgba(0, 0, 0, 0.3) 0%, transparent 100%);
}

/* Responsive Design */
@media (max-width: 1199.98px) {
  .app-brand {
    margin: 0 5px 15px 5px;
    padding: 15px;
  }
  
  .menu-inner {
    padding: 0 10px 15px 10px;
  }
  
  .menu-link {
    padding: 10px 12px;
  }
}

@media (max-width: 575.98px) {
  .app-brand-text {
    font-size: 1rem;
  }
  
  .menu-link {
    padding: 8px 10px;
  }
  
  .menu-icon {
    font-size: 1.1rem;
  }
}

/* Smooth Scrollbar */
.menu-inner::-webkit-scrollbar {
  width: 4px;
}

.menu-inner::-webkit-scrollbar-track {
  background: transparent;
}

.menu-inner::-webkit-scrollbar-thumb {
  background: rgba(176, 154, 96, 0.3);
  border-radius: 2px;
}

.menu-inner::-webkit-scrollbar-thumb:hover {
  background: rgba(176, 154, 96, 0.5);
}

/* Loading Animation */
@keyframes menuSlideIn {
  from {
    opacity: 0;
    transform: translateX(-20px);
  }
  to {
    opacity: 1;
    transform: translateX(0);
  }
}

.menu-item {
  animation: menuSlideIn 0.3s ease-out;
}

.menu-item:nth-child(1) { animation-delay: 0.1s; }
.menu-item:nth-child(2) { animation-delay: 0.2s; }
.menu-item:nth-child(3) { animation-delay: 0.3s; }
.menu-item:nth-child(4) { animation-delay: 0.4s; }
.menu-item:nth-child(5) { animation-delay: 0.5s; }

/* FINAL OVERRIDE - Must be at the end */
/* Force sidebar background override */
aside#layout-menu,
aside#layout-menu.layout-menu,
aside#layout-menu.menu-vertical,
aside#layout-menu.menu,
aside#layout-menu.bg-menu-theme,
aside#layout-menu.layout-menu.menu-vertical.menu.bg-menu-theme {
  background: linear-gradient(180deg, #f8f9fa 0%, #ffffff 100%) !important;
}

.dark-style aside#layout-menu,
.dark-style aside#layout-menu.layout-menu,
.dark-style aside#layout-menu.menu-vertical,
.dark-style aside#layout-menu.menu,
.dark-style aside#layout-menu.bg-menu-theme,
.dark-style aside#layout-menu.layout-menu.menu-vertical.menu.bg-menu-theme {
  background: linear-gradient(180deg, #1e2028 0%, #2b2d3a 100%) !important;
}

/* Nuclear option - override everything */
*[id="layout-menu"] {
  background: linear-gradient(180deg, #f8f9fa 0%, #ffffff 100%) !important;
}

.dark-style *[id="layout-menu"] {
  background: linear-gradient(180deg, #1e2028 0%, #2b2d3a 100%) !important;
}

/* Alternative dark mode selectors */
html[data-theme="dark"] #layout-menu,
html.dark-style #layout-menu,
body.dark-style #layout-menu,
.dark-style #layout-menu {
  background: linear-gradient(180deg, #1e2028 0%, #2b2d3a 100%) !important;
}

/* Force dark mode for testing */
#layout-menu.dark-mode {
  background: linear-gradient(180deg, #1e2028 0%, #2b2d3a 100%) !important;
}
</style>

<aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme">

  <!-- ! Hide app brand if navbar-full -->
  <?php if(!isset($navbarFull)): ?>
  <div class="app-brand demo">
    <a href="<?php echo e(url('/')); ?>" class="app-brand-link">
      <span class="app-brand-logo demo">
        <img src="/assets/logoback.png" style="width: 100%; height:100%;">
      </span>
      <span class=" text-white demo menu-text fw-bolder ms-2">LA DERMA</span>
    </a>

    <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto">
      <i class="ti ti-chevrons-left menu-toggle-icon d-none d-xl-block ti-sm align-middle"></i>
      <i class="ti ti-x d-block d-xl-none ti-sm align-middle"></i>
    </a>
  </div>
  <?php endif; ?>

  <div class="menu-inner-shadow"></div>

  <ul class="menu-inner py-1">
    <!-- Dashboard -->
    <li class="menu-item <?php echo e((request()->segment(1) == '') ? 'active' : ''); ?>">
      <a href="/" class="menu-link">
        <i class="menu-icon tf-icons ti ti-dashboard"></i>
        <div><?php echo app('translator')->get('word.Dashboard'); ?></div>
      </a>
    </li>

    <?php if($isSuperAdmin): ?>

    <!-- Patient Management Section -->
    <li class="menu-header small text-uppercase bg-lighter">
      <span class="menu-header-text">Patient Management</span>
    </li>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', App\Models\Patient::class)): ?>
    <li class="menu-item <?php echo e(request()->is('patients*') ? 'active' : ''); ?>">
      <a href="<?php echo e(route('patients.index')); ?>" class="menu-link">
        <i class="menu-icon tf-icons ti ti-users"></i>
        <div>Patients</div>
      </a>
    </li>
    <?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', App\Models\Invoice::class)): ?>
    <li class="menu-item <?php echo e(request()->is('invoices*') ? 'active' : ''); ?>">
      <a href="<?php echo e(route('invoices.index')); ?>" class="menu-link">
        <i class="menu-icon tf-icons ti ti-receipt"></i>
        <div>Invoices</div>
      </a>
    </li>
    <?php endif; ?>


    <!-- Products & Services Section -->
    <li class="menu-header small text-uppercase bg-lighter">
      <span class="menu-header-text">Products & Services</span>
    </li>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', App\Models\Category::class)): ?>
    <li class="menu-item <?php echo e(request()->is('categories*') ? 'active' : ''); ?>">
      <a href="<?php echo e(route('categories.index')); ?>" class="menu-link">
        <i class="menu-icon tf-icons ti ti-category"></i>
        <div>Categories</div>
      </a>
    </li>
    <?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', App\Models\Subcategory::class)): ?>
    <li class="menu-item <?php echo e(request()->is('subcategories*') ? 'active' : ''); ?>">
      <a href="<?php echo e(route('subcategories.index')); ?>" class="menu-link">
        <i class="menu-icon tf-icons ti ti-list"></i>
        <div>Subcategories</div>
      </a>
    </li>
    <?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', App\Models\Product::class)): ?>
    <li class="menu-item <?php echo e(request()->is('products*') ? 'active' : ''); ?>">
      <a href="<?php echo e(route('products.index')); ?>" class="menu-link">
        <i class="menu-icon tf-icons ti ti-package"></i>
        <div>Products</div>
      </a>
    </li>
    <?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', App\Models\Supplier::class)): ?>
    <li class="menu-item <?php echo e(request()->is('suppliers*') ? 'active' : ''); ?>">
      <a href="<?php echo e(route('suppliers.index')); ?>" class="menu-link">
        <i class="menu-icon tf-icons ti ti-truck"></i>
        <div>Suppliers</div>
      </a>
    </li>
    <?php endif; ?>


    <!-- Reports Section -->
    <li class="menu-header small text-uppercase bg-lighter">
      <span class="menu-header-text">Reports</span>
    </li>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', App\Models\Patient::class)): ?>
    <li class="menu-item <?php echo e(request()->is('reports/patients*') ? 'active' : ''); ?>">
      <a href="<?php echo e(route('reports.patients')); ?>" class="menu-link">
        <i class="menu-icon tf-icons ti ti-chart-line"></i>
        <div>Patient Report</div>
      </a>
    </li>
    <?php endif; ?>

    <li class="menu-item <?php echo e(request()->is('reports/products*') ? 'active' : ''); ?>">
      <a href="<?php echo e(route('reports.products')); ?>" class="menu-link">
        <i class="menu-icon tf-icons ti ti-chart-pie"></i>
        <div>Product Report</div>
      </a>
    </li>

    <li class="menu-item <?php echo e(request()->is('reports/invoices*') ? 'active' : ''); ?>">
      <a href="<?php echo e(route('reports.invoices')); ?>" class="menu-link">
        <i class="menu-icon tf-icons ti ti-file-text"></i>
        <div>Invoice Report</div>
      </a>
    </li>


    <!-- System Section -->
    <li class="menu-header small text-uppercase bg-lighter">
      <span class="menu-header-text">System</span>
    </li>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', Spatie\Activitylog\Models\Activity::class)): ?>
    <li class="menu-item <?php echo e((request()->segment(1) == 'logs') ? 'active' : ''); ?>">
      <a href="/logs" class="menu-link">
        <i class="menu-icon tf-icons ti ti-file-analytics"></i>
        <div><?php echo app('translator')->get('word.SystemLogs'); ?></div>
      </a>
    </li>
    <?php endif; ?>

    <?php if(Auth::user()->can('view-any', Spatie\Permission\Models\Role::class) ||
      Auth::user()->can('view-any', Spatie\Permission\Models\Permission::class)): ?>
      <li class="menu-header small text-uppercase bg-lighter">
        <span class="menu-header-text"><?php echo app('translator')->get('word.User'); ?></span>
      </li>

      <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', Spatie\Permission\Models\User::class)): ?>
      <li class="menu-item <?php echo e(request()->segment(1) == 'users' ? 'active' : ''); ?>">
        <a href="<?php echo e(route('users.index')); ?>" class="menu-link">
          <i class="menu-icon tf-icons ti ti-users-group"></i>
          <div><?php echo app('translator')->get('word.User'); ?></div>
        </a>
      </li>
      <?php endif; ?>

    
    <?php endif; ?>

    <?php endif; ?>

    <!-- User Menu Section - Show for users with patient/invoice permissions -->
    <?php if(!$isSuperAdmin && (Auth::user()->can('view-any', App\Models\Patient::class) || Auth::user()->can('view-any', App\Models\Invoice::class))): ?>

    <!-- Patient Management Section -->
    <li class="menu-header small text-uppercase bg-lighter">
      <span class="menu-header-text">Patient Management</span>
    </li>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', App\Models\Patient::class)): ?>
    <li class="menu-item <?php echo e(request()->is('patients*') ? 'active' : ''); ?>">
      <a href="<?php echo e(route('patients.index')); ?>" class="menu-link">
        <i class="menu-icon tf-icons ti ti-users"></i>
        <div>Patients</div>
      </a>
    </li>
    <?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', App\Models\Invoice::class)): ?>
    <li class="menu-item <?php echo e(request()->is('invoices*') ? 'active' : ''); ?>">
      <a href="<?php echo e(route('invoices.index')); ?>" class="menu-link">
        <i class="menu-icon tf-icons ti ti-receipt"></i>
        <div>Invoices</div>
      </a>
    </li>
    <?php endif; ?>

    <!-- Reports Section -->
    <li class="menu-header small text-uppercase bg-lighter">
      <span class="menu-header-text">Reports</span>
    </li>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', App\Models\Patient::class)): ?>
    <li class="menu-item <?php echo e(request()->is('reports/patients*') ? 'active' : ''); ?>">
      <a href="<?php echo e(route('reports.patients')); ?>" class="menu-link">
        <i class="menu-icon tf-icons ti ti-chart-line"></i>
        <div>Patient Report</div>
      </a>
    </li>
    <?php endif; ?>

    <?php endif; ?>

 
  </ul>
</aside>

<script>
// Debug and force dark mode
document.addEventListener('DOMContentLoaded', function() {
  console.log('Menu loaded, checking dark mode...');
  
  // Check current theme
  const htmlElement = document.documentElement;
  const bodyElement = document.body;
  const menuElement = document.getElementById('layout-menu');
  
  console.log('HTML classes:', htmlElement.className);
  console.log('HTML data-theme:', htmlElement.getAttribute('data-theme'));
  console.log('HTML data-style:', htmlElement.getAttribute('data-style'));
  console.log('Body classes:', bodyElement.className);
  
  // Force dark mode if needed
  function checkAndApplyDarkMode() {
    const isDarkMode = htmlElement.classList.contains('dark-style');
    
    console.log('HTML classes:', htmlElement.className);
    console.log('Is dark mode:', isDarkMode);
    
    if (isDarkMode) {
      menuElement.classList.add('dark-mode');
      console.log('Applied dark mode to menu');
    } else {
      menuElement.classList.remove('dark-mode');
      console.log('Removed dark mode from menu');
    }
  }
  
  // Check initially
  checkAndApplyDarkMode();
  
  // Watch for theme changes
  const observer = new MutationObserver(function(mutations) {
    mutations.forEach(function(mutation) {
      if (mutation.type === 'attributes' && 
          (mutation.attributeName === 'class' || 
           mutation.attributeName === 'data-theme' || 
           mutation.attributeName === 'data-style')) {
        console.log('Theme changed, rechecking...');
        checkAndApplyDarkMode();
      }
    });
  });
  
  observer.observe(htmlElement, {
    attributes: true,
    attributeFilter: ['class', 'data-theme', 'data-style']
  });
  
  observer.observe(bodyElement, {
    attributes: true,
    attributeFilter: ['class']
  });
});
</script><?php /**PATH C:\Dev\doublehair\resources\views/layouts/sections/menu/verticalMenu.blade.php ENDPATH**/ ?>