<div>
    <div class="card">
        <div class="card-header">
            <h4 class="card-title mb-0">Create Patient & Invoice</h4>
        </div>
        <div class="card-body">
            <!--[if BLOCK]><![endif]--><?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <h6 class="alert-heading"><i class="ti ti-alert-circle"></i> Please fix the following errors:</h6>
                    <ul class="mb-0">
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                    </ul>
                </div>
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

            <!-- Patient Information Section - Compact -->
            <div class="card mb-3 border-primary">
                <div class="card-body p-3">
                    <!--[if BLOCK]><![endif]--><?php if($isEditingPatient && $selectedPatientId): ?>
                    <div class="alert alert-info alert-sm py-2 mb-2">
                        <div class="d-flex justify-content-between align-items-center">
                            <small><i class="ti ti-info-circle me-1"></i>Editing: <strong><?php echo e($name); ?></strong> (<?php echo e($code); ?>)</small>
                            <button type="button" class="btn btn-xs btn-outline-secondary btn-sm" wire:click="clearPatientSelection">
                                <i class="ti ti-x"></i>
                            </button>
                        </div>
                    </div>
                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                    <div class="row g-2">
                        <div class="col-md-3">
                            <div class="form-floating form-floating-outline position-relative">
                                <input type="text" 
                                    class="form-control form-control-sm <?php $__errorArgs = ['code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    id="code" 
                                    wire:model.live.debounce.300ms="code" 
                                    placeholder="Code" 
                                    required
                                    autocomplete="off">
                                <label for="code">Code <span class="text-danger">*</span></label>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> 
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                
                                <?php if($showSearchResults && count($searchResults) > 0): ?>
                                <div class="position-absolute w-100 bg-white border rounded shadow-lg" style="z-index: 1000; top: 100%; margin-top: 2px; max-height: 250px; overflow-y: auto;">
                                    <div class="list-group list-group-flush">
                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $searchResults; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <button type="button" 
                                                class="list-group-item list-group-item-action py-2"
                                                wire:click="selectPatient(<?php echo e($result->id); ?>)"
                                                style="cursor: pointer;">
                                                <div class="d-flex justify-content-between">
                                                    <div>
                                                        <strong class="small"><?php echo e($result->code); ?></strong> - <?php echo e($result->name); ?>

                                                        <!--[if BLOCK]><![endif]--><?php if($result->phone): ?>
                                                            <br><small class="text-muted"><?php echo e($result->phone); ?></small>
                                                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                                                    </div>
                                                    <i class="ti ti-arrow-right text-primary"></i>
                                                </div>
                                            </button>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-floating form-floating-outline position-relative">
                                <input type="text" 
                                    class="form-control form-control-sm <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    id="name" 
                                    wire:model.live.debounce.300ms="name" 
                                    placeholder="Name" 
                                    required
                                    autocomplete="off">
                                <label for="name">Name <span class="text-danger">*</span></label>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> 
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                
                                <?php if($showSearchResults && count($searchResults) > 0): ?>
                                <div class="position-absolute w-100 bg-white border rounded shadow-lg" style="z-index: 1000; top: 100%; margin-top: 2px; max-height: 250px; overflow-y: auto;">
                                    <div class="list-group list-group-flush">
                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $searchResults; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <button type="button" 
                                                class="list-group-item list-group-item-action py-2"
                                                wire:click="selectPatient(<?php echo e($result->id); ?>)"
                                                style="cursor: pointer;">
                                                <div class="d-flex justify-content-between">
                                                    <div>
                                                        <strong class="small"><?php echo e($result->name); ?></strong> (<?php echo e($result->code); ?>)
                                                        <!--[if BLOCK]><![endif]--><?php if($result->phone): ?>
                                                            <br><small class="text-muted"><?php echo e($result->phone); ?></small>
                                                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                                                    </div>
                                                    <i class="ti ti-arrow-right text-primary"></i>
                                                </div>
                                            </button>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-floating form-floating-outline">
                                <input type="text" class="form-control form-control-sm <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="phone" wire:model.blur="phone" placeholder="Phone">
                                <label for="phone">Phone</label>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> 
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-floating form-floating-outline">
                                <input type="text" class="form-control form-control-sm <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="address" wire:model.blur="address" placeholder="Address">
                                <label for="address">Address</label>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> 
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Invoice Items Section -->
            <div class="card mb-4">
                <div class="card-header bg-success text-white d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><i class="ti ti-receipt me-2"></i>Invoice Items</h5>
                    <div>
                        <button type="button" class="btn btn-sm btn-light me-2" wire:click="openServiceModal">
                            <i class="ti ti-plus me-1"></i>Add Service
                        </button>
                        <button type="button" class="btn btn-sm btn-light" wire:click="openProductModal">
                            <i class="ti ti-plus me-1"></i>Add Drug
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['items'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="alert alert-danger">
                            <i class="ti ti-alert-circle"></i> <?php echo e($message); ?>

                        </div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <!--[if ENDBLOCK]><![endif]-->

                    <!--[if BLOCK]><![endif]--><?php if(count($selectedServices) == 0 && count($selectedProducts) == 0): ?>
                        <div class="alert alert-info mb-0">
                            <i class="ti ti-info-circle me-2"></i>
                            <strong>No items added yet.</strong> Click "Add Service" or "Add Drug" to add items to the invoice.
                        </div>
                    <?php else: ?>
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Type</th>
                                        <th>Item Name</th>
                                        <th>Category</th>
                                        <th>Quantity</th>
                                        <th>Unit Price</th>
                                        <th>Total</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                        $totalAmount = 0;
                                    ?>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $selectedServices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $totalAmount += $service['cost'];
                                        ?>
                                        <tr>
                                            <td><span class="badge bg-primary">Service</span></td>
                                            <td><?php echo e($service['name']); ?></td>
                                            <td>
                                                <?php
                                                    $category = \App\Models\Category::find($service['category_id']);
                                                ?>
                                                <?php echo e($category->name ?? 'N/A'); ?>

                                            </td>
                                            <td>1</td>
                                            <td>$<?php echo e(number_format($service['cost'], 2)); ?></td>
                                            <td><strong>$<?php echo e(number_format($service['cost'], 2)); ?></strong></td>
                                            <td>
                                                <button type="button" class="btn btn-sm btn-danger" wire:click="removeService(<?php echo e($index); ?>)">
                                                    <i class="ti ti-trash"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $selectedProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $itemTotal = $product['sale_price'] * $product['quantity'];
                                            $totalAmount += $itemTotal;
                                        ?>
                                        <tr>
                                            <td><span class="badge bg-success">Drug</span></td>
                                            <td><?php echo e($product['name']); ?></td>
                                            <td>-</td>
                                            <td>
                                                <div class="d-flex gap-2 align-items-center">
                                                    <input type="number" 
                                                        class="form-control form-control-sm" 
                                                        style="width: 80px;"
                                                        min="1" 
                                                        max="<?php echo e($product['stock_quantity']); ?>"
                                                        value="<?php echo e($product['quantity']); ?>"
                                                        wire:change="updateProductQuantity(<?php echo e($index); ?>, $event.target.value)">
                                                    <?php if(isset($productBatchesMap[$product['product_id']]) && $productBatchesMap[$product['product_id']]->count() > 0): ?>
                                                        <select class="form-select form-select-sm" 
                                                            style="width: 150px;"
                                                            wire:change="updateProductBatch(<?php echo e($index); ?>, $event.target.value)">
                                                            <option value="">Select Batch</option>
                                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $productBatchesMap[$product['product_id']]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $batch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($batch->id); ?>" <?php echo e(($product['batch_id'] == $batch->id) ? 'selected' : ''); ?>>
                                                                    <?php echo e($batch->batch_number); ?> (<?php echo e($batch->available_quantity); ?>)
                                                                </option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                                                        </select>
                                                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                                                </div>
                                            </td>
                                            <td>$<?php echo e(number_format($product['sale_price'], 2)); ?></td>
                                            <td><strong>$<?php echo e(number_format($itemTotal, 2)); ?></strong></td>
                                            <td>
                                                <button type="button" class="btn btn-sm btn-danger" wire:click="removeProduct(<?php echo e($index); ?>)">
                                                    <i class="ti ti-trash"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="5" class="text-end">Total Amount:</th>
                                        <th class="text-primary">$<?php echo e(number_format($totalAmount, 2)); ?></th>
                                        <th></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>

            <!-- Notes Section -->
            <div class="card mb-4">
                <div class="card-header bg-info text-white">
                    <h6 class="mb-0"><i class="ti ti-notes me-2"></i>Notes</h6>
                </div>
                <div class="card-body">
                    <div class="form-floating form-floating-outline">
                        <textarea class="form-control" id="notes" wire:model="notes" style="height: 120px" placeholder="Enter any additional notes for this invoice"></textarea>
                        <label for="notes">Invoice Notes (Optional)</label>
                    </div>
                </div>
            </div>

            <!-- Submit Buttons -->
            <div class="d-flex justify-content-end gap-2">
                <button type="button" class="btn btn-primary btn-lg" wire:click="saveAndPrint">
                    <i class="ti ti-printer me-2"></i>Save & Print Invoice
                </button>
                <button type="button" class="btn btn-success btn-lg" wire:click="save">
                    <i class="ti ti-check me-2"></i>Save & Reset Form
                </button>
            </div>
        </div>
    </div>

    <!-- Service Modal -->
    <!--[if BLOCK]><![endif]--><?php if($showServiceModal): ?>
    <div class="modal fade show d-block" tabindex="-1" style="background-color: rgba(0,0,0,0.5);" wire:click.self="closeServiceModal">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title"><i class="ti ti-category me-2"></i>Add Service</h5>
                    <button type="button" class="btn-close btn-close-white" wire:click="closeServiceModal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Search Service</label>
                        <div class="input-group">
                            <input type="text" 
                                class="form-control" 
                                wire:model.live.debounce.300ms="serviceSearchQuery"
                                placeholder="Enter service name...">
                            <button class="btn btn-primary" type="button" wire:click="searchServices">
                                <i class="ti ti-search"></i> Search
                            </button>
                        </div>
                        
                        <?php if($showServiceSearchResults && count($serviceSearchResults) > 0): ?>
                            <div class="list-group mt-2" style="max-height: 400px; overflow-y: auto;">
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $serviceSearchResults; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong><?php echo e($result['name']); ?></strong>
                                            <br>
                                            <small class="text-muted"><?php echo e($result['category_name']); ?> - $<?php echo e(number_format($result['cost'], 2)); ?></small>
                                        </div>
                                        <button class="btn btn-sm btn-primary" 
                                            wire:click="addService(<?php echo e($result['id']); ?>, <?php echo e($result['category_id']); ?>, '<?php echo e($result['name']); ?>', <?php echo e($result['cost']); ?>)">
                                            <i class="ti ti-plus"></i> Add
                                        </button>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                            </div>
                        <?php elseif($showServiceSearchResults && strlen($serviceSearchQuery) >= 1 && count($serviceSearchResults) == 0): ?>
                            <div class="alert alert-info mt-2 mb-0 py-2">
                                <small>No services found</small>
                            </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="closeServiceModal">Close</button>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

    <!-- Product (Drug) Modal -->
    <!--[if BLOCK]><![endif]--><?php if($showProductModal): ?>
    <div class="modal fade show d-block" tabindex="-1" style="background-color: rgba(0,0,0,0.5);" wire:click.self="closeProductModal">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header bg-success text-white">
                    <h5 class="modal-title"><i class="ti ti-package me-2"></i>Add Drug</h5>
                    <button type="button" class="btn-close btn-close-white" wire:click="closeProductModal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Search Product</label>
                        <div class="input-group">
                            <input type="text" 
                                class="form-control" 
                                wire:model.live.debounce.300ms="productSearchQuery"
                                placeholder="Enter product name...">
                            <button class="btn btn-success" type="button" wire:click="searchProducts">
                                <i class="ti ti-search"></i> Search
                            </button>
                        </div>
                        
                        <?php if($showProductSearchResults && count($productSearchResults) > 0): ?>
                            <div class="list-group mt-2" style="max-height: 400px; overflow-y: auto;">
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $productSearchResults; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong><?php echo e($result['name']); ?></strong>
                                            <br>
                                            <small class="text-muted">
                                                Stock: <?php echo e($result['stock_quantity']); ?> | 
                                                Price: $<?php echo e(number_format($result['sale_price'], 2)); ?>

                                            </small>
                                        </div>
                                        <button class="btn btn-sm btn-success" 
                                            wire:click="addProduct(<?php echo e($result['id']); ?>, '<?php echo e($result['name']); ?>', <?php echo e($result['sale_price']); ?>, <?php echo e($result['stock_quantity']); ?>)">
                                            <i class="ti ti-plus"></i> Add
                                        </button>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                            </div>
                        <?php elseif($showProductSearchResults && strlen($productSearchQuery) >= 1 && count($productSearchResults) == 0): ?>
                            <div class="alert alert-info mt-2 mb-0 py-2">
                                <small>No products found</small>
                            </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="closeProductModal">Close</button>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

    <style>
        .modal.show {
            display: block !important;
        }
        .modal-backdrop {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 1040;
        }
       
        .btn-xs {
            padding: 0.125rem 0.375rem;
            font-size: 0.75rem;
        }
        .form-control-sm {
            padding: 0.5rem 0.75rem;
            font-size: 0.875rem;
        }
        .form-floating > label {
            padding: 0.5rem 0.75rem;
            font-size: 0.875rem;
        }
        .form-floating > .form-control:focus ~ label,
        .form-floating > .form-control:not(:placeholder-shown) ~ label {
            transform: scale(0.85) translateY(-0.5rem) translateX(0.15rem);
        }
    </style>
</div>
<?php /**PATH C:\Dev\doublehair\resources\views/livewire/patient-invoice-wizard.blade.php ENDPATH**/ ?>