<?php

/**
 * Simple OneSignal Test
 */

echo "🔍 Testing OneSignal with your API key...\n\n";

$appId = '737941d8-27b3-49b6-82f7-fd46ab10fd74';
$restApiKey = '3eme7eppte7evz3oiv4lplg5z';

echo "App ID: {$appId}\n";
echo "REST API Key: " . substr($restApiKey, 0, 10) . "... (length: " . strlen($restApiKey) . ")\n\n";

// Test 1: Get app info
echo "1. Testing app info...\n";
$url = "https://onesignal.com/api/v1/apps/{$appId}";
$headers = [
    'Authorization: Basic ' . $restApiKey,
    'Content-Type: application/json'
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "   ❌ cURL Error: {$error}\n";
} else {
    echo "   HTTP Code: {$httpCode}\n";
    if ($httpCode === 200) {
        $data = json_decode($response, true);
        echo "   ✅ Success! App Name: " . ($data['name'] ?? 'Unknown') . "\n";
    } else {
        echo "   ❌ Failed! Response: {$response}\n";
    }
}

echo "\n";

// Test 2: Send test notification
echo "2. Testing notification send...\n";
$url = "https://onesignal.com/api/v1/notifications";
$payload = [
    'app_id' => $appId,
    'include_player_ids' => ['test-player-id-' . time()],
    'contents' => ['en' => 'Test notification from Laravel - ' . date('Y-m-d H:i:s')],
    'data' => ['type' => 'test']
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "   ❌ cURL Error: {$error}\n";
} else {
    echo "   HTTP Code: {$httpCode}\n";
    if ($httpCode === 200) {
        $data = json_decode($response, true);
        if (isset($data['errors'])) {
            echo "   ❌ OneSignal Errors:\n";
            foreach ($data['errors'] as $error) {
                echo "      - {$error}\n";
            }
        } else {
            echo "   ✅ Success! Notification ID: " . ($data['id'] ?? 'Unknown') . "\n";
        }
    } else {
        echo "   ❌ Failed! Response: {$response}\n";
    }
}

echo "\n✅ Test completed!\n";


