#!/bin/bash

# Statistics Feature Setup Script
# This script sets up the backend for statistics and app version features

echo "🚀 Setting up Statistics Feature..."
echo "===================================="
echo ""

# Colors
GREEN='\033[0;32m'
RED='\033[0;31m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

# Step 1: Run Migration
echo "📦 Step 1: Running migration..."
php artisan migrate --force

if [ $? -eq 0 ]; then
    echo -e "${GREEN}✅ Migration completed successfully${NC}"
else
    echo -e "${RED}❌ Migration failed${NC}"
    exit 1
fi

echo ""

# Step 2: Seed App Versions
echo "📱 Step 2: Seeding app versions..."
php artisan db:seed --class=AppVersionSeeder

if [ $? -eq 0 ]; then
    echo -e "${GREEN}✅ App versions seeded${NC}"
else
    echo -e "${YELLOW}⚠️  App version seeding had issues (might already exist)${NC}"
fi

echo ""

# Step 3: Seed Currency Rate History
echo "💱 Step 3: Seeding currency rate history..."
php artisan db:seed --class=CurrencyRateHistorySeeder

if [ $? -eq 0 ]; then
    echo -e "${GREEN}✅ Currency rate history seeded${NC}"
else
    echo -e "${YELLOW}⚠️  Rate history seeding had issues${NC}"
fi

echo ""

# Step 4: Record Current Rates
echo "📊 Step 4: Recording current rates..."
php artisan currency:record-rates

if [ $? -eq 0 ]; then
    echo -e "${GREEN}✅ Current rates recorded${NC}"
else
    echo -e "${YELLOW}⚠️  Rate recording had issues${NC}"
fi

echo ""
echo "===================================="
echo -e "${GREEN}🎉 Setup Complete!${NC}"
echo ""
echo "Next steps:"
echo "1. Restart your Flutter app"
echo "2. Go to Profile → Statistics"
echo "3. Enjoy the beautiful charts! 📊"
echo ""
echo "Test the APIs:"
echo "curl https://LA DERMA.innovation-pulsehub.com/api/mobile/statistics/transactions -H 'Authorization: Bearer YOUR_TOKEN'"
echo ""

