<div>
    <!-- Debug Info (remove in production) -->
    @if(config('app.debug'))
        <div class="alert alert-info" style="font-size: 12px; padding: 5px; margin-bottom: 10px;">
            <strong>Debug:</strong> Component rendered at {{ now()->format('H:i:s') }} | 
            Transactions count: {{ $transactions->count() ?? 0 }} | 
            Total: {{ $transactions->total() ?? 0 }}
        </div>
    @endif

    <style>
      
        .card {
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            padding: 20px;
            margin-bottom: 20px;
        }
        .filters {
            background-color: #fff;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        .table {
            background: white;
            border-radius: 8px;
            overflow: hidden;
            border-collapse: collapse !important;
            width: 100% !important;
        }
        
        .table-container {
            position: relative;
            overflow-x: auto;
        }
        .table thead th {
            background-color: #f8f9fa;
            border-bottom: 2px solid #dee2e6;
            color: #2c7be5 !important;
            font-weight: 600;
            padding: 12px;
        }
        .table tbody tr:hover {
            background-color: #f8f9fa;
            transition: all 0.2s;
        }
        .table td {
            padding: 12px;
            vertical-align: middle;
        }
        .btn-download {
            background-color: #2c7be5;
            color: white;
            border: none;
            padding: 8px 15px;
            border-radius: 5px;
            transition: all 0.2s;
        }
        .btn-download:hover {
            background-color: #1a68d1;
        }
        .header-info {
            margin-bottom: 20px;
        }
        .header-info h5 {
            color: #495057;
            margin-bottom: 10px;
        }
        .date-range {
            display: flex;
            gap: 15px;
            align-items: flex-end;
        }
        .form-control {
            border-radius: 5px;
            border: 1px solid #dee2e6;
            padding: 8px 12px;
        }
        .form-control:focus {
            border-color: #2c7be5;
            box-shadow: 0 0 0 0.2rem rgba(44,123,229,0.25);
        }
        .pagination {
            margin-top: 20px;
        }
        .empty-state {
            text-align: center;
            padding: 40px;
            color: #6c757d;
        }
        .table-header {
            background-color: #f8f9fa !important;
            border-bottom: 2px solid #dee2e6 !important;
            color: #2c7be5 !important;
            font-weight: 600 !important;
        }
        
        .table-header th {
            background-color: #f8f9fa !important;
            border-bottom: 2px solid #dee2e6 !important;
            color: #2c7be5 !important;
            font-weight: 600 !important;
            padding: 12px !important;
            vertical-align: middle !important;
        }
        
        .table thead {
            position: sticky !important;
            top: 0 !important;
            z-index: 10 !important;
            background-color: #f8f9fa !important;
            display: table-header-group !important;
        }
        
        .table thead tr {
            display: table-row !important;
        }
        
        .table thead th {
            display: table-cell !important;
        }
        
        /* Ensure table headers are always visible during Livewire updates */
        [wire\\:loading] .table thead,
        [wire\\:loading\\.delay] .table thead {
            display: table-header-group !important;
            visibility: visible !important;
            opacity: 1 !important;
        }

        .rtl-text {
            direction: rtl;
            unicode-bidi: isolate;
            font-family: "Noto Sans Arabic", "Tahoma", sans-serif;
            white-space: nowrap;
            display: inline-block;
            font-weight: bold;
            padding: 10px;
            border-bottom: 2px solid #dee2e6;
        }
        .total-row {
            background-color: #f8f9fa;
            font-weight: bold;
        }
        .total-row td {
            border-top: 2px solid #dee2e6;
        }
        .positive-amount {
            color: green;
        }
        .negative-amount {
            color: red;
        }
        @media print {
            .no-print {
                display: none;
            }
        }

        .header {
            text-align: center;
            margin-bottom: 10px;
        }

        .logo {
            width: 350px;
            height: auto;
            margin: 0 auto;
        }

        .contact-info {
            direction: ltr;
            unicode-bidi: embed;
            text-align: left;
            display: inline-block;
        }
    </style>

    <div  id="capture-area">

     
        <!-- Error Messages -->
        @if (session()->has('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        <!-- Filters Section -->
        <div class="card no-print">
            <div class="row">
                <div class="col-md-8">
                    <div class="date-range">
                        <div class="form-group flex-grow-1">
                            <label>لە ڕێکەوتی:</label>
                            <input type="date" wire:model.live="startDate" class="form-control">
                        </div>
                        <div class="form-group flex-grow-1">
                            <label>بۆ ڕێکەوتی:</label>
                            <input type="date" wire:model.live="endDate" class="form-control">
                        </div>
                        <button class="btn btn-download btn-lg" wire:click="downloadExcel" wire:loading.attr="disabled" wire:loading.class="opacity-50">
                            <span wire:loading.remove>
                                <i class="fas fa-file-excel me-2"></i> داونڵۆدکردن بە Excel
                            </span>
                            <span wire:loading>
                                <i class="fas fa-spinner fa-spin me-2"></i> دروستکردنی Excel...
                            </span>
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <div class="header">
            <div class="row">
                <div class="col-4">
                    <h1>الامان</h1>
                    <p>بۆ ئاڵوگۆڕی دراو</p>
                    <p>هەڤاڵان كۆڵانى باب الحاره - جادەى بيستيەكەى</p>
                </div>
                <div class="col-4">
                    <img src="/assets/logoback.png" alt="Berat Logo" class="logo">
                </div>
                <div class="col-4">
                    <h1>LA DERMA</h1>
                    <p>al-aman for moeny Exchange</p>
                    <p class="contact-info">Mobile - 0751 825 3732 <br>
                    0751 466 8873 <br>
                    0751 531 4173</p>
                </div>
            </div>
        </div>


        <!-- Header Information -->
        <div align="center" class="card header-info">
            <div class="row">
                <div class="col-md-6">
                    <h5>لە ڕێکەوتی: {{$startDate}}</h5>
                    <h5>ناوی موشتەری: {{$account->customer->customer_name}} - {{$account->customer->id}}</h5>
                </div>
                <div class="col-md-6">
                    <h5>بۆ رێکەوتی: {{$endDate}}</h5>
                    <h5>جۆری دراو: {{$account->currency->currency_name}}</h5>
                </div>
                <div class="col-md-12">
                    <h4>
                    بەڵانس:    {{ number_format($account->calculateTotalBalance(), 0, '.', ',') ?? '-' }}  {{$account->currency->currency_name}}
                    </h4>
                </div>
            </div>
        </div>

        <!-- Transactions Table -->
        <div class="card">
            <div class="table-responsive table-container">
                <table class="table table-bordered">
                    <thead>
                        <tr class="table-header">
                            <th><p class="rtl-text mb-0">#</p></th>
                            <th><p class="rtl-text mb-0">جۆری جوڵە</p></th>
                            <th><p class="rtl-text mb-0">ژمارە</p></th>
                            <th><p class="rtl-text mb-0">رێکەوت</p></th>
                            <th><p class="rtl-text mb-0">هاتوو</p></th>
                            <th><p class="rtl-text mb-0">دەرچوو</p></th>
                            <th><p class="rtl-text mb-0">بەڵانس</p></th>
                            <th><p class="rtl-text mb-0">تێبینی</p></th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $totalIncome = 0;
                            $totalExpense = 0;
                            $totalDeposit = 0;
                            $totalWithdrawal = 0;
                            $runningTotal = 0; // Initialize running total
                        @endphp
                        
                        @if($transactions && $transactions->count() > 0)
                            @foreach($transactions as $value)
                            @php
                                if ($value->transaction_type == 'withdrawal') {
                                    $totalExpense += $value->transaction_amount;
                                    $totalWithdrawal += $value->transaction_amount;
                                    $runningTotal -= $value->transaction_amount; // Subtract for withdrawal
                                } else {
                                    $totalIncome += $value->transaction_amount;
                                    $totalDeposit += $value->transaction_amount;
                                    $runningTotal += $value->transaction_amount; // Add for deposit
                                }
                            @endphp
                            <tr>
                                <td>{{$loop->iteration}}</td>
                                <td>
                                    @if($value->transaction_type == 'deposit')
                                        <span class="badge bg-success">{{ __('word.Deposit') }}</span>
                                    @elseif($value->transaction_type == 'withdrawal')
                                        <span class="badge bg-danger">{{ __('word.Withdrawal') }}</span>
                                    @elseif($value->transaction_type == 'transfer')
                                        <span class="badge bg-primary">{{ __('word.Transfer') }}</span>
                                    @endif
                                </td>
                                <td>{{$value->id}}</td>
                                <td>{{ $value->created_at ? $value->created_at->format('d/m/Y') : '-' }}</td>
                
                                <!-- Moved columns for "هاتوو" and "دەرچوو" -->
                                <td>
                                    @if($value->transaction_type == 'deposit')
                                        {{ number_format($value->transaction_amount, 0, '.', ',') }} {{$account->currency->currency_name}}
                                    @else
                                        0 {{$account->currency->currency_name}}
                                    @endif
                                </td>
                                <td>
                                    @if($value->transaction_type == 'withdrawal')
                                        {{ number_format($value->transaction_amount, 0, '.', ',') }} {{$account->currency->currency_name}}
                                    @else
                                        0 {{$account->currency->currency_name}}
                                    @endif
                                </td>
                
                                <!-- Cumulative balance for "بڕی پارە" -->
                                <td>
                                    <span >
                                        {{ number_format($runningTotal, 0, '.', ',') }} {{$account->currency->currency_name}}
                                    </span>
                                </td>
                
                                {{-- <td>{{ $value->person_name ?? '-' }}</td> --}}
                                <td>{{ $value->note ?? '-' }}</td>
                            </tr>
                            @endforeach
                        @else
                            <tr>
                                <td colspan="8" class="empty-state">
                                    <i class="fas fa-inbox fa-3x mb-3"></i>
                                    <p>هیچ داتایەک نەدۆزرایەوە</p>
                                </td>
                            </tr>
                        @endif
                
                        <!-- Totals Row -->
                        @if($transactions && $transactions->count() > 0)
                        <tr class="total-row">
                            <td colspan="4" class="text-end">کۆی گشتی</td>
                            <td>
                                <div class="positive-amount">+ {{ number_format($totalDeposit, 0, '.', ',') }} {{$account->currency->currency_name}}</div>
                            </td>
                            <td>
                                <div class="negative-amount">- {{ number_format($totalWithdrawal, 0, '.', ',') }} {{$account->currency->currency_name}}</div>
                            </td>
                            <td>
                                <div class="mt-1 {{ ($totalIncome - $totalExpense) >= 0 ? 'positive-amount' : 'negative-amount' }}">
                                    = {{ number_format($totalIncome - $totalExpense, 0, '.', ',') }} {{$account->currency->currency_name}}
                                </div>
                            </td>
                            <td colspan="2"></td>
                        </tr>
                        @endif
                    </tbody>
                </table>                
            </div>
            
            <!-- Pagination -->
            <div class="d-flex justify-content-center no-print">
                {{ $transactions->links(data: ['scrollTo' => false]) }}

            </div>
        </div>
    </div>


</div>
