<div>
    <!-- Info Alert -->
    <div class="alert alert-info alert-dismissible fade show" role="alert">
        <i class="fa fa-info-circle me-2"></i>
        <strong>Performance Optimized:</strong> This page loads today's transactions by default for faster performance. 
        Use the date filters or quick filter buttons below to view other time periods.
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>

    <!-- Summary Cards with Loading States -->
    <div class="row">
        <div class="col-sm-6 col-lg-3 mb-4">
            <div class="card card-border-shadow-primary">
                <div class="card-body">
                    <div class="d-flex align-items-center mb-2 pb-1">
                        <div class="avatar me-2">
                            <span class="avatar-initial rounded bg-label-primary"><i class="ti ti-report-money ti-md"></i></span>
                        </div>
                        <h4 class="ms-1 mb-0">
                            <span wire:loading.remove wire:target="loadSummaryData">{{ number_format($totalDeposits) }}</span>
                            <span wire:loading wire:target="loadSummaryData" class="spinner-border spinner-border-sm" role="status">
                                <span class="visually-hidden">Loading...</span>
                            </span>
                        </h4>
                    </div>
                    <p class="mb-1">@lang('word.getTotalDeposit')</p>
                </div>
            </div>
        </div>

        <div class="col-sm-6 col-lg-3 mb-4">
            <div class="card card-border-shadow-warning">
                <div class="card-body">
                    <div class="d-flex align-items-center mb-2 pb-1">
                        <div class="avatar me-2">
                            <span class="avatar-initial rounded bg-label-warning"><i class="ti ti-report-money ti-md"></i></span>
                        </div>
                        <h4 class="ms-1 mb-0">
                            <span wire:loading.remove wire:target="loadSummaryData">{{ number_format($totalWithdrawals) }}</span>
                            <span wire:loading wire:target="loadSummaryData" class="spinner-border spinner-border-sm" role="status">
                                <span class="visually-hidden">Loading...</span>
                            </span>
                        </h4>
                    </div>
                    <p class="mb-1">@lang('word.getTotalWithdrawal')</p>
                </div>
            </div>
        </div>

        <div class="col-sm-6 col-lg-3 mb-4">
            <div class="card card-border-shadow-danger">
                <div class="card-body">
                    <div class="d-flex align-items-center mb-2 pb-1">
                        <div class="avatar me-2">
                            <span class="avatar-initial rounded bg-label-danger"><i class="ti ti-send ti-md"></i></span>
                        </div>
                        <h4 class="ms-1 mb-0">
                            <span wire:loading.remove wire:target="loadSummaryData">{{ number_format($totalTransfers) }}</span>
                            <span wire:loading wire:target="loadSummaryData" class="spinner-border spinner-border-sm" role="status">
                                <span class="visually-hidden">Loading...</span>
                            </span>
                        </h4>
                    </div>
                    <p class="mb-1">@lang('word.Transfer')</p>
                </div>
            </div>
        </div>

        <div class="col-sm-6 col-lg-3 mb-4">
            <div class="card card-border-shadow-info">
                <div class="card-body">
                    <div class="d-flex align-items-center mb-2 pb-1">
                        <div class="avatar me-2">
                            <span class="avatar-initial rounded bg-label-info"><i class="ti ti-transform ti-md"></i></span>
                        </div>
                        <h4 class="ms-1 mb-0">
                            <span wire:loading.remove wire:target="loadSummaryData">{{ number_format($totalTransactions) }}</span>
                            <span wire:loading wire:target="loadSummaryData" class="spinner-border spinner-border-sm" role="status">
                                <span class="visually-hidden">Loading...</span>
                            </span>
                        </h4>
                    </div>
                    <p class="mb-1">@lang('word.TotalTransactions')</p>
                </div>
            </div>
        </div>
    </div>
    
    

    <!-- Filter Section with Loading States -->
    <div class="card mt-4">
        <div class="row m-4">
            <!-- Reset Button at the Top-Left Corner -->
            <div class="col-md-12 d-flex justify-content-start mb-3">
                <button class="btn btn-dark btn-sm" wire:click="resetFilters" wire:loading.attr="disabled">
                    <span wire:loading.remove wire:target="resetFilters">
                        <i class="fa fa-close"></i>
                    </span>
                    <span wire:loading wire:target="resetFilters">
                        <span class="spinner-border spinner-border-sm" role="status">
                            <span class="visually-hidden">Loading...</span>
                        </span>
                    </span>
                </button>
            </div>
            
            <!-- Date and Filter Inputs -->
            <div class="col-md-3">
                <label for="startDate">@lang('word.FromDate')</label>
                <input type="date" id="startDate" class="form-control" wire:model.lazy="startDate">
            </div>
            <div class="col-md-3">
                <label for="endDate">@lang('word.ToDate')</label>
                <input type="date" id="endDate" class="form-control" wire:model.lazy="endDate">
            </div>
            <div class="col-md-3">
                <label for="transactionType">@lang('word.TransactionType')</label>
                <select id="transactionType" class="form-control" wire:model.lazy="transactionType">
                    <option value="">{{ __('word.All') }}</option>
                    <option value="deposit">{{ __('word.Deposit') }}</option>
                    <option value="transfer">{{ __('word.Transfer') }}</option>
                    <option value="withdrawal">{{ __('word.Withdrawal') }}</option>
                </select>
            </div>
            <div class="col-md-3">
                <label for="currency">@lang('word.Currency')</label>
                <select id="currency" class="form-control" wire:model.lazy="currency">
                    <option value="">{{ __('word.All') }}</option>
                    @foreach($currencies as $currency)
                        <option value="{{ $currency->id }}">{{ $currency->currency_name }}</option>
                    @endforeach
                </select>
            </div>
        </div>
        
        <!-- Quick Filter Buttons -->
        <div class="row mx-4 mb-2">
            <div class="col-12">
                <div class="btn-group btn-group-sm" role="group">
                    <button type="button" class="btn btn-outline-primary" wire:click="$set('startDate', '{{ now()->toDateString() }}'); $set('endDate', '{{ now()->toDateString() }}'); $refresh">
                        Today
                    </button>
                    <button type="button" class="btn btn-outline-primary" wire:click="$set('startDate', '{{ now()->subDays(7)->toDateString() }}'); $set('endDate', '{{ now()->toDateString() }}'); $refresh">
                        Last 7 Days
                    </button>
                    <button type="button" class="btn btn-outline-primary" wire:click="$set('startDate', '{{ now()->startOfMonth()->toDateString() }}'); $set('endDate', '{{ now()->endOfMonth()->toDateString() }}'); $refresh">
                        This Month
                    </button>
                    <button type="button" class="btn btn-outline-primary" wire:click="$set('startDate', ''); $set('endDate', ''); $refresh">
                        All Time
                    </button>
                </div>
            </div>
        </div>

        <!-- Filter Status Display -->
        <div class="row mx-4 mb-3">
            <div class="col-12">
                <small class="text-muted">
                    @if($startDate && $endDate)
                        @if($startDate === $endDate)
                            <span class="badge bg-primary me-1">Date: {{ $startDate }} (Today)</span>
                        @else
                            <span class="badge bg-primary me-1">Date Range: {{ $startDate }} to {{ $endDate }}</span>
                        @endif
                    @elseif($startDate)
                        <span class="badge bg-primary me-1">From: {{ $startDate }}</span>
                    @elseif($endDate)
                        <span class="badge bg-primary me-1">To: {{ $endDate }}</span>
                    @else
                        <span class="badge bg-warning me-1">Date: All Time (May be slow)</span>
                    @endif
                    
                    @if($transactionType)
                        <span class="badge bg-info me-1">Type: {{ ucfirst($transactionType) }}</span>
                    @else
                        <span class="badge bg-secondary me-1">Type: All</span>
                    @endif
                    
                    @if($currency)
                        <span class="badge bg-success me-1">Currency: {{ $currencies->find($currency)->currency_name ?? 'Unknown' }}</span>
                    @else
                        <span class="badge bg-secondary me-1">Currency: All</span>
                    @endif
                </small>
            </div>
        </div>
    </div>



    <!-- Transaction Table with Loading States -->
    <div class="card mt-4">
        <div class="card-body">
            <!-- Loading State -->
            <div wire:loading wire:target="render" class="text-center p-4">
                <div class="spinner-border" role="status">
                    <span class="visually-hidden">Loading transactions...</span>
                </div>
                <p class="mt-2">Loading transactions...</p>
            </div>

            <!-- Transaction List Table -->
            <div wire:loading.remove wire:target="render">
                @if($transactions->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-border table-hover">
                            <thead>
                                <tr>
                                    <th>@lang('word.ClientName')</th>
                                    <th>@lang('word.Date')</th>
                                    <th>@lang('word.TransactionType')</th>
                                    <th>@lang('word.TransactionAmount')</th>
                                    <th>@lang('word.Fee')</th>
                                    <th>بەکارهێنەر</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($transactions as $transaction)
                                    <tr>
                                        <td>{{ $transaction->from_account->customer->customer_name ?? 'N/A' }}</td>
                                        <td>{{ $transaction->transaction_date->format('Y-m-d') }}</td>
                                        <td>
                                            @if($transaction->transaction_type == 'deposit')
                                                <span class="badge bg-success">{{ __('word.Deposit') }}</span>
                                            @elseif($transaction->transaction_type == 'transfer')
                                                <span class="badge bg-info">{{ __('word.Transfer') }}</span>
                                            @elseif($transaction->transaction_type == 'withdrawal')
                                                <span class="badge bg-warning">{{ __('word.Withdrawal') }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            {{ number_format($transaction->transaction_amount, 0, '.', ',') }} 
                                            {{ $transaction->from_account->currency->currency_name }}
                                        </td>
                                        <td>
                                            {{ number_format($transaction->fees->sum('fee_amount') ?? $transaction->get_fee, 0, '.', ',') }}
                                        </td>
                                        <td>{{ $transaction->user->name ?? 'N/A' }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <div class="d-flex justify-content-between align-items-center mt-4">
                        <!-- Total Count -->
                        <div>
                            <small class="text-muted">
                                Showing {{ $transactions->firstItem() }} to {{ $transactions->lastItem() }} 
                                of {{ $transactions->total() }} transactions
                            </small>
                        </div>
                        
                        <!-- Pagination Links -->
                        <div>
                            {{ $transactions->links(data: ['scrollTo' => false]) }}
                        </div>
                    </div>
                @else
                    <div class="alert alert-info text-center">
                        <i class="fa fa-info-circle me-2"></i>
                        <strong>No transactions found</strong>
                        <p class="mb-0 mt-2">
                            @if($startDate || $endDate || $transactionType || $currency)
                                Try adjusting your filters or 
                                <button type="button" class="btn btn-link p-0" wire:click="resetFilters">reset filters</button>
                                to see all transactions.
                            @else
                                No transactions are available at the moment.
                            @endif
                        </p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
