<div>
    <!-- Info Alert -->
    <div class="alert alert-info alert-dismissible fade show" role="alert">
        <i class="fa fa-info-circle me-2"></i>
        <strong>Performance Optimized:</strong> This page loads today's transactions by default for faster performance. 
        Use the date filters or quick filter buttons below to view other time periods.
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>

    <script src="//cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  
    @php
        $user = Auth::user();
        $isSuperAdmin = $user->hasRole('super-admin');
        $isSupervisor = $user->hasRole('supervisor');
    @endphp

    <!-- Filter Card -->
    <div class="card shadow-sm mb-4 border-0 rounded-3">
        <div class="card-header bg-white border-bottom-0 py-3 d-flex justify-content-between align-items-center">
            <h5 class="mb-0 text-primary">فلتەر</h5>
            <button wire:click="resetFilters" class="btn btn-outline-secondary btn-sm" wire:loading.attr="disabled">
                <span wire:loading.remove wire:target="resetFilters">
                    <i class="fa fa-refresh"></i> Reset
                </span>
                <span wire:loading wire:target="resetFilters">
                    <span class="spinner-border spinner-border-sm" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </span>
                </span>
            </button>
        </div>
        <div class="card-body">
            <!-- Quick Filter Buttons -->
            <div class="row mb-3">
                <div class="col-12">
                    <div class="btn-group btn-group-sm" role="group">
                        <button type="button" class="btn btn-outline-primary" wire:click="$set('startDate', '{{ now()->toDateString() }}'); $set('endDate', '{{ now()->toDateString() }}'); $refresh">
                            Today
                        </button>
                        <button type="button" class="btn btn-outline-primary" wire:click="$set('startDate', '{{ now()->subDays(7)->toDateString() }}'); $set('endDate', '{{ now()->toDateString() }}'); $refresh">
                            Last 7 Days
                        </button>
                        <button type="button" class="btn btn-outline-primary" wire:click="$set('startDate', '{{ now()->startOfMonth()->toDateString() }}'); $set('endDate', '{{ now()->endOfMonth()->toDateString() }}'); $refresh">
                            This Month
                        </button>
                        <button type="button" class="btn btn-outline-primary" wire:click="$set('startDate', ''); $set('endDate', ''); $refresh">
                            All Time
                        </button>
                    </div>
                </div>
            </div>

            <div class="row g-3 align-items-end">
                <!-- Conditionally show Cashier dropdown for super-admin -->
                @if(auth()->user()->hasRole('super-admin'))
                    <div class="col-md-3">
                        <label class="form-label text-muted small">@lang('word.Cashier')</label>
                        <select wire:model.lazy="selectedCashier" class="form-select rounded-3 shadow-sm">
                            <option value="">@lang('word.Cashier')</option>
                            @foreach($cashiers as $cashier)
                                <option value="{{ $cashier->id }}">{{ $cashier->user->name }}</option>
                            @endforeach
                        </select>
                    </div>
                @endif

                <div class="col-md-2">
                    <label class="form-label text-muted small">@lang('word.start_date')</label>
                    <input type="date" wire:model.lazy="startDate" class="form-control rounded-3 shadow-sm" />
                </div>

                <div class="col-md-2">
                    <label class="form-label text-muted small">@lang('word.end_date')</label>
                    <input type="date" wire:model.lazy="endDate" class="form-control rounded-3 shadow-sm" />
                </div>

                <div class="col-md-2">
                    <label class="form-label text-muted small">@lang('word.TransactionType')</label>
                    <select wire:model.lazy="transactionType" class="form-select rounded-3 shadow-sm">
                        <option value="">@lang('word.All')</option>
                        <option value="sell">@lang('word.Sell')</option>
                        <option value="buy">@lang('word.Buy')</option>
                    </select>
                </div>
                @if($isSuperAdmin)
                <div class="col-md-3">
                    <button wire:click="toggleProfitSummary" class="btn btn-primary px-4 py-2 rounded-3 shadow-sm w-100" wire:loading.attr="disabled">
                        <span wire:loading.remove wire:target="toggleProfitSummary">
                            {{ $showProfitSummary ? __('word.HideProfitSummary') : __('word.ShowProfitSummary') }}
                            <i class="fa {{ $showProfitSummary ? 'fa-eye-slash' : 'fa-eye' }} ms-2"></i>
                        </span>
                        <span wire:loading wire:target="toggleProfitSummary">
                            <span class="spinner-border spinner-border-sm" role="status">
                                <span class="visually-hidden">Loading...</span>
                            </span>
                        </span>
                    </button>
                </div>
                @endif
            </div>

            <!-- Filter Status Display -->
            <div class="row mt-3">
                <div class="col-12">
                    <small class="text-muted">
                        @if($startDate && $endDate)
                            @if($startDate === $endDate)
                                <span class="badge bg-primary me-1">Date: {{ $startDate }} (Today)</span>
                            @else
                                <span class="badge bg-primary me-1">Date Range: {{ $startDate }} to {{ $endDate }}</span>
                            @endif
                        @elseif($startDate)
                            <span class="badge bg-primary me-1">From: {{ $startDate }}</span>
                        @elseif($endDate)
                            <span class="badge bg-primary me-1">To: {{ $endDate }}</span>
                        @else
                            <span class="badge bg-warning me-1">Date: All Time (May be slow)</span>
                        @endif
                        
                        @if($transactionType)
                            <span class="badge bg-info me-1">Type: {{ ucfirst($transactionType) }}</span>
                        @else
                            <span class="badge bg-secondary me-1">Type: All</span>
                        @endif
                        
                        @if($selectedCashier)
                            <span class="badge bg-success me-1">Cashier: {{ $cashiers->find($selectedCashier)->user->name ?? 'Unknown' }}</span>
                        @else
                            <span class="badge bg-secondary me-1">Cashier: All</span>
                        @endif
                    </small>
                </div>
            </div>
        </div>
    </div>

    @if (session()->has('error'))
    <div class="alert alert-danger rounded-3 shadow-sm d-flex align-items-center" role="alert" wire:poll.5s>
        <i class="fa fa-exclamation-triangle me-2"></i>
        {{ session('error') }}
    </div>
    @endif

    @if($isSuperAdmin)
    <!-- Profit Summary Section -->
    @if($showProfitSummary && isset($profitSummary))
    <div class="card shadow-sm mb-4 border-0 rounded-3">
        <div class="card-header bg-primary text-white py-3 rounded-top">
            <div class="d-flex justify-content-between align-items-center">
                <h2 style="font-size: 20px" class="mb-0 text-white">@lang('word.ProfitSummary')</h2>
                <div class="text-end">
                    <h2 style="font-size: 20px" class="mb-0 badge bg-white text-dark rounded-pill px-3 py-2">
                        @lang('word.TotalProfit'): {{ number_format($profitSummary['total_profit'], 0, '.', ',') }} د.ع
                    </h2>
                </div>
            </div>
        </div>
        <div class="mt-3">
            <!-- Detailed Profit Breakdown -->
            <div class="card mb-4 border-0 shadow-sm">
                <div class="card-header bg-success text-white d-flex justify-content-between align-items-center">
                    <h6 class="mb-0 text-white">@lang('word.DetailedProfitBreakdown')</h6>
                    <button class="btn btn-sm btn-light" type="button" data-bs-toggle="collapse" data-bs-target="#detailedProfitBreakdown" aria-expanded="false">
                        <i class="fa fa-chevron-down"></i>
                    </button>
                </div>
                <div class="collapse show" id="detailedProfitBreakdown">
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>@lang('word.CurrencyPair')</th>
                                        <th>@lang('word.SellAmount')</th>
                                        <th>@lang('word.BuyAmount')</th>
                                        <th>@lang('word.MatchedAmount')</th>
                                        <th>@lang('word.ProfitAmount')</th>
                                        <th>@lang('word.Remaining')</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($profitSummary['matched_transactions'] as $match)
                                        <tr>
                                            <td class="fw-bold">
                                                {{ $match['profit_currency'] }}
                                            </td>
                                            <td>
                                                {{ number_format($match['sell_amount'], 0, '.', ',') }}
                                                <span class="text-muted small d-block">@lang('word.Fee'): {{ number_format($match['sell_fee'], 0, '.', ',') }}</span>
                                            </td>
                                            <td>
                                                {{ number_format($match['buy_amount'], 0, '.', ',') }}
                                                <span class="text-muted small d-block">@lang('word.Fee'): {{ number_format($match['buy_fee'], 0, '.', ',') }}</span>
                                            </td>
                                            <td>{{ number_format($match['match_amount'], 0, '.', ',') }}</td>
                                            <td class="fw-bold text-success">
                                                {{ number_format($match['profit'], 0, '.', ',') }} {{ $match['profit_currency'] }}
                                                <span class="text-muted small d-block">@lang('word.FeeDiff'): {{ $match['fee_difference'] }}</span>
                                            </td>
                                            <td>
                                                <span class="badge bg-warning text-dark">@lang('word.Sell'): {{ number_format($match['sell_remaining'], 0, '.', ',') }}</span>
                                                <span class="badge bg-info text-dark">@lang('word.Buy'): {{ number_format($match['buy_remaining'], 0, '.', ',') }}</span>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="6" class="text-center py-4">
                                                <div class="alert alert-info mb-0">@lang('word.Empty')</div>
                                            </td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Original Profit Summary -->
            <div class="card mb-4 border-0 shadow-sm">
                <div class="card-header bg-info text-white d-flex justify-content-between align-items-center">
                    <h6 class="mb-0 text-white">@lang('word.ProfitCalculationResults')</h6>
                    <button class="btn btn-sm btn-light" type="button" data-bs-toggle="collapse" data-bs-target="#profitCalculationResults" aria-expanded="false">
                        <i class="fa fa-chevron-down"></i>
                    </button>
                </div>
                <div class="collapse" id="profitCalculationResults">
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>@lang('word.CurrencyPair')</th>
                                        <th>@lang('word.HighestFee')</th>
                                        <th>@lang('word.LowestFee')</th>
                                        <th>@lang('word.FeeDifference')</th>
                                        <th>@lang('word.Amount')</th>
                                        <th>@lang('word.ProfitAmount')</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($profitSummary['profit_by_pair'] as $currencyPair => $pairData)
                                        @foreach($pairData['details'] as $index => $detail)
                                            <tr>
                                                <td>
                                                    @if(isset($pairData['currency_pairs'][$index]))
                                                        {{ $pairData['currency_pairs'][$index]['given'] }}/{{ $pairData['currency_pairs'][$index]['received'] }}
                                                    @else
                                                        {{ $currencyPair }}
                                                    @endif
                                                </td>
                                                <td>{{ number_format($detail['high_fee'], 0, '.', ',') }}</td>
                                                <td>{{ number_format($detail['low_fee'], 0, '.', ',') }}</td>
                                                <td>{{ number_format($detail['fee_difference'], 2, '.', ',') }}</td>
                                                <td>{{ number_format($detail['amount'], 0, '.', ',') }} {{ $detail['currency'] }}</td>
                                                <td class="fw-bold text-success">{{ number_format($detail['profit'], 0, '.', ',') }} {{ $detail['currency'] }}</td>
                                            </tr>
                                        @endforeach
                                    @empty
                                        <tr>
                                            <td colspan="6" class="text-center py-4">
                                                <div class="alert alert-info mb-0">@lang('word.Empty')</div>
                                            </td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Transaction Fee Details by Currency Pair -->
            <div class="row">
                <div class="col-md-6">
                    <div class="card mb-4 border-0 shadow-sm">
                        <div class="card-header bg-primary text-white">
                            <div class="d-flex justify-content-between align-items-center">
                                <h6 class="mb-0 text-white">@lang('word.SellTransactionsByCurrencyPair')</h6>
                                <button class="btn btn-sm btn-light" type="button" data-bs-toggle="collapse" data-bs-target="#sellTransactionsDetails" aria-expanded="false">
                                    <i class="fa fa-chevron-down"></i>
                                </button>
                            </div>
                        </div>
                        <div class="collapse" id="sellTransactionsDetails">
                            <div class="card-body">
                                <div class="accordion" id="sellAccordion">
                                    @php
                                        $hasVisibleSellPairs = false;
                                    @endphp
                                    
                                    @foreach($profitSummary['sell'] as $currencyPair => $feeData)
                                        @php
                                            // Extract currency names from the pair
                                            list($fromCurrencyName, $toCurrencyName) = explode('/', $currencyPair);
                                            
                                            // Find the currency objects to check their types
                                            $fromCurrency = App\Models\Currency::where('currency_name', $fromCurrencyName)->first();
                                            $toCurrency = App\Models\Currency::where('currency_name', $toCurrencyName)->first();
                                            
                                            // Skip if either currency has type 1 or if currency not found
                                            if (!$fromCurrency || !$toCurrency || 
                                                $fromCurrency->currency_type == 1 || 
                                                $toCurrency->currency_type == 1) {
                                                continue;
                                            }
                                            
                                            $hasVisibleSellPairs = true;
                                        @endphp
                                        
                                        <div class="accordion-item mb-2 border rounded">
                                            <h2 class="accordion-header" id="heading-sell-{{ str_replace('/', '-', $currencyPair) }}">
                                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" 
                                                    data-bs-target="#collapse-sell-{{ str_replace('/', '-', $currencyPair) }}" 
                                                    aria-expanded="false" aria-controls="collapse-sell-{{ str_replace('/', '-', $currencyPair) }}">
                                                    <span class="fw-bold">{{ $currencyPair }}</span>
                                                </button>
                                            </h2>
                                            <div id="collapse-sell-{{ str_replace('/', '-', $currencyPair) }}" class="accordion-collapse collapse" 
                                                aria-labelledby="heading-sell-{{ str_replace('/', '-', $currencyPair) }}" 
                                                data-bs-parent="#sellAccordion">
                                                <div class="accordion-body p-0">
                                                    <div class="table-responsive">
                                                        <table class="table table-sm table-striped mb-0">
                                                            <thead class="table-light">
                                                                <tr>
                                                                    <th>@lang('word.Fee')</th>
                                                                    <th>@lang('word.TransactionCount')</th>
                                                                    <th>@lang('word.AmountGiven')</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                @foreach($feeData as $fee => $data)
                                                                    <tr>
                                                                        <td>{{ number_format($fee, 4) }}</td>
                                                                        <td>{{ $data['count'] }}</td>
                                                                        <td>{{ number_format($data['total_amount_given'], 0, '.', ',') }} {{ $data['given_currency'] }}</td>
                                                                    </tr>
                                                                @endforeach
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                    
                                    @if(!$hasVisibleSellPairs)
                                        <div class="alert alert-info">@lang('word.Empty')</div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="card mb-4 border-0 shadow-sm">
                        <div class="card-header bg-warning text-dark">
                            <div class="d-flex justify-content-between align-items-center">
                                <h6 class="mb-0 text-white">@lang('word.BuyTransactionsByCurrencyPair')</h6>
                                <button class="btn btn-sm btn-dark" type="button" data-bs-toggle="collapse" data-bs-target="#buyTransactionsDetails" aria-expanded="false">
                                    <i class="fa fa-chevron-down"></i>
                                </button>
                            </div>
                        </div>
                        <div class="collapse" id="buyTransactionsDetails">
                            <div class="card-body">
                                <div class="accordion" id="buyAccordion">
                                    @php
                                        $hasVisibleBuyPairs = false;
                                    @endphp
                                    
                                    @foreach($profitSummary['buy'] as $currencyPair => $feeData)
                                        @php
                                            // Extract currency names from the pair
                                            list($fromCurrencyName, $toCurrencyName) = explode('/', $currencyPair);
                                            
                                            // Find the currency objects to check their types
                                            $fromCurrency = App\Models\Currency::where('currency_name', $fromCurrencyName)->first();
                                            $toCurrency = App\Models\Currency::where('currency_name', $toCurrencyName)->first();
                                            
                                            // Skip if either currency has type 1 or if currency not found
                                            if (!$fromCurrency || !$toCurrency || 
                                                $fromCurrency->currency_type == 1 || 
                                                $toCurrency->currency_type == 1) {
                                                continue;
                                            }
                                            
                                            $hasVisibleBuyPairs = true;
                                        @endphp
                                        
                                        <div class="accordion-item mb-2 border rounded">
                                            <h2 class="accordion-header" id="heading-buy-{{ str_replace('/', '-', $currencyPair) }}">
                                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" 
                                                    data-bs-target="#collapse-buy-{{ str_replace('/', '-', $currencyPair) }}" 
                                                    aria-expanded="false" aria-controls="collapse-buy-{{ str_replace('/', '-', $currencyPair) }}">
                                                    <span class="fw-bold">{{ $currencyPair }}</span>
                                                </button>
                                            </h2>
                                            <div id="collapse-buy-{{ str_replace('/', '-', $currencyPair) }}" class="accordion-collapse collapse" 
                                                aria-labelledby="heading-buy-{{ str_replace('/', '-', $currencyPair) }}" 
                                                data-bs-parent="#buyAccordion">
                                                <div class="accordion-body p-0">
                                                    <div class="table-responsive">
                                                        <table class="table table-sm table-striped mb-0">
                                                            <thead class="table-light">
                                                                <tr>
                                                                    <th>@lang('word.Fee')</th>
                                                                    <th>@lang('word.TransactionCount')</th>
                                                                    <th>@lang('word.AmountReceived')</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                @foreach($feeData as $fee => $data)
                                                                    <tr>
                                                                        <td>{{ number_format((float) $fee, 4) }}</td>
                                                                        <td>{{ $data['count'] }}</td>
                                                                        <td>{{ number_format($data['total_amount_received'], 0, '.', ',') }} {{ $data['received_currency'] }}</td>
                                                                    </tr>
                                                                @endforeach
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                    
                                    @if(!$hasVisibleBuyPairs)
                                        <div class="alert alert-info">@lang('word.Empty')</div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif
    @endif

    <!-- Transactions Table -->
    <div class="card shadow-sm border-0 rounded-3">
        <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
            <h5 class="mb-0 text-primary">@lang('word.TransactionList')</h5>
            <span class="badge bg-primary rounded-pill px-3 py-2">{{ $transactions->total() }} @lang('word.Transactions')</span>
        </div>
        <div class="card-body p-0">
            <!-- Loading State -->
            <div wire:loading wire:target="render" class="text-center p-4">
                <div class="spinner-border" role="status">
                    <span class="visually-hidden">Loading transactions...</span>
                </div>
                <p class="mt-2">Loading transactions...</p>
            </div>

            <!-- Transaction List Table -->
            <div wire:loading.remove wire:target="render">
                @if($transactions->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-hover align-middle mb-0">
                            <thead class="table-light text-nowrap">
                                <tr>
                                    <th class="ps-3">#</th>
                                    <th>@lang('word.Cashier')</th>
                                    <th>@lang('word.TransactionType')</th>
                                    <th>@lang('word.AmountGiven')</th>
                                    <th>@lang('word.AmountReceived')</th>
                                    <th>@lang('word.Fee')</th>
                                    <th>@lang('word.Date')</th>
                                    <th class="text-center">@lang('word.Actions')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($transactions as $transaction)
                                    <tr>
                                        <td class="ps-3">{{ $transaction->id }}</td>
                                        <td>{{ $transaction->cashierShift->cashier->user->name ?? 'N/A' }}</td>
                                        <td>
                                            @if($transaction->transaction_type == 'sell')
                                                <span class="badge bg-primary rounded-pill">{{ __('word.Sell') }}</span>
                                            @else
                                                <span class="badge bg-warning text-dark rounded-pill">{{ __('word.Buy') }}</span>
                                            @endif
                                        </td>                    
                                        <td>
                                            <span class="fw-bold">{{ number_format($transaction->amount_given, 0, '.', ',') }}</span>
                                            <span class="text-muted small">{{ $transaction->to_currency_code->currency_name }}</span>
                                        </td>
                                        <td>
                                            <span class="fw-bold">{{ number_format($transaction->amount_received, 0, '.', ',') }}</span>
                                            <span class="text-muted small">{{ $transaction->from_currency_code->currency_name }}</span>
                                        </td>
                                        <td>{{ number_format(optional($transaction->fees->first())->fee_amount ?? 0, 2, '.', ',') }}</td>
                                        <td>
                                            <div>{{ $transaction->transaction_date->format('Y-m-d') }}</div>
                                            <div class="text-muted small">{{ $transaction->transaction_time }}</div>
                                        </td>
                                        <td>
                                            <div class="d-flex justify-content-center gap-1">
                                                <a target="_blank" href="{{ route('transaction_invoice', [ $transaction->id]) }}" class="btn btn-sm btn-outline-dark rounded-3">
                                                    <i class="fa fa-print"></i>
                                                    <span class="d-none d-lg-inline ms-1">@lang('word.Print')</span>
                                                </a>
                                                
                                                <a target="_blank" href="{{ route('transaction_invoice_pos', [ $transaction->id]) }}" class="btn btn-sm btn-outline-primary rounded-3">
                                                    <i class="fa fa-receipt"></i>
                                                    <span class="d-none d-lg-inline ms-1">POS</span>
                                                </a>
                                                
                                                @if(Auth::user()->hasRole('super-admin'))
                                                <button wire:click="deleteTransaction({{ $transaction->id }})"
                                                    class="btn btn-sm btn-outline-danger rounded-3"
                                                    onclick="confirm('{{ trans('word.ConfirmDelete') }}') || event.stopImmediatePropagation()">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Pagination -->
                    <div class="d-flex justify-content-between align-items-center py-3 border-top">
                        <!-- Total Count -->
                        <div>
                            <small class="text-muted">
                                Showing {{ $transactions->firstItem() }} to {{ $transactions->lastItem() }} 
                                of {{ $transactions->total() }} transactions
                            </small>
                        </div>
                        
                        <!-- Pagination Links -->
                        <div>
                            {{ $transactions->links(data: ['scrollTo' => false]) }}
                        </div>
                    </div>
                @else
                    <div class="alert alert-info text-center">
                        <i class="fa fa-info-circle me-2"></i>
                        <strong>No transactions found</strong>
                        <p class="mb-0 mt-2">
                            @if($startDate || $endDate || $transactionType || $selectedCashier)
                                Try adjusting your filters or 
                                <button type="button" class="btn btn-link p-0" wire:click="resetFilters">reset filters</button>
                                to see all transactions.
                            @else
                                No transactions are available at the moment.
                            @endif
                        </p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>