<div>
  <script src="//cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
  <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

  <style>
 
  
    .control-card {
      background: #fff;
      border-radius: 12px;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
      padding: 12px;
      height: auto;
      display: flex;
      flex-direction: column;
      justify-content: center;
    }

    .control-label {
      font-size: 1rem;
      font-weight: 600;
      color: #2c3e50;
      margin-bottom: 10px;
    }

    .customer-field {
      margin-bottom: 0;
    }

    .customer-field input {
      border: 2px solid #e9ecef;
      border-radius: 8px;
      padding: 12px 15px;
      font-size: 1.1rem;
      width: 100%;
    }

    .action-card-single {
      background: #fff;
      border-radius: 12px;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
      padding: 10px;
      height: auto;
      display: flex;
      align-items: center;
      justify-content: center;
    }

    .compact-card {
      padding: 10px 14px;
      flex-direction: column;
      gap: 8px;
    }

    .fee-mode-card {
      padding: 10px 14px;
      flex-direction: column;
      gap: 8px;
    }

    .transaction-button {
      width: 100%;
      height: auto;
      padding: 12px 16px;
      border: none;
      background-color: #f8f9fa;
      color: #495057;
      cursor: pointer;
      font-size: 1.4rem;
      font-weight: 600;
      transition: all 0.3s ease;
      border-radius: 10px;
    }

    .transaction-button:hover {
      opacity: 0.9;
    }

    .transaction-button.active[wire\:click="$set('transaction_type', 'sell')"] {
      background-color: #dc3545;
      color: #fff;
      box-shadow: 0 8px 20px rgba(220, 53, 69, 0.25);
    }

    .transaction-button.active[wire\:click="$set('transaction_type', 'buy')"] {
      background-color: #28a745;
      color: #fff;
      box-shadow: 0 8px 20px rgba(40, 167, 69, 0.25);
    }

    .digital-card {
      padding: 10px 14px;
    }

    .digital-toggle {
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 12px;
      margin: 0;
    }

    .toggle-checkbox {
      position: relative;
      width: 50px;
      height: 26px;
      -webkit-appearance: none;
      appearance: none;
      background: #e9ecef;
      border-radius: 20px;
      transition: 0.4s;
      box-shadow: inset 0 0 5px rgba(0, 0, 0, 0.1);
      cursor: pointer;
    }

    .toggle-checkbox:before {
      content: '';
      position: absolute;
      width: 22px;
      height: 22px;
      border-radius: 20px;
      top: 2px;
      left: 2px;
      background: #fff;
      transition: 0.4s;
      box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
    }

    .toggle-checkbox:checked {
      background: #3498db;
    }

    .toggle-checkbox:checked:before {
      left: 24px;
    }

    .conversion-row {
      margin-bottom: 30px;
    }

    .section-title {
      font-size: 1.1rem;
      font-weight: 700;
      color: #2c3e50;
      margin-bottom: 12px;
    }

    .conversion-card {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      border-radius: 12px;
      overflow: hidden;
      box-shadow: 0 8px 25px rgba(102, 126, 234, 0.3);
      color: #fff;
    }

    .conversion-header {
      background: rgba(255, 255, 255, 0.1);
      padding: 20px;
      text-align: center;
      font-size: 1.3rem;
      font-weight: 600;
      border-bottom: 1px solid rgba(255, 255, 255, 0.2);
    }

    .conversion-header i {
      margin-right: 10px;
      font-size: 1.2rem;
    }

    .conversion-body {
      padding: 25px;
    }

    .conversion-info {
      margin-bottom: 20px;
    }

    .conversion-amount,
    .conversion-rate {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 15px;
      padding: 15px;
      background: rgba(255, 255, 255, 0.1);
      border-radius: 8px;
      border: 1px solid rgba(255, 255, 255, 0.2);
    }

    .conversion-amount label,
    .conversion-rate label {
      font-weight: 600;
      font-size: 1.1rem;
      margin: 0;
    }

    .converted-value,
    .rate-value {
      font-weight: 700;
      font-size: 1.2rem;
      color: #ffd700;
      text-shadow: 0 0 10px rgba(255, 215, 0, 0.5);
    }

    .conversion-note {
      background: rgba(255, 255, 255, 0.15);
      padding: 15px;
      border-radius: 8px;
      border-left: 4px solid #ffd700;
      font-size: 0.95rem;
      line-height: 1.5;
    }

    .conversion-note i {
      margin-right: 8px;
      color: #ffd700;
    }

    .conversion-placeholder {
      background: rgba(255, 255, 255, 0.08);
      border-radius: 8px;
      padding: 25px;
      text-align: center;
      border: 1px dashed rgba(255, 255, 255, 0.2);
    }

    .conversion-placeholder span {
      display: block;
      margin-top: 10px;
      color: rgba(255, 255, 255, 0.8);
    }

    .rate-card {
      background: #fff;
      border-radius: 12px;
      box-shadow: 0 8px 20px rgba(0, 0, 0, 0.08);
      padding: 12px;
      height: auto;
      display: flex;
      flex-direction: column;
      gap: 12px;
    }

    .fee-input {
      width: 100%;
      padding: 12px;
      border: 2px solid #e9ecef;
      border-radius: 8px;
      font-size: 1.1rem;
      font-weight: 600;
      text-align: center;
    }

    .fee-input[readonly] {
      background-color: #f8f9fa;
      cursor: not-allowed;
    }

    .fee-mode-options {
      display: flex;
      justify-content: center;
      gap: 10px;
      margin-bottom: 8px;
      max-width: 200px;
      margin-left: auto;
      margin-right: auto;
      flex-wrap: wrap;
    }

    .fee-mode-options label {
      display: flex;
      align-items: center;
      gap: 6px;
      font-size: 0.9rem;
      font-weight: 500;
      color: #495057;
      cursor: pointer;
    }

    .fee-mode-options input[type="radio"] {
      accent-color: #3498db;
      width: 16px;
      height: 16px;
    }

    .fee-mode-hint {
      font-size: 0.85rem;
      color: #6c757d;
      text-align: center;
      margin-top: 4px;
    }

    .save-button {
      width: 100%;
      padding: 14px 20px;
      background-color: #3498db;
      border: none;
      border-radius: 8px;
      color: #fff;
      font-size: 1.1rem;
      font-weight: 600;
      cursor: pointer;
      transition: all 0.3s ease;
      box-shadow: 0 4px 12px rgba(52, 152, 219, 0.3);
    }

    .save-button:hover {
      background-color: #2980b9;
      transform: translateY(-2px);
      box-shadow: 0 6px 15px rgba(52, 152, 219, 0.4);
    }

    /* Currency cards styling (unchanged) */
    .exchange-cards {
      display: flex;
      gap: 20px;
      margin-bottom: 30px;
    }

    .currency-card {
      flex: 1;
      border-radius: 12px;
      overflow: hidden;
      box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
      background: white;
      transition: all 0.3s ease;
    }

    .currency-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 12px 30px rgba(0, 0, 0, 0.15);
    }

    .card-header {
      background-color: #3498db;
      color: white;
      padding: 15px 20px;
      font-size: 1.2rem;
      font-weight: 600;
    }

    .card-body {
      padding: 20px;
    }

    .amount-field {
      margin-bottom: 20px;
    }

    .amount-field label {
      display: block;
      margin-bottom: 10px;
      font-size: 1.5rem;
      font-weight: 600;
      color: #2c3e50;
    }

    .amount-field input {
      width: 100%;
      padding: 15px;
      border: 2px solid #e9ecef;
      border-radius: 8px;
      font-size: 1.5rem;
      font-weight: 600;
      transition: border-color 0.3s;
    }

    .amount-field input:focus {
      border-color: #3498db;
      outline: none;
    }

    .currency-selection-label {
      display: block;
      margin: 15px 0;
      font-size: 1.2rem;
      font-weight: 600;
      color: #2c3e50;
    }

    .currency-row {
      display: flex;
      flex-wrap: wrap;
      gap: 15px;
      margin-bottom: 15px;
    }

    .currency-option {
      position: relative;
      flex: 0 0 calc(33.333% - 15px);
      text-align: center;
      transition: all 0.3s ease;
    }

    .currency-label {
      display: flex;
      flex-direction: column;
      align-items: center;
      padding: 15px 10px;
      border-radius: 10px;
      cursor: pointer;
      transition: all 0.3s ease;
      background-color: #f8f9fa;
    }

    .currency-label:hover {
      background-color: #e9ecef;
      transform: translateY(-3px);
    }

    .currency-img {
      width: 60px;
      height: 60px;
      object-fit: contain;
      border: 3px solid transparent;
      border-radius: 50%;
      padding: 5px;
      margin-bottom: 8px;
      transition: all 0.3s ease;
      background-color: white;
      box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
    }

    .currency-name {
      font-size: 0.9rem;
      font-weight: 500;
      color: #495057;
      margin-top: 8px;
    }

    .currency-radio {
      position: absolute;
      opacity: 0;
    }

    .currency-radio:checked + .currency-label {
      background-color: #e3f2fd;
    }

    .currency-radio:checked + .currency-label .currency-img {
      border-color: #3498db;
      transform: scale(1.1);
    }

    .load-more {
      display: block;
      width: 100%;
      padding: 12px;
      background-color: #f1f3f5;
      border: none;
      border-radius: 8px;
      color: #495057;
      font-weight: 600;
      cursor: pointer;
      transition: all 0.3s ease;
    }

    .load-more:hover {
      background-color: #e9ecef;
    }

    /* Responsive Adjustments */
    @media (max-width: 992px) {
      .exchange-cards {
        flex-direction: column;
      }

      .currency-option {
        flex: 0 0 calc(50% - 15px);
      }
    }

    @media (max-width: 768px) {
      .currency-option {
        flex: 0 0 calc(50% - 15px);
      }

      .conversion-amount,
      .conversion-rate {
        flex-direction: column;
        text-align: center;
        gap: 10px;
      }

      .conversion-body {
        padding: 20px;
      }
    }

    @media (max-width: 576px) {
      .currency-option {
        flex: 0 0 100%;
      }

      .amount-field input,
      .fee-input {
        font-size: 1.2rem;
      }

      .transaction-button {
        font-size: 1.1rem;
      }
    }
  </style>

  @if (session()->has('message'))
  <div class="alert alert-success" wire:poll.5s>
    {{ session('message') }}
  </div>
  @endif

  @if (session()->has('error'))
  <div class="alert alert-danger" wire:poll.5s>
    {{ session('error') }}
  </div>
  @endif

  <div class="currency-exchange">
      
      <div class="row align-items-stretch g-3 mb-2">
        <div class="col-xl-2 col-lg-3 col-sm-6">
          <div class="action-card-single compact-card w-100 h-100">
            <label class="control-label" for="customer_name">@lang('word.NameCustomerIf')</label>
            <input placeholder="<?php echo trans('word.NameCustomerIf'); ?>" type="text" id="customer_name" class="form-control" step="0.01" wire:model="customer_name">
            @error('customer_name') <span class="text-danger">{{ $message }}</span> @enderror
          </div>
        </div>
        <div class="col-xl-2 col-lg-3 col-sm-6">
          <div class="action-card-single fee-mode-card w-100 h-100">
            <div class="fee-mode-options">
              <label class="mb-0">
                <input type="radio" name="fee_mode" value="auto" wire:model.live="fee_mode">
                <span>خۆکار</span>
              </label>
              <label class="mb-0 {{ $this->isUsdConversion ? '' : 'text-muted' }}">
                <input type="radio" name="fee_mode" value="manual" wire:model.live="fee_mode" {{ $this->isUsdConversion ? '' : 'disabled' }}>
                <span>دەستکرد (تەنها USD)</span>
              </label>
            </div>
            <input type="text" id="transaction_fee" step="0.01" wire:model.live="transaction_fee" class="fee-input" {{ $is_digital_currency || ($fee_mode === 'manual' && $this->isUsdConversion) ? '' : 'readonly' }}>
            <div class="fee-mode-hint">
              @if(!$this->isUsdConversion)
                {{-- دەستکاری بە دەستکرد تەنها کاتێک چالاک دەبێت کە USD لە گۆڕانکاریەکەدا بەشدار بێت. --}}
              @elseif($fee_mode === 'auto')
                نرخەکە خۆکارانە لە نرخە پشتەوەی USD وەرگیرایە.
              @else
                نرخە کڕین/فرۆشتنی USD بە دەستکرد بنووسە بۆ گۆڕینی نرخە خۆکارەکە.
              @endif
            </div>
            @error('transaction_fee') <span class="text-danger">{{ $message }}</span> @enderror
          </div>
        </div>
        <div class="col-xl-2 col-lg-3 col-sm-6">
          <div class="control-card digital-card mb-0 w-100 h-100 d-flex align-items-center justify-content-center flex-column">
            <span class="control-label">@lang('crud.currencies.inputs.digital')</span>
            <div class="digital-toggle">
              <input type="checkbox" id="digital_currency" class="toggle-checkbox" wire:model.live="is_digital_currency" />
              {{-- <label for="digital_currency" class="mb-0">@lang('crud.currencies.inputs.digital')</label> --}}
            </div>
          </div>
        </div>
        <div class="col-xl-2 col-lg-3 col-sm-6">
          <div class="action-card-single w-100 h-100 d-flex align-items-center">
            <button class="save-button" type="submit" wire:click="submit">@lang('word.Save')</button>
          </div>
        </div>

        <div class="col-xl-2 col-lg-4 col-sm-6">
          <div class="action-card-single w-100 h-100">
            <button type="button" class="transaction-button {{ $transaction_type === 'sell' ? 'active' : '' }}" wire:click="$set('transaction_type', 'sell')">
              @lang('word.Sell')
            </button>
          </div>
        </div>
        <div class="col-xl-2 col-lg-4 col-sm-6">
          <div class="action-card-single w-100 h-100">
            <button type="button" class="transaction-button {{ $transaction_type === 'buy' ? 'active' : '' }}" wire:click="$set('transaction_type', 'buy')">
              @lang('word.Buy')
            </button>
          </div>
        </div>
       
        
      </div>

      <div class="row mb-2">
        <div class="col-12 text-center">
          @error('transaction_type') <span class="text-danger">{{ $message }}</span> @enderror
        </div>
      </div>

      <div class="exchange-cards">
        <div class="currency-card">
          <div class="card-header">
            @lang('word.FromCurrency')
          </div>
          <div class="card-body">
            <div class="amount-field">
              <label for="amount_received">@lang('word.AmountReceived')</label>
              <input type="text" x-mask:dynamic="$money($input, '.', ',', 4)" id="amount_received" step="0.01" wire:model.live="amount_received">
              @error('amount_received') <span class="text-danger">{{ $message }}</span> @enderror
            </div>

            <label class="currency-selection-label">@lang('word.FromCurrency')</label>
            <div class="currency-selection">
              <div class="currency-row">
                @foreach($filteredFromCurrencies as $currency)
                <div class="currency-option">
                  <input type="radio" id="from_currency{{ $currency->id }}" name="from_currency" wire:model.live="filters.from_currency" value="{{ $currency->id }}" class="currency-radio">
                  <label for="from_currency{{ $currency->id }}" class="currency-label">
                    <img src="{{ $currency->code ? \Storage::url($currency->code) : '' }}" alt="{{ $currency->currency_name }}" class="currency-img">
                    <span class="currency-name">{{ $currency->currency_name }}</span>
                  </label>
                </div>
                @endforeach
              </div>
              @if($currencies->count() > $visibleFromCurrencies)
              <button wire:click="loadMoreFromCurrencies" class="load-more">@lang('word.LoadMore')</button>
              @endif
            </div>
            @error('filters.from_currency') <span class="text-danger">{{ $message }}</span> @enderror
          </div>
        </div>

        <div class="currency-card">
          <div class="card-header">
            @lang('word.ToCurrency')
          </div>
          <div class="card-body">
            <div class="amount-field">
              <label for="amount_given">@lang('word.AmountGiven')</label>
              <input type="text" x-mask:dynamic="$money($input, '.', ',', 4)" id="amount_given" step="0.01" wire:model.live="amount_given">
              @error('amount_given') <span class="text-danger">{{ $message }}</span> @enderror
            </div>

            <label class="currency-selection-label">@lang('word.ToCurrency')</label>
            <div class="currency-selection">
              <div class="currency-row">
                @foreach($filteredToCurrencies as $currency)
                <div class="currency-option">
                  <input type="radio" id="to_currency{{ $currency->id }}" name="to_currency" wire:model.live="filters.to_currency" value="{{ $currency->id }}" class="currency-radio">
                  <label for="to_currency{{ $currency->id }}" class="currency-label">
                    <img src="{{ $currency->code ? \Storage::url($currency->code) : '' }}" alt="{{ $currency->currency_name }}" class="currency-img">
                    <span class="currency-name">{{ $currency->currency_name }}</span>
                  </label>
                </div>
                @endforeach
              </div>
              @if($currencies->count() > $visibleToCurrencies)
              <button wire:click="loadMoreToCurrencies" class="load-more">@lang('word.LoadMore')</button>
              @endif
            </div>
            @error('filters.to_currency') <span class="text-danger">{{ $message }}</span> @enderror
          </div>
        </div>
      </div>

      <div class="conversion-card mt-4">
        <div class="conversion-header">
          <i class="fa fa-exchange-alt"></i>
          گۆڕینی دراو
        </div>
        <div class="conversion-body">
          @if($showConversionInfo)
          <div class="conversion-info">
            <div class="conversion-amount">
              <label>@lang('word.ConvertedAmount')</label>
              <span class="converted-value">{{ $convertedAmount }}</span>
            </div>
            <div class="conversion-rate">
              <label>@lang('word.ConversionRate')</label>
              <span class="rate-value">{{ $conversionRate }}</span>
            </div>
          </div>
          <div class="conversion-note">
            <i class="fa fa-info-circle"></i>
            @lang('word.ConversionNote')
          </div>
          @else
          <div class="conversion-placeholder">
            <strong>@lang('word.CurrencyConversion')</strong>
            <span>@lang('word.ConversionNote')</span>
          </div>
          @endif
        </div>
      </div>
  </div>
</div>