<div >
    <script src="//cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  
    <div class="card shadow border-0 mb-4 rounded-3">
        <div class="card-header bg-gradient-primary text-white py-3">
            <h2 class="mb-0 fs-4 fw-bold text-white"><i class="fa fa-check-circle me-2"></i>ڕەزامەندی جوڵەکان</h2>
        </div>
        
        <div class="card-body mt-3">
            <!-- Filters Section -->
            <div class="bg-light p-3 rounded-3 mb-4 shadow-sm">
                <div class="row g-3">
                    <div class="col-md-3">
                        <div class="form-floating">
                            <input type="text" class="form-control" id="searchInput" placeholder="گەڕان" wire:model.live="search">
                            <label for="searchInput"><i class="fa fa-search me-1"></i>گەڕان بە ناو/تێبینی/ناسنامە...</label>
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                        <div class="form-floating">
                            <select class="form-select" id="userSelect" wire:model.live="selectedUser">
                                <option value="">هەموو بەکارهێنەران</option>
                                @foreach($users as $user)
                                    <option value="{{ $user->id }}">{{ $user->name }}</option>
                                @endforeach
                            </select>
                            <label for="userSelect"><i class="fa fa-user me-1"></i>بەکارهێنەر</label>
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                        <div class="form-floating">
                            <input type="date" class="form-control" id="startDate" wire:model.live="startDate">
                            <label for="startDate"><i class="fa fa-calendar me-1"></i>لە بەرواری</label>
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                        <div class="form-floating">
                            <input type="date" class="form-control" id="endDate" wire:model.live="endDate">
                            <label for="endDate"><i class="fa fa-calendar me-1"></i>بۆ بەرواری</label>
                        </div>
                    </div>
                    
                    <div class="col-12 d-flex justify-content-end">
                        <button class="btn btn-secondary px-4" wire:click="resetFilters">
                            <i class="fa fa-refresh me-2"></i>پاککردنەوەی فلتەرەکان
                        </button>
                    </div>
                </div>
            </div>
            
            <!-- Pending Transactions Section -->
            <div class="mb-4">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h3 class="fs-5 text-primary fw-bold"><i class="fa fa-clock-o me-2"></i>جوڵەکانی چاوەڕوانی ڕەزامەندی</h3>
                    <span class="badge bg-warning px-3 py-2 rounded-pill fs-6">{{ count($transactions) }} جوڵە</span>
                </div>
                
                <div class="table-responsive shadow-sm rounded-3">
                    <table class="table table-hover mb-0 align-middle">
                        <thead class="bg-light">
                            <tr>
                                <th class="py-3 text-nowrap">#</th>
                                <th class="py-3 text-nowrap">بەروار</th>
                                <th class="py-3 text-nowrap">لە موشتەرییەوە</th>
                                <th class="py-3 text-nowrap">اسم مستفید</th>
                                <th class="py-3 text-nowrap">جۆر</th>
                                <th class="py-3 text-nowrap">بڕ</th>
                                <th class="py-3 text-nowrap">لۆ موشتەری</th>
                                <th class="py-3 text-nowrap">تێبینی</th>
                                <th class="py-3 text-nowrap">بەکارهێنەر</th>
                                <th class="py-3 text-center text-nowrap">کردارەکان</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($transactions as $transaction)
                                <tr>
                                    <td>{{ $transaction->id }}</td>
                                    <td>
                                        <div class="d-flex flex-column">
                                            <span class="fw-medium">{{ $transaction->created_at->format('Y-m-d') }}</span>
                                            <small class="text-muted">{{ $transaction->created_at->format('H:i') }}</small>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex flex-column">
                                            <span class="fw-medium">{{ $transaction->sender_name ?? 'Unknown' }}</span>
                                            @if($transaction->sender_phone)
                                                <small class="text-muted">
                                                    <i class="fas fa-phone-alt me-1"></i>{{ $transaction->sender_phone }}
                                                </small>
                                            @endif
                                        </div>
                                    </td>
                                    
                                    <td>
                                        <div class="d-flex flex-column">
                                            <span class="fw-medium">{{ $transaction->receiver_name }}</span>
                                            @if($transaction->receiver_phone)
                                                <small class="text-muted">
                                                    <i class="fas fa-phone-alt me-1"></i>{{ $transaction->receiver_phone }}
                                                </small>
                                            @endif
                                        </div>
                                    </td>
                                    <td>
                                        @if($transaction->transaction_type == 'deposit')
                                            <span class="badge bg-success-subtle text-success px-3 py-2 rounded-pill">{{ __('word.Deposit') }}</span>
                                        @elseif($transaction->transaction_type == 'withdrawal')
                                            <span class="badge bg-danger-subtle text-danger px-3 py-2 rounded-pill">{{ __('word.Withdrawal') }}</span>
                                        @elseif($transaction->transaction_type == 'transfer')
                                            <span class="badge bg-primary-subtle text-primary px-3 py-2 rounded-pill">{{ __('word.Transfer') }}</span>
                                        @endif
                                    </td>
                                    <td class="fw-bold">
                                        <span class="text-dark">{{ $transaction->from_account?->currency?->currency_name }}</span>
                                        <span class="ms-1">{{ number_format($transaction->transaction_amount, 0, '.', ',') }}</span>
                                    </td>
                                    <td>{{ $transaction->to_account->customer->customer_name ?? 'N/A' }}</td>
                                    <td>
                                        <div class="text-wrap" style="max-width: 200px;">{{ $transaction->note }}</div>
                                    </td>
                                    <td>{{ $transaction->user->name }}</td>
                                    <td class="text-center">
                                        <div class="btn-group" role="group">
                                            <button class="btn btn-sm btn-success" wire:click="openApprovalModal({{ $transaction->id }})">
                                                <i class="fa fa-check me-1"></i>پەسەندکردن
                                            </button>
                                            <button class="btn btn-sm btn-danger" wire:click="openRejectionModal({{ $transaction->id }})">
                                                <i class="fa fa-times me-1"></i>ڕەتکردنەوە
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="10" class="text-center py-5">
                                        <i class="fa fa-info-circle me-2 fa-2x text-muted"></i>
                                        <p class="mt-2 text-muted mb-0">هیچ تڕانزاکشنێک نییە کە چاوەڕوانی ڕەزامەندی بێت</p>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <div class="mt-3 d-flex justify-content-center">
                    {{ $transactions->links() }}
                </div>
            </div>
            
            <!-- Approved Transactions Section -->
            <div>
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h3 class="fs-5 text-success fw-bold"><i class="fa fa-check-circle me-2"></i>جوڵەکانی پەسەندکراو</h3>
                    <span class="badge bg-success px-3 py-2 rounded-pill fs-6">{{ count($approvedTransactions ?? []) }} جوڵە</span>
                </div>
                
                <div class="table-responsive shadow-sm rounded-3">
                    <table class="table table-hover mb-0 align-middle">
                        <thead class="bg-light">
                            <tr>
                                <th class="py-3 text-nowrap">#</th>
                                <th class="py-3 text-nowrap">بەروار</th>
                                <th class="py-3 text-nowrap">لە موشتەرییەوە</th>
                                <th class="py-3 text-nowrap">اسم مستفید</th>
                                <th class="py-3 text-nowrap">جۆر</th>
                                <th class="py-3 text-nowrap">بڕ</th>
                                <th class="py-3 text-nowrap">لۆ موشتەری</th>
                                <th class="py-3 text-nowrap">تێبینی</th>
                                <th class="py-3 text-nowrap">پەسەندکراوە لەلایەن</th>
                                <th class="py-3 text-nowrap">پەسەندکراوە لە</th>
                                <th class="py-3 text-center text-nowrap">کردارەکان</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($approvedTransactions ?? [] as $transaction)
                                <tr>
                                    <td>{{ $transaction->id }}</td>
                                    <td>
                                        <div class="d-flex flex-column">
                                            <span class="fw-medium">{{ $transaction->created_at->format('Y-m-d') }}</span>
                                            <small class="text-muted">{{ $transaction->created_at->format('H:i') }}</small>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex flex-column">
                                            <span class="fw-medium">{{ $transaction->sender_name ?? 'Unknown' }}</span>
                                            @if($transaction->sender_phone)
                                                <small class="text-muted">
                                                    <i class="fas fa-phone-alt me-1"></i>{{ $transaction->sender_phone }}
                                                </small>
                                            @endif
                                        </div>
                                    </td>
                                    
                                    <td>
                                        <div class="d-flex flex-column">
                                            <!-- Added a clickable receiver name to open edit phone modal -->
                                            <span class="fw-medium cursor-pointer" wire:click="openPhoneEditModal({{ $transaction->id }})">
                                                {{ $transaction->receiver_name }}
                                                <i class="fas fa-edit text-primary ms-1 small"></i>
                                            </span>
                                            @if($transaction->receiver_phone)
                                                <small class="text-muted">
                                                    <i class="fas fa-phone-alt me-1"></i>{{ $transaction->receiver_phone }}
                                                </small>
                                            @endif
                                        </div>
                                    </td>
                                    <td>
                                        @if($transaction->transaction_type == 'deposit')
                                            <span class="badge bg-success-subtle text-success px-3 py-2 rounded-pill">{{ __('word.Deposit') }}</span>
                                        @elseif($transaction->transaction_type == 'withdrawal')
                                            <span class="badge bg-danger-subtle text-danger px-3 py-2 rounded-pill">{{ __('word.Withdrawal') }}</span>
                                        @elseif($transaction->transaction_type == 'transfer')
                                            <span class="badge bg-primary-subtle text-primary px-3 py-2 rounded-pill">{{ __('word.Transfer') }}</span>
                                        @endif
                                    </td>
                                    <td class="fw-bold">
                                        <span class="text-dark">{{ $transaction->from_account?->currency?->currency_name }}</span>
                                        <span class="ms-1">{{ number_format($transaction->transaction_amount, 0, '.', ',') }}</span>
                                    </td>
                                    <td>{{ $transaction->to_account->customer->customer_name ?? 'N/A' }}</td>
                                    <td>
                                        <div class="text-wrap cursor-pointer" style="max-width: 200px;" wire:click="openNoteEditModal({{ $transaction->id }})">
                                            {{ $transaction->note }}
                                            <i class="fas fa-edit text-primary ms-1 small"></i>
                                        </div>
                                    </td>
                                    <td>{{ $transaction->approvedBy->name ?? 'N/A' }}</td>
                                    <td>
                                        @if($transaction->approved_at)
                                            <div class="d-flex flex-column">
                                                <span class="fw-medium">{{ Carbon\Carbon::parse($transaction->approved_at)->format('Y-m-d') }}</span>
                                                <small class="text-muted">{{ Carbon\Carbon::parse($transaction->approved_at)->format('H:i') }}</small>
                                            </div>
                                        @else
                                            N/A
                                        @endif
                                    </td>
                                    <td class="text-center">
                                        <div class="btn-group" role="group">
                                            {{-- <button class="btn btn-sm btn-info me-1" wire:click="openPhoneEditModal({{ $transaction->id }})">
                                                <i class="fa fa-phone me-1"></i> نوێکردنەوە
                                            </button> --}}
                                            <a target="_blank" href="{{ route('invoice-transfer', [$transaction->id]) }}" class="btn btn-sm btn-outline-dark">
                                                <i class="fa fa-print me-1"></i> چاپکردن
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="11" class="text-center py-5">
                                        <i class="fa fa-info-circle me-2 fa-2x text-muted"></i>
                                        <p class="mt-2 text-muted mb-0">هیچ تڕانزاکشنێکی پەسەندکراو نییە</p>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination for Approved Transactions -->
                @if(!empty($approvedTransactions))
                <div class="mt-3 d-flex justify-content-center">
                    {{ $approvedTransactions->links() }}
                </div>
                @endif
            </div>
        </div>
    </div>
    
    <!-- Approval Modal -->
    @if($showApprovalModal)
    <div class="modal fade show d-block" style="background-color: rgba(0,0,0,0.5);" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content border-0 shadow rounded-4">
                <div class="modal-header bg-success text-white">
                    <h5 class="modal-title text-white"><i class="fa fa-check-circle me-2"></i>پەسەندکردنی تڕانزاکشن</h5>
                    <button type="button" class="btn-close btn-close-white" wire:click="$set('showApprovalModal', false)"></button>
                </div>
                <div class="modal-body p-4">
                    <div class="text-center mb-4">
                        <div class="avatar avatar-lg">
                            <div class="avatar-icon rounded-circle bg-light-success">
                                <i class="fa fa-check-circle text-success fa-3x"></i>
                            </div>
                        </div>
                    </div>
                    <p class="text-center fs-5">ئایا دڵنیایت دەتەوێت ئەم تڕانزاکشنە پەسەند بکەیت؟</p>
                </div>
                <div class="modal-footer border-top-0">
                    <button type="button" class="btn btn-outline-secondary px-4" wire:click="$set('showApprovalModal', false)">
                        <i class="fa fa-times me-2"></i>نەخێر
                    </button>
                    <button type="button" class="btn btn-success px-4" wire:click="approveTransaction">
                        <i class="fa fa-check me-2"></i>بەڵێ، پەسەندی دەکەم
                    </button>
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- Rejection Modal -->
    @if($showRejectionModal)
    <div class="modal fade show d-block" style="background-color: rgba(0,0,0,0.5);" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content border-0 shadow rounded-4">
                <div class="modal-header bg-danger text-white">
                    <h5 class="modal-title text-white"><i class="fa fa-times-circle me-2"></i>ڕەتکردنەوەی تڕانزاکشن</h5>
                    <button type="button" class="btn-close btn-close-white" wire:click="$set('showRejectionModal', false)"></button>
                </div>
                <div class="modal-body p-4">
                    <div class="text-center mb-4">
                        <div class="avatar avatar-lg">
                            <div class="avatar-icon rounded-circle bg-light-danger">
                                <i class="fa fa-times-circle text-danger fa-3x"></i>
                            </div>
                        </div>
                    </div>
                    <p class="text-center fs-5">ئایا دڵنیایت دەتەوێت ئەم تڕانزاکشنە ڕەت بکەیتەوە؟</p>
                    
                    <div class="form-floating mt-3">
                        <textarea class="form-control" id="rejectionReason" style="height: 100px" 
                            wire:model="rejectionReason" placeholder="هۆکاری ڕەتکردنەوە"></textarea>
                        <label for="rejectionReason">هۆکاری ڕەتکردنەوە (ئارەزوومەندانە)</label>
                    </div>
                </div>
                <div class="modal-footer border-top-0">
                    <button type="button" class="btn btn-outline-secondary px-4" wire:click="$set('showRejectionModal', false)">
                        <i class="fa fa-times me-2"></i>نەخێر
                    </button>
                    <button type="button" class="btn btn-danger px-4" wire:click="rejectTransaction">
                        <i class="fa fa-times me-2"></i>بەڵێ، ڕەتی دەکەمەوە
                    </button>
                </div>
            </div>
        </div>
    </div>
    @endif
    
    <!-- Phone Edit Modal -->
    @if($showPhoneEditModal)
    <div class="modal fade show d-block" style="background-color: rgba(0,0,0,0.5);" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content border-0 shadow rounded-4">
                <div class="modal-header bg-info text-white">
                    <h5 class="modal-title text-white"><i class="fa fa-phone me-2"></i>نوێکردنەوەی ژمارەی تەلەفۆن</h5>
                    <button type="button" class="btn-close btn-close-white" wire:click="$set('showPhoneEditModal', false)"></button>
                </div>
                <div class="modal-body p-4">
                    <div class="text-center mb-4">
                        <div class="avatar avatar-lg">
                            <div class="avatar-icon rounded-circle bg-light-info">
                                <i class="fa fa-phone text-info fa-3x"></i>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-floating mt-3">
                        <input type="tel" class="form-control @error('editingReceiverPhone') is-invalid @enderror" 
                            id="editingReceiverPhone" wire:model="editingReceiverPhone" placeholder="ژمارەی تەلەفۆن">
                        <label for="editingReceiverPhone">ژمارەی تەلەفۆن</label>
                        @error('editingReceiverPhone')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                
                </div>
                <div class="modal-footer border-top-0">
                    <button type="button" class="btn btn-outline-secondary px-4" wire:click="$set('showPhoneEditModal', false)">
                        <i class="fa fa-times me-2"></i>پاشگەزبوونەوە
                    </button>
                    <button type="button" class="btn btn-info px-4 text-white" wire:click="updateReceiverPhone">
                        <i class="fa fa-save me-2"></i>پاشەکەوتکردن
                    </button>
                </div>
            </div>
        </div>
    </div>
    @endif
    
    @if($showNoteEditModal)
    <div class="modal fade show d-block" style="background-color: rgba(0,0,0,0.5);" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content border-0 shadow rounded-4">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title text-white"><i class="fa fa-edit me-2"></i>نوێکردنەوەی تێبینی</h5>
                    <button type="button" class="btn-close btn-close-white" wire:click="$set('showNoteEditModal', false)"></button>
                </div>
                <div class="modal-body p-4">
                    <div class="text-center mb-4">
                        <div class="avatar avatar-lg">
                            <div class="avatar-icon rounded-circle bg-light-primary">
                                <i class="fa fa-edit text-primary fa-3x"></i>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-floating mt-3">
                        <textarea class="form-control @error('editingNote') is-invalid @enderror" 
                            id="editingNote" wire:model="editingNote" placeholder="تێبینی" 
                            style="height: 150px"></textarea>
                        <label for="editingNote">تێبینی</label>
                        @error('editingNote')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                
                </div>
                <div class="modal-footer border-top-0">
                    <button type="button" class="btn btn-outline-secondary px-4" wire:click="$set('showNoteEditModal', false)">
                        <i class="fa fa-times me-2"></i>پاشگەزبوونەوە
                    </button>
                    <button type="button" class="btn btn-primary px-4 text-white" wire:click="updateNote">
                        <i class="fa fa-save me-2"></i>پاشەکەوتکردن
                    </button>
                </div>
            </div>
        </div>
    </div>
    @endif
</div>