<div wire:poll.30s="loadCurrencies" class="min-h-screen bg-white p-4">
    <!-- Animated Background Currency Bubbles -->
    <div class="fixed inset-0 pointer-events-none z-10 overflow-hidden">
        <div class="bubble" data-currency="USD">💵</div>
        <div class="bubble" data-currency="EUR">💶</div>
        <div class="bubble" data-currency="GBP">💷</div>
        <div class="bubble" data-currency="JPY">💴</div>
        <div class="bubble" data-currency="CNY">💰</div>
        <div class="bubble" data-currency="AUD">🪙</div>
        <div class="bubble" data-currency="CAD">🪙</div>
        <div class="bubble" data-currency="CHF">🏦</div>
        <div class="bubble" data-currency="SEK">💎</div>
        <div class="bubble" data-currency="EXTRA1">💱</div>
        <div class="bubble" data-currency="EXTRA2">📊</div>
        <div class="bubble" data-currency="EXTRA3">📈</div>
        <div class="bubble" data-currency="EXTRA4">📉</div>
        <div class="bubble" data-currency="EXTRA5">🏛️</div>
    </div>

    <!-- Modern Currency Exchange Display -->
    
    <!-- Header Section -->
    <div class="bg-gray-900 rounded-2xl mx-auto my-4 shadow-xl max-w-6xl lg:max-w-7xl xl:max-w-full">
        <div class="p-6">
            <!-- Logo, Timer, and Date layout -->
            <div class="flex flex-col lg:flex-row items-center justify-between gap-4">
                <!-- Desktop: Date on left, Logo center, Timer on right -->
                <div class="hidden lg:flex items-center gap-2 bg-blue-900/20 text-white font-semibold px-3 py-2 lg:px-4 lg:py-3 xl:px-5 xl:py-4 rounded-full border border-blue-400/30 text-lg lg:text-xl xl:text-2xl 2xl:text-3xl 3xl:text-4xl">
                    <span class="date-icon">📅</span>
                    <span id="live-date">{{ now()->format('d/m/Y') }}</span>
                </div>
                
                <!-- Logo and text centered -->
                <div class="text-center flex-1">
                    <div class="flex flex-col items-center">
                        <img src="{{ asset('assets/logoback.png') }}" alt="Logo" class="h-32 w-auto max-w-80 lg:max-w-96 drop-shadow-lg">
                        <div class="mt-2 space-y-1">
                            <div class="text-white font-semibold text-lg lg:text-3xl xl:text-4xl 2xl:text-5xl 3xl:text-6xl drop-shadow-lg">الامان بۆ ئاڵو گۆڕی دراو</div>
                            <div class="text-white font-semibold text-lg lg:text-3xl xl:text-4xl 2xl:text-5xl 3xl:text-6xl drop-shadow-lg">نرخی دراوە جیهانییەکان</div>
                        </div>
                        
                        <!-- Mobile: Date and Timer under logo -->
                        <div class="flex lg:hidden items-center justify-center gap-4 mt-4">
                            <div class="flex items-center gap-2 bg-blue-900/20 text-white font-semibold px-3 py-2 rounded-full border border-blue-400/30 text-xl">
                                <span class="date-icon">📅</span>
                                <span id="live-date-mobile">{{ now()->format('d/m/Y') }}</span>
                            </div>
                            <div class="flex items-center gap-2 bg-blue-900/20 text-white font-semibold px-3 py-2 rounded-full border border-blue-400/30 text-xl">
                                <span class="update-icon">🕒</span>
                                <span id="live-timer-mobile">00:00:00</span>
                            </div>
                        </div>
                        

                    </div>
                </div>
                
                <!-- Desktop: Timer on right -->
                <div class="hidden lg:flex items-center gap-2 bg-blue-900/20 text-white font-semibold px-3 py-2 lg:px-4 lg:py-3 xl:px-5 xl:py-4 rounded-full border border-blue-400/30 text-lg lg:text-xl xl:text-2xl 2xl:text-3xl 3xl:text-4xl">
                    <span class="update-icon">🕒</span>
                    <span id="live-timer">00:00:00</span>
                </div>
            </div>
        </div>
    </div>

    <!-- News Ticker -->
    <div class="bg-blue-50 rounded-2xl mx-auto my-4 border border-blue-200 max-w-6xl lg:max-w-7xl xl:max-w-full overflow-hidden">
        <div class="overflow-hidden h-12">
            <div class="flex gap-6 animate-scroll">
                @php
                    $digitalCurrencies = \App\Models\Currency::where('type', 1)->get();
                @endphp
                @foreach($digitalCurrencies as $digitalCurrency)
                    <div class="bg-blue-100 px-4 py-2 rounded-full border border-blue-300 flex items-center gap-2 flex-shrink-0">
                        <img src="{{ asset('storage/' . $digitalCurrency->code) }}" 
                             alt="{{ $digitalCurrency->currency_name }}" 
                             class="w-8 h-8 rounded-full bg-white p-1 shadow-sm object-contain"
                             onerror="this.style.display='none'">
                        <span class="text-blue-800 font-medium text-sm">{{ $digitalCurrency->currency_name }}</span>
                    </div>
                @endforeach
            </div>
        </div>
    </div>



    <!-- Currency Table -->
    <div class="bg-white rounded-2xl shadow-xl mx-auto my-6 border max-w-6xl lg:max-w-7xl xl:max-w-full overflow-hidden">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50 border-b">
                    <tr>
                        <th class="text-right py-4 px-4 lg:py-6 lg:px-6 xl:py-8 xl:px-8 2xl:py-10 2xl:px-10 text-xl lg:text-lg xl:text-2xl 2xl:text-3xl 3xl:text-4xl font-semibold text-gray-700 w-1/3">
                            <span class="block">Currency</span>
                            <span class="block text-lg lg:text-base xl:text-xl 2xl:text-2xl 3xl:text-3xl text-gray-500">دراو / العملە</span>
                        </th>
                        <th class="text-center py-4 px-4 lg:py-6 lg:px-6 xl:py-8 xl:px-8 2xl:py-10 2xl:px-10 text-xl lg:text-lg xl:text-2xl 2xl:text-3xl 3xl:text-4xl font-semibold text-gray-700 w-1/3">
                            <span class="block">Buy</span>
                            <span class="block text-lg lg:text-base xl:text-xl 2xl:text-2xl 3xl:text-3xl text-gray-500">کڕین / شراء</span>
                        </th>
                        <th class="text-center py-4 px-4 lg:py-6 lg:px-6 xl:py-8 xl:px-8 2xl:py-10 2xl:px-10 text-xl lg:text-lg xl:text-2xl 2xl:text-3xl 3xl:text-4xl font-semibold text-gray-700 w-1/3">
                            <span class="block">Sell</span>
                            <span class="block text-lg lg:text-base xl:text-xl 2xl:text-2xl 3xl:text-3xl text-gray-500">فرۆشتن / بیع</span>
                        </th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    @php
                        $flagMap = [
                            'USD' => ['flag' => 'us', 'symbol' => '$', 'name' => 'US Dollar', 'order' => 1],
                            'EURO' => ['flag' => 'eu', 'symbol' => '€', 'name' => 'Euro', 'order' => 2],
                            'POUND' => ['flag' => 'gb', 'symbol' => '£', 'name' => 'British Pound', 'order' => 3],
                            'TURKIYE' => ['flag' => 'tr', 'symbol' => '₺', 'name' => 'Turkish Lira', 'order' => 4],
                            'TUMAN' => ['flag' => 'ir', 'symbol' => '﷼', 'name' => 'Iranian Tuman', 'order' => 5],
                            'EMIRATES' => ['flag' => 'ae', 'symbol' => 'د.إ', 'name' => 'UAE Dirham', 'order' => 6],
                            'JORDAN' => ['flag' => 'jo', 'symbol' => 'د.أ', 'name' => 'Jordanian Dinar', 'order' => 7],
                            'SWEED' => ['flag' => 'se', 'symbol' => 'kr', 'name' => 'Swedish Krona', 'order' => 8],
                            'NARWEJ' => ['flag' => 'no', 'symbol' => 'kr', 'name' => 'Norwegian Krone', 'order' => 9],
                            'SWESRA' => ['flag' => 'ch', 'symbol' => 'CHF', 'name' => 'Swiss Franc', 'order' => 10],
                            'SAUDI' => ['flag' => 'sa', 'symbol' => 'ر.س', 'name' => 'Saudi Riyal', 'order' => 11],
                            'AUSTRALA' => ['flag' => 'au', 'symbol' => 'A$', 'name' => 'Australian Dollar', 'order' => 12],
                            'CANADA' => ['flag' => 'ca', 'symbol' => 'C$', 'name' => 'Canadian Dollar', 'order' => 13],
                        ];
                    @endphp

                    @foreach($currencies as $currency)
                        @php
                            $currencyInfo = $flagMap[$currency->currency_name] ?? ['flag' => 'xx', 'symbol' => '', 'name' => $currency->currency_name];
                            $flagUrl = "https://flagcdn.com/w80/{$currencyInfo['flag']}.png";
                            $fallbackFlagUrl = "https://flagsapi.com/{$currencyInfo['flag']}/flat/64.png";
                            $secondFallback = "https://restcountries.eu/data/{$currencyInfo['flag']}.svg";
                            
                            $buyRate = number_format($currency->buy_rate, 0);
                            $sellRate = number_format($currency->sell_rate, 0);
                            
                            $spread = $currency->sell_rate - $currency->buy_rate;
                            $spreadPercentage = $currency->buy_rate > 0 ? ($spread / $currency->buy_rate) * 100 : 0;
                        @endphp
                        
                        <tr class="hover:bg-gray-50 transition-colors duration-200">
                            <td style="float: right;" class="py-4 px-4 lg:py-6 lg:px-6 xl:py-8 xl:px-8 2xl:py-10 2xl:px-10 text-right">
                                                                    <div class="flex items-center justify-end space-x-4">
                                        <div class="w-10 h-10 lg:w-14 lg:h-14 xl:w-16 xl:h-16 2xl:w-20 2xl:h-20 3xl:w-24 3xl:h-24 rounded-full overflow-hidden shadow-sm flex-shrink-0 border-2 border-gray-300">
                                            <img src="https://flagcdn.com/72x54/{{ strtolower($currencyInfo['flag']) }}.png" 
                                                 alt="{{ $currencyInfo['name'] }} flag" 
                                                 class="w-full h-full object-cover currency-flag"
                                                 onerror="this.src='https://flagcdn.com/72x54/{{ strtolower($currencyInfo['flag']) }}.png'"
                                                 data-fallback="https://flagcdn.com/72x54/{{ strtolower($currencyInfo['flag']) }}.png">
                                        </div>
                                    <div class="text-right">
                                        {{-- <div class="font-semibold text-gray-900 text-xl lg:text-lg xl:text-2xl 2xl:text-3xl 3xl:text-4xl leading-tight">{{ $currencyInfo['name'] }}</div> --}}
                                        <div class="text-blue-600 font-medium text-xl lg:text-lg xl:text-2xl 2xl:text-3xl 3xl:text-4xl">
                                            @php
                                                $words = explode(' ', $currencyInfo['name']);
                                                foreach($words as $index => $word) {
                                                    if ($index > 0) echo '<br>';
                                                    echo $word;
                                                }
                                            @endphp
                                        </div>
                                    </div>
                                </td>
                            <td class="py-4 px-4 lg:py-6 lg:px-6 xl:py-8 xl:px-8 2xl:py-10 2xl:px-10 text-center">
                                <div class="inline-flex items-center justify-center bg-gray-900 text-white font-bold rounded-lg border-2 border-white shadow-md w-full max-w-xs h-12 lg:h-16 xl:h-20 2xl:h-24 3xl:h-28 text-xl lg:text-2xl xl:text-4xl 2xl:text-5xl 3xl:text-6xl px-2">
                                    @if(round($currency->buy_rate, 2) == floor($currency->buy_rate))
                                        {{ number_format($currency->buy_rate, 0, '.', ',') }}
                                    @else
                                        {{ number_format($currency->buy_rate, 2, '.', ',') }}
                                    @endif
                                </div>
                            </td>
                            <td class="py-4 px-4 lg:py-6 lg:px-6 xl:py-8 xl:px-8 2xl:py-10 2xl:px-10 text-center">
                                <div class="inline-flex items-center justify-center bg-gray-900 text-white font-bold rounded-lg border-2 border-white shadow-md w-full max-w-xs h-12 lg:h-16 xl:h-20 2xl:h-24 3xl:h-28 text-xl lg:text-2xl xl:text-4xl 2xl:text-5xl 3xl:text-6xl px-2">
                                    @if(round($currency->sell_rate, 2) == floor($currency->sell_rate))
                                        {{ number_format($currency->sell_rate, 0, '.', ',') }}
                                    @else
                                        {{ number_format($currency->sell_rate, 2, '.', ',') }}
                                    @endif
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <!-- Footer Info -->
    <div class="bg-white rounded-2xl shadow-lg mx-auto my-6 border-t max-w-6xl lg:max-w-7xl xl:max-w-full">
        <div class="p-6 text-center">
            <p class="text-gray-600 text-xl lg:text-lg xl:text-2xl 2xl:text-3xl 3xl:text-4xl mb-4">
                <span class="mr-2">ℹ️</span>
                نرخەکان هەر ٣٠ چرکە جارێک نوێ دەکرێتەوە و دەکرێت جیاواز بن. پەیوەندی بە ئێمە بکە بۆ مامەڵە گەورەکان.
                <br>
                هەڤاڵان كۆڵانى باب الحاره - جادەى بيستيەكەى
            </p>
            <div class="flex flex-wrap justify-center gap-4 text-xl lg:text-lg xl:text-2xl 2xl:text-3xl 3xl:text-4xl text-gray-500">
                <span class="flex items-center gap-2">
                    📞 پەیوەندی:
                    <span class="contact-info-ltr">0751 825 3732 <br>
                    0751 466 8873 <br>
                    0751 531 4173</span>
                </span>
                <span>🌐 www.LA DERMA.com</span>
            </div>
        </div>
    </div>

    <style>
        /* Custom Kurdish Font */
        @font-face {
            font-family: 'K24KurdishBold';
            src: url('{{ asset('fonts/K24KurdishBold-Bold.ttf') }}') format('truetype');
            font-weight: bold;
            font-style: normal;
            font-display: swap;
        }

        .contact-info-ltr {
            direction: ltr;
            unicode-bidi: embed;
            text-align: left;
            display: inline-block;
        }

        /* Apply Kurdish font to all elements */
        body, h1, h2, h3, h4, h5, h6, 
        div, span, p, table, td, th, 
        input, button, select, textarea {
            font-family: 'K24KurdishBold', Arial, sans-serif !important;
        }

        /* Animated Background Currency Bubbles */
        .bubble {
            position: absolute;
            font-size: 2rem;
            opacity: 0.15;
            animation: float 20s infinite linear;
            filter: blur(0.5px);
            transition: all 0.3s ease;
        }

        .bubble:hover {
            opacity: 0.3;
            transform: scale(1.1);
        }

        .bubble[data-currency="USD"] { color: #85bb65; }
        .bubble[data-currency="EUR"] { color: #1e3a8a; }
        .bubble[data-currency="GBP"] { color: #dc2626; }
        .bubble[data-currency="JPY"] { color: #dc2626; }
        .bubble[data-currency="CNY"] { color: #dc2626; }
        .bubble[data-currency="AUD"] { color: #1e40af; }
        .bubble[data-currency="CAD"] { color: #dc2626; }
        .bubble[data-currency="CHF"] { color: #dc2626; }
        .bubble[data-currency="SEK"] { color: #1e40af; }
        .bubble[data-currency="EXTRA1"] { color: #667eea; }
        .bubble[data-currency="EXTRA2"] { color: #059669; }
        .bubble[data-currency="EXTRA3"] { color: #059669; }
        .bubble[data-currency="EXTRA4"] { color: #dc2626; }
        .bubble[data-currency="EXTRA5"] { color: #1e40af; }

        .bubble:nth-child(1) { left: 10%; animation-delay: 0s; animation-duration: 25s; }
        .bubble:nth-child(2) { left: 20%; animation-delay: 2s; animation-duration: 30s; }
        .bubble:nth-child(3) { left: 30%; animation-delay: 4s; animation-duration: 28s; }
        .bubble:nth-child(4) { left: 40%; animation-delay: 6s; animation-duration: 32s; }
        .bubble:nth-child(5) { left: 50%; animation-delay: 8s; animation-duration: 26s; }
        .bubble:nth-child(6) { left: 60%; animation-delay: 10s; animation-duration: 29s; }
        .bubble:nth-child(7) { left: 70%; animation-delay: 12s; animation-duration: 31s; }
        .bubble:nth-child(8) { left: 80%; animation-delay: 14s; animation-duration: 27s; }
        .bubble:nth-child(9) { left: 90%; animation-delay: 16s; animation-duration: 33s; }
        .bubble:nth-child(10) { left: 15%; animation-delay: 18s; animation-duration: 24s; }
        .bubble:nth-child(11) { left: 25%; animation-delay: 20s; animation-duration: 30s; }
        .bubble:nth-child(12) { left: 35%; animation-delay: 22s; animation-duration: 29s; }
        .bubble:nth-child(13) { left: 45%; animation-delay: 24s; animation-duration: 31s; }
        .bubble:nth-child(14) { left: 55%; animation-delay: 26s; animation-duration: 28s; }
        .bubble:nth-child(15) { left: 65%; animation-delay: 28s; animation-duration: 32s; }
        .bubble:nth-child(16) { left: 75%; animation-delay: 30s; animation-duration: 27s; }
        .bubble:nth-child(17) { left: 85%; animation-delay: 32s; animation-duration: 30s; }
        .bubble:nth-child(18) { left: 95%; animation-delay: 34s; animation-duration: 29s; }
        .bubble:nth-child(19) { left: 5%; animation-delay: 36s; animation-duration: 31s; }
        .bubble:nth-child(20) { left: 35%; animation-delay: 38s; animation-duration: 28s; }
        .bubble:nth-child(21) { left: 65%; animation-delay: 40s; animation-duration: 33s; }
        .bubble:nth-child(22) { left: 85%; animation-delay: 42s; animation-duration: 26s; }
        .bubble:nth-child(23) { left: 15%; animation-delay: 44s; animation-duration: 30s; }
        .bubble:nth-child(24) { left: 55%; animation-delay: 46s; animation-duration: 29s; }
        .bubble:nth-child(25) { left: 75%; animation-delay: 48s; animation-duration: 31s; }
        .bubble:nth-child(26) { left: 25%; animation-delay: 50s; animation-duration: 28s; }
        .bubble:nth-child(27) { left: 45%; animation-delay: 52s; animation-duration: 32s; }
        .bubble:nth-child(28) { left: 85%; animation-delay: 54s; animation-duration: 27s; }

        @keyframes float {
            0% {
                transform: translateY(100vh) rotate(0deg);
                opacity: 0;
            }
            10% {
                opacity: 0.1;
            }
            90% {
                opacity: 0.1;
            }
            100% {
                transform: translateY(-100px) rotate(360deg);
                opacity: 0;
            }
        }

        /* News Ticker Animation */
        .animate-scroll {
            animation: scroll-left 30s linear infinite;
        }

        @keyframes scroll-left {
            0% {
                transform: translateX(100%);
            }
            100% {
                transform: translateX(-100%);
            }
        }

        /* Pause on hover */
        .animate-scroll:hover {
            animation-play-state: paused;
        }

        /* Flag display improvements */
        .currency-flag {
            object-fit: cover;
            border-radius: 50%;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }



        /* TV Portrait Mode - Large Fonts for Customer Display */
        @media (orientation: portrait) and (min-width: 768px) {
            /* Force larger base font size for TV */
            body {
                font-size: 1.5rem !important;
                line-height: 1.6 !important;
            }
            
            /* Ensure all text elements are large enough for TV viewing */
            p, span, div, td, th {
                font-size: 1.5rem !important;
                line-height: 1.6 !important;
            }
            
            /* Header adjustments for TV portrait mode - optimize for space */
            .h-32 {
                height: 10rem !important;
            }
            
            .max-w-80 {
                max-width: 20rem !important;
            }
            
            .max-w-96 {
                max-width: 24rem !important;
            }
            
            /* Optimize text sizes for TV viewing while ensuring all currencies fit */
            .text-lg {
                font-size: 2rem !important;
            }
            
            .text-xl {
                font-size: 2.5rem !important;
            }
            
            .text-2xl {
                font-size: 3rem !important;
            }
            
            .text-3xl {
                font-size: 3.5rem !important;
            }
            
            .text-4xl {
                font-size: 4rem !important;
            }
            
            .text-5xl {
                font-size: 4.5rem !important;
            }
            
            .text-6xl {
                font-size: 5rem !important;
            }
            
            /* Optimize padding for TV while saving vertical space */
            .px-3 {
                padding-left: 1rem !important;
                padding-right: 1rem !important;
            }
            
            .py-2 {
                padding-top: 0.75rem !important;
                padding-bottom: 0.75rem !important;
            }
            
            .px-4 {
                padding-left: 1.5rem !important;
                padding-right: 1.5rem !important;
            }
            
            .py-4 {
                padding-top: 0.75rem !important;
                padding-bottom: 0.75rem !important;
            }
            
            .px-6 {
                padding-left: 2rem !important;
                padding-right: 2rem !important;
            }
            
            .py-6 {
                padding-top: 1.5rem !important;
                padding-bottom: 1.5rem !important;
            }
            
            /* Table adjustments for TV */
            .w-1/3 {
                width: 33.333333% !important;
            }
            
            /* Optimize flag sizes for TV while saving space */
            .w-12 {
                width: 5rem !important;
            }
            
            .h-12 {
                height: 5rem !important;
            }
            
            .w-16 {
                width: 6rem !important;
            }
            
            .h-16 {
                height: 6rem !important;
            }
            
            .w-20 {
                width: 7rem !important;
            }
            
            .h-20 {
                height: 7rem !important;
            }
            
            .w-24 {
                width: 8rem !important;
            }
            
            .h-24 {
                height: 8rem !important;
            }
            
            .w-28 {
                width: 9rem !important;
            }
            
            .h-28 {
                height: 9rem !important;
            }
            
            /* Optimize spacing for TV */
            .space-x-3 {
                gap: 1rem !important;
            }
            
            .gap-4 {
                gap: 1.5rem !important;
            }
            
            .gap-6 {
                gap: 2rem !important;
            }
            
            /* Optimize margins for TV */
            .my-4 {
                margin-top: 1rem !important;
                margin-bottom: 1rem !important;
            }
            
            .my-6 {
                margin-top: 1.5rem !important;
                margin-bottom: 1.5rem !important;
            }
            
            /* Optimize border radius for TV */
            .rounded-2xl {
                border-radius: 1rem !important;
            }
            
            .rounded-lg {
                border-radius: 0.75rem !important;
            }
            
            .rounded-full {
                border-radius: 9999px !important;
            }
            
            /* Specific table row optimizations for TV portrait mode */
            .py-4.px-4, .py-6.px-6, .py-8.px-8, .py-10.px-10 {
                padding-top: 0.75rem !important;
                padding-bottom: 0.75rem !important;
                padding-left: 1rem !important;
                padding-right: 1rem !important;
            }
            
            /* Reduce header margins to save space */
            .my-4 {
                margin-top: 1rem !important;
                margin-bottom: 1rem !important;
            }
            
            /* Optimize footer spacing */
            .p-6 {
                padding: 1.5rem !important;
            }
            
            .mb-4 {
                margin-bottom: 1rem !important;
            }
            
            /* Ensure table rows are compact for TV portrait mode */
            .divide-y > tr {
                border-bottom-width: 1px !important;
            }
            
            /* Optimize table cell heights */
            td, th {
                padding-top: 0.75rem !important;
                padding-bottom: 0.75rem !important;
            }
        }

        /* Extra Large TV Portrait Mode - Optimized for All Currencies */
        @media (orientation: portrait) and (min-width: 1920px) {
            /* Force larger fonts for 4K+ TVs while maintaining space efficiency */
            body {
                font-size: 1.75rem !important;
                line-height: 1.5 !important;
            }
            
            /* Optimize text sizes for 4K+ TV viewing while ensuring all currencies fit */
            .text-lg {
                font-size: 2.5rem !important;
            }
            
            .text-xl {
                font-size: 3rem !important;
            }
            
            .text-2xl {
                font-size: 3.5rem !important;
            }
            
            .text-3xl {
                font-size: 4rem !important;
            }
            
            .text-4xl {
                font-size: 4.5rem !important;
            }
            
            .text-5xl {
                font-size: 5rem !important;
            }
            
            .text-6xl {
                font-size: 5.5rem !important;
            }
            
            /* Optimize padding and margins for 4K+ TV */
            .px-3, .px-4, .px-6 {
                padding-left: 2rem !important;
                padding-right: 2rem !important;
            }
            
            .py-2, .py-4, .py-6 {
                padding-top: 1rem !important;
                padding-bottom: 1rem !important;
            }
            
            .my-4, .my-6 {
                margin-top: 2rem !important;
                margin-bottom: 2rem !important;
            }
            
            /* Optimize flag and element sizes for 4K+ TV */
            .w-12, .h-12 {
                width: 6rem !important;
                height: 6rem !important;
            }
            
            .w-16, .h-16 {
                width: 7rem !important;
                height: 7rem !important;
            }
            
            .w-20, .h-20 {
                width: 8rem !important;
                height: 8rem !important;
            }
            
            .w-24, .h-24 {
                width: 9rem !important;
                height: 9rem !important;
            }
            
            .w-28, .h-28 {
                width: 10rem !important;
                height: 10rem !important;
            }
            
            /* Additional space optimizations for 4K+ TV */
            .py-4.px-4, .py-6.px-6, .py-8.px-8, .py-10.px-10 {
                padding-top: 1rem !important;
                padding-bottom: 1rem !important;
                padding-left: 1.5rem !important;
                padding-right: 1.5rem !important;
            }
            
            /* Compact table rows for 4K+ TV */
            td, th {
                padding-top: 1rem !important;
                padding-bottom: 1rem !important;
            }
        }

        /* Mobile responsive adjustments */
        @media (max-width: 768px) {
            /* Header adjustments for mobile */
            .h-32 {
                height: 8rem !important;
            }
            
            .max-w-64 {
                max-width: 16rem !important;
            }
            
            .text-lg {
                font-size: 1rem !important;
            }
            
            .px-3 {
                padding-left: 0.5rem !important;
                padding-right: 0.5rem !important;
            }
            
            .py-2 {
                padding-top: 0.5rem !important;
                padding-bottom: 0.5rem !important;
            }
            
            /* Table adjustments */
            .w-2/5 {
                width: 60% !important;
            }
            
            .w-1/5 {
                width: 20% !important;
            }
            
            .w-20 {
                width: 4rem !important;
            }
            
            .h-12 {
                height: 3rem !important;
            }
            
            .text-sm {
                font-size: 0.875rem !important;
            }
            
            .px-4 {
                padding-left: 1rem !important;
                padding-right: 1rem !important;
            }
            
            .py-4 {
                padding-top: 1rem !important;
                padding-bottom: 1rem !important;
            }
            
            /* Currency column improvements */
            .w-10 {
                width: 2rem !important;
            }
            
            .h-10 {
                height: 2rem !important;
            }
            
            .space-x-3 {
                gap: 0.5rem !important;
            }
        }

        @media (max-width: 480px) {
            /* Header extra small adjustments */
            .h-32 {
                height: 6rem !important;
            }
            
            .max-w-64 {
                max-width: 12rem !important;
            }
            
            .text-lg {
                font-size: 0.875rem !important;
            }
            
            .px-3 {
                padding-left: 0.25rem !important;
                padding-right: 0.25rem !important;
            }
            
            .py-2 {
                padding-top: 0.25rem !important;
                padding-bottom: 0.25rem !important;
            }
            
            /* Table extra small adjustments */
            .w-2/5 {
                width: 65% !important;
            }
            
            .w-1/5 {
                width: 17.5% !important;
            }
            
            .w-20 {
                width: 3.5rem !important;
            }
            
            .h-12 {
                height: 2.5rem !important;
            }
            
            .text-sm {
                font-size: 0.75rem !important;
            }
            
            .px-4 {
                padding-left: 0.5rem !important;
                padding-right: 0.5rem !important;
            }
            
            .py-4 {
                padding-top: 0.75rem !important;
                padding-bottom: 0.75rem !important;
            }
            
            /* Currency column extra small improvements */
            .w-10 {
                width: 1.75rem !important;
            }
            
            .h-10 {
                height: 1.75rem !important;
            }
            
            .space-x-3 {
                gap: 0.25rem !important;
            }
        }
    </style>

    <!-- JavaScript for enhanced functionality -->
    <script>
        // Function to initialize timer
        function initializeTimer() {
            // Timer and Date update functionality
            function updateTimer() {
                const timerElement = document.getElementById('live-timer');
                const timerMobileElement = document.getElementById('live-timer-mobile');
                const now = new Date();
                let hours = now.getHours();
                const minutes = String(now.getMinutes()).padStart(2, '0');
                const seconds = String(now.getSeconds()).padStart(2, '0');
                
                // Convert to 12-hour format and add Kurdish AM/PM
                const isAM = hours < 12;
                const kurdishPeriod = isAM ? 'بەیانی' : 'ئێوارە';
                
                // Convert 24-hour to 12-hour format
                if (hours === 0) {
                    hours = 12; // Midnight
                } else if (hours > 12) {
                    hours = hours - 12; // PM hours
                }
                
                const hours12 = String(hours).padStart(2, '0');
                const timeString = hours12 + ':' + minutes + ':' + seconds + ' ' + kurdishPeriod;
                
                if (timerElement) {
                    timerElement.textContent = timeString;
                }
                if (timerMobileElement) {
                    timerMobileElement.textContent = timeString;
                }
                
                // Debug logging
                console.log('Timer update:', timeString);
                console.log('Mobile timer element found:', !!timerMobileElement);
            }
            
            function updateDate() {
                const dateElement = document.getElementById('live-date');
                const dateMobileElement = document.getElementById('live-date-mobile');
                const now = new Date();
                const day = String(now.getDate()).padStart(2, '0');
                const month = String(now.getMonth() + 1).padStart(2, '0');
                const year = now.getFullYear();
                const dateString = day + '/' + month + '/' + year;
                
                if (dateElement) {
                    dateElement.textContent = dateString;
                }
                if (dateMobileElement) {
                    dateMobileElement.textContent = dateString;
                }
            }
            
            // Start timer and date immediately
            updateTimer();
            updateDate();
            
            // Also try to start timer after a short delay to ensure elements are loaded
            setTimeout(function() {
                updateTimer();
                updateDate();
            }, 100);
            
            // Additional fallback timer initialization
            setTimeout(function() {
                updateTimer();
                updateDate();
            }, 500);
            
            // Update timer every second
            setInterval(updateTimer, 1000);
            
            // Update date every minute (in case of date change)
            setInterval(updateDate, 60000);
        }

        // Try multiple ways to initialize the timer
        document.addEventListener('DOMContentLoaded', initializeTimer);
        window.addEventListener('load', initializeTimer);
        
        // Also try to initialize when Livewire is ready
        if (typeof Livewire !== 'undefined') {
            Livewire.on('DOMContentLoaded', initializeTimer);
        }
        
        document.addEventListener('DOMContentLoaded', function() {

            // Add smooth scroll to top functionality
            window.addEventListener('scroll', function() {
                const scrollTop = document.getElementById('scroll-top');
                if (scrollTop) {
                    scrollTop.style.display = window.pageYOffset > 300 ? 'block' : 'none';
                }
            });

            // Optimize image loading with multiple fallbacks
            const flags = document.querySelectorAll('img[data-fallback]');
            flags.forEach(flag => {
                flag.addEventListener('error', function() {
                    // Try fallback URL first
                    if (this.dataset.fallback) {
                        this.src = this.dataset.fallback;
                    } else {
                        // Use default placeholder if no fallback
                        this.src = 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNjQiIGhlaWdodD0iNDgiIHZpZXdCb3g9IjAgMCA2NCA0OCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3Qgd2lkdGg9IjY0IiBoZWlnaHQ9IjQ4IiBmaWxsPSIjRjVGNUY1Ii8+CjxwYXRoIGQ9Ik0yNCAyNEgzMlYzMkgyNFYyNFoiIGZpbGw9IiNEQURBREEiLz4KPC9zdmc+';
                    }
                });
            });

            // Add visual feedback for rate changes
            window.addEventListener('livewire:update', function() {
                const rows = document.querySelectorAll('tbody tr');
                rows.forEach(row => {
                    row.style.animation = 'none';
                    row.offsetHeight; // Trigger reflow
                    row.style.animation = 'fadeIn 0.3s ease-out';
                });
            });
        });

        // Add fadeIn animation
        const style = document.createElement('style');
        style.textContent = `
            @keyframes fadeIn {
                from {
                    opacity: 0;
                    transform: translateY(10px);
                }
                to {
                    opacity: 1;
                    transform: translateY(0);
                }
            }
        `;
        document.head.appendChild(style);


    </script>
</div>