<div dir="rtl" wire:poll.5s class="currency-display">
    <link rel="preload" href="{{ asset('fonts/rudawregular2.ttf') }}" as="font" type="font/ttf" crossorigin="anonymous">    
    <style>
        /* Add these media queries to your existing CSS */

/* For large screens (TVs, monitors) */
@media (min-width: 1920px) {
    /* Increase overall font size */
    body {
        font-size: 18px;
    }
    
    /* Enhance header for better visibility */
    .header-content {
        padding: 20px 40px;
    }
    
    .logo {
        width: 120px;
        height: 120px;
    }
    
    .header-title h2 {
        font-size: 42px;
    }
    
    .header-subtitle {
        font-size: 24px;
    }
    
    .time-display {
        font-size: 24px;
    }
    
    /* Make table larger and more spaced out */
    .currency-table {
        max-width: 1800px;
        margin: 0 auto;
    }
    
    .currency-table th {
        font-size: 24px;
        padding: 20px;
    }
    
    .currency-table td {
        padding: 20px 25px;
    }
    
    .currency-flag {
        width: 48px;
        height: 36px;
    }
    
    .currency-english {
        font-size: 22px;
    }
    
    .currency-kurdish {
        font-size: 18px;
    }
    
    .rate-buy, .rate-sell {
        font-size: 28px;
        font-weight: bold;
        text-align: center;
        padding: 15px 10px;
    }
    
    /* Make footer larger */
    .scrolling-footer {
        height: 60px;
        padding: 15px 0;
        font-size: 22px;
    }
    
    /* Adjust rate input for editing */
    .rate-input {
        font-size: 28px;
        width: 150px;
    }
    
    .edit-buttons .btn {
        font-size: 18px;
        padding: 5px 15px;
    }
}

/* For extra large TVs (4K and above) */
@media (min-width: 3840px) {
    body {
        font-size: 24px;
    }
    
    .logo {
        width: 180px;
        height: 180px;
    }
    
    .header-title h2 {
        font-size: 60px;
    }
    
    .header-subtitle {
        font-size: 36px;
    }
    
    .time-display {
        font-size: 36px;
    }
    
    .currency-table th {
        font-size: 32px;
    }
    
    .currency-flag {
        width: 64px;
        height: 48px;
    }
    
    .currency-english {
        font-size: 30px;
    }
    
    .currency-kurdish {
        font-size: 24px;
    }
    
    .rate-buy, .rate-sell {
        font-size: 36px;
        font-weight: bold;
        text-align: center;
        padding: 20px 15px;
    }
    
    .scrolling-footer {
        height: 80px;
        font-size: 32px;
    }
}
        @font-face {
            font-family: 'rudawregular2';
            src: url('{{ asset('fonts/rudawregular2.ttf') }}') format('truetype');
            font-weight: normal;
            font-style: normal;
            font-display: swap;
        }

        body, h1, h2, h3, h4, h5, h6, 
        div, span, p, table, td, th, 
        input, button, select, textarea {
            font-family: 'rudawregular2', Arial, sans-serif !important;
        }

        .currency-display {
            font-family: 'rudawregular2', 'Segoe UI', sans-serif;
            position: relative;
            width: 100vw;
            max-width: 100%;
            padding: 0;
            margin: 0;
            overflow-x: hidden;
        }
        
        .watermark {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            opacity: 0.05;
            z-index: 0;
            width: 60%;
            height: auto;
            pointer-events: none;
        }

        .table-wrapper {
            width: 100%;
            position: relative;
            z-index: 1;
            overflow-x: hidden;
        }

        .currency-table {
            width: 100%;
            border-collapse: collapse;
            table-layout: fixed;
        }

        .currency-table thead {
            position: sticky;
            top: 0;
            z-index: 2;
        }

        .currency-table th {
            text-align: right;
            font-size: 16px;
            background-color: #66410b;
            color: white;
        }

        .currency-table td {
            padding: 12px 15px;
            border-bottom: 1px solid #eceff1;
            transition: background-color 0.2s;
        }

        .currency-table tbody tr:hover {
            background-color: #f0f7fa;
        }

        .currency-table tbody tr:last-child td {
            border-bottom: none;
        }

        .currency-name {
            display: flex;
            align-items: center;
            gap: 12px;
            font-weight: 500;
        }

        .currency-flag {
            width: 32px;
            height: 24px;
            object-fit: cover;
            border-radius: 3px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .currency-info {
            display: flex;
            flex-direction: column;
        }

        .currency-english {
            font-size: 15px;
            font-weight: 500;
        }

        .currency-kurdish {
            font-size: 13px;
            color: #666;
            font-weight: normal;
        }

        .rate-buy {
            color: #0077b6;
            font-weight: 600;
            font-size: 17px;
            cursor: default;
            text-align: center;
        }

        .rate-sell {
            color: #D32F2F;
            font-weight: 600;
            font-size: 17px;
            cursor: default;
            text-align: center;
        }

        .rate-editable {
            cursor: pointer;
            position: relative;
        }

        .rate-editable:hover::after {
            content: "داگرە لۆ نوێکردنەوە";
            position: absolute;
            bottom: -15px;
            left: 50%;
            transform: translateX(-50%);
            background-color: #333;
            color: #fff;
            padding: 3px 8px;
            border-radius: 3px;
            font-size: 11px;
            white-space: nowrap;
            opacity: 0.8;
        }

        .rate-input {
            font-weight: 600;
            font-size: 17px;
            border: 2px solid #4caf50;
            border-radius: 4px;
            padding: 5px 10px;
            width: 100px;
            text-align: center;
            outline: none;
        }

        .rate-input.buy {
            border-color: #0077b6;
            color: #0077b6;
        }

        .rate-input.sell {
            border-color: #D32F2F;
            color: #D32F2F;
        }

        .rate-change {
            animation: highlight 2s ease-out;
        }

        @keyframes highlight {
            0% { background-color: rgba(255, 235, 59, 0.4); }
            100% { background-color: transparent; }
        }

        .rate-label {
            display: block;
            font-size: 14px;
            color: #fff;
            margin-bottom: 4px;
            font-weight: 500;
        }

        .edit-buttons {
            display: flex;
            gap: 5px;
            margin-top: 5px;
            justify-content: center;
        }

        .edit-button {
            padding: 3px 8px;
            border-radius: 3px;
            font-size: 12px;
            cursor: pointer;
            border: none;
            color: white;
        }

        .save-button {
            background-color: #0077b6;
        }

        .cancel-button {
            background-color: #D32F2F;
        }

        .header-container {
            background: linear-gradient(135deg, #66410b, #66410b);
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.15);
            margin-bottom: 0;
            width: 100%;
            border-radius: 10%;
        }

        .header-content {
            display: flex;
            align-items: center;
            width: 100%;
            padding: 10px 20px;
            gap: 20px;
        }

        .logo-container {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .logo {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            object-fit: cover;
            border: 3px solid white;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.2);
        }

        .header-title {
            color: white;
            flex-grow: 1;
        }

        .header-title h2 {
            margin: 0;
            font-size: 26px;
            font-weight: 600;
            margin-bottom: 5px;
        }

        .header-subtitle {
            font-size: 16px;
            opacity: 0.9;
        }

      

        .time-display {
            text-align: right;
            color: white;
        }

        /* Fixed scrolling footer to move from right to left */
        .scrolling-footer {
            position: fixed;
            bottom: 0;
            left: 0;
            width: 100%;
            background-color: #66410b;
            color: white;
            padding: 10px 0;
            overflow: hidden;
            white-space: nowrap;
            z-index: 100;
            height: 40px;
            direction: ltr; /* Ensure right-to-left movement */
        }

        .scrolling-footer marquee {
            width: 100%;
        }

        /* Mobile Responsiveness */
        @media (max-width: 768px) {
            .header-content {
                flex-direction: column;
                text-align: center;
                gap: 10px;
                padding: 10px 0;
            }

            .logo-container {
                flex-direction: column;
                align-items: center;
            }

            .logo {
                width: 60px;
                height: 60px;
            }

            .header-title {
                text-align: center;
            }

            .header-title h2 {
                font-size: 20px;
            }

            .header-subtitle, .time-display {
                font-size: 14px;
            }
            
            .currency-table {
                font-size: 14px;
            }
            
            .currency-table th, 
            .currency-table td {
                padding: 8px 6px;
            }
            
            .currency-flag {
                width: 24px;
                height: 18px;
            }
            
            .currency-english {
                font-size: 13px;
            }
            
            .currency-kurdish {
                font-size: 11px;
            }
            
            .rate-buy, .rate-sell {
                font-size: 15px;
            }
            
            .currency-name {
                gap: 6px;
            }
            
            .table-wrapper {
                overflow-y: auto;
                margin-bottom: 50px;
            }
            
            .currency-table th:first-child,
            .currency-table td:first-child {
                width: 45%;
            }
            
            .currency-table th:nth-child(2),
            .currency-table td:nth-child(2),
            .currency-table th:nth-child(3),
            .currency-table td:nth-child(3) {
                width: 27.5%;
            }
        }
    </style>

    <div class="p-0">
        <div class="row g-0">
            <div class="col-12">
                
            </div>
        </div>
        
        <div class="row g-0">
            <div class="col-12">
                <div class="table-wrapper">
                    <img src="/assets/logo.png" alt="Berat Logo Watermark" class="watermark">
                    <table class="table currency-table table-responsive">
                        <thead>
                            <tr>
                                <th class="text-right">دراو</th>
                                <th class="text-center text-white">
                                    <span class="rate-label">Buy</span>
                                    کڕین - شراء
                                </th>
                                <th class="text-center text-white">
                                    <span class="rate-label">Sell</span>
                                    فرۆشتن - بیع
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                            // Updated currency order and data
                            $orderedCurrencies = [
                                'USD' => [
                                    'flag' => 'us',
                                    'english' => 'US Dollar',
                                    'kurdish' => 'دۆلاری ئەمریکی',
                                    'symbol' => '$'
                                ],
                                'EURO' => [
                                    'flag' => 'eu',
                                    'english' => 'Euro',
                                    'kurdish' => 'یۆرۆ',
                                    'symbol' => '€'
                                ],
                                'POUND' => [
                                    'flag' => 'gb',
                                    'english' => 'British Pound',
                                    'kurdish' => 'پاوەندی بەریتانی',
                                    'symbol' => '£'
                                ],
                                'TURKIYE' => [
                                    'flag' => 'tr',
                                    'english' => 'Turkish Lira',
                                    'kurdish' => 'لیرەی تورکی',
                                    'symbol' => '₺'
                                ],
                                'TUMAN' => [
                                    'flag' => 'ir',
                                    'english' => 'Iranian Toman',
                                    'kurdish' => 'تمەنی ئێرانی',
                                    'symbol' => 'تومان'
                                ],
                                'EMIRATES' => [
                                    'flag' => 'ae',
                                    'english' => 'UAE Dirham',
                                    'kurdish' => 'دیرهەمی ئیمارات',
                                    'symbol' => 'د.إ'
                                ],
                                'JORDAN' => [
                                    'flag' => 'jo',
                                    'english' => 'Jordanian Dinar',
                                    'kurdish' => 'دیناری ئوردونی',
                                    'symbol' => 'د.أ'
                                ],
                                'SWEED' => [
                                    'flag' => 'se',
                                    'english' => 'Swedish Krona',
                                    'kurdish' => 'کرۆنی سویدی',
                                    'symbol' => 'kr'
                                ],
                                'NARWEJ' => [
                                    'flag' => 'no',
                                    'english' => 'Norwegian Krone',
                                    'kurdish' => 'کرۆنی نەرویژی',
                                    'symbol' => 'kr'
                                ],
                                'SWESRA' => [
                                    'flag' => 'ch',
                                    'english' => 'Swiss Franc',
                                    'kurdish' => 'فرانکی سویسری',
                                    'symbol' => 'CHF'
                                ],
                                'SAUDI' => [
                                    'flag' => 'sa',
                                    'english' => 'Saudi Riyal',
                                    'kurdish' => 'ڕیاڵی سعودی',
                                    'symbol' => 'ر.س'
                                ],
                                'AUSTRALA' => [
                                    'flag' => 'au',
                                    'english' => 'Australian Dollar',
                                    'kurdish' => 'دۆلاری ئوسترالی',
                                    'symbol' => 'A$'
                                ],
                                'CANADA' => [
                                    'flag' => 'ca',
                                    'english' => 'Canadian Dollar',
                                    'kurdish' => 'دۆلاری کەنەدی',
                                    'symbol' => 'C$'
                                ]
                            ];
                            
                            $user = Auth::user();
                            // Check if user has edit privileges
                            $canEdit = auth()->check() && $user->hasRole(['super-admin', 'supervisor','cashier']);
                            @endphp
                            @foreach($currencies as $currency)
                           
                                @php
                                    // Skip if currency isn't in our ordered list
                                    if (!isset($orderedCurrencies[$currency->currency_name])) continue;
                                    
                                    $currencyData = $orderedCurrencies[$currency->currency_name];
                                    $countryCode = $currencyData['flag'];
                                    $flagUrl = "https://flagcdn.com/48x36/{$countryCode}.png";
                                @endphp
                                
                                <tr>
                                    <td>
                                        <div align="right" class="currency-name">
                                            <img class="currency-flag" src="{{ $flagUrl }}" alt="{{ $currency->currency_name }}">
                                            <div class="currency-info">
                                                <div class="currency-english">{{ $currencyData['english'] }} <span>({{ $currencyData['symbol'] }})</span></div>
                                                <div class="currency-kurdish">{{ $currencyData['kurdish'] }}</div>
                                            </div>
                                        </div>
                                    </td>
                                    
                                    @if($canEdit)
                                    <!-- Replace the entire rate-editable div structure with this -->
                                    <td class="rate-buy rate-editable" wire:key="buy-{{ $currency->id }}">
                                        @if($editingCurrency === $currency->id && $editingField === 'buy_rate')
                                            <div style="background-color: transparent !important; position: relative; z-index: 2;">
                                                <input 
                                                    type="number" 
                                                    step="0.01"
                                                    class="form-control rate-input buy"
                                                    wire:model="editValue"
                                                    wire:keydown.enter="saveEdit"
                                                    wire:keydown.escape="cancelEdit"
                                                    autofocus
                                                    
                                                />
                                                <div class="edit-buttons">
                                                    <button class="btn btn-sm btn-primary" wire:click="saveEdit" style="background-color: rgba(0, 119, 182, 0.9);">هەڵگرتن</button>
                                                    <button class="btn btn-sm btn-danger" wire:click="cancelEdit" style="background-color: rgba(211, 47, 47, 0.9);">هەڵوەشاندنەوە</button>
                                                </div>
                                            </div>
                                        @else
                                            <div wire:click="startEdit({{ $currency->id }}, 'buy_rate', {{ $currency->buy_rate ?? 0 }})" >
                                                @if(round($currency->buy_rate, 2) == floor($currency->buy_rate))
                                                {{ number_format($currency->buy_rate, 0, '.', ',') }} 
                                                @else
                                                {{ number_format($currency->buy_rate, 2, '.', ',') }} 
                                                @endif
                                            </div>
                                        @endif
                                    </td>
                                    
                                    <td class="rate-sell rate-editable" wire:key="sell-{{ $currency->id }}">
                                        @if($editingCurrency === $currency->id && $editingField === 'sell_rate')
                                            <div>
                                                <input 
                                                    type="number" 
                                                    step="0.01"
                                                    class="form-control rate-input sell"
                                                    wire:model="editValue"
                                                    wire:keydown.enter="saveEdit"
                                                    wire:keydown.escape="cancelEdit"
                                                    autofocus
                                                />
                                                <div class="edit-buttons">
                                                    <button class="btn btn-sm btn-primary" wire:click="saveEdit">هەڵگرتن</button>
                                                    <button class="btn btn-sm btn-danger" wire:click="cancelEdit">هەڵوەشاندنەوە</button>
                                                </div>
                                            </div>
                                        @else
                                        <div wire:click="startEdit({{ $currency->id }}, 'sell_rate', {{ $currency->sell_rate ?? 0 }})">
                                            @if(round($currency->sell_rate, 2) == floor($currency->sell_rate))
                                                {{ number_format($currency->sell_rate, 0, '.', ',') }}
                                            @else
                                                {{ number_format($currency->sell_rate, 2, '.', ',') }}
                                            @endif
                                        </div>
                                        @endif
                                    </td>
                                    @else
                                    <td style="background-color: #c47805" class="rate-buy rounded text-white" wire:key="buy-{{ $currency->id }}">
                                        @if(round($currency->buy_rate, 2) == floor($currency->buy_rate))
                                            {{ number_format($currency->buy_rate, 0, '.', ',') }}
                                        @else
                                            {{ number_format($currency->buy_rate, 2, '.', ',') }}
                                        @endif
                                    </td>
                                    <td style="background-color: #c47805"  class="rate-sell rounded m-1 text-white" wire:key="sell-{{ $currency->id }}">
                                        @if(round($currency->sell_rate, 2) == floor($currency->sell_rate))
                                            {{ number_format($currency->sell_rate, 0, '.', ',') }}
                                        @else
                                            {{ number_format($currency->sell_rate, 2, '.', ',') }}
                                        @endif
                                    </td>
                                    @endif
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Add JavaScript to highlight rate changes when they update
        document.addEventListener('livewire:load', function() {
            Livewire.hook('message.processed', (message, component) => {
                // Find elements that changed
                document.querySelectorAll('[wire\\:key]').forEach(el => {
                    if (el.classList.contains('rate-buy') || el.classList.contains('rate-sell')) {
                        // Add and remove animation class
                        el.classList.remove('rate-change');
                        void el.offsetWidth; // Trigger reflow to restart animation
                        el.classList.add('rate-change');
                    }
                });
            });
        });
    </script>
    
    <!-- Fixed scrolling footer with marquee for reliable right-to-left movement -->
   
</div>