<div>
    <script src="//cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>

    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  
    @php
        $currency = $account->currency->currency_name;
        $isFiltered = $startDate || $endDate;
    @endphp




    <div class="row">
        
      
        <div class="col-xl-4 col-lg-5 col-md-5">

           
            <!-- About User -->
            <div class="card mb-4">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-center" style="text-align: center; height: 100%;">
                        <div class="badge rounded-pill bg-label-primary">
                            <i class="ti ti-user-check" style="font-size: 65px;"></i>
                        </div>
                    </div>
                    <ul class="purchaseList-unstyled mb-4 mt-3">
                        <li class="d-flex align-items-center mb-3">
                            <i class="ti ti-user"></i>
                            <span class="fw-bold mx-2">{{ trans('word.BankCash') }}:</span>
                            <span>
                                
                                @if ($account->account_type === 'cashier' )
                                    گواستنەوەی پارە لۆ کاشێر
                                @elseif ($account->account_type === 'supervisor' )
                                پارە گواستنەوە لە ئەدمین لۆ سوپەر ڤایسەر
                                @else
                                {{ $account->customer->user->name ?? '-' }}
                            
                                @endif
                            </span>
                        </li>
                        <li class="d-flex align-items-center mb-3">
                            <i class="ti ti-file-invoice"></i>
                            <span class="fw-bold mx-2">{{ trans('word.AccountNumber') }}:</span>
                            <span>{{ $account->account_title ?? '-' }}</span>
                        </li>
                        <li class="d-flex align-items-center mb-3">
                            <i class="ti ti-user-check"></i>
                            <span class="fw-bold mx-2">{{ trans('word.Balance') }}:</span>
                            <span>{{ number_format($account->calculateTotalBalance(), 0, '.', ',') ?? '-' }}  {{$currency}}</span>
                        </li>
                        <li class="d-flex align-items-center mb-3">
                            <i class="ti ti-exchange"></i>
                            <span class="fw-bold mx-2">{{ trans('word.TotalTransactions') }}:</span>
                            <span>{{ $transactions->count() ?? '-' }}</span>
                        </li>
                       
                    </ul>
                </div>
            </div>
        </div>
        <div class="col-xl-8 col-lg-7 col-md-7">

            
            <!-- Activity Timeline -->
            <div class="col-xl-12">

                
                <div class="nav-align-top mb-4">
                    <div class="dropdown">
                        {{-- Tabs --}}
                        <ul class="nav nav-pills mb-3" role="tablist">
                            <li class="nav-item">
                                <button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#sales" aria-controls="sales" aria-selected="false">@lang('word.Transactions')</button>
                            </li>
                            @if($account->account_type == 'cashier')
                            <li class="nav-item">
                                <button type="button" class="nav-link" role="tab" wire:click="openModalTransfer" >گواستنەوەی پارە لۆ کاشێر</button>
                            </li>
                            @else
                            <li class="nav-item">
                                <button type="button" class="nav-link " role="tab" wire:click="openModal" aria-controls="adjustment" aria-selected="false">@lang('word.Transfer')</button>
                            </li>
                            @endif
                            <li class="nav-item">
                                <button type="button" class="nav-link" role="tab" onclick="printContent()"><i style="font-size: 20px;" class="fa fa-print"></i></button>
                            </li>

                            <div class="row">
                                <div class="col-4" align="left">
                                <a href="{{ route('cashbox') }}" class="btn btn-outline-primary">
                                    <i class="ti ti-arrow-left me-1"></i> @lang('word.Back')
                                </a>
                                </div>
                            </div>
                        </ul>
                        {{-- / Tabs --}}
                    </div>
                    {{-- Tabs Content --}}
                    <div class="tab-content">
                        {{-- Tab Sales --}}
                        <div class="tab-pane show active" id="sales" role="tabpanel">
                            <!-- Add a toggle button for filters -->
                            <div class="d-flex justify-content-between mb-3 no-print">
                                <button type="button" class="btn btn-outline-primary" wire:click="toggleFilters">
                                <i class="fas fa-filter me-1"></i>{{ $showFilters ? "شاردنەوەی فلتەر" : "پیشاندانی فلتەر" }}
                                </button>
                                
                                <!-- Only show per page dropdown when no date filters are active -->
                                @if(!$isFiltered)
                                <div class="d-flex align-items-center">
                                <span class="me-2">پیشاندان لەهەر لاپەڕەک:</span>
                                <select wire:model.live="perPage" class="form-select form-select-sm" style="width: auto;">
                                    <option value="10">10</option>
                                    <option value="25">25</option>
                                    <option value="50">50</option>
                                    <option value="100">100</option>
                                    <option value="all">هەموو تۆمارەکان</option>
                                </select>
                                </div>
                                @endif
                            </div>
                            
                            <!-- Filter card, shown only when toggled -->
                            <div class="card mb-3 no-print" @if(!$showFilters) style="display: none;" @endif>
                                <div class="card-body">
                                <div class="row">
                                    <div class="col-md-4">
                                    <label for="startDate" class="form-label">لە بەرواری</label>
                                    <input type="date" wire:model.live="startDate" id="startDate" class="form-control">
                                    </div>
                                    <div class="col-md-4">
                                    <label for="endDate" class="form-label">بۆ بەرواری</label>
                                    <input type="date" wire:model.live="endDate" id="endDate" class="form-control">
                                    </div>
                                    <div class="col-md-4 d-flex align-items-end">
                                    <button type="button" class="btn btn-secondary me-2" wire:click="resetFilters">
                                        <i class="fas fa-sync-alt me-1"></i>پاککردنەوە
                                    </button>
                                    <button type="button" class="btn btn-primary" wire:click="toggleSortDirection">
                                        <i class="fas fa-sort me-1"></i>
                                        {{ $sortDirection === 'desc' ? 'کۆنەکان' : 'نوێیەکان' }}
                                    </button>
                                    </div>
                                </div>
                                </div>
                            </div>

                            <!-- Show statistics when filters are applied -->
                            @if($isFiltered)
                            <div class="alert alert-info mb-3 no-print">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <strong>ئەنجامە فلتەرکراوەکان:</strong> 
                                        {{ $transactions->count() }} جوڵە
                                    </div>
                                    <div>
                                        <span class="me-3">{{ trans('word.Deposit') }}: 
                                            <strong class="text-success">{{ number_format($totalDeposit, 0, '.', ',') }} {{$currency}}</strong>
                                        </span>
                                        <span>{{ trans('word.Withdrawal') }}: 
                                            <strong class="text-danger">{{ number_format($totalWithdrawal, 0, '.', ',') }} {{$currency}}</strong>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            @endif

                            <div class="table-responsive sales-table">
                                <table class="table">
                                    <thead>
                                        <tr class="border-bottom">
                                            <th class=" text-primary">@lang('word.TransactionID')</th>
                                            <th class="text-primary">@lang('word.Date')</th>
                                            <th class=" text-primary">@lang('word.TransactionAmount')</th>
                                            <th class=" text-primary">@lang('word.Fee')</th>
                                            <th class=" text-primary">حسابی نێردەر</th>                                         
                                            <th class=" text-primary">@lang('word.TransactionType')</th>
                                            <th class=" text-primary">@lang('word.Note')</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($transactions as $value)

                                        <?php
                                        if ($value->moneyTransferOnly == 1) 
                                        continue;
                                        ?>

                                        <tr>
                                            <td>{{ $value->id ?? '-' }}</td>
                                            <td>{{ $value->created_at ?? '-' }}</td>
                                            <td>
                                                @php
                                                    $isWithdrawal = $value->transaction_type == 'withdrawal';
                                                    $amount = $isWithdrawal ? -$value->transaction_amount : $value->transaction_amount;
                                                    $color = $isWithdrawal ? 'red' : 'green'; // Conditional color
                                                @endphp
                                                <span style="color: {{ $color }};">
                                                    {{ number_format($amount, 0, '.', ',') ?? '-' }} {{$currency}}
                                                </span>
                                            </td>
                                            <td>
                                                {{ $value->get_fee }}                                                
                                                {{-- {{ number_format(optional($value->fees->first())->fee_amount ?? $value->get_fee, 0, '.', ',') }} --}}
                                            </td>
                                            <td>
                                                @if ($value->to_account && $value->to_account->customer)
                                                    @if ($value->to_account->customer->customer_name == 'Cashiers')
                                                        (Cashier) {{ $value->to_account->customer->user->name ?? '-' }}
                                                    @else
                                                        {{ $value->to_account->customer->customer_name ?? '-' }}
                                                    @endif
                                                @else
                                                    -
                                                @endif
                                            </td>                                            
                                            <td>
                                                @if($value->transaction_type == 'deposit')
                                                    {{ __('word.Deposit') }}
                                                @elseif($value->transaction_type == 'withdrawal')
                                                    {{ __('word.Withdrawal') }}
                                                @elseif($value->transaction_type == 'transfer')
                                                    {{ __('word.Transfer') }}
                                                @endif
                                            </td>
                                            <td>{{ $value->note ?? '-' }}</td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                                <!-- Pagination links - only show when no date filters are active -->
                                @if(!$isFiltered && $perPage != 'all')
                                <div class="d-flex justify-content-center mt-4 no-print">
                                    {{ $transactions->links(data: ['scrollTo' => false]) }}
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Adjustment modaltransfer for account cashbox --}}
    @if($showModalTransfer)
        <div class="modal fade show d-block" style="background-color: rgba(0, 0, 0, 0.5);" tabindex="-1">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">گواستنەوەی پارە لۆ کاشێر</h5>
                        <button type="button" class="btn-close" wire:click="closeModalTransfer"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            
                      
                        <!-- For the transfer modal (showModalTransfer) -->
                        <div class="col-6">
                            @livewire('components.custom-select', [
                                'label' => __('word.Account'),
                                'placeholder' => __('word.Account'),
                                'identifier' => "filters.to_account",
                                'options' => App\Models\Account::where('id', '!=', $this->account->id) // Exclude the current account
                                    ->where(function ($query) {
                                        $query->where('account_type', 'checking')
                                            ->orWhere('account_type', 'supervisor')
                                            ->orWhere('account_title', 'Business Owner Cashbox');
                                    })
                                    ->where('currency_id', $this->accountCurrencyId) // Same currency
                                    ->get()
                                    ->mapWithKeys(function ($account) {
                                        $currencyName = $account->currency->currency_name ?? 'Unknown Currency';
                                        
                                        if ($account->account_type === 'supervisor') {
                                            // For supervisor accounts
                                            $label = "پارە گواستنەوە لە ئەدمین لۆ سوپەر ڤایسەر ({$currencyName})";
                                        } elseif ($account->account_title === 'Business Owner Cashbox') {
                                            // For Business Owner Cashbox
                                            $label = "خاوەن کار - ({$currencyName})";
                                        } else {
                                            // For other account types
                                            $customerName = optional($account->customer)->user->name ?? 'خاوەن کار';
                                            $label = "({$currencyName}) - {$customerName}";
                                        }
                                        
                                        // Add debugging information to the label
                                        // $label .= " [Type: {$account->account_type}]";
                                        
                                        return [$account->id => $label];
                                    }),
                            ], key('select-account'))
                            @error('filters.to_account') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>

                            <!-- Transaction Type -->
                            <div class="col-6 mb-3">
                                <label for="transaction_type" class="form-label"> @lang('word.TransactionType')</label>
                                <select wire:model="create_transaction_type" class="form-control" id="transaction_type" disabled>
                                    @foreach($transactionTypes as $type)
                                        <option value="{{ $type }}">
                                            @if($type == 'deposit')
                                            {{ __('word.Deposit') }}
                                            @elseif($type == 'withdrawal')
                                            {{ __('word.Withdrawal') }}
                                            @elseif($type == 'transfer')
                                            {{ __('word.Transfer') }}
                                            @endif
                                        </option>
                                    @endforeach
                                </select>
                                @error('create_transaction_type') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>

                            <!-- Transaction Amount -->
                            <div class="col-12 mb-3">
                                <label for="transaction_amount" class="form-label"> @lang('word.TransactionAmount')</label>
                                <input type="text" x-mask:dynamic="$money($input, '.', ',', 4)" wire:model="create_transaction_amount" class="form-control" id="transaction_amount">
                                @error('create_transaction_amount') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>

                            <!-- Note -->
                            <div class="col-12 mb-3">
                                <label for="note" class="form-label"> @lang('word.Note')</label>
                                <textarea wire:model="create_note" class="form-control" id="note"></textarea>
                                @error('create_note') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
                        </div>

                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" wire:click="closeModalTransfer"> @lang('word.Close')</button>
                        <button wire:click="saveTransfer" type="submit" class="btn btn-primary"> @lang('word.Save')</button>
                    </div>
                </div>
            </div>
        </div>
    @endif



    {{-- Adjustment modal for account cashbox --}}
       @if($showModal)
        <div class="modal fade show d-block" style="background-color: rgba(0, 0, 0, 0.5);" tabindex="-1">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">@lang('word.Transfer')</h5>
                        <button type="button" class="btn-close" wire:click="closeModal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                             
                           <!-- Account Selection -->
                         
                           <div class="col-6">
                            @livewire('components.custom-select', [
                                'label' => __('word.Account'),
                                'placeholder' => __('word.Account'),
                                'identifier' => "filters.to_account",
                                'options' => App\Models\Account::where('id', '!=', $this->account->id)
                                    ->where(function ($query) {
                                        $query->where('account_type', 'checking')
                                            ->orWhere('account_type', 'supervisor')
                                            ->orWhere('account_type', 'cashier')
                                            ->orWhere('account_title', 'Business Owner Cashbox');
                                    })
                                    ->where('currency_id', $this->accountCurrencyId)
                                    ->get()
                                    ->mapWithKeys(function ($account) {
                                        $currencyName = $account->currency->currency_name ?? '';
                                        
                                        if ($account->account_type === 'cashier') {
                                            $label = "قاسەی گواستنەوەی پارە لۆ کاشێر ({$currencyName})";
                                        } elseif ($account->account_type === 'supervisor') {
                                            $label = "پارە گواستنەوە لە ئەدمین لۆ سوپەر ڤایسەر ({$currencyName})";
                                        } elseif ($account->account_title === 'Business Owner Cashbox') {
                                            $label = "خاوەن کار - ({$currencyName})";
                                        } else {
                                            $customerName = $account->customer?->user?->name ?? 'بێ ناو';
                                            $label = "({$currencyName}) - {$customerName}";
                                        }
                                        
                                        // Add debugging information to the label
                                        // $label .= " [Type: {$account->account_type}]";
                                        
                                        return [$account->id => $label];
                                    }),
                            ], key('select-account-transfer'))
                            @error('filters.to_account') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>                        
                    
                            
                            <!-- Transaction Type -->
                            <div class="col-6 mb-3">
                                <label for="transaction_type" class="form-label"> @lang('word.TransactionType')</label>
                                <select wire:model="create_transaction_type" class="form-control" id="transaction_type" disabled>
                                    @foreach($transactionTypes as $type)
                                        <option value="{{ $type }}">
                                            @if($type == 'deposit')
                                            {{ __('word.Deposit') }}
                                            @elseif($type == 'withdrawal')
                                            {{ __('word.Withdrawal') }}
                                            @elseif($type == 'transfer')
                                            {{ __('word.Transfer') }}
                                            @endif
                                        </option>
                                    @endforeach
                                </select>
                                @error('create_transaction_type') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>

                            <!-- Transaction Amount -->
                            <div class="col-12 mb-3">
                                <label for="transaction_amount" class="form-label"> @lang('word.TransactionAmount')</label>
                                <input type="text" x-mask:dynamic="$money($input, '.', ',', 4)" wire:model="create_transaction_amount" class="form-control" id="transaction_amount">
                                @error('create_transaction_amount') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>

                             <!-- Transaction Fee -->
                             {{-- <div class="col-6 mb-3">
                                <label for="transaction_fee" class="form-label"> @lang('word.Fee')</label>
                                <input type="number" wire:model="create_transaction_fee" class="form-control" id="transaction_fee">
                                @error('create_transaction_fee') <span class="text-danger">{{ $message }}</span> @enderror
                            </div> --}}

                            <!-- Note -->
                            <div class="col-12 mb-3">
                                <label for="note" class="form-label"> @lang('word.Note')</label>
                                <textarea wire:model="create_note" class="form-control" id="note"></textarea>
                                @error('create_note') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
                        </div>

                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" wire:click="closeModal"> @lang('word.Close')</button>
                        <button wire:click="saveCreate" type="submit" class="btn btn-primary"> @lang('word.Save')</button>
                    </div>
                </div>
            </div>
        </div>
    @endif
    <script>
        function printContent() {
            var content = document.querySelector('.row').innerHTML; // Select the content to print
            var printWindow = window.open('', '_blank', 'height=700,width=900');

            if (printWindow) {
                printWindow.document.open();
                printWindow.document.write('<html><head><title>Print</title>');
                printWindow.document.write('<style>');
                printWindow.document.write(`
                    @media print {
                        body * {
                            visibility: hidden;
                        }
                        .row, .row * {
                            visibility: visible;
                        }
                        .row {
                            position: absolute;
                            left: 0;
                            top: 0;
                            width: 100%;
                            margin: 0 !important;
                            padding: 0 !important;
                            direction: rtl; /* Set RTL direction */
                        }
                        table {
                            width: 100%;
                            border-collapse: collapse;
                            direction: rtl; /* Set table direction to RTL */
                        }
                        th, td {
                            border: 1px solid #000;
                            padding: 8px;
                            text-align: right; /* Align text to the right */
                        }
                        th {
                            background-color: #f2f2f2;
                        }
                        button, .no-print {
                            display: none !important; /* Hide buttons and elements with no-print class */
                        }
                    }
                `);
                printWindow.document.write('</style>');
                printWindow.document.write('</head><body>');
                printWindow.document.write('<div class="row">');
                printWindow.document.write(content);
                printWindow.document.write('</div>');
                printWindow.document.write('</body></html>');
                printWindow.document.close();

                printWindow.onload = function() {
                    printWindow.focus();
                    printWindow.print();
                    printWindow.onafterprint = function() {
                        printWindow.close();
                    };
                };
            } else {
                alert('Failed to open print window. Please ensure popups are enabled.');
            }
        }

        document.addEventListener('livewire:load', function () {
            Livewire.on('hide-modal', () => {
                var modal = new bootstrap.Modal(document.getElementById('paymentModal'));
                modal.hide();
            });
        });
    </script>
</div>