<div>
    <script src="//cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>

    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  
    @php
        $currency = $account->currency->currency_name;
    @endphp
    <div class="row" id="printSection">
        <div class="col-xl-4 col-lg-5 col-md-5">
            <!-- About User -->
            <div class="card mb-4">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-center" style="text-align: center; height: 100%;">
                        <div class="badge rounded-pill bg-label-primary">
                            <i class="ti ti-user-check" style="font-size: 65px;"></i>
                        </div>
                    </div>
                    <ul class="purchaseList-unstyled mb-4 mt-3">
                        <li class="d-flex align-items-center mb-3">
                            <i class="ti ti-user"></i>
                            <span class="fw-bold mx-2">{{ trans('word.Customer') }}:</span>
                            <span>{{ $account->customer->customer_name ?? '-' }}</span>
                        </li>
                        <li class="d-flex align-items-center mb-3">
                            <i class="ti ti-user-check"></i>
                            <span class="fw-bold mx-2">{{ trans('word.AccountNumber') }}:</span>
                            <span>{{ $account->account_title ?? '-' }}</span>
                        </li>

                        <li class="d-flex align-items-center mb-3">
                            <i class="ti ti-user-check"></i>
                            <span class="fw-bold mx-2">{{ trans('word.Balance') }}:</span>
                            <span>
                                {{ number_format($account->calculateTotalBalance(), 0, '.', ',') ?? '-' }}  
                                {{$currency}}</span>
                                

                        </li>
                        <li class="d-flex align-items-center mb-3">
                            <i class="ti ti-address-book"></i>
                            <span class="fw-bold mx-2">{{ trans('word.Phone') }}:</span>
                            <span>{{ $account->customer->phone_number ?? '-' }}</span>
                        </li>
                        <li class="d-flex align-items-center mb-3">
                            <i class="ti ti-map-pins"></i>
                            <span class="fw-bold mx-2">{{ trans('word.Address') }}:</span>
                            <span>{{ $account->customer->address ?? '-' }}</span>
                        </li>
                        <li class="d-flex align-items-center mb-3">
                            <i class="ti ti-transform"></i>
                            <span class="fw-bold mx-2">{{ trans('word.TotalTransactions') }}:</span>
                            <span>{{ number_format($account->getCountTransaction(), 0, '.', ',') ?? '-' }}</span>
                        </li>
                       
                        {{-- <li class="d-flex align-items-center mb-3">
                            <i class="ti ti-cash-banknote"></i>
                            <span class="fw-bold mx-2">{{ trans('word.getTotalDeposit') }}:</span>
                            <span>{{ number_format($account->getTotalDeposit(), 0, '.', ',') ?? '-' }} {{$currency}}</span>
                        </li>
                        <li class="d-flex align-items-center mb-3">
                            <i class="ti ti-credit-card"></i>
                            <span class="fw-bold mx-2">{{ trans('word.getTotalWithdrawal') }}:</span>
                            <span>{{ number_format($account->getTotalWithdrawal(), 0, '.', ',') ?? '-' }} {{$currency}}</span>
                        </li> --}}
                    </ul>
                </div>
            </div>
        </div>
        <div class="col-xl-8 col-lg-7 col-md-7">
            <!-- Activity Timeline -->
            <div class="col-xl-12">
                <div class="nav-align-top mb-4">
                    <div class="dropdown">
                        {{-- Tabs --}}
                        <ul class="nav nav-pills mb-3" role="tablist">
                            <li class="nav-item">
                                <button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#sales" aria-controls="sales" aria-selected="false">@lang('word.Transactions')</button>
                            </li>
                            @if(!Auth::user()->hasRole('customer'))
                            <li class="nav-item">
                                <button type="button" class="nav-link " role="tab" wire:click="openModal" aria-controls="adjustment" aria-selected="false">@lang('word.Transfer')</button>
                            </li>

                            {{-- <li class="nav-item">
                                <button type="button" class="nav-link " role="tab" wire:click="openConvertModal" aria-controls="adjustment" aria-selected="false">@lang('word.Convert')</button>
                            </li> --}}

                            @endif
                            @if(Auth::user()->hasRole('customer'))
                            <li class="nav-item">
                                <a href="/">  <button type="button" class="nav-link " role="tab"  aria-controls="adjustment" aria-selected="false">
                                    
                                    گەڕانەوە
                               
                                </button> </a>
                            </li>
                            @endif
                            <li class="nav-item">
                                <button type="button" class="nav-link" role="tab"  onclick="printContent()"><i style="font-size: 20px;margin-left:5px;" class="fa fa-print" ></i> چاپکردن </button>
                            </li>
                        </ul>
                    </div>
                    <div class="tab-content">
                        <div class="tab-pane show active" id="sales" role="tabpanel">
                            <div class="table-responsive sales-table">
                                <table class="table">
                                    <thead>
                                        <tr class="border-bottom">
                                            <th class="text-primary">@lang('word.TransactionID')</th>
                                            <th class="text-primary">@lang('word.Date')</th>
                                            <th class="text-primary">@lang('word.TransactionAmount')</th>
                                            <th class="text-primary">@lang('word.Fee')</th>
                                            <th class="text-primary">@lang('word.TransactionType')</th>
                                            <th class="text-primary">@lang('word.ToAccount')</th>
                                            <th class="text-primary">@lang('word.NameCustomerIf')</th>
                                            <th class="text-primary">@lang('word.Note')</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($transactions as $value)
                                            <tr>
                                                <td>{{ $value->id ?? '-' }}</td>
                                                <td>{{ $value->created_at ?? '-' }}</td>
                                                <td>
                                                    @php
                                                        $isWithdrawal = $value->transaction_type == 'withdrawal';
                                                        $amount = $isWithdrawal ? -$value->transaction_amount : $value->transaction_amount;
                                                        $color = $isWithdrawal ? 'red' : 'green'; // Conditional color
                                                    @endphp
                                                    <span style="color: {{ $color }};">
                                                        {{ number_format($amount, 0, '.', ',') ?? '-' }} {{$currency}}
                                                    </span>
                                                </td>
                                                <td>{{ $value->get_fee }}</td>
                                                <td>
                                                    @if($value->transaction_type == 'deposit')
                                                        {{ __('word.Deposit') }}
                                                    @elseif($value->transaction_type == 'withdrawal')
                                                        {{ __('word.Withdrawal') }}
                                                    @elseif($value->transaction_type == 'transfer')
                                                        {{ __('word.Transfer') }}
                                                    @endif
                                                </td>
                                                <td>{{ $value->to_account->customer->customer_name }}</td>
                                                <td>{{ $value->person_name ?? '-' }}</td>
                                                <td>{{ $value->note ?? '-' }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            
                                <!-- Load More Button -->
                                @if($transactions->count() >= $perPage)
                                    <div class="text-center mt-3">
                                        <button wire:click="loadMore" wire:loading.attr="disabled" class="btn btn-primary">
                                           بینینی جولەی زیاتر
                                        </button>
                            
                                        <!-- Show loading indicator while fetching data -->
                                        <div wire:loading class="mt-2">
                                            <span class="spinner-border spinner-border-sm text-primary"></span> Loading...
                                        </div>
                                    </div>
                                @endif
                                <br>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    {{-- Adjustment modal for account cashbox --}}
    @if($showConvertModal)
    <div class="modal fade show d-block" style="background-color: rgba(0, 0, 0, 0.5);" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('word.Convert')</h5>
                    <button type="button" class="btn-close" wire:click="closeConvertModal"></button>
                </div>
                <div class="modal-body">
                    <b>دەتەوێت پارەکەت بە چ حسابەک بشکێنیەوە؟ 
                        بەڕێزت بەم دراوانە حسابت هەیە</b>
                    <select wire:model="selectedAccountId" class="form-control">
                        <option value="">حساب دیاریبکە</option>
                        @foreach ($this->account->customer->accounts as $accountCon)
                            @if ($accountCon->id !== $account->id) <!-- Exclude the current account -->
                                <option value="{{ $accountCon->id }}">
                                    {{ $accountCon->currency->currency_name }} - باڵانس: {{ $accountCon->balance }}
                                </option>
                            @endif
                        @endforeach
                    </select>
                    @error('selectedAccountId') <span class="text-danger">{{ $message }}</span> @enderror
                    <br>
                    <b>بڕی پارەکە بنوسە بۆ گۆڕین</b>
                    <input type="text" x-mask:dynamic="$money($input, '.', ',', 4)" wire:model.live="amountToConvert" class="form-control">
                    @error('amountToConvert') <span class="text-danger">{{ $message }}</span> @enderror
                    <br>
                    <b>ڕێژەی گۆڕین بنوسە
                        
                    </b>
                    <input type="text" x-mask:dynamic="$money($input, '.', ',', 4)"  wire:model.live="rate" class="form-control">
                    @error('rate') <span class="text-danger">{{ $message }}</span> @enderror
                    <br>
                    <b>هەڵبژاردنی گۆڕین</b>
                    <div>
                        <label>
                            <input type="radio" wire:model.live="operationType" value="multiply"> جاران 
                        </label>
                        <label>
                            <input type="radio" wire:model.live="operationType" value="divide"> دابەشکردن 
                        </label>
                    </div>
                    @error('operationType') <span class="text-danger">{{ $message }}</span> @enderror
                    <br>
                    <b>تێبینی</b>
                    <textarea wire:model="convert_note" class="form-control"></textarea>
                    @error('convert_note') <span class="text-danger">{{ $message }}</span> @enderror

                    <br>
                    <button
                    wire:click="selectCustomerForNewAccount({{ $account->customer->id }})"
                      
                        title="Add new Account"
                        type="button"
                        class="btn btn-outline-success m-1" >
                        <i class="fa fa-user"></i>  دەتەوێت حسابی تر دروست بکەیت؟ بۆ شکانەوەکە
                    </button>
              

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="closeConvertModal">@lang('word.Close')</button>
                    <button wire:click="saveConvert" type="submit" class="btn btn-primary">@lang('word.Save')</button>
                </div>
            </div>
        </div>
    </div>
    @endif


    <!-- Modal for Create Account Customer -->
    @if($showCreateAccountModal)
    <div class="modal fade show d-block" style="background-color: rgba(0, 0, 0, 0.5); " tabindex="-1">
        <div class="modal-dialog modal-md" style="margin-top:20px;">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('word.NewAccount')</h5>
                    <button type="button" class="btn-close" wire:click="closeCreateAccountModal"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="form-group">
                            <label>@lang('word.Currency')</label>
                            <select class="form-control" wire:model="currency_id" required>
                                <option value="">@lang('word.Currency')</option>
                                @foreach($currencies as $currency)
                                <option value="{{ $currency->id }}">{{ $currency->currency_name }}</option>
                                @endforeach
                            </select>
                            @error('currency_id') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                       
                    
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="closeCreateAccountModal"> @lang('word.Close')</button>
                    <button wire:click="createAccountForSelectedCustomer" type="submit" class="btn btn-primary"> @lang('word.Save')</button>
                </div>
            </div>
        </div>
    </div>
    @endif

    {{-- Adjustment modal for account cashbox --}}
    @if($showModal)
    <div class="modal fade show d-block" style="background-color: rgba(0, 0, 0, 0.5);" tabindex="-1">
        <div class="modal-dialog modal-lg"> <!-- Add modal-lg or modal-xl here -->
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('word.Transfer')</h5>
                    <button type="button" class="btn-close" wire:click="closeModal"></button>
                </div>
                <div class="modal-body">
                    <div class="row">

                         <!-- Transaction Amount -->
                         <div class="col-6">
                            <div class="form-group text-center">
                                <input placeholder="<?php echo trans('word.NameCustomerIf'); ?>" type="text" id="create_person_name" class="form-control" wire:model="create_person_name">
                                @error('create_person_name') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
                        </div>

                          <!-- My Get Fee Amount -->
                          <div class="col-6">
                            <div class="form-group text-center">
                                <input placeholder="<?php echo trans('word.MyFee'); ?>" type="text" x-mask:dynamic="$money($input, '.', ',', 4)" id="create_get_fee" class="form-control" wire:model="create_get_fee">
                                @error('create_get_fee') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        

                        <!-- Account Selection -->
                        @php
                            $customer_cashiers_ids = App\Models\Customer::where('customer_name', 'Cashiers')->pluck('id'); // Use pluck to get an array of IDs
                        @endphp
                        <div class="col-6 ">
                            @livewire('components.custom-select', [
                                    'label' => 'لە حسابی نێردەر',
                                    'placeholder' =>'لە حسابی نێردەر',
                                'identifier' => "filters.account",
                                'options' => App\Models\Account::where('id', '!=', $this->account->id) // Exclude the from account by ID
                                    ->whereIn('account_type', ['savings', 'cashier']) // Include both 'savings' and 'cashier' account types
                                    ->whereNotIn('customer_id', $customer_cashiers_ids) 
                                    ->where('currency_id', $this->accountCurrencyId) // Only show accounts with the same currency ID
                                    ->get()
                                    ->mapWithKeys(function ($account) {
                                        $label = $account->account_type === 'cashier' 
                                            ? "قاسەی گواستنەوەی پارە لۆ کاشێر ({$account->currency->currency_name})"
                                            : " {$account->customer->id} ({$account->currency->currency_name}) - {$account->customer->user->name} ";
                                        return [$account->id => $label];
                                    }),
                            ], key('select-account'))
                            @error('filters.account') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                        
                       <!-- Transaction Type -->
                        <div class="col-6 mb-3">
                            <label for="transaction_type" class="form-label">@lang('word.TransactionType')</label>
                            <select wire:model="create_transaction_type" class="form-control" id="transaction_type" disabled>
                                <option value="transfer">{{ __('word.Transfer') }}</option>
                            </select>
                            @error('create_transaction_type') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>


                        <!-- Transaction Amount -->
                        <div class="col-6 mb-3">
                            <label for="transaction_amount" class="form-label"> بڕی پارەی گواستنەوە </label>
                            <input type="text" x-mask:dynamic="$money($input, '.', ',', 4)" wire:model="create_transaction_amount" class="form-control" id="transaction_amount">
                            @error('create_transaction_amount') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>

                         <!-- Transaction Fee -->
                         <div class="col-6 mb-3">
                            <label for="transaction_fee"  class="form-label"> عمولەی نێردەر</label>
                            <input type="text" x-mask:dynamic="$money($input, '.', ',', 4)" wire:model="create_transaction_fee" class="form-control" id="transaction_fee">
                            @error('create_transaction_fee') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>

                        <!-- Note -->
                        <div class="col-12 mb-3">
                            <label for="note" class="form-label"> @lang('word.Note')</label>
                            <textarea wire:model="create_note" class="form-control" id="note"></textarea>
                            @error('create_note') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                    </div>

                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="closeModal"> @lang('word.Close')</button>
                    <button wire:click="saveCreate" type="submit" class="btn btn-primary"> @lang('word.Save')</button>
                </div>
            </div>
        </div>
    </div>
@endif

<script>
    function printContent() {
        var content = document.getElementById('printSection').innerHTML;

        // Open a new window for printing
        var printWindow = window.open('', '_blank', 'height=700,width=900');

        // Make sure the window is successfully opened
        if (printWindow) {
            printWindow.document.open();
            printWindow.document.write('<html><head><title>Print</title>');
            // Add custom print styles here
            printWindow.document.write('<style>');
            printWindow.document.write(`
                @media print {
                    /* Hide all unnecessary layout elements */
                    body * {
                        visibility: hidden;
                    }

                    /* Show only the content inside #printSection */
                    #printSection, #printSection * {
                        visibility: visible;
                    }

                    /* Ensure the printSection starts immediately at the top */
                    #printSection {
                        position: absolute;
                        left: 0;
                        top: 0;
                        margin: 0 !important;
                        padding: 0 !important;
                        width: 100%;
                        direction: rtl;  /* Right-to-left direction for the printed content */
                    }

                    /* Table styling for print */
                    table {
                        width: 100%;
                        border-collapse: collapse;
                        direction: rtl;  /* Right-to-left for tables */
                    }

                    th, td {
                        border: 1px solid #000;
                        padding: 8px;
                        text-align: right; /* Align text to the right */
                    }

                    th {
                        background-color: #f2f2f2;
                    }

                    /* Hide print button */
                    button {
                        display: none;
                    }

                    /* Prevent page breaks inside key elements */
                    .card, .table-responsive, .row {
                        page-break-inside: avoid;
                    }

                    /* Clear any floating content */
                    .clearfix:after {
                        content: "";
                        display: table;
                        clear: both;
                    }
                }
            `);
            printWindow.document.write('</style>');
            printWindow.document.write('</head><body>');
            printWindow.document.write('<div id="printSection">');
            printWindow.document.write(content);
            printWindow.document.write('</div>');
            printWindow.document.write('</body></html>');
            printWindow.document.close();

            // Wait for the content to load and then trigger the print
            printWindow.onload = function() {
                printWindow.focus();
                printWindow.print();
                printWindow.onafterprint = function() {
                    printWindow.close();
                };
            };
        } else {
            alert('Failed to open print window. Please ensure popups are enabled.');
        }
        
    }
</script>
</div>

    