<div>
    @can('create', App\Models\Patient::class)
    <div class="d-flex justify-content-between mb-3">
        <h2>Patient Management</h2>
        <div>
            <a href="{{ route('patient-invoice-wizard') }}" class="btn btn-success me-2">
                <i class="ti ti-user-plus me-2"></i>New Patient & Invoice
            </a>
        </div>
    </div>
    @endcan

    <div class="card mt-4">
        <div class="card-body">
            <!-- Search Input -->
            <div class="d-flex justify-content-between align-items-center mb-4">
                <input 
                    type="text" 
                    class="form-control w-50" 
                    placeholder="Search patients..." 
                    wire:model.live="searchQuery" 
                />
            </div>

            <div class="table-responsive mt-4">
                <table class="table table-border table-hover">
                    <thead>
                        <tr>
                            <th>Code</th>
                            <th>Name</th>
                            <th>Phone</th>
                            <th>Address</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($patients as $patient)
                            <tr>
                                <td>{{ $patient->code }}</td>
                                <td>{{ $patient->name }}</td>
                                <td>{{ $patient->phone }}</td>
                                <td>{{ $patient->address ?? '-' }}</td>
                                <td class="text-center" style="width: 134px;">
                                    <div role="group" aria-label="Row Actions" class="btn-group">
                                        @can('view', $patient)
                                        <a href="{{ route('patients.show', $patient->id) }}">
                                            <button type="button" class="btn btn-icon btn-outline-primary m-1">
                                                <i class="fa fa-eye"></i>
                                            </button>
                                        </a>
                                        @endcan

                                        @can('update', $patient)
                                        <button wire:click="showEditPatientModal({{ $patient->id }})"
                                            type="button" class="btn btn-icon btn-outline-info m-1">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                        @endcan

                                        @can('delete', $patient)
                                        <button wire:click="deletePatient({{ $patient->id }})"
                                            wire:confirm="Are you sure you want to delete this patient?"
                                            type="button" class="btn btn-icon btn-outline-danger m-1">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                        @endcan
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <div class="d-flex justify-content-between align-items-center mt-4">
                <div>
                    <p class="mb-0">Total: {{ $patients->total() }}</p>
                </div>
                <div>
                    {{ $patients->links(data: ['scrollTo' => false]) }}
                </div>
            </div>
        </div>
    </div>

    <!-- Create Modal -->
    @if($showCreateModal)
    <div class="modal fade show d-block" style="background-color: rgba(0, 0, 0, 0.5);" tabindex="-1" wire:key="create-modal">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">New Patient</h5>
                    <button type="button" class="btn-close" wire:click="closeCreateModal"></button>
                </div>
                <div class="modal-body">
                    @if ($errors->any())
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <h6 class="alert-heading"><i class="fa fa-exclamation-triangle"></i> Please fix the following errors:</h6>
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div class="form-floating">
                                <input type="text" class="form-control @error('code') is-invalid @enderror" id="code" wire:model="code" placeholder="Patient Code" required>
                                <label for="code">Patient Code <span class="text-danger">*</span></label>
                                @error('code') 
                                    <div class="text-danger small mt-1"><i class="fa fa-exclamation-circle"></i> {{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="form-floating">
                                <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" wire:model="name" placeholder="Patient Name" required>
                                <label for="name">Patient Name <span class="text-danger">*</span></label>
                                @error('name') 
                                    <div class="text-danger small mt-1"><i class="fa fa-exclamation-circle"></i> {{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="form-floating">
                                <input type="text" class="form-control @error('phone') is-invalid @enderror" id="phone" wire:model="phone" placeholder="Phone" required>
                                <label for="phone">Phone <span class="text-danger">*</span></label>
                                @error('phone') 
                                    <div class="text-danger small mt-1"><i class="fa fa-exclamation-circle"></i> {{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-12 mb-3">
                            <div class="form-floating">
                                <textarea class="form-control @error('address') is-invalid @enderror" id="address" wire:model="address" style="height: 100px" placeholder="Address"></textarea>
                                <label for="address">Address</label>
                                @error('address') 
                                    <div class="text-danger small mt-1"><i class="fa fa-exclamation-circle"></i> {{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="closeCreateModal">Close</button>
                    <button wire:click="savePatient" type="button" class="btn btn-primary">Save</button>
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- Edit Modal -->
    @if($showEditModal)
    <div class="modal fade show d-block" style="background-color: rgba(0, 0, 0, 0.5);" tabindex="-1" wire:key="edit-modal">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Patient</h5>
                    <button type="button" class="btn-close" wire:click="closeEditModal"></button>
                </div>
                <div class="modal-body">
                    @if ($errors->any())
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <h6 class="alert-heading"><i class="fa fa-exclamation-triangle"></i> Please fix the following errors:</h6>
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div class="form-floating">
                                <input type="text" class="form-control @error('edit_code') is-invalid @enderror" id="edit_code" wire:model="edit_code" placeholder="Patient Code" required>
                                <label for="edit_code">Patient Code <span class="text-danger">*</span></label>
                                @error('edit_code') 
                                    <div class="text-danger small mt-1"><i class="fa fa-exclamation-circle"></i> {{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="form-floating">
                                <input type="text" class="form-control @error('edit_name') is-invalid @enderror" id="edit_name" wire:model="edit_name" placeholder="Patient Name" required>
                                <label for="edit_name">Patient Name <span class="text-danger">*</span></label>
                                @error('edit_name') 
                                    <div class="text-danger small mt-1"><i class="fa fa-exclamation-circle"></i> {{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="form-floating">
                                <input type="text" class="form-control @error('edit_phone') is-invalid @enderror" id="edit_phone" wire:model="edit_phone" placeholder="Phone" required>
                                <label for="edit_phone">Phone <span class="text-danger">*</span></label>
                                @error('edit_phone') 
                                    <div class="text-danger small mt-1"><i class="fa fa-exclamation-circle"></i> {{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-12 mb-3">
                            <div class="form-floating">
                                <textarea class="form-control @error('edit_address') is-invalid @enderror" id="edit_address" wire:model="edit_address" style="height: 100px" placeholder="Address"></textarea>
                                <label for="edit_address">Address</label>
                                @error('edit_address') 
                                    <div class="text-danger small mt-1"><i class="fa fa-exclamation-circle"></i> {{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="closeEditModal">Close</button>
                    <button wire:click="updatePatient" type="button" class="btn btn-primary">Save</button>
                </div>
            </div>
        </div>
    </div>
    @endif
</div>
