<div>
    <!-- Styles remain the same -->
<script src="https://html2canvas.hertzen.com/dist/html2canvas.min.js"></script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">

<div wire:loading.flex.class.remove="d-none" wire:target="saveDailyReport" 
     class="position-fixed top-0 start-0 w-100 h-100 bg-dark bg-opacity-50 align-items-center justify-content-center d-none" 
     style="z-index: 9999;">
    <div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status">
        <span class="visually-hidden">Loading...</span>
    </div>
</div>
    <div class="d-flex justify-content-between align-items-center mb-3">
        <div>
            <button wire:click="loadBalances" class="btn btn-sm btn-primary">
                <i class="fas fa-sync-alt me-1"></i> نوێکردنەوە
            </button>
            <button wire:click="clearConversionData" class="btn btn-sm btn-warning ms-2">
                <i class="fas fa-eraser me-1"></i> سڕینەوەی گۆڕینەوە
            </button>
        </div>
        
        @if(!$todayReportExists)
            <button wire:click="saveDailyReport" class="btn btn-sm btn-success">
                <i class="fas fa-save me-1"></i> پاشەکەوتکردنی داتای ئەمڕۆ
            </button>
        @else
            <span class="badge bg-info text-white">
                <i class="fas fa-check me-1"></i> داتای ئەمڕۆ پاشەکەوت بوو
            </span>
        @endif
    </div>

    <div class="net-balance-component row g-4">
        <!-- IQD Balance Card -->
        <div class="col-xl-4 col-lg-6 col-md-6">
            <div class="card shadow-lg border-0 flex-grow-1 d-flex flex-column currency-card">
                <div class="card-header bg-primary text-white p-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="mb-1 fw-bold text-white">
                                <i class="fas fa-money-bill-wave me-2"></i>
                                حساباتی ڕۆژانەی دینار (IQD)
                            </h5>
                            @if($balanceAfterUsdToIqdConversion > 0 && $convertedUsdToIqd > 0)
                                <span style="font-size: 18px;" class="balance-badge fw-bold {{ $balanceAfterUsdToIqdConversion < 0 ? 'text-danger' : 'text-white' }}">
                                    <i class="fas fa-wallet me-1 mt-3"></i>
                                    کۆی گشتی: {{ number_format($balanceAfterUsdToIqdConversion, 0, '.', ',') }} IQD
                                </span>
                            @else
                                <span style="font-size: 18px;" class="balance-badge fw-bold {{ $totalBalance < 0 ? 'text-danger' : 'text-white' }}">
                                    <i class="fas fa-wallet me-1 mt-3"></i>
                                    کۆی گشتی: {{ number_format($totalBalance, 0, '.', ',') }} IQD
                                </span>
                            @endif
                        </div>

                        <div class="d-flex">
                            <button wire:click="loadBalances" class="btn btn-sm btn-outline-light rounded-circle me-2">
                                <i class="fas fa-sync-alt"></i>
                            </button>
                            <button wire:click="openIqdToUsdModal" class="btn btn-sm btn-outline-light rounded-circle">
                                <i class="fas fa-exchange-alt"></i>
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="card-body p-0">
                    <div class="list-group list-group-flush">
                        @php
                            $regularAccounts = collect($accountsBalances)->filter(function($account) {
                                return !isset($account['is_customer_total']) || !$account['is_customer_total'];
                            });
                            
                            $customerTotal = collect($accountsBalances)->filter(function($account) {
                                return isset($account['is_customer_total']) && $account['is_customer_total'];
                            })->first();
                        @endphp

                        @forelse($regularAccounts as $index => $account)
                            <div class="list-group-item d-flex justify-content-between align-items-center py-3 px-4 hover-highlight">
                                <div class="d-flex align-items-center">
                                    <span class="badge bg-light text-dark me-3">{{ $account['title'] }}</span>
                                </div>
                                <div>
                                    <span class="fw-bold fs-5 {{ $account['balance'] >= 0 ? 'text-success' : 'text-danger' }}">
                                        {{ number_format($account['balance'], 0, '.', ',') }} 
                                        <small class="text-muted">IQD</small>
                                    </span>
                                </div>
                            </div>
                        @empty
                            <div class="text-center py-4 text-muted">
                               @lang('word.Empty')
                            </div>
                        @endforelse

                        <div class="list-group-item bg-light py-3 px-4 d-flex justify-content-between align-items-center total-highlight border-primary">
                            <span class="fw-bold fs-5 text-primary">کۆی گشتی پێش هاتوو و چوو</span>
                            <span class="fw-bold fs-5 {{ $subtotalBeforeCustomerIQD >= 0 ? 'text-success' : 'text-danger' }}">
                                {{ number_format($subtotalBeforeCustomerIQD, 0, '.', ',') }} 
                                <small class="text-muted">IQD</small>
                            </span>
                        </div>
                        
                        @if($customerTotal)
                            <div class="list-group-item d-flex justify-content-between align-items-center py-3 px-4 hover-highlight">
                                <div class="d-flex align-items-center">
                                    <span class="badge bg-light text-dark me-3">{{ $customerTotal['title'] }}</span>
                                </div>
                                <div>
                                    <span class="fw-bold fs-5 {{ $customerTotal['balance'] >= 0 ? 'text-success' : 'text-danger' }}">
                                        {{ number_format($customerTotal['balance'], 0, '.', ',') }} 
                                        <small class="text-muted">IQD</small>
                                    </span>
                                </div>
                            </div>
                        @endif

                        <!-- USD to IQD Conversion Section -->
                        @if($convertedUsdToIqd > 0)
                            <div class="list-group-item bg-warning-subtle py-3 px-4 d-flex justify-content-between align-items-center">
                                <div class="d-flex align-items-center">
                                    <span class="badge bg-warning text-dark me-3">
                                        <i class="fas fa-exchange-alt me-1"></i> گۆڕینەوە لە USD بۆ IQD
                                        @if($usdToIqdRate > 0)
                                            <small class="ms-2">(1 USD = {{ number_format($usdToIqdRate, 0) }} IQD)</small>
                                        @endif
                                    </span>
                                </div>
                                <div>
                                    <span class="fw-bold fs-5 text-success">
                                        {{ number_format($convertedUsdToIqd, 0, '.', ',') }} 
                                        <small class="text-muted">IQD</small>
                                    </span>
                                </div>
                            </div>
                            
                            <div class="list-group-item bg-light py-3 px-4 d-flex justify-content-between align-items-center">
                                <div class="d-flex align-items-center">
                                    <span class="badge bg-info text-white me-3">
                                        <i class="fas fa-calculator me-1"></i> کۆی گشتی دوای گۆڕینەوە
                                    </span>
                                </div>
                                <div>
                                    <span class="fw-bold fs-5 {{ $balanceAfterUsdToIqdConversion >= 0 ? 'text-success' : 'text-danger' }}">
                                        {{ number_format($balanceAfterUsdToIqdConversion, 0, '.', ',') }} 
                                        <small class="text-muted">IQD</small>
                                    </span>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
        
        <!-- USD Balance Card -->
        <div class="col-xl-4 col-lg-6 col-md-6 d-flex">
            <div class="card shadow-lg border-0 flex-grow-1 d-flex flex-column currency-card">
                <div class="card-header bg-success text-white p-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="mb-1 fw-bold text-white">
                                <i class="fas fa-dollar-sign me-2"></i>
                                حساباتی ڕۆژانەی دۆلار (USD)
                            </h5>
                            <div style="font-size: 18px;">
                                <div class="fw-bold text-white">
                                    <i class="fas fa-wallet me-1"></i>
                                    کۆی گشتی: {{ number_format($totalBalanceUSD + $totalAdditionalCurrencyUsdValue, 2, '.', ',') }} USD
                                </div>
                                @if($convertedIqdToUsd > 0)
                                    <div class="fw-bold text-white mt-2">
                                        <i class="fas fa-exchange-alt me-1"></i>
                                        گۆڕینەوە لە IQD: {{ number_format($convertedIqdToUsd, 2, '.', ',') }} USD
                                    </div>
                                    <div class="fw-bold {{ ($totalBalanceUSD + $totalAdditionalCurrencyUsdValue + $convertedIqdToUsd) >= 0 ? 'text-success' : 'text-danger' }} mt-2">
                                        <i class="fas fa-calculator me-1"></i>
                                        کۆی دوای گۆڕینەوە: {{ number_format($totalBalanceUSD + $totalAdditionalCurrencyUsdValue + $convertedIqdToUsd, 2, '.', ',') }} USD
                                    </div>
                                @endif
                            </div>
                        </div>
                      
                        <div class="d-flex">
                            <button wire:click="loadBalances" class="btn btn-sm btn-outline-light rounded-circle me-2">
                                <i class="fas fa-sync-alt"></i>
                            </button>
                            <button wire:click="openUsdToIqdModal" class="btn btn-sm btn-outline-light rounded-circle">
                                <i class="fas fa-exchange-alt"></i>
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="card-body p-0">
                    <div class="list-group list-group-flush">
                        @php
                            $regularAccountsUSD = collect($accountsBalancesUSD)->filter(function($account) {
                                return !isset($account['is_customer_total']) || !$account['is_customer_total'];
                            });
                            
                            $customerTotalUSD = collect($accountsBalancesUSD)->filter(function($account) {
                                return isset($account['is_customer_total']) && $account['is_customer_total'];
                            })->first();
                        @endphp

                        @forelse($regularAccountsUSD as $index => $account)
                            <div class="list-group-item d-flex justify-content-between align-items-center py-3 px-4 hover-highlight">
                                <div class="d-flex align-items-center">
                                    <span class="badge bg-light text-dark me-3">{{ $account['title'] }}</span>
                                </div>
                                <div>
                                    <span class="fw-bold fs-5 {{ $account['balance'] >= 0 ? 'text-success' : 'text-danger' }}">
                                        {{ number_format($account['balance'], 2, '.', ',') }} 
                                        <small class="text-muted">USD</small>
                                    </span>
                                </div>
                            </div>
                        @empty
                            <div class="text-center py-4 text-muted">
                                @lang('word.Empty')
                            </div>
                        @endforelse
                        
                        <div class="list-group-item bg-light py-3 px-4 d-flex justify-content-between align-items-center total-highlight border-success">
                            <span class="fw-bold fs-5 text-primary">کۆی گشتی پێش هاتوو و چوو</span>
                            <span class="fw-bold fs-5 {{ $subtotalBeforeCustomerUSD >= 0 ? 'text-success' : 'text-danger' }}">
                                {{ number_format($subtotalBeforeCustomerUSD, 2, '.', ',') }} 
                                <small class="text-muted">USD</small>
                            </span>
                        </div>
                        
                        @if($customerTotalUSD)
                            <div class="list-group-item d-flex justify-content-between align-items-center py-3 px-4 hover-highlight">
                                <div class="d-flex align-items-center">
                                    <span class="badge bg-light text-dark me-3">{{ $customerTotalUSD['title'] }}</span>
                                </div>
                                <div>
                                    <span class="fw-bold fs-5 {{ $customerTotalUSD['balance'] >= 0 ? 'text-success' : 'text-danger' }}">
                                        {{ number_format($customerTotalUSD['balance'], 2, '.', ',') }} 
                                        <small class="text-muted">USD</small>
                                    </span>
                                </div>
                            </div>
                        @endif

                        <!-- Converted currencies section -->
                        @foreach($additionalCurrencyBalances as $currency)
                            @if($currency['rate'] > 0 && $currency['converted_value'] != 0)
                                <div class="list-group-item d-flex justify-content-between align-items-center py-3 px-4 hover-highlight">
                                    <div class="d-flex align-items-center">
                                        <span class="badge bg-warning text-dark me-3">
                                            <i class="fas fa-exchange-alt me-1"></i> گۆڕینەوە لە {{ $currency['currency_name'] }}
                                            <small class="ms-2">(1 {{ $currency['currency_name'] }} = {{ $currency['rate'] }} USD)</small>
                                        </span>
                                    </div>
                                    <div>
                                        <span class="fw-bold fs-5 text-success">
                                            {{ number_format($currency['converted_value'], 2, '.', ',') }} 
                                            <small class="text-muted">USD</small>
                                        </span>
                                    </div>
                                </div>
                            @endif
                        @endforeach

                        <!-- IQD to USD Conversion Section -->
                        @if($convertedIqdToUsd > 0)
                            <div class="list-group-item bg-warning-subtle py-3 px-4 d-flex justify-content-between align-items-center">
                                <div class="d-flex align-items-center">
                                    <span class="badge bg-warning text-dark me-3">
                                        <i class="fas fa-exchange-alt me-1"></i> گۆڕینەوە لە IQD بۆ USD
                                        @if($iqdToUsdRate > 0)
                                            <small class="ms-2">(1 USD = {{ number_format($iqdToUsdRate, 0) }} IQD)</small>
                                        @endif
                                    </span>
                                </div>
                                <div>
                                    <span class="fw-bold fs-5 text-success">
                                        {{ number_format($convertedIqdToUsd, 2, '.', ',') }} 
                                        <small class="text-muted">USD</small>
                                    </span>
                                </div>
                            </div>
                            
                            <div class="list-group-item bg-light py-3 px-4 d-flex justify-content-between align-items-center">
                                <div class="d-flex align-items-center">
                                    <span class="badge bg-info text-white me-3">
                                        <i class="fas fa-calculator me-1"></i> کۆی گشتی دوای گۆڕینەوە
                                    </span>
                                </div>
                                <div>
                                    <span class="fw-bold fs-5 {{ ($totalBalanceUSD + $totalAdditionalCurrencyUsdValue + $convertedIqdToUsd) >= 0 ? 'text-success' : 'text-danger' }}">
                                        {{ number_format($totalBalanceUSD + $totalAdditionalCurrencyUsdValue + $convertedIqdToUsd, 2, '.', ',') }} 
                                        <small class="text-muted">USD</small>
                                    </span>
                                </div>
                            </div>
                            
                            @if($profitFromConversion > 0)
                            <div class="list-group-item bg-success-subtle py-3 px-4 d-flex justify-content-between align-items-center">
                                <div class="d-flex align-items-center">
                                    <span class="badge bg-success text-white me-3">
                                        <i class="fas fa-coins me-1"></i> قازانج
                                    </span>
                                </div>
                                <div>
                                    <span class="fw-bold fs-5 text-success">
                                        {{ number_format($profitFromConversion, 2, '.', ',') }} 
                                        <small class="text-muted">{{ $profitCurrency }}</small>
                                    </span>
                                </div>
                            </div>
                            @endif
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- Other Currency Card (Now includes EURO) -->
        <div class="col-xl-4 col-lg-6 col-md-6 d-flex">
            <div class="card shadow-lg border-0 flex-grow-1 d-flex flex-column currency-card">
                <div class="card-header bg-info text-white p-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="mb-1 fw-bold text-white">
                                <i class="fas fa-coins me-2"></i>
                                دراوەکانى تر
                            </h5>
                            <span style="font-size: 18px;" class="balance-badge fw-bold text-white">
                                <i class="fas fa-wallet me-1 mt-3"></i>
                                کۆی گشتی: {{ number_format($totalAdditionalCurrencyUsdValue, 2, '.', ',') }} USD
                            </span>
                        </div>
                        <div>
                            <button wire:click="loadBalances" class="btn btn-sm btn-outline-light rounded-circle me-2">
                                <i class="fas fa-sync-alt"></i>
                            </button>
                            <button wire:click="openCurrencyModal" class="btn btn-sm btn-outline-light rounded-circle">
                                <i class="fas fa-plus"></i>
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="card-body p-0">
                    <div class="list-group list-group-flush">
                        @forelse($additionalCurrencyBalances as $currency)
                            <div class="list-group-item d-flex justify-content-between align-items-center py-3 px-4 hover-highlight">
                                <div class="d-flex align-items-center">
                                    <span class="badge bg-light text-dark me-3">قاسەی خاوەن کار ({{ $currency['currency_name'] }})</span>
                                </div>
                                <div class="text-end">
                                    <div class="fw-bold fs-5 {{ $currency['balance'] >= 0 ? 'text-success' : 'text-danger' }}">
                                        {{ number_format($currency['balance'], 0, '.', ',') }} 
                                        <small class="text-muted">{{ $currency['currency_name'] }}</small>
                                    </div>
                                    @if($currency['rate'] > 0)
                                        <div class="text-muted small">
                                            <i class="fas fa-exchange-alt me-1"></i>
                                            {{ number_format($currency['converted_value'], 2, '.', ',') }} USD
                                            <small>(نرخ: {{ $currency['rate'] }})</small>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        @empty
                            <div class="text-center py-4 text-muted">
                                هيچ دراوێک دەستنیشان نەکراوە
                            </div>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- USD to IQD Conversion Modal -->
    @if($showUsdToIqdModal)
        <div class="modal-backdrop fade show" style="z-index: 1040;"></div>
        <div class="modal fade show d-block" tabindex="-1" style="z-index: 1050;">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header bg-primary text-white">
                        <h5 class="modal-title text-white">
                            <i class="fas fa-exchange-alt me-2"></i>
                            گۆڕینەوەی دۆلار بۆ دینار
                        </h5>
                        <button type="button" class="btn-close btn-close-white" wire:click="closeUsdToIqdModal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle me-2"></i>
                            نرخی گۆڕینەوەی دۆلار بۆ دینار دیاری بکە
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-bold">کۆی گشتی دۆلار</label>
                            <div class="input-group">
                                <input type="text" class="form-control" readonly 
                                    value="{{ number_format($totalBalanceUSD + $totalAdditionalCurrencyUsdValue, 2, '.', ',') }}">
                                <span class="input-group-text">USD</span>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-bold">نرخی گۆڕینەوە</label>
                            <div class="input-group">
                                <span class="input-group-text">1 USD =</span>
                                <input type="number" 
                                    step="0.01" 
                                    class="form-control"
                                    placeholder="نرخی گۆڕینەوە"
                                    wire:model.live="usdToIqdRate">
                                <span class="input-group-text">IQD</span>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-bold">کۆی گشتی دینار</label>
                            <div class="input-group">
                                <input type="text" class="form-control" readonly 
                                    value="{{ number_format(($totalBalanceUSD + $totalAdditionalCurrencyUsdValue) * $usdToIqdRate, 0, '.', ',') }}">
                                <span class="input-group-text">IQD</span>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" wire:click="closeUsdToIqdModal">داخستن</button>
                        <button type="button" class="btn btn-primary" wire:click="convertUsdToIqd">پاشەکەوتکردن</button>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <!-- IQD to USD Conversion Modal -->
    @if($showIqdToUsdModal)
        <div class="modal-backdrop fade show" style="z-index: 1040;"></div>
        <div class="modal fade show d-block" tabindex="-1" style="z-index: 1050;">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header bg-success text-white">
                        <h5 class="modal-title text-white">
                            <i class="fas fa-exchange-alt me-2"></i>
                            گۆڕینەوەی دینار بۆ دۆلار
                        </h5>
                        <button type="button" class="btn-close btn-close-white" wire:click="closeIqdToUsdModal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle me-2"></i>
                            نرخی گۆڕینەوەی دینار بۆ دۆلار دیاری بکە
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-bold">کۆی گشتی دینار</label>
                            <div class="input-group">
                                <input type="text" class="form-control" readonly 
                                    value="{{ number_format($totalBalance, 0, '.', ',') }}">
                                <span class="input-group-text">IQD</span>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-bold">نرخی گۆڕینەوە</label>
                            <div class="input-group">
                                <span class="input-group-text">1 USD =</span>
                                <input type="number" 
                                    step="0.01" 
                                    class="form-control"
                                    placeholder="نرخی گۆڕینەوە"
                                    wire:model.live="iqdToUsdRate">
                                <span class="input-group-text">IQD</span>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-bold">کۆی گشتی دۆلار</label>
                            <div class="input-group">
                                <input type="text" class="form-control" readonly 
                                    value="{{ $iqdToUsdRate > 0 ? number_format($totalBalance / $iqdToUsdRate, 2, '.', ',') : '0.00' }}">
                                <span class="input-group-text">USD</span>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" wire:click="closeIqdToUsdModal">داخستن</button>
                        <button type="button" class="btn btn-primary" wire:click="convertIqdToUsd">پاشەکەوتکردن</button>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <!-- Modal section -->
    @if($showCurrencyModal)
        <div class="modal-backdrop fade show" style="z-index: 1040;"></div>
        <div class="modal fade show d-block" tabindex="-1" style="z-index: 1050;">
            <div class="modal-dialog modal-dialog-centered modal-xl">
                <div class="modal-content">
                    <div class="modal-header bg-primary text-white">
                        <h5 class="modal-title text-white">
                            <i class="fas fa-money-bill-wave me-2"></i>
                            دەستنیشانکردنی دراوى تر
                        </h5>
                        <button type="button" class="btn-close btn-close-white" wire:click="closeCurrencyModal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-12">
                                <div class="alert alert-info">
                                    <i class="fas fa-info-circle me-2"></i>
                                    دراوەکانى تر دەستنیشان بکە و نرخى گۆڕینەوەکەى بۆ دۆلار
                                </div>
                            </div>
                        </div>
                        
                        <div class="row g-3">
                            @forelse($availableCurrencies as $currency)
                                @if(($this->currencyBalances[$currency->id] ?? 0) != 0)
                                    <div class="col-md-4 col-sm-6">
                                        <!-- Completing the Currency Modal from where it was cut off -->
                                        <div class="card h-100 {{ isset($selectedCurrencies[$currency->id]) ? 'border-primary' : 'border' }}">
                                            <div class="card-body">
                                                <div class="d-flex justify-content-between align-items-center mb-2">
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="checkbox" 
                                                            id="currency-{{ $currency->id }}"
                                                            wire:click="toggleCurrency({{ $currency->id }})"
                                                            {{ isset($selectedCurrencies[$currency->id]) ? 'checked' : '' }}>
                                                        <label class="form-check-label fw-bold" for="currency-{{ $currency->id }}">
                                                            {{ $currency->currency_name }}
                                                        </label>
                                                    </div>
                                                    <span class="badge bg-{{ ($this->currencyBalances[$currency->id] ?? 0) >= 0 ? 'success' : 'danger' }} rounded-pill">
                                                        {{ number_format($this->currencyBalances[$currency->id] ?? 0, 0, '.', ',') }}
                                                    </span>
                                                </div>
                                                
                                                @if(isset($selectedCurrencies[$currency->id]))
                                                    <div class="mt-3">
                                                        <label class="form-label small">نرخی گۆڕینەوە بۆ دۆلار</label>
                                                        <div class="input-group input-group-sm">
                                                            <span class="input-group-text">1 {{ $currency->currency_name }} =</span>
                                                            <input type="number" 
                                                                class="form-control" 
                                                                placeholder="0.00"
                                                                step="0.0001"
                                                                wire:model.live="selectedCurrencies.{{ $currency->id }}.rate"
                                                                wire:change="updateCurrencyRate({{ $currency->id }}, $event.target.value)">
                                                            <span class="input-group-text">USD</span>
                                                        </div>
                                                        
                                                        @if(isset($selectedCurrencies[$currency->id]['rate']) && $selectedCurrencies[$currency->id]['rate'] > 0)
                                                            <div class="small text-success mt-2">
                                                                <i class="fas fa-exchange-alt me-1"></i>
                                                                {{ number_format(($this->currencyBalances[$currency->id] ?? 0) * $selectedCurrencies[$currency->id]['rate'], 2, '.', ',') }} USD
                                                            </div>
                                                        @endif
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    @endif
                            @empty
                                <div class="col-12">
                                    <div class="alert alert-info">
                                        <i class="fas fa-info-circle me-2"></i>
                                        هيچ دراوێک بەردەست نییە
                                    </div>
                                </div>
                            @endforelse
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" wire:click="closeCurrencyModal">داخستن</button>
                        <button type="button" class="btn btn-primary" wire:click="loadAdditionalCurrencies">پاشەکەوتکردن</button>
                    </div>
                </div>
            </div>
        </div>
    @endif
    <script>
        document.addEventListener('livewire:initialized', () => {
    @this.on('captureScreenshot', () => {
        // Livewire will automatically show loading state for the saveDailyReport action
        setTimeout(() => {
            const element = document.querySelector('.net-balance-component');
            if (!element) {
                console.error('Could not find element to capture');
                return;
            }
            
            const options = {
                scale: 2,
                useCORS: true,
                allowTaint: true,
                backgroundColor: '#ffffff',
                logging: true,
                scrollX: 0,
                scrollY: 0,
                windowWidth: document.documentElement.scrollWidth,
                windowHeight: document.documentElement.scrollHeight
            };
            
            html2canvas(element, options).then(canvas => {
                const imageData = canvas.toDataURL('image/png');
                @this.call('saveReportWithImage', imageData);
            }).catch(error => {
                console.error('Screenshot capture failed:', error);
                if (typeof Swal !== 'undefined') {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'Failed to capture report image. Please try again.'
                    });
                } else {
                    alert('Failed to capture report image. Please try again.');
                }
            });
        }, 500);
    });
});
</script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

</div>