<div>
    <div class="card border-0 shadow-sm">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4 class="card-title mb-0">
                    <i class="menu-icon tf-icons ti ti-receipt me-2"></i>
                    Invoices
                </h4>
            </div>

            <!-- Filters -->
            <div class="card filter-card mb-4 border">
                <div class="card-header bg-white border-bottom py-3 d-flex justify-content-between align-items-center">
                    <h5 class="mb-0 text-primary">
                        <i class="menu-icon tf-icons ti ti-filter me-2"></i>
                        Filters
                    </h5>
                    <button wire:click="resetFilters" class="btn btn-outline-secondary btn-sm">
                        <i class="menu-icon tf-icons ti ti-refresh me-1"></i>
                        Reset
                    </button>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-3">
                            <label class="form-label">Search</label>
                            <div class="input-group">
                                <span class="input-group-text">
                                    <i class="menu-icon tf-icons ti ti-search"></i>
                                </span>
                                <input 
                                    type="text" 
                                    wire:model.live.debounce.300ms="search" 
                                    class="form-control" 
                                    placeholder="Invoice number, patient..."
                                >
                            </div>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">Start Date</label>
                            <input type="date" wire:model.live="startDate" class="form-control">
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">End Date</label>
                            <input type="date" wire:model.live="endDate" class="form-control">
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">Status</label>
                            <select wire:model.live="status" class="form-select">
                                <option value="">All Status</option>
                                <option value="draft">Draft</option>
                                <option value="completed">Completed</option>
                                <option value="cancelled">Cancelled</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">Patient</label>
                            <div class="position-relative" x-data="{ open: false }">
                                <div class="input-group">
                                    <input 
                                        type="text" 
                                        class="form-control" 
                                        placeholder="{{ $patient_id ? 'Patient selected' : 'Search patient...' }}"
                                        wire:model.live.debounce.300ms="patientSearch"
                                        @focus="open = true"
                                        @click.away="setTimeout(() => open = false, 200)"
                                        @if($patient_id) readonly style="background-color: #e9ecef;" @endif
                                    >
                                    @if($patient_id)
                                        <button 
                                            class="btn btn-outline-secondary" 
                                            type="button"
                                            wire:click="clearPatient"
                                            title="Clear patient filter"
                                        >
                                            <i class="menu-icon tf-icons ti ti-x"></i>
                                        </button>
                                    @endif
                                </div>
                                <div 
                                    class="position-absolute w-100 mt-1 bg-white border rounded shadow-lg" 
                                    x-show="open"
                                    style="max-height: 250px; overflow-y: auto; z-index: 1000;"
                                    x-cloak
                                    x-transition
                                    wire:loading.class="d-none"
                                >
                                    @if($filteredPatients->count() > 0)
                                        @foreach($filteredPatients as $patient)
                                            <button 
                                                type="button"
                                                class="btn btn-sm btn-light w-100 text-start border-bottom rounded-0"
                                                wire:click="selectPatient({{ $patient->id }})"
                                                @click="open = false"
                                            >
                                                <div>
                                                    <strong>{{ $patient->name }}</strong>
                                                    <br>
                                                    <small class="text-muted">{{ $patient->code }}</small>
                                                    @if($patient->phone)
                                                        <small class="text-muted"> • {{ $patient->phone }}</small>
                                                    @endif
                                                </div>
                                            </button>
                                        @endforeach
                                    @else
                                        <div class="p-2 text-muted text-center">
                                            <small>No patients found</small>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="col-md-1">
                            <label class="form-label">User</label>
                            <select wire:model.live="user_id" class="form-select">
                                <option value="">All Users</option>
                                @foreach($users as $user)
                                    <option value="{{ $user->id }}">{{ $user->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Table -->
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-light">
                        <tr>
                            <th style="cursor: pointer;" wire:click="sortByField('invoice_number')">
                                Invoice #
                                @if($sortBy === 'invoice_number')
                                    <i class="menu-icon tf-icons ti ti-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th style="cursor: pointer;" wire:click="sortByField('patient_id')">
                                Patient
                                @if($sortBy === 'patient_id')
                                    <i class="menu-icon tf-icons ti ti-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th style="cursor: pointer;" wire:click="sortByField('invoice_date')">
                                Date
                                @if($sortBy === 'invoice_date')
                                    <i class="menu-icon tf-icons ti ti-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th style="cursor: pointer;" wire:click="sortByField('total_amount')">
                                Total Amount
                                @if($sortBy === 'total_amount')
                                    <i class="menu-icon tf-icons ti ti-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th style="cursor: pointer;" wire:click="sortByField('status')">
                                Status
                                @if($sortBy === 'status')
                                    <i class="menu-icon tf-icons ti ti-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th>Created By</th>
                            <th style="cursor: pointer;" wire:click="sortByField('created_at')">
                                Created At
                                @if($sortBy === 'created_at')
                                    <i class="menu-icon tf-icons ti ti-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th class="text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($invoices as $invoice)
                            <tr>
                                <td>
                                    <strong>{{ $invoice->invoice_number }}</strong>
                                </td>
                                <td>
                                    @if($invoice->patient)
                                        <div>
                                            <strong>{{ $invoice->patient->name }}</strong>
                                            <br>
                                            <small class="text-muted">{{ $invoice->patient->code }}</small>
                                        </div>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td>
                                    {{ $invoice->invoice_date->format('Y-m-d') }}
                                </td>
                                <td>
                                    <strong class="text-success">{{ number_format($invoice->total_amount, 2) }}</strong>
                                </td>
                                <td>
                                    <span class="badge bg-{{ $invoice->status === 'completed' ? 'success' : ($invoice->status === 'cancelled' ? 'danger' : 'warning') }}">
                                        {{ ucfirst($invoice->status) }}
                                    </span>
                                </td>
                                <td>
                                    @if($invoice->user)
                                        <span class="text-muted">{{ $invoice->user->name }}</span>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td>
                                    <small class="text-muted">{{ $invoice->created_at->format('Y-m-d H:i') }}</small>
                                </td>
                                <td class="text-center" style="width: 134px;">
                                    <div role="group" aria-label="Row Actions" class="btn-group">
                                        @can('view', $invoice)
                                        <a href="{{ route('invoices.show', $invoice) }}">
                                            <button type="button" class="btn btn-icon btn-outline-primary m-1">
                                                <i class="fa fa-eye"></i>
                                            </button>
                                        </a>
                                        @endcan

                                        @can('update', $invoice)
                                        <a href="{{ route('invoices.edit', $invoice) }}">
                                            <button type="button" class="btn btn-icon btn-outline-info m-1">
                                                <i class="fa fa-edit"></i>
                                            </button>
                                        </a>
                                        @endcan

                                        @can('delete', $invoice)
                                        <button 
                                            wire:click="deleteInvoice({{ $invoice->id }})"
                                            wire:confirm="Are you sure you want to delete this invoice?"
                                            type="button" 
                                            class="btn btn-icon btn-outline-danger m-1"
                                        >
                                            <i class="fa fa-trash"></i>
                                        </button>
                                        @endcan
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="menu-icon tf-icons ti ti-receipt fs-1 d-block mb-2"></i>
                                        No invoices found
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="mt-4">
                {{ $invoices->links() }}
            </div>
        </div>
    </div>
</div>

