<div>
    <h4 class="text-primary">All Your Transactions</h4>

    @if (count($transactions) > 0)
    <div class="card mt-4">
        <div class="card-body">
        <div class="table-responsive mt-4">
            
        <table class="table table-striped">
            <thead>
                <tr>
                    <th>Transaction ID</th>
                    <th>Account ID</th>
                    <th>Amount</th>
                    <th>Date</th>
                    <th>Description</th>
                </tr>
            </thead>
            <tbody>
                @foreach($transactions as $transaction)
                    <tr>
                        <td>{{ $transaction->id }}</td>
                        
                        <!-- Check if account exists to avoid errors -->
                        <td>
                            @if($transaction->account)
                                {{ $transaction->account->account_title }}
                            @else
                                <span class="text-danger">Account not found</span>
                            @endif
                        </td>

                        <td>{{ $transaction->transaction_amount }} {{$transaction->account->currency->currency_name}}</td>
                        <td>{{ $transaction->created_at->format('Y-m-d H:i') }}</td>
                        <td>{{ $transaction->note }}</td>
                    </tr>
                @endforeach

            </tbody>
        </table>
    @else
        <p>No transactions found.</p>
    @endif
        </div>
        </div>
    </div>
</div>
