<div>
    <script src="//cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>

    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  
    @if(Auth::user()->hasRole('super-admin') || Auth::user()->hasRole('supervisor') )
    <div class="d-flex justify-content-between mb-3">
        <h2>@lang('word.CustomerManagement')</h2>
        <button class="btn btn-primary" wire:click="openCreateModal">@lang('word.NewClient')</button>
    </div>
    @endif

    @if (session()->has('message'))
        <div class="alert alert-success" wire:poll.5s>
            {{ session('message') }}
        </div>
    @endif
    
    @if (session()->has('error'))
        <div class="alert alert-danger" wire:poll.5s>
            {{ session('error') }}
        </div>
    @endif

    <div class="card mt-4">
        <div class="card-body">

             <!-- Search Input -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <input 
                type="text" 
                class="form-control w-50" 
                placeholder="@lang('word.Search')" 
                wire:model.live="searchQuery" 
            />
        </div>

        <div class="table-responsive mt-4">
            <table class="table table-border table-hover">
        <thead>
            <tr>
                <th>@lang('word.AccountName')</th>
                <th>@lang('word.Phone')</th>
                 <th>@lang('word.ID')</th>
               {{-- <th>Address</th>
                <th>Note</th> --}}
                {{-- <th>@lang('word.Accounts')</th> --}}
                <th>@lang('word.Actions')</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($customers as $customer)
                <tr>
                    <td>{{ $customer->customer_name ?? '-' }} ({{ $customer->id ?? '-' }})</td>
                    <td>{{ $customer->phone_number ?? '-' }}</td>
                     <td>{{ $customer->second_phone ?? '-' }}</td>
                   {{-- <td>{{ $customer->address }}</td>
                    <td>{{ $customer->note }}</td> --}}
                    {{-- <td>
                        <ul>
                            @foreach ($customer->accounts as $account)
                                <a href="{{ route('accounts.show', $account) }}">
                                    <li>
                                        <span style="font-size: 0.8em; padding: 0.5em 0.75em;"  class="m-2 badge {{ $account->calculateTotalBalance() > 0 ? 'bg-info' : 'bg-danger' }}">
                                             {{ number_format($account->calculateTotalBalance(), 0, '.', ',') }} 
                                        </span>
                                        {{ $account->currency->currency_name }}
                                    </li>
                                </a>
                            @endforeach
                        </ul>
                    </td> --}}
                 
                    <td class="text-center" style="width: 134px;">
                        <div
                            role="group"
                            aria-label="Row Actions"
                            class="btn-group" >
                           
                             @can('update', $customer)

                             <a target="_blank"
                                href="{{ route('show_customer', $customer->id) }}" >
                                <button
                                   
                                    type="button"
                                    class="btn btn-icon btn-outline-primary m-1" >
                                    <i class="fa fa-eye"></i>  
                                </button>
                            </a>

                            <a
                                href="#" >
                                <button
                                wire:click="showEditCustomerModal({{ $customer->id }})"
                                    data-bs-toggle="tooltip"
                                    data-bs-placement="top"
                                    data-bs-custom-class="tooltip-info"
                                    title="View"
                                    type="button"
                                    class="btn btn-icon btn-outline-info
                                        m-1 " >
                                    <i class="fa fa-edit"></i>
                                </button>
                            </a>

                            <a
                                href="#" >
                                <button
                                wire:click="selectCustomerForNewAccount({{ $customer->id }})"
                                    data-bs-toggle="tooltip"
                                    data-bs-placement="top"
                                    data-bs-custom-class="tooltip-success"
                                    title="Add new Account"
                                    type="button"
                                    class="btn btn-icon btn-outline-success m-1" >
                                    <i class="fa fa-user"></i>  <i class="fa fa-plus"></i>
                                </button>
                            </a>
                            @endcan 
                            
                        </div>
                    </td>

                </tr>
            @endforeach
        </tbody>
    </table>

        </div>

        <div class="d-flex justify-content-between align-items-center mt-4">
            <!-- Total Count -->
            <div>
                <p class="mb-0">@lang('word.Total'): {{ $customers->total() }}</p>
            </div>
            
            <!-- Pagination Links -->
            <div>
                {{ $customers->links(data: ['scrollTo' => false]) }}
            </div>
        </div>
</div>
    </div>




     <!-- Modal for Account Transfer -->
     @if($showCreateModal)
     <div class="modal fade show d-block" style="background-color: rgba(0, 0, 0, 0.5);" tabindex="-1">
         <div class="modal-dialog modal-lg">
             <div class="modal-content">
                 <div class="modal-header">
                     <h5 class="modal-title">@lang('word.NewClient')</h5>
                     <button type="button" class="btn-close" wire:click="closeCreateModal"></button>
                 </div>

                 <div class="modal-body">
                     <div class="row">
                         <div class="col-md-6 mb-3">
                             <div class="form-floating">
                                 <input type="text" class="form-control" id="client-name" wire:model="customer_name" placeholder="@lang('word.ClientName')" required>
                                 <label for="client-name">@lang('word.ClientName')</label>
                                 @error('customer_name') <span class="text-danger small">{{ $message }}</span> @enderror
                             </div>
                         </div>
                         
                         <div class="col-md-6 mb-3">
                             <div class="form-floating">
                                 <input type="text" class="form-control" id="phone-number" wire:model="phone_number" placeholder="@lang('word.Phone')" required>
                                 <label for="phone-number">@lang('word.Phone')</label>
                                 @error('phone_number') <span class="text-danger small">{{ $message }}</span> @enderror
                             </div>
                         </div>
                         
                         <div class="col-md-6 mb-3">
                             <div class="form-floating">
                                 <input type="text" class="form-control" id="id-number" wire:model="second_phone" placeholder="@lang('word.ID')">
                                 <label for="id-number">@lang('word.ID')</label>
                                 @error('second_phone') <span class="text-danger small">{{ $message }}</span> @enderror
                             </div>
                         </div>
                         
                         <div class="col-md-6 mb-3">
                             <div class="form-floating">
                                 <input type="text" class="form-control" id="address" wire:model="address" placeholder="@lang('word.Address')" required>
                                 <label for="address">@lang('word.Address')</label>
                                 @error('address') <span class="text-danger small">{{ $message }}</span> @enderror
                             </div>
                         </div>
                         
                         <div class="col-md-12 mb-3">
                             <div class="form-floating">
                                 <textarea class="form-control" id="note" wire:model="note" style="height: 100px" placeholder="@lang('word.Note')"></textarea>
                                 <label for="note">@lang('word.Note')</label>
                                 @error('note') <span class="text-danger small">{{ $message }}</span> @enderror
                             </div>
                         </div>

                         <div class="col-12 mt-3">
                             <h5 class="mb-3">@lang('word.Currency')</h5>
                             <div class="row">
                                 @foreach($currencies as $index => $currency)
                                     <div class="col-md-4 mb-3">
                                         <div class="currency-card {{ in_array($currency->id, $currency_ids) ? 'selected' : '' }}" style="border: 1px solid #dee2e6; border-radius: 10px; padding: 15px; background-color: #f8f9fa; {{ in_array($currency->id, $currency_ids) ? 'border-color: #0d6efd; background-color: rgba(13, 110, 253, 0.05);' : '' }}">
                                             <div class="form-check">
                                                 <input type="checkbox" class="form-check-input" 
                                                     id="currency_{{ $currency->id }}"
                                                     wire:model.live="currency_ids" 
                                                     value="{{ $currency->id }}">
                                                 <label class="form-check-label fw-bold" for="currency_{{ $currency->id }}">
                                                     {{ $currency->currency_name }}
                                                 </label>
                                             </div>
                                             
                                             @if(in_array($currency->id, $currency_ids))
                                                 <div class="mt-3">
                                                     <!-- Transaction Type -->
                                                     <div class="mb-3">
                                                         <label class="form-label">@lang('word.TransactionType')</label>
                                                         <div class="d-flex">
                                                             <div class="form-check me-3">
                                                                 <input class="form-check-input" type="radio" 
                                                                     wire:model="transaction_types.{{ $currency->id }}" 
                                                                     id="deposit_{{ $currency->id }}" 
                                                                     value="deposit" 
                                                                     checked>
                                                                 <label class="form-check-label" for="deposit_{{ $currency->id }}">
                                                                     @lang('word.Deposit')
                                                                 </label>
                                                             </div>
                                                             <div class="form-check">
                                                                 <input class="form-check-input" type="radio" 
                                                                     wire:model="transaction_types.{{ $currency->id }}" 
                                                                     id="withdrawal_{{ $currency->id }}" 
                                                                     value="withdrawal">
                                                                 <label class="form-check-label" for="withdrawal_{{ $currency->id }}">
                                                                     @lang('word.Withdrawal')
                                                                 </label>
                                                             </div>
                                                         </div>
                                                         @error('transaction_types.' . $currency->id) 
                                                             <span class="text-danger small">{{ $message }}</span> 
                                                         @enderror
                                                     </div>
                                                     
                                                     <!-- Transaction Amount -->
                                                     <div class="form-floating">
                                                         <input type="text" 
                                                             class="form-control" 
                                                             id="amount_{{ $currency->id }}"
                                                             wire:model="transaction_amounts.{{ $currency->id }}"
                                                             placeholder="بڕی پارە">
                                                         <label for="amount_{{ $currency->id }}">@lang('word.Balance')</label>
                                                         @error('transaction_amounts.' . $currency->id) 
                                                             <span class="text-danger small">{{ $message }}</span> 
                                                         @enderror
                                                     </div>
                                                 </div>
                                             @endif
                                         </div>
                                     </div>
                                 @endforeach
                             </div>
                             @error('currency_ids') <span class="text-danger small">{{ $message }}</span> @enderror
                         </div>                    
                     </div>
                 </div>
                 <div class="modal-footer">
                     <button type="button" class="btn btn-secondary" wire:click="closeCreateModal"> @lang('word.Close')</button>
                     <button wire:click="saveCustomer" type="submit" class="btn btn-primary"> @lang('word.Save')</button>
                 </div>
             </div>
         </div>
     </div>
 @endif


 <!-- Modal for Edit Customer -->
 @if($showEditModal)
 <div class="modal fade show d-block" style="background-color: rgba(0, 0, 0, 0.5);" tabindex="-1">
     <div class="modal-dialog modal-lg">
         <div class="modal-content">
             <div class="modal-header">
                 <h5 class="modal-title">@lang('word.EditCustomer')</h5>
                 <button type="button" class="btn-close" wire:click="closeEditModal"></button>
             </div>
             <div class="modal-body">
                <div class="row">
                        <div class="form-group">
                            <label>@lang('word.AccountName')</label>
                            <input type="text" class="form-control" wire:model="edit_customer_name" required>
                            @error('edit_customer_name') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                        <div class="form-group mt-2">
                            <label>@lang('word.Phone')</label>
                            <input type="text" class="form-control" wire:model="edit_phone_number" required>
                            @error('edit_phone_number') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                        <div class="form-group mt-2">
                            <label>@lang('word.ID')</label>
                            <input type="text" class="form-control" wire:model="edit_second_phone">
                            @error('edit_second_phone') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                        <div class="form-group mt-2">
                            <label>@lang('word.Address')</label>
                            <input type="text" class="form-control" wire:model="edit_address" required>
                            @error('edit_address') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                        <div class="form-group mt-2">
                            <label>@lang('word.Note') </label>
                            <textarea class="form-control" wire:model="edit_note"></textarea>
                            @error('edit_note') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                      
                </div>
             </div>
             <div class="modal-footer">
                 <button type="button" class="btn btn-secondary" wire:click="closeEditModal"> @lang('word.Close')</button>
                 <button wire:click="updateCustomer" type="submit" class="btn btn-primary"> @lang('word.Save')</button>
             </div>
         </div>
     </div>
 </div>
@endif



 <!-- Modal for Create Account Customer -->
 @if($showCreateAccountModal)
 <div class="modal fade show d-block" style="background-color: rgba(0, 0, 0, 0.5);" tabindex="-1">
     <div class="modal-dialog modal-lg">
         <div class="modal-content">
             <div class="modal-header">
                 <h5 class="modal-title">@lang('word.NewAccount')</h5>
                 <button type="button" class="btn-close" wire:click="closeCreateAccountModal"></button>
             </div>
             <div class="modal-body">
                <div class="row">
                    <div class="form-group">
                        <label>@lang('word.Currency')</label>
                        <select class="form-control" wire:model="currency_id" required>
                            <option value="">@lang('word.Currency')</option>
                            @foreach($currencies as $currency)
                            <option value="{{ $currency->id }}">{{ $currency->currency_name }}</option>
                            @endforeach
                        </select>
                        @error('currency_id') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                    <div class="form-group mt-2">
                        <label>@lang('word.Balance')</label>
                        <input type="number" class="form-control" wire:model="account_balance" required>
                        @error('account_balance') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                   
                </div>
             </div>
             <div class="modal-footer">
                 <button type="button" class="btn btn-secondary" wire:click="closeCreateAccountModal"> @lang('word.Close')</button>
                 <button wire:click="createAccountForSelectedCustomer" type="submit" class="btn btn-primary"> @lang('word.Save')</button>
             </div>
         </div>
     </div>
 </div>
@endif

</div>

