<div>
    <div class="mb-4">
        @can('create', App\Models\Account::class)
        <button class="btn btn-primary" wire:click="newAccount">
            <i class="icon ion-md-add"></i>
            @lang('crud.common.new')
        </button>
        @endcan @can('delete-any', App\Models\Account::class)
        <button
            class="btn btn-danger"
             {{ empty($selected) ? 'disabled' : '' }} 
            onclick="confirm('Are you sure?') || event.stopImmediatePropagation()"
            wire:click="destroySelected"
        >
            <i class="icon ion-md-trash"></i>
            @lang('crud.common.delete_selected')
        </button>
        @endcan
    </div>

    <x-modal id="customer-accounts-modal" wire:model="showingModal">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ $modalTitle }}</h5>
                <button
                    type="button"
                    class="close"
                    data-dismiss="modal"
                    aria-label="Close"
                >
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <div class="modal-body">
                <div>
                    <x-inputs.group class="col-sm-12">
                        <x-inputs.text
                            name="account.account_number"
                            label="Account Number"
                            wire:model="account.account_number"
                            maxlength="255"
                            placeholder="Account Number"
                        ></x-inputs.text>
                    </x-inputs.group>

                    <x-inputs.group class="col-sm-12">
                        <x-inputs.number
                            name="account.balance"
                            label="Balance"
                            wire:model="account.balance"
                            max="255"
                            step="0.01"
                            placeholder="Balance"
                        ></x-inputs.number>
                    </x-inputs.group>

                    <x-inputs.group class="col-sm-12">
                        <x-inputs.select
                            name="account.account_type"
                            label="Account Type"
                            wire:model="account.account_type"
                        >
                            <option value="savings" {{ $selected == 'savings' ? 'selected' : '' }} >Savings</option>
                            <option value="checking" {{ $selected == 'checking' ? 'selected' : '' }} >Checking</option>
                        </x-inputs.select>
                    </x-inputs.group>
                </div>
            </div>

            @if($editing) @endif

            <div class="modal-footer">
                <button
                    type="button"
                    class="btn btn-light float-left"
                    wire:click="$toggle('showingModal')"
                >
                    <i class="icon ion-md-close"></i>
                    @lang('crud.common.cancel')
                </button>

                <button type="button" class="btn btn-primary" wire:click="save">
                    <i class="icon ion-md-save"></i>
                    @lang('crud.common.save')
                </button>
            </div>
        </div>
    </x-modal>

    <div class="table-responsive">
        <table class="table table-borderless table-hover">
            <thead>
                <tr>
                    <th>
                        <input
                            type="checkbox"
                            wire:model="allSelected"
                            wire:click="toggleFullSelection"
                            title="{{ trans('crud.common.select_all') }}"
                        />
                    </th>
                    <th class="text-left">
                        @lang('crud.customer_accounts.inputs.account_number')
                    </th>
                    <th class="text-right">
                        @lang('crud.customer_accounts.inputs.balance')
                    </th>
                    <th class="text-left">
                        @lang('crud.customer_accounts.inputs.account_type')
                    </th>
                    <th></th>
                </tr>
            </thead>
            <tbody class="text-gray-600">
                @foreach ($accounts as $account)
                <tr class="hover:bg-gray-100">
                    <td class="text-left">
                        <input
                            type="checkbox"
                            value="{{ $account->id }}"
                            wire:model="selected"
                        />
                    </td>
                    <td class="text-left">
                        {{ $account->account_number ?? '-' }}
                    </td>
                    <td class="text-right">{{ $account->calculateTotalBalance() ?? '-' }}</td>
                    <td class="text-left">
                        {{ $account->account_type ?? '-' }}
                    </td>
                    <td class="text-right" style="width: 134px;">
                        <div
                            role="group"
                            aria-label="Row Actions"
                            class="relative inline-flex align-middle"
                        >
                            @can('update', $account)
                            <button
                                type="button"
                                class="btn btn-light"
                                wire:click="editAccount({{ $account->id }})"
                            >
                                <i class="icon ion-md-create"></i>
                            </button>
                            @endcan
                        </div>
                    </td>
                </tr>
                @endforeach
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="4">{{ $accounts->render() }}</td>
                </tr>
            </tfoot>
        </table>
    </div>
</div>
