<div>
    <!-- Add some custom styles -->
    <style>
        .currency-selection {
            display: flex;
            gap: 15px;
        }
        .currency-option {
            display: inline-block;
            text-align: center;
        }
        .currency-radio {
            display: none;
        }
        .currency-label {
            cursor: pointer;
        }
        .currency-img {
            width: 50px;
            height: 50px;
            object-fit: contain;
            border: 2px solid transparent;
            border-radius: 50%;
            padding: 5px;
            transition: border-color 0.3s;
        }
        .currency-radio:checked + .currency-label .currency-img {
            border-color: #007bff; /* Change color to highlight when selected */
        }
        .currency-img:hover {
            border-color: #007bff;
        }

        /* Custom styles for transaction type buttons */
        .transaction-type {
            margin-bottom: 20px;
            display: flex;
            justify-content: center;
            gap: 10px;
        }
        .transaction-button {
            padding: 10px 20px;
            border: 1px solid #007bff;
            background-color: transparent;
            color: #007bff;
            cursor: pointer;
            border-radius: 5px;
            transition: all 0.3s ease;
        }
        .transaction-button.active {
            background-color: #007bff;
            color: white;
        }
    </style>

    @if (session()->has('message'))
    <div class="alert alert-success" wire:poll.5s>
        {{ session('message') }}
    </div>
    @endif

    @if (session()->has('error'))
    <div class="alert alert-danger" wire:poll.5s>
        {{ session('error') }}
    </div>
    @endif
    <div class="row">
        <div class="col-8">
    <!-- Transaction Type Selection -->
    <div class="transaction-type">
        <button type="button" class="transaction-button {{ $transaction_type === 'sell' ? 'active' : '' }}" wire:click="$set('transaction_type', 'sell')">
            Sell
        </button>
        <button type="button" class="transaction-button {{ $transaction_type === 'buy' ? 'active' : '' }}" wire:click="$set('transaction_type', 'buy')">
            Buy
        </button>
       

    </div>

    <div align="center" class="row mb-4">
        @error('transaction_type') <span class="text-danger">{{ $message }}</span> @enderror
    </div>
        </div>
    </div>
    <div class="row">
        <!-- Card 1: Amount Received and From Currency -->
        <div class="col-8">
            <div class="card">
                <div class="card-body">
                    <!-- Amount Received -->
                    <div class="form-group">
                        <label for="transaction_amount">Amount Received</label>
                        <input type="number" id="transaction_amount" class="form-control" step="0.01" wire:model="transaction_amount">
                        @error('transaction_amount') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                    <!-- From Currency (Image Selection) -->
                    <label for="from_currency">From Currency</label>
                    <div class="currency-selection">
                        @foreach($currencies as $currency)
                            <div class="currency-option">
                                <!-- Hidden Radio Button -->
                                <input type="radio" id="from_currency{{ $currency->id }}" name="from_currency" wire:model="filters.from_currency" value="{{ $currency->id }}" class="currency-radio">
                                <!-- Image acting as a radio button -->
                                <label for="from_currency{{ $currency->id }}" class="currency-label">
                                    <img src="{{ $currency->code ? \Storage::url($currency->code) : '' }}" alt="{{ $currency->currency_name }}" class="currency-img">
                                </label>
                            </div>
                        @endforeach
                    </div>
                    @error('filters.from_currency') <span class="text-danger">{{ $message }}</span> @enderror
                </div>
            </div>
        </div>

        <!-- Card 2: Amount Given and To Currency -->
        {{-- <div class="col-6">
            <div class="card">
                <div class="card-body">
                    <!-- Amount Given -->
                    <div class="form-group">
                        <label for="amount_given">Amount Given</label>
                        <input type="number" id="amount_given" class="form-control" step="0.01" wire:model="amount_given">
                        @error('amount_given') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>

                    <!-- To Currency (Image Selection) -->
                    <label for="to_currency">To Currency</label>
                    <div class="currency-selection">
                        @foreach($currencies as $currency)
                            <div class="currency-option">
                                <!-- Hidden Radio Button -->
                                <input type="radio" id="to_currency{{ $currency->id }}" name="to_currency" wire:model="filters.to_currency" value="{{ $currency->id }}" class="currency-radio">
                                <!-- Image acting as a radio button -->
                                <label for="to_currency{{ $currency->id }}" class="currency-label">
                                    <img src="{{ $currency->code ? \Storage::url($currency->code) : '' }}" alt="{{ $currency->currency_name }}" class="currency-img">
                                </label>
                            </div>
                        @endforeach
                    </div>
                    @error('filters.to_currency') <span class="text-danger">{{ $message }}</span> @enderror

                </div>
            </div>
        </div> --}}
    </div>

    <!-- Submit Button -->
    <div class="row mt-4">
        <div style="margin-top: 200px;" class="col-12 text-center">
            <button type="submit" wire:click="submit" class="btn btn-primary">Submit</button>
        </div>
    </div>
</div>
