<div class="currency-display-container">
    <!-- Skeleton Loading Animation -->
    <div class="skeleton-container">
        <div class="skeleton-header">
            <div class="skeleton-title"></div>
            <div class="skeleton-subtitle"></div>
        </div>
        
        <div class="skeleton-table">
            <div class="skeleton-header">
                <div class="skeleton-th"></div>
                <div class="skeleton-th"></div>
                <div class="skeleton-th"></div>
                <div class="skeleton-th"></div>
            </div>
            @for($i = 0; $i < 6; $i++)
            <div class="skeleton-row">
                <div class="skeleton-td currency-td">
                    <div class="skeleton-flag"></div>
                    <div class="skeleton-currency-info">
                        <div class="skeleton-currency-name"></div>
                        <div class="skeleton-currency-details"></div>
                    </div>
                </div>
                <div class="skeleton-td">
                    <div class="skeleton-rate"></div>
                    <div class="skeleton-label"></div>
                </div>
                <div class="skeleton-td">
                    <div class="skeleton-rate"></div>
                    <div class="skeleton-label"></div>
                </div>
                <div class="skeleton-td">
                    <div class="skeleton-spread"></div>
                    <div class="skeleton-percentage"></div>
                </div>
            </div>
            @endfor
        </div>
    </div>
    
    <style>
        .skeleton-container {
            padding: 0;
            width: 100vw;
            height: 100vh;
            margin: 0;
        }
        
        .skeleton-header {
            text-align: center;
            margin-bottom: 3rem;
        }
        
        .skeleton-title {
            height: 40px;
            background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
            background-size: 200% 100%;
            animation: skeleton-loading 1.5s infinite;
            border-radius: 8px;
            margin: 0 auto 1rem;
            width: 300px;
        }
        
        .skeleton-subtitle {
            height: 20px;
            background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
            background-size: 200% 100%;
            animation: skeleton-loading 1.5s infinite;
            border-radius: 6px;
            margin: 0 auto;
            width: 200px;
        }
        
        .skeleton-table {
            background: white;
            border-radius: 16px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
            margin-top: 2rem;
            overflow: hidden;
            width: 100%;
            height: calc(100vh - 200px);
        }
        
        .skeleton-header {
            display: grid;
            grid-template-columns: 2fr 1fr 1fr 1fr;
            gap: 1rem;
            padding: 1.5rem;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            direction: rtl;
        }
        
        .skeleton-th {
            height: 24px;
            background: rgba(255, 255, 255, 0.3);
            border-radius: 6px;
            animation: skeleton-loading 1.5s infinite;
        }
        
        .skeleton-row {
            display: grid;
            grid-template-columns: 2fr 1fr 1fr 1fr;
            gap: 1rem;
            padding: 1.5rem;
            border-bottom: 1px solid #f0f0f0;
            align-items: center;
        }
        
        .skeleton-row:nth-child(even) {
            background: rgba(0, 0, 0, 0.02);
        }
        
        .skeleton-td {
            display: flex;
            flex-direction: column;
            gap: 0.5rem;
        }
        
        .skeleton-td.currency-td {
            flex-direction: row-reverse;
            align-items: center;
            gap: 1rem;
        }
        
        .skeleton-flag {
            width: 50px;
            height: 35px;
            background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
            background-size: 200% 100%;
            animation: skeleton-loading 1.5s infinite;
            border-radius: 8px;
            flex-shrink: 0;
        }
        
        .skeleton-currency-info {
            flex: 1;
            display: flex;
            flex-direction: column;
            gap: 0.5rem;
        }
        
        .skeleton-currency-name {
            height: 20px;
            background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
            background-size: 200% 100%;
            animation: skeleton-loading 1.5s infinite;
            border-radius: 6px;
            width: 80%;
        }
        
        .skeleton-currency-details {
            height: 16px;
            background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
            background-size: 200% 100%;
            animation: skeleton-loading 1.5s infinite;
            border-radius: 4px;
            width: 60%;
        }
        
        .skeleton-rate {
            height: 24px;
            background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
            background-size: 200% 100%;
            animation: skeleton-loading 1.5s infinite;
            border-radius: 6px;
            width: 80%;
        }
        
        .skeleton-label {
            height: 16px;
            background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
            background-size: 200% 100%;
            animation: skeleton-loading 1.5s infinite;
            border-radius: 4px;
            width: 60%;
        }
        
        .skeleton-spread {
            height: 20px;
            background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
            background-size: 200% 100%;
            animation: skeleton-loading 1.5s infinite;
            border-radius: 6px;
            width: 90%;
        }
        
        .skeleton-percentage {
            height: 16px;
            background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
            background-size: 200% 100%;
            animation: skeleton-loading 1.5s infinite;
            border-radius: 4px;
            width: 70%;
        }
        
        @keyframes skeleton-loading {
            0% { background-position: -200% 0; }
            100% { background-position: 200% 0; }
        }
        
        @media (max-width: 768px) {
            .skeleton-table {
                border-radius: 12px;
            }
            
            .skeleton-header,
            .skeleton-row {
                padding: 1rem 0.75rem;
                gap: 0.75rem;
            }
            
            .skeleton-th {
                height: 20px;
            }
            
            .skeleton-flag {
                width: 40px;
                height: 28px;
            }
            
            .skeleton-currency-name {
                height: 18px;
                width: 70%;
            }
            
            .skeleton-currency-details {
                height: 14px;
                width: 50%;
            }
            
            .skeleton-rate {
                height: 20px;
                width: 70%;
            }
            
            .skeleton-label {
                height: 14px;
                width: 50%;
            }
            
            .skeleton-title {
                width: 250px;
                height: 32px;
            }
            
            .skeleton-subtitle {
                width: 150px;
                height: 16px;
            }
        }
    </style>
</div>
