<div x-data="{
    items: @entangle('currencies'),
    dragStartIndex: null,
    startDrag(event, index) {
        this.dragStartIndex = index;
    },
    drop(event, index) {
        const draggedItem = this.items.splice(this.dragStartIndex, 1)[0];
        this.items.splice(index, 0, draggedItem);

        // Emit the new order to Livewire for saving
        this.saveOrder();
    },
    saveOrder() {
        const orderedIds = this.items.map(item => item.id);
        @this.call('updateOrder', orderedIds);
    }
}">
    <div class="row">
        <button 
        class="btn btn-primary mt-3"
        @click="saveOrder"
    >
       هەڵگرتن
    </button>
        <template x-for="(item, index) in items" :key="item.id">
            <div class="col-12 col-md-3 mb-4 mt-4">
                <div 
                    class="card shadow-sm"
                    draggable="true"
                    @dragstart="startDrag($event, index)"
                    @dragover.prevent
                    @drop="drop($event, index)"
                    style="cursor: move;">
                    
                    <div class="card-body text-center">
                        <!-- Currency Image -->
                        <img 
                            :src="'{{ \Storage::url('') }}' + item.code"
                            :alt="item.currency_name"
                            class="img-fluid rounded-circle mb-2"
                            style="width: 60px; height: 60px;" 
                        />
                        
                        <!-- Currency Name -->
                        <h5 class="card-title" x-text="item.currency_name"></h5>
                    </div>
                </div>
            </div>
        </template>
    </div>

  
</div>
