<div>
  <div x-cloak x-data="{ open: false }" x-on:click.away="open = false" style="position: relative;">
      @if($label)
      <label class="label-control">{{ $label }}</label>
      @endif
      <div class="input-group">
          @if($selectedValue == null)
              <input type="text" class="{{ $class }}" wire:model.live='search'
                  x-on:click="open = true"
                  x-on:input="open = true"
                  placeholder="{{ $placeholder }}"
                  @if($options->isEmpty()) disabled @endif
                  @if($disabled) disabled @endif
              >
              <span class="input-group-text" style="cursor: pointer;" x-on:click="open = !open" @if($disabled) disabled @endif>
                <i class="ti ti-caret-down"></i>
              </span>
          </div>
          <div wire:loading.remove x-show="open" class="mt-2 border bg-white shadow-lg" style="position: absolute; top: 100%; left: 0; right: 0; max-height: {{ $height ?? '200px' }}; overflow-y: auto; z-index: 999; border-radius: 8px;">
              @foreach ($options as $id => $title)
                  @php $disabledOption = $disabledOptions->contains($id) @endphp
                  @if (stripos($title, $search) !== false)
                      <button class="@if($disabledOption) bg-secondary @else bg-white @endif border-bottom" style="border: 0; width: 100%; text-align: left;" wire:click="selectValue('{{ $id }}')" @if($disabledOption) disabled @endif>
                          <h6 class="@if($disabledOption) text-white @endif mx-2 mt-1">{{ $title }}</h6>
                      </button>
                  @endif
              @endforeach
          </div>
          @else
          <div class="input-group">
              <input type="text" class="{{ $class }}" x-on:click="open = false" value="{{ $options[$selectedValue] }}" disabled>
              @if(!$disabled)
              <button class="{{ $btnclass }}" wire:click="selectValue(null)">X</button>
              @endif
          </div>
          @endif
      </div>
  </div>
