<div>
    <div x-cloak x-data="{ open: true }" x-on:click.away="open = true" style="position: relative;">
        @if($label)
        <label class="label-control">{{$label}}</label>
        @endif
        @if($selectedValue == null)
            <input autofocus type="text" class="{{$class}}" wire:model.live='search'
                x-on:click="open = true"
                id="myText"
                x-on:input="open = true"
                placeholder="{{$placeholder}}"
                @if($options->isEmpty()) disabled @endif
                @if($disabled) disabled @endif
                >

            <div  wire:loading.remove x-show="open" class="mt-2 border bg-white shadow-lg" style="position: absolute; top: 100%; left: 0; right: 0; max-height: {{$height ?? '400px'}}; overflow-y: auto; z-index: 999; border-radius: 8px;">
                @foreach ($options as $option)
                    @php $disabledOption = $disabledOptions->contains($option->id) @endphp
                    @if (stripos($option->name, $search) !== false  )
                        <button class="@if($disabledOption) bg-secondary @else bg-white @endif border-bottom" style="border: 0; width: 100%; text-align: left;" wire:click="selectValue({{$option->id}})" @if($disabledOption) disabled @endif>
                            <h6 class="@if($disabledOption) text-white @endif mx-2 mt-1">{{ $option->name }}</h6>
                        </button>
                    @endif
                @endforeach
            </div>
        @else
            <div class="input-group">

                <input autofocus id="myText" type="text" class="{{$class}}" x-on:click="open = false" value="{{$options[$selectedValue]}}" >

            </div>
        @endif
    </div>

    <script>
      window.addEventListener('load', () => {
        document.getElementById('myText').focus();
      });
    </script>

</div>
