<div >
    <script src="//cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>

    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  
    <h2>@lang('word.CashierShift') </h2>

    <!-- Button to Open Modal -->
    <button class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#addShiftModal">
        @lang('word.CreateCashierShift') 
    </button>

    <div class="card">
        <div class="card-body">

   
    <!-- Table to List Shifts -->
    <div class="table-responsive">
    <table class="table table-border table-hover">
        <thead>
            <tr>
                <th>  @lang('crud.cashiers.inputs.cashier_name')</th>
                <th>  @lang('crud.cashiers.inputs.supervisor_name')</th>
                <th>  @lang('crud.cashiers.inputs.start_time')</th>
                {{-- <th>  @lang('crud.cashiers.inputs.end_time')</th> --}}
                {{-- <th>Starting Amount</th>
                <th>Ending Amount</th> --}}
            </tr>
        </thead>
        <tbody>
            @foreach($shifts as $shift)
                <tr>
                    <!-- Access the user through cashier relationship -->
                    <td>{{ optional($shift->cashier->user)->name ?? 'N/A' }}</td>
                    <!-- Access the user directly through supervisor relationship -->
                    <td>{{ optional($shift->supervisor)->name ?? 'N/A' }}</td>
                    <td>{{ $shift->start_time }}</td>
                    {{-- <td>{{ $shift->end_time }}</td> --}}
                    {{-- <td>{{ number_format($shift->starting_amount, 0, '.', ',')) }}</td>
                    <td>{{ number_format($shift->ending_amount, 0, '.', ',')) }}</td> --}}
                </tr>
            @endforeach
        </tbody>
    </table>
    </div>
    </div>
</div>
    <!-- Bootstrap Modal -->
    <div  wire:ignore.self  class="modal fade" id="addShiftModal" tabindex="-1" aria-labelledby="addShiftModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addShiftModalLabel">@lang('word.CreateCashierShift') </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form wire:submit.prevent="store">
                        <div class="row">
                            <!-- Cashier Dropdown -->
                            <div class="col-6 mb-3">
                                <label for="cashier_id" class="form-label">@lang('crud.cashiers.inputs.cashier_name')</label>
                                <select wire:model="cashier_id" class="form-control" id="cashier_id">
                                    <option value="">@lang('crud.cashiers.inputs.cashier_name')</option>
                                    @foreach($cashiers as $cashier)
                                        <option value="{{ $cashier->id }}">{{ $cashier->user->name }}</option>
                                    @endforeach
                                </select>
                                @error('cashier_id') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>

                            <!-- Supervisor Dropdown -->
                            <div class="col-6 mb-3">
                                <label for="supervisor_id" class="form-label">@lang('crud.cashiers.inputs.supervisor_name')</label>
                                <select wire:model="supervisor_id" class="form-control" id="supervisor_id">
                                    <option value="">@lang('crud.cashiers.inputs.supervisor_name')</option>
                                    @foreach($supervisors as $supervisor)
                                        <option value="{{ $supervisor->user->id }}">{{ $supervisor->user->name }}</option>
                                    @endforeach
                                </select>
                                @error('supervisor_id') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
{{-- 
                            <div class="col-6 mb-3">
                                <label for="start_time" class="form-label">@lang('crud.cashiers.inputs.start_time')</label>
                                <input type="datetime-local" wire:model="start_time" class="form-control" id="start_time">
                                @error('start_time') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>

                            <div class="col-6 mb-3">
                                <label for="end_time" class="form-label">@lang('crud.cashiers.inputs.end_time')</label>
                                <input type="datetime-local" wire:model="end_time" class="form-control" id="end_time">
                                @error('end_time') <span class="text-danger">{{ $message }}</span> @enderror
                            </div> --}}

                            {{-- <div class="col-6 mb-3">
                                <label for="starting_amount" class="form-label">Starting Amount</label>
                                <input type="number" wire:model="starting_amount" class="form-control" id="starting_amount">
                                @error('starting_amount') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>

                            <div class="col-6 mb-3">
                                <label for="ending_amount" class="form-label">Ending Amount</label>
                                <input type="number" wire:model="ending_amount" class="form-control" id="ending_amount">
                                @error('ending_amount') <span class="text-danger">{{ $message }}</span> @enderror
                            </div> --}}
                        </div>

                        <button type="submit" class="btn btn-primary">Save Shift</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Script to Close Modal on Success -->
<script>
    window.addEventListener('close-modal', event => {
        var myModal = new bootstrap.Modal(document.getElementById('addShiftModal'));
        myModal.hide();
    });
</script>
