<div>
   
    <style>
        /* Custom styles for modern design */
        :root {
            --primary-color: #4361ee;
            --success-color: #10b981;
            --danger-color: #ef4444;
            --warning-color: #f59e0b;
            --light-color: #f3f4f6;
            --dark-color: #1f2937;
        }
        
        body {
            background-color: #f9fafb;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .card {
            border-radius: 1rem;
            box-shadow: 0 10px 15px -3px rgba(0,0,0,0.1), 0 4px 6px -2px rgba(0,0,0,0.05);
            overflow: hidden;
            margin-bottom: 1.5rem;
            border: none;
            transition: transform 0.3s ease;
        }
        
        .card:hover {
            transform: translateY(-5px);
        }
        
        .card-header {
            border-bottom: none;
            padding: 1.25rem;
        }
        
        .bg-primary {
            background-color: var(--primary-color) !important;
        }
        
        .bg-success {
            background-color: var(--success-color) !important;
        }
        
        .bg-danger {
            background-color: var(--danger-color) !important;
        }
        
        .bg-warning {
            background-color: var(--warning-color) !important;
        }
        
        .text-primary {
            color: var(--primary-color) !important;
        }
        
        .text-success {
            color: var(--success-color) !important;
        }
        
        .text-danger {
            color: var(--danger-color) !important;
        }
        
        .badge {
            padding: 0.5rem 0.75rem;
            font-weight: 500;
            border-radius: 0.5rem;
        }
        
        .form-select {
            border-radius: 0.75rem;
            padding: 0.75rem 1rem;
            border: 1px solid #e5e7eb;
            box-shadow: none;
            font-size: 0.95rem;
        }
        
        .form-select:focus {
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.25);
            border-color: var(--primary-color);
        }
        
        .table {
            margin-bottom: 0;
        }
        
        .table th {
            font-weight: 600;
            color: #4b5563;
            border-bottom-width: 1px;
        }
        
        .table td {
            padding: 1rem 0.75rem;
            vertical-align: middle;
        }
        
        .table-hover tbody tr:hover {
            background-color: rgba(249, 250, 251, 0.8);
        }
        
        /* Card title styles */
        .currency-title {
            font-size: 1.25rem;
            font-weight: 600;
        }
        
        /* Total balance badge styles */
        .total-balance {
            font-size: 1rem;
            font-weight: 600;
            padding: 0.5rem 1rem;
            border-radius: 0.75rem;
        }
        
        /* Customer name styles */
        .customer-name {
            font-weight: 600;
            color: var(--dark-color);
            text-decoration: none;
            display: block;
            transition: color 0.2s ease;
        }
        
        .customer-name:hover {
            color: var(--primary-color);
        }
        
        .phone-number {
            font-size: 0.8rem;
            color: #6b7280;
        }
        
        /* Card value badges */
        .value-badge {
            font-size: 0.9rem;
            font-weight: 600;
            padding: 0.35rem 0.75rem;
            border-radius: 0.5rem;
            display: inline-block;
        }
        
        /* Responsive table cards for mobile */
        @media (max-width: 767.98px) {
            .table-responsive-card .table {
                display: block;
            }
            
            .table-responsive-card thead {
                position: absolute;
                width: 1px;
                height: 1px;
                padding: 0;
                margin: -1px;
                overflow: hidden;
                clip: rect(0, 0, 0, 0);
                white-space: nowrap;
                border-width: 0;
            }
            
            .table-responsive-card tbody tr {
                display: block;
                border: 1px solid #e5e7eb;
                border-radius: 0.75rem;
                margin-bottom: 1rem;
                padding: 0.75rem;
                box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            }
            
            .table-responsive-card td {
                display: flex;
                justify-content: space-between;
                align-items: center;
                border: none;
                padding: 0.5rem 0;
            }
            
            .table-responsive-card td:before {
                content: attr(data-label);
                font-weight: 600;
                color: #4b5563;
                flex: 1;
            }
            
            /* Change layout for mobile screens */
            .mobile-container {
                padding: 0.5rem;
            }
            
            .summary-container {
                display: flex;
                flex-direction: column;
                gap: 0.5rem;
                padding: 0.5rem;
            }
            
            /* Adjust card headers for mobile */
            .card-header {
                padding: 0.75rem;
            }
            
            .card-header .d-flex {
                flex-direction: column;
                align-items: flex-start !important;
            }
            
            .card-header .text-end {
                margin-top: 0.5rem;
                align-self: flex-start;
            }
            
            /* Adjust badges for mobile */
            .small-badge {
                font-size: 0.75rem;
                padding: 0.25rem 0.5rem;
            }
        }
        
        /* Show both tables side by side on mobile (non-scrollable) */
        @media (max-width: 767.98px) {
            .currency-tables {
                display: flex;
                flex-direction: column;
                gap: 1rem;
                overflow-x: hidden;
            }
            
            .currency-card {
                min-width: 100%;
            }
        }
    </style>
@php
    // Initialize totals for both currencies
    $totalDepositIQD = 0;
    $totalWithdrawalIQD = 0;
    $totalBalanceIQD = 0;
    
    $totalDepositUSD = 0;
    $totalWithdrawalUSD = 0;
    $totalBalanceUSD = 0;
    
    // Initialize status-specific totals
    $totalApprovedBalanceIQD = 0;
    $totalPendingBalanceIQD = 0;
    $totalApprovedBalanceUSD = 0;
    $totalPendingBalanceUSD = 0;
    
    // Use pre-calculated balances instead of recalculating
    foreach ($customersIQD as $customer) {
        if (isset($customerBalances[$customer->id]['IQD'])) {
            $balance = $customerBalances[$customer->id]['IQD'];
            $totalApprovedBalanceIQD += $balance['approved'];
            $totalPendingBalanceIQD += $balance['pending'];
        }
    }
    
    foreach ($customersUSD as $customer) {
        if (isset($customerBalances[$customer->id]['USD'])) {
            $balance = $customerBalances[$customer->id]['USD'];
            $totalApprovedBalanceUSD += $balance['approved'];
            $totalPendingBalanceUSD += $balance['pending'];
        }
    }
    
    // Calculate final balances
    $totalBalanceIQD = $totalApprovedBalanceIQD + $totalPendingBalanceIQD;
    $totalBalanceUSD = $totalApprovedBalanceUSD + $totalPendingBalanceUSD;
    
    $totalLamanaUSD = 0;
    $totalLatanaUSD = 0;
    $totalLamanaIQD = 0;
    $totalLatanaIQD = 0;
    
    // Status-specific total displays for the headers
    $totalDisplayIQD = number_format(abs($totalBalanceIQD), 0, '.', ',') . ' IQD';
    $totalStatusDisplayIQD = '(پەسەندکراو: ' . number_format(abs($totalApprovedBalanceIQD), 0, '.', ',') . 
                           ' | چاوەڕوان: ' . number_format(abs($totalPendingBalanceIQD), 0, '.', ',') . ')';
                           
    $totalDisplayUSD = number_format(abs($totalBalanceUSD), 0, '.', ',') . ' USD';
    $totalStatusDisplayUSD = '(پەسەندکراو: ' . number_format(abs($totalApprovedBalanceUSD), 0, '.', ',') . 
                           ' | چاوەڕوان: ' . number_format(abs($totalPendingBalanceUSD), 0, '.', ',') . ')';
@endphp

        <div class="row mb-3">
            <!-- Filters Row -->
            <div class="col-md-6 col-12 mb-2">
                <select wire:model.live="filterIQD" class="form-select">
                    <option value="all">هەموو</option>
                    <option value="positive">موشتەری باڵانسی پۆزەتیڤ</option>
                    <option value="negative">موشتەری باڵانسی نێگەتیڤ</option>
                </select>
            </div>
            <div class="col-md-6 col-12 mb-2">
                <select wire:model.live="filterUSD" class="form-select">
                    <option value="all">هەموو</option>
                    <option value="positive">موشتەری باڵانسی پۆزەتیڤ</option>
                    <option value="negative">موشتەری باڵانسی نێگەتیڤ</option>
                </select>
            </div>
        </div>

        <div class="currency-tables row">
            <!-- IQD Transactions Section -->
            <div class="currency-card col-6">
                <div class="card shadow-sm">
                    <div class="card-header bg-primary text-white">
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="currency-title">
                                <i class="fas fa-coins me-2"></i>دیناری عیراقی
                            </div>
                            <div class="text-end">
                                <span class="badge bg-light text-primary total-balance" style="color: {{ ($totalBalanceIQD < 0) ? 'var(--danger-color)' : 'var(--success-color)' }} !important;">
                                    کۆی گشتی: {{ ($totalBalanceIQD < 0) ? '-' : '+' }} {{ $totalDisplayIQD }}
                                </span>
                                <div class="small text-white mt-1">
                                    {{ $totalStatusDisplayIQD }}
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-body p-0">
                        <div class="table-responsive-card">
                            <div class="p-2">
                                <input type="text" class="form-control form-control-sm" id="searchIQD" placeholder="گەڕان بە ناو یان ID موشتەری...">
                            </div>
                            <table id="iqdTable" class="table table-hover align-middle mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>موشتەری</th>
                                        <th>لامانە (IQD)</th>
                                        <th>لاتانە (IQD)</th>
                                        <th>دۆخ</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php 
                                        $hasIqdRows = false; 
                                        // Use pre-calculated balances
                                        $customerBalancesIQD = [];
                                        foreach ($customersIQD as $customer) {
                                            if (isset($customerBalances[$customer->id]['IQD'])) {
                                                $balanceData = $customerBalances[$customer->id]['IQD'];
                                                $totalBalance = $balanceData['total'];

                                                $customerBalancesIQD[$customer->id] = [
                                                    'customer' => $customer,
                                                    'approvedBalance' => $balanceData['approved'],
                                                    'pendingBalance' => $balanceData['pending'],
                                                    'totalBalance' => $totalBalance
                                                ];
                                            }
                                        }
                                        uasort($customerBalancesIQD, function($a, $b) {
                                            return strcasecmp($a['customer']->customer_name ?? '', $b['customer']->customer_name ?? '');
                                        });
                                    @endphp

                                    @foreach ($customerBalancesIQD as $customerData)
                                        @php
                                            $customer = $customerData['customer'];
                                            $approvedBalanceIQD = $customerData['approvedBalance'];
                                            $pendingBalanceIQD = $customerData['pendingBalance'];
                                            $balanceIQD = $customerData['totalBalance'];
                                            
                                            $hasIqdRows = true;
                                            
                                            // Update the totals based on balance sign
                                            if ($balanceIQD > 0) {
                                                $totalLamanaIQD += $balanceIQD;
                                            } elseif ($balanceIQD < 0) {
                                                $totalLatanaIQD += abs($balanceIQD);
                                            }
                                        @endphp

                                        <tr>
                                            <td data-label="موشتەری">
                                                <a class="customer-name" target="_blank" href="{{ route('show_customer', $customer->id) }}">
                                                    {{ $customer->customer_name }} <b>({{ $customer->id }})</b>
                                                </a>
                                                <span class="phone-number">{{ $customer->phone_number }}</span>
                                            </td>
                                            <td data-label="لامانە (IQD)">
                                                @if($balanceIQD > 0)
                                                <span class="value-badge bg-success text-white">
                                                    {{ number_format($balanceIQD, 0, '.', ',') }}
                                                </span>
                                                @else
                                                <span class="value-badge bg-light text-white">
                                                    0
                                                </span>
                                                @endif
                                            </td>
                                            <td data-label="لاتانە (IQD)">
                                                @if($balanceIQD < 0)
                                                <span class="value-badge bg-danger text-white">
                                                    {{ number_format(abs($balanceIQD), 0, '.', ',') }}
                                                </span>
                                                @else
                                                <span class="value-badge bg-light text-white">
                                                    0
                                                </span>
                                                @endif
                                            </td>
                                            <td data-label="دۆخ">
                                                @if ($pendingBalanceIQD != 0)
                                                    <span class="small-badge badge bg-warning">
                                                        چاوەڕوان: {{ number_format(abs($pendingBalanceIQD), 0, '.', ',') }}
                                                    </span>
                                                @endif
                                                @if ($approvedBalanceIQD != 0)
                                                    <span class="small-badge badge bg-success ms-1">
                                                        پەسەندکراو: {{ number_format(abs($approvedBalanceIQD), 0, '.', ',') }}
                                                    </span>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach

                                    @if (!$hasIqdRows)
                                        <tr>
                                            <td colspan="4" class="text-center py-4">هیچ ئەکاونتێکی IQD بە باڵانسی ناسفر نییە</td>
                                        </tr>
                                    @endif
                                </tbody>
                                @if ($hasIqdRows)
                                    <tfoot>
                                        <tr class="bg-light">
                                            <td class="text-end"><strong>کۆی گشتی</strong></td>
                                            <td>
                                                <span class="value-badge bg-success text-white">
                                                    {{ number_format($totalLamanaIQD, 0, '.', ',') }} IQD
                                                </span>
                                            </td>
                                            <td>
                                                <span class="value-badge bg-danger text-white">
                                                    {{ number_format($totalLatanaIQD, 0, '.', ',') }} IQD
                                                </span>
                                            </td>
                                            <td>
                                                <span class="small-badge badge bg-success ">
                                                    پەسەندکراو: {{ number_format(abs($totalApprovedBalanceIQD), 0, '.', ',') }}
                                                </span>
                                                <span class="small-badge badge bg-warning ms-1">
                                                    چاوەڕوان: {{ number_format(abs($totalPendingBalanceIQD), 0, '.', ',') }}
                                                </span>
                                            </td>
                                        </tr>
                                    </tfoot>
                                @endif
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- USD Transactions Section -->
            <div class="currency-card col-6">
                <div class="card shadow-sm">
                    <div class="card-header bg-success text-white">
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="currency-title">
                                <i class="fas fa-dollar-sign me-2"></i>دۆلاری ئەمریکی
                            </div>
                            <div class="text-end">
                                <span class="badge bg-light text-success total-balance" style="color: {{ ($totalBalanceUSD < 0) ? 'var(--danger-color)' : 'var(--success-color)' }} !important;">
                                    کۆی گشتی: {{ ($totalBalanceUSD < 0) ? '-' : '+' }} {{ $totalDisplayUSD }}
                                </span>
                                <div class="small text-white mt-1">
                                    {{ $totalStatusDisplayUSD }}
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-body p-0">
                        <div class="table-responsive-card">
                            <div class="p-2">
                                <input type="text" class="form-control form-control-sm" id="searchUSD" placeholder="گەڕان بە ناو یان ID موشتەری...">
                            </div>
                            <table id="usdTable" class="table table-hover align-middle mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>موشتەری</th>
                                        <th>لامانە (USD)</th>
                                        <th>لاتانە (USD)</th>
                                        <th>دۆخ</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php 
                                        $hasUsdRows = false; 
                                        // Use pre-calculated balances
                                        $customerBalancesUSD = [];
                                       foreach ($customersUSD as $customer) {
                                            if (isset($customerBalances[$customer->id]['USD'])) {
                                                $balanceData = $customerBalances[$customer->id]['USD'];
                                                $totalBalance = $balanceData['total'];

                                                $customerBalancesUSD[$customer->id] = [
                                                    'customer' => $customer,
                                                    'approvedBalance' => $balanceData['approved'],
                                                    'pendingBalance' => $balanceData['pending'],
                                                    'totalBalance' => $totalBalance
                                                ];
                                            }
                                        }

                                        // 🔽 Sort customers alphabetically so both tables stay aligned
                                        uasort($customerBalancesUSD, function($a, $b) {
                                            return strcasecmp($a['customer']->customer_name ?? '', $b['customer']->customer_name ?? '');
                                        });
                                    @endphp

                                    @foreach ($customerBalancesUSD as $customerData)
                                        @php
                                            $customer = $customerData['customer'];
                                            $approvedBalanceUSD = $customerData['approvedBalance'];
                                            $pendingBalanceUSD = $customerData['pendingBalance'];
                                            $balanceUSD = $customerData['totalBalance'];
                                            
                                            $hasUsdRows = true;
                                            
                                            // Update the totals based on balance sign
                                            if ($balanceUSD > 0) {
                                                $totalLamanaUSD += $balanceUSD;
                                            } elseif ($balanceUSD < 0) {
                                                $totalLatanaUSD += abs($balanceUSD);
                                            }
                                        @endphp

                                        <tr>
                                            <td data-label="موشتەری">
                                                <a class="customer-name" target="_blank" href="{{ route('show_customer', $customer->id) }}">
                                                    {{ $customer->customer_name }} <b>({{ $customer->id }})</b>
                                                </a>
                                                <span class="phone-number">{{ $customer->phone_number }}</span>
                                            </td>
                                            <td data-label="لامانە (USD)">
                                                @if($balanceUSD > 0)
                                                <span class="value-badge bg-success text-white">
                                                    {{ number_format($balanceUSD, 0, '.', ',') }}
                                                </span>
                                                @else
                                                <span class="value-badge bg-light text-white">
                                                    0
                                                </span>
                                                @endif
                                            </td>
                                            <td data-label="لاتانە (USD)">
                                                @if($balanceUSD < 0)
                                                <span class="value-badge bg-danger text-white">
                                                    {{ number_format(abs($balanceUSD), 0, '.', ',') }}
                                                </span>
                                                @else
                                                <span class="value-badge bg-light text-white">
                                                    0
                                                </span>
                                                @endif
                                            </td>
                                            <td data-label="دۆخ">
                                                @if ($pendingBalanceUSD != 0)
                                                    <span class="small-badge badge bg-warning">
                                                        چاوەڕوان: {{ number_format(abs($pendingBalanceUSD), 0, '.', ',') }}
                                                    </span>
                                                @endif
                                                @if ($approvedBalanceUSD != 0)
                                                    <span class="small-badge badge bg-success ms-1">
                                                        پەسەندکراو: {{ number_format(abs($approvedBalanceUSD), 0, '.', ',') }}
                                                    </span>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach

                                    @if (!$hasUsdRows)
                                        <tr>
                                            <td colspan="4" class="text-center py-4">هیچ ئەکاونتێکی USD بە باڵانسی ناسفر نییە</td>
                                        </tr>
                                    @endif
                                </tbody>
                                @if ($hasUsdRows)
                                    <tfoot>
                                        <tr class="bg-light">
                                            <td class="text-end"><strong>کۆی گشتی</strong></td>
                                            <td>
                                                <span class="value-badge bg-success text-white">
                                                    {{ number_format($totalLamanaUSD, 0, '.', ',') }} USD
                                                </span>
                                            </td>
                                            <td>
                                                <span class="value-badge bg-danger text-white">
                                                    {{ number_format($totalLatanaUSD, 0, '.', ',') }} USD
                                                </span>
                                            </td>
                                            <td>
                                                <span class="small-badge badge bg-success text-white">
                                                    پەسەندکراو: {{ number_format(abs($totalApprovedBalanceUSD), 0, '.', ',') }}
                                                </span>
                                                <span class="small-badge badge bg-warning ms-1">
                                                    چاوەڕوان: {{ number_format(abs($totalPendingBalanceUSD), 0, '.', ',') }}
                                                </span>
                                            </td>
                                        </tr>
                                    </tfoot>
                                @endif
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
<script>
document.addEventListener('DOMContentLoaded', function () {
    function addSearch(inputId, tableId) {
        const input = document.getElementById(inputId);
        const rows = document.querySelectorAll(`#${tableId} tbody tr`);

        input.addEventListener('input', function () {
            const query = input.value.trim().toLowerCase();

            rows.forEach(row => {
                const nameCell = row.querySelector('td[data-label="موشتەری"]');
                const customerName = nameCell?.querySelector('.customer-name')?.textContent.toLowerCase() || '';
                const customerId = nameCell?.querySelector('.customer-name')?.getAttribute('href')?.split('/').pop() || '';

                if (customerName.includes(query) || customerId.includes(query)) {
                    row.classList.add('table-warning');
                    row.style.display = '';
                } else {
                    row.classList.remove('table-warning');
                    row.style.display = query ? 'none' : '';
                }
            });
        });
    }

    addSearch('searchIQD', 'iqdTable');
    addSearch('searchUSD', 'usdTable');
});
</script>

</div>

