<div >
    <script src="//cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  
    @php
        $user = Auth::user();
        $isSuperAdmin = $user->hasRole('super-admin');
        $supervisor = $user->hasRole('supervisor');
    @endphp

    <!-- Header Section with Page Title -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="fw-bold text-primary">بەڕێوبردنی قاسە</h2>
        
        @if ($isSuperAdmin)
            <button type="button" class="btn btn-primary" wire:click="openCreateModal">
                <i class="ti ti-plus me-1"></i> @lang('word.NewCashbox')
            </button>
        @endif
    </div>

    <!-- Filter Section with Modern UI -->
    @if ($isSuperAdmin)
        <div class="card shadow-sm mb-4">
            <div class="card-body">
                <h5 class="card-title mb-3">فلتەر</h5>
                <div class="d-flex flex-wrap gap-3">
                    <div class="form-check">
                        <input type="radio" id="savings" wire:model.live="filterType" value="savings" class="form-check-input">
                        <label for="savings" class="form-check-label">کاشبۆکسی خاوەن کار</label>
                    </div>
                    
                    <div class="form-check">
                        <input type="radio" id="profit_only" wire:model.live="filterType" value="profit_only" class="form-check-input">
                        <label for="profit_only" class="form-check-label">دراوی دجیتالی</label>
                    </div>
                    
                    <div class="form-check">
                        <input type="radio" id="profit" wire:model.live="filterType" value="profit" class="form-check-input">
                        <label for="profit" class="form-check-label">@lang('word.Profit')</label>
                    </div>
                    
                    {{-- <div class="form-check">
                        <input type="radio" id="cashier" wire:model.live="filterType" value="cashier" class="form-check-input">
                        <label for="cashier" class="form-check-label">گواستنەوەی پارە لۆ کاشێر</label>
                    </div> --}}
                    
                    <div class="form-check">
                        <input type="radio" id="box_cashier" wire:model.live="filterType" value="box_cashier" class="form-check-input">
                        <label for="box_cashier" class="form-check-label">قاسەی کاشێرەکان</label>
                    </div>
                </div>
            </div>
        </div>
    @endif

    @if ($supervisor)
        <div class="card shadow-sm mb-4">
            <div class="card-body">
                <h5 class="card-title mb-3">فلتەر</h5>
                <div class="d-flex flex-wrap gap-3">
                     <div class="form-check">
                        <input type="radio" id="box_cashier" wire:model.live="filterType" value="box_cashier" class="form-check-input">
                        <label for="box_cashier" class="form-check-label">قاسەی کاشێرەکان</label>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <!-- Create Cashier Account Button -->
    @if ($filterType == 'cashier')
        @if($currencies->where('type', 0)->pluck('id')->diff(
                $accounts->where('account_type', 'cashier')->pluck('currency_id')
            )->isNotEmpty())
                <button type="button" class="btn btn-success mb-4" wire:click="CreateCashierAccount">
                    <i class="ti ti-plus me-1"></i> دروستکرنی قاسە لۆ گواستنەوەی پارە
                </button>
        @endif
    @endif

    <!-- Accounts Cards Section with Modern Design -->
    <div class="row g-4">
        @if ($accounts->isEmpty())
            <div class="col-12">
                <div class="alert alert-info d-flex align-items-center">
                    <i class="ti ti-info-circle me-2 fs-5"></i>
                    <span>@lang('word.Empty')</span>
                </div>
            </div>
        @else
            @foreach ($accounts as $account)
                <div class="col-md-6 col-lg-4 col-xl-3">
                    <div class="card h-100 border-0 shadow-sm hover-shadow transition-all">
                        <div class="position-relative">
                            <!-- Badge for Account Type -->
                            <div class="position-absolute top-0 end-0 m-2">
                                @if($account->account_type === 'profit')
                                    <span class="badge bg-success rounded-pill px-3 py-2">@lang('word.Profit')</span>
                                @elseif($account->account_type === 'savings')
                                    <span class="badge bg-info rounded-pill px-3 py-2">@lang('word.BankCash')</span>
                                @endif
                            </div>
                        </div>
                        
                        <div class="card-body d-flex align-items-center p-4">
                            <!-- Currency Image -->
                            <div class="me-3">
                                <div class="rounded-circle overflow-hidden currency-image-container d-flex align-items-center justify-content-center" style="width: 70px; height: 70px; border: 3px solid #f8f9fa; background-color: #f8f9fa;">
                                    @if($account->currency->code)
                                        <img src="{{ \Storage::url($account->currency->code) }}"
                                             alt="{{ $account->currency->currency_name }}" 
                                             class="img-fluid w-100 h-100 object-fit-cover"
                                             onerror="this.style.display='none'; this.parentElement.innerHTML='<i class=\'ti ti-currency-dollar text-muted\' style=\'font-size: 24px;\'></i>';">
                                    @else
                                        <i class="ti ti-currency-dollar text-muted" style="font-size: 24px;"></i>
                                    @endif
                                </div>
                            </div>
                            
                            <!-- Account Details -->
                            <div class="flex-grow-1">
                                <h6 class="text-muted mb-1">{{ $account->currency->currency_name }}</h6>
                                <h4 class="mb-0 fw-bold">
                                    {{ number_format($account->computed_balance ?? $account->calculateTotalBalance(), 0, '.', ',') }}
                                </h4>
                            </div>
                        </div>
                        
                        <!-- Card Footer with Action Buttons -->
                        <div class="card-footer bg-transparent border-top-0 d-flex justify-content-end gap-2 p-3">
                            <a href="{{ route('show-cashbox', $account) }}?return_filter={{ $filterType }}{{ ($filterType == 'box_cashier' || $filterType == 'cashier') && $selectedCashier ? '&cashier_id='.$selectedCashier : '' }}" 
                                    class="btn btn-outline-primary">
                                    <i class="ti ti-info-square me-1"></i>
                                    </a>
                            
                            @if ($isSuperAdmin)
                                <button class="btn btn-sm btn-outline-dark" wire:click="confirmReset({{ $account->id }})" data-bs-toggle="tooltip" title="Reset Balance">
                                    <i class="ti ti-reload"></i>
                                </button>
                            @endif

                            @if ($filterType == 'cashier' || $filterType == 'savings' || $filterType == 'supervisor' || $filterType == 'profit_only')
                                @if ($isSuperAdmin)  
                                <button class="btn btn-outline-success" wire:click='openOwnerModal({{$account}})'>
                                        <i class="ti ti-home-move"></i>
                                    </button>
                                    @endif
                                @endif
                        </div>
                    </div>
                </div>
            @endforeach
        @endif
    </div>
    
    <!-- Cashier Selection Section -->
    @if ($filterType == 'box_cashier' || $supervisor)
        <div class="card shadow-sm mt-4 mb-4">
            <div class="card-body">
                <h5 class="card-title mb-3">@lang('word.SelectCashier')</h5>
                <div class="row">
                    <div class="col-md-6 col-lg-4">
                        <select class="form-select" id="cashierSelect" wire:model.live="selectedCashier">
                            <option value="">@lang('word.SelectCashier')</option>
                            @foreach($cashiers as $cashier)
                                <option value="{{ $cashier->id }}">{{ $cashier->cashier_name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <!-- Cashier Accounts Section -->
    @if ($filterType == 'box_cashier')
        <div class="row g-4 mt-2">
            @if (!$cashier_accounts || $cashier_accounts->isEmpty())
                <div class="col-12">
                    <div class="alert alert-info d-flex align-items-center">
                        <i class="ti ti-info-circle me-2 fs-5"></i>
                        <span>@lang('word.Empty')</span>
                    </div>
                </div>
            @else
                @foreach ($cashier_accounts as $account)
                    <div class="col-md-6 col-lg-4 col-xl-3">
                        <div class="card h-100 border-0 shadow-sm hover-shadow transition-all">
                            <a href="{{ route('show-cashbox', $account) }}?return_filter={{ $filterType }}{{ ($filterType == 'box_cashier' || $filterType == 'cashier') && $selectedCashier ? '&cashier_id='.$selectedCashier : '' }}" class="text-decoration-none">
                                <div class="card-body d-flex align-items-center p-4">
                                    <!-- Currency Image -->
                                    <div class="me-3">
                                        <div class="rounded-circle overflow-hidden currency-image-container d-flex align-items-center justify-content-center" style="width: 70px; height: 70px; border: 3px solid #f8f9fa; background-color: #f8f9fa;">
                                            @if($account->currency->code)
                                                <img src="{{ \Storage::url($account->currency->code) }}" 
                                                    alt="{{ $account->currency->currency_name }}" 
                                                    class="img-fluid w-100 h-100 object-fit-cover"
                                                    onerror="this.style.display='none'; this.parentElement.innerHTML='<i class=\'ti ti-currency-dollar text-muted\' style=\'font-size: 24px;\'></i>';">
                                            @else
                                                <i class="ti ti-currency-dollar text-muted" style="font-size: 24px;"></i>
                                            @endif
                                        </div>
                                    </div>
                                    
                                    <!-- Account Details -->
                                    <div class="flex-grow-1">
                                        <h6 class="text-muted mb-1">{{ $account->currency->currency_name }}</h6>
                                        <h4 class="mb-0 fw-bold text-dark">
                                            {{ number_format($account->computed_balance ?? $account->calculateTotalBalance(), 0, '.', ',') }}
                                        </h4>
                                        
                                        <!-- Account Type Badge -->
                                        @if($account->account_type === 'profit')
                                            <span class="badge bg-success mt-2">@lang('word.Profit')</span>
                                        @elseif($account->account_type === 'checking')
                                            <span class="badge bg-info mt-2">@lang('word.BankCash')</span>
                                        @endif
                                    </div>
                                </div>
                            </a>
                            
                            <!-- Card Footer with Action Buttons -->
                            <div class="card-footer bg-transparent border-top-0 d-flex justify-content-end gap-2 p-3">
                                @if ($isSuperAdmin)
                                    <a href="{{ route('show-cashbox', $account) }}?return_filter={{ $filterType }}{{ ($filterType == 'box_cashier' || $filterType == 'cashier') && $selectedCashier ? '&cashier_id='.$selectedCashier : '' }}"  
                                        class="btn btn-sm btn-outline-primary" data-bs-toggle="tooltip" title="View Details">
                                        <i class="ti ti-info-square"></i>
                                    </a>
                                    
                                    <button class="btn btn-sm btn-outline-dark" wire:click="confirmReset({{ $account->id }})" data-bs-toggle="tooltip" title="Reset Balance">
                                        <i class="ti ti-reload"></i>
                                    </button>
                                @endif
                            </div>
                        </div>
                    </div>
                @endforeach
            @endif
        </div>
    @endif

    <!-- Reset Balance Modal with Modern Design -->
    @if($showResetModal)
    <div class="modal fade show d-block" style="background-color: rgba(0, 0, 0, 0.5);" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content border-0 shadow">
                <div class="modal-header bg-light">
                    <h5 class="modal-title">سفر کردنەوەی بەڵانس</h5>
                    <button type="button" class="btn-close" wire:click="closeResetModal"></button>
                </div>
                <div class="modal-body p-4">
                    <div class="text-center mb-3">
                        <i class="ti ti-alert-circle text-warning" style="font-size: 3rem;"></i>
                    </div>
                    <p class="text-center fs-5">دڵنیایت لە سفر کردنەوەی حساب؟</p>
                </div>
                <div class="modal-footer justify-content-center border-0">
                    <button type="button" class="btn btn-light px-4" wire:click="closeResetModal">@lang('word.Close')</button>
                    <button wire:click="reset_balance" type="submit" class="btn btn-danger px-4">بەڵێ، سفری بکەوە</button>
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- Owner Modal with Modern Design -->
    @if($showOwnerModal)
    <div class="modal fade show d-block" style="background-color: rgba(0, 0, 0, 0.5);" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content border-0 shadow">
                <div class="modal-header bg-light">
                    <h5 class="modal-title">جوڵەکردنی پارە لەلایەن ساحێبەوە</h5>
                    <button type="button" class="btn-close" wire:click="closeOwnerModal"></button>
                </div>
                <div class="modal-body p-4">
                    <div class="row g-3">
                        <div class="col-12">
                            <label class="form-label fw-medium">@lang('word.TransactionAmount')</label>
                            <input type="text" x-mask:dynamic="$money($input, '.', ',', 4)" wire:model.defer="amount" id="amount" class="form-control form-control-lg" placeholder="@lang('word.TransactionAmount')">
                            @error('amount') <span class="text-danger small mt-1">{{ $message }}</span> @enderror
                        </div>
                        
                        <div class="col-12">
                            <label for="transaction_type" class="form-label fw-medium">@lang('word.TransactionType')</label>
                            <select wire:model="transaction_type" class="form-select form-select-lg" id="transaction_type">
                                <option value="">{{ __('word.TransactionType') }}</option>
                                <option value="deposit">{{ __('word.Deposit') }}</option>
                                <option value="withdrawal">{{ __('word.Withdrawal') }}</option>
                            </select>
                            @error('transaction_type') <span class="text-danger small mt-1">{{ $message }}</span> @enderror
                        </div>
                        
                        <div class="col-12">
                            <label class="form-label fw-medium">@lang('word.Note')</label>
                            <textarea wire:model.defer="ownerNote" id="ownerNote" class="form-control" rows="3" placeholder="@lang('word.Note')"></textarea>
                            @error('ownerNote') <span class="text-danger small mt-1">{{ $message }}</span> @enderror
                        </div>
                    </div>
                </div>
                <div class="modal-footer border-0">
                    <button type="button" class="btn btn-light" wire:click="closeOwnerModal">@lang('word.Close')</button>
                    <button wire:click="ownerBalance({{ $account->id }})" type="submit" class="btn btn-primary">@lang('word.Save')</button>
                </div>
            </div>
        </div>
    </div>
    @endif
    
    <!-- Create Account Modal with Modern Design -->
    @if($showCreateModal)
    <div class="modal fade show d-block" style="background-color: rgba(0, 0, 0, 0.5);" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content border-0 shadow">
                <div class="modal-header bg-light">
                    <h5 class="modal-title">@lang('word.NewCashbox')</h5>
                    <button type="button" class="btn-close" wire:click="closeCreateModal"></button>
                </div>
                <div class="modal-body p-4">
                    <div class="row g-3">
                        <div class="col-12">
                            <label class="form-label fw-medium">@lang('word.Currency')</label>
                            <select class="form-select form-select-lg" wire:model="currency_id" required>
                                <option value="">@lang('word.Currency')</option>
                                @foreach($currencies as $currency)
                                <option value="{{ $currency->id }}">{{ $currency->currency_name }}</option>
                                @endforeach
                            </select>
                            @error('currency_id') <span class="text-danger small mt-1">{{ $message }}</span> @enderror
                        </div>
                    </div>
                </div>
                <div class="modal-footer border-0">
                    <button type="button" class="btn btn-light" wire:click="closeCreateModal">@lang('word.Close')</button>
                    <button wire:click="createAccount" type="submit" class="btn btn-primary">@lang('word.Save')</button>
                </div>
            </div>
        </div>
    </div>
    @endif

    <style>
        .hover-shadow:hover {
            transform: translateY(-5px);
            box-shadow: 0 .5rem 1rem rgba(0,0,0,.15)!important;
        }
        
        .transition-all {
            transition: all 0.3s ease;
        }
        
        .object-fit-cover {
            object-fit: cover;
        }

        .currency-image-container {
            transition: all 0.3s ease;
        }

        /* Responsive image sizing */
        @media (max-width: 768px) {
            .currency-image-container {
                width: 60px !important;
                height: 60px !important;
            }
        }

        @media (max-width: 576px) {
            .currency-image-container {
                width: 50px !important;
                height: 50px !important;
            }
        }
    </style>
    
    <script>
        // Initialize tooltips
        document.addEventListener('DOMContentLoaded', function() {
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
            var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl)
            });
        });
    </script>
</div>