<div>
    <div class="card shadow">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0 text-white">
                <i class="fas fa-file-alt me-2"></i> ڕاپۆرتی ڕۆژانەی باڵانس
            </h5>
        </div>
        
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>بەروار</th>
                            <th class="text-end">کۆی گشتی عیراقی</th>
                            <th class="text-end">کۆی گشتی دۆلار</th>
                            <th class="text-end">کۆی گشتی</th>
                            <th class="text-end">کۆی گشتی (دۆلار)</th>
                            <th></th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($reports as $report)
                        <tr>
                            <td>{{ $report->report_date->format('Y-m-d') }}</td>
                            <td class="text-end">{{ number_format($report->total_iqd, 0) }} د.ع</td>
                            <td class="text-end">{{ number_format($report->total_usd, 0) }} $</td>
                            <td class="text-end">
                                @if($report->profit_amount)
                                    {{ number_format($report->profit_amount, 0) }} {{ $report->profit_currency == 'iqd' ? 'د.ع' : '$' }}
                                @else
                                    -
                                @endif
                            </td>
                            <td>
                                 @if($report->image)
                                    <div class="text-center">
                                        <h6>Report Screenshot</h6>
                                        <img src="{{ $report->image }}" class="img-fluid border rounded" 
                                            alt="Report Screenshot" style="max-height: 100px;">
                                        <div class="mt-2">
                                            <a href="{{ $report->image }}" class="btn btn-sm btn-outline-primary" 
                                            download="report-{{ $report->report_date->format('Y-m-d') }}.png">
                                                <i class="fas fa-download"></i> Download Image
                                            </a>
                                        </div>
                                    </div>
                                @else
                                    <div class="alert alert-info">
                                        No screenshot available for this report
                                    </div>
                                @endif
                            </td>
                            <td class="text-end fw-bold">{{ number_format($report->grand_total_usd, 0) }} $</td>
                            <td class="text-end">
                                <button class="btn btn-sm btn-outline-primary" 
                                    wire:click="showReport({{ $report->id }})">
                                    <i class="fas fa-eye me-1"></i> پیشاندان
                                </button>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="6" class="text-center py-4 text-muted">
                                هیچ ڕاپۆرتێک نەدۆزرایەوە
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            <div class="mt-3">
                {{ $reports->links() }}
            </div>
        </div>
    </div>
    

    <!-- Modal -->
    @if($showModal)
        <div class="modal fade show d-block" tabindex="-1" style="background: rgba(0,0,0,0.5);">
            <div class="modal-dialog modal-lg modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header bg-primary text-white">
                        <h5 class="modal-title text-white">
                            وردەکاری ڕاپۆرت - {{ $selectedReport->report_date->format('Y-m-d') }}
                        </h5>
                        <button type="button" class="btn-close btn-close-white" wire:click="$set('showModal', false)"></button>
                    </div>
                    
                    <div class="modal-body">
                        @if($selectedReport)
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <h6>دراوە سەرەکییەکان</h6>
                                        <table class="table table-sm">
                                            <tr>
                                                <td>باڵانسی عیراقی:</td>
                                                <td class="text-end">{{ number_format($selectedReport->total_iqd, 0) }} د.ع</td>
                                            </tr>
                                            <tr>
                                                <td>باڵانسی دۆلار:</td>
                                                <td class="text-end">{{ number_format($selectedReport->total_usd, 0) }} $</td>
                                            </tr>
                                            <tr>
                                                <td>باڵانسی یۆرۆ:</td>
                                                <td class="text-end">{{ number_format($selectedReport->total_euro, 0) }} €</td>
                                            </tr>
                                            @if($selectedReport->euro_to_usd_rate)
                                            <tr>
                                                <td>نرخی یۆرۆ بۆ دۆلار:</td>
                                                <td class="text-end">{{ $selectedReport->euro_to_usd_rate }}</td>
                                            </tr>
                                            <tr>
                                                <td>یۆرۆ گۆڕاو بۆ دۆلار:</td>
                                                <td class="text-end">{{ number_format($selectedReport->converted_euro_to_usd, 2) }} $</td>
                                            </tr>
                                            @endif
                                        </table>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <h6>گۆڕانکاری نرخ</h6>
                                        <table class="table table-sm">
                                            <tr>
                                                <td>نرخی دۆلار بۆ عیراقی:</td>
                                                <td class="text-end">{{ $selectedReport->usd_to_iqd_rate ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <td>نرخی عیراقی بۆ دۆلار:</td>
                                                <td class="text-end">{{ $selectedReport->iqd_to_usd_rate ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <td>دۆلار گۆڕاو بۆ عیراقی:</td>
                                                <td class="text-end">
                                                    @if($selectedReport->converted_usd_to_iqd)
                                                        {{ number_format($selectedReport->converted_usd_to_iqd, 0) }} د.ع
                                                    @else
                                                        -
                                                    @endif
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>عیراقی گۆڕاو بۆ دۆلار:</td>
                                                <td class="text-end">
                                                    @if($selectedReport->converted_iqd_to_usd)
                                                        {{ number_format($selectedReport->converted_iqd_to_usd, 0) }} $
                                                    @else
                                                        -
                                                    @endif
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    @if($selectedReport->additional_currencies)
                                    <h6>دراوەکانی تر</h6>
                                    <table class="table table-sm">
                                        @foreach(json_decode($selectedReport->additional_currencies, true) as $currency)
                                        <tr>
                                            <td>{{ $currency['currency_name'] }}:</td>
                                            <td class="text-end">{{ number_format($currency['balance'], 0) }}</td>
                                            <td class="text-end">
                                                @if(isset($currency['rate']) && $currency['rate'] > 0)
                                                    ({{ number_format($currency['converted_value'], 2) }} $)
                                                @endif
                                            </td>
                                        </tr>
                                        @endforeach
                                        @if($selectedReport->total_additional_usd)
                                        <tr class="fw-bold">
                                            <td colspan="2">کۆی گشتی دراوەکانی تر بۆ دۆلار:</td>
                                            <td class="text-end">{{ number_format($selectedReport->total_additional_usd, 2) }} $</td>
                                        </tr>
                                        @endif
                                    </table>
                                    @endif
                                    
                                    <div class="mt-3">
                                        <h6>کۆی گشتی</h6>
                                        <table class="table table-sm">
                                            <tr>
                                                <td>کۆی گشتی:</td>
                                                <td class="text-end">
                                                    @if($selectedReport->profit_amount)
                                                        {{ number_format($selectedReport->profit_amount, 0) }} 
                                                        {{ $selectedReport->profit_currency == 'iqd' ? 'د.ع' : '$' }}
                                                    @else
                                                        -
                                                    @endif
                                                </td>
                                            </tr>
                                            <tr class="fw-bold">
                                                <td>کۆی گشتی بە دۆلار:</td>
                                                <td class="text-end">{{ number_format($selectedReport->grand_total_usd, 0) }} $</td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        @else
                            <div class="alert alert-warning">
                                زانیاری ڕاپۆرت نەدۆزرایەوە
                            </div>
                        @endif
                    </div>
                    
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" wire:click="$set('showModal', false)">داخستن</button>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <style>
        .modal.show {
            display: block;
            backdrop-filter: blur(2px);
        }
    </style>
</div>