<div >
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title mb-0">
                        <i class="fas fa-shield-alt text-warning"></i> App Version Management
                        <small class="text-muted">(Super-Admin Only)</small>
                    </h3>
                    <button wire:click="create" class="btn btn-primary">
                        <i class="fas fa-plus"></i> Add New Version
                    </button>
                </div>

                @if (session()->has('message'))
                    <div class="alert alert-success alert-dismissible fade show mx-3 mt-3" role="alert">
                        {{ session('message') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                <!-- Form Modal -->
                @if($show_form)
                <div class="modal fade show d-block" tabindex="-1" style="background-color: rgba(0,0,0,0.5);">
                    <div class="modal-dialog modal-lg">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">
                                    {{ $editing_id ? 'Edit App Version' : 'Add New App Version' }}
                                </h5>
                                <button type="button" wire:click="cancel" class="btn-close"></button>
                            </div>
                            <div class="modal-body">
                                <form wire:submit.prevent="save">
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Version</label>
                                            <input type="text" wire:model="version" class="form-control" placeholder="e.g., 1.2.3">
                                            @error('version') <div class="text-danger small">{{ $message }}</div> @enderror
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Version Code</label>
                                            <input type="number" wire:model="version_code" class="form-control" placeholder="e.g., 123">
                                            @error('version_code') <div class="text-danger small">{{ $message }}</div> @enderror
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Platform</label>
                                            <select wire:model="platform" class="form-select">
                                                <option value="android">Android</option>
                                                <option value="ios">iOS</option>
                                            </select>
                                            @error('platform') <div class="text-danger small">{{ $message }}</div> @enderror
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Min Supported Version</label>
                                            <input type="text" wire:model="min_supported_version" class="form-control" placeholder="e.g., 1.0.0">
                                            @error('min_supported_version') <div class="text-danger small">{{ $message }}</div> @enderror
                                        </div>

                                        <div class="col-12 mb-3">
                                            <label class="form-label">Download URL</label>
                                            <input type="url" wire:model="download_url" class="form-control" placeholder="https://play.google.com/store/apps/details?id=com.LA DERMA.mobile">
                                            @error('download_url') <div class="text-danger small">{{ $message }}</div> @enderror
                                        </div>

                                        <div class="col-12 mb-3">
                                            <label class="form-label">Release Notes</label>
                                            <textarea wire:model="release_notes" rows="3" class="form-control" placeholder="Bug fixes and performance improvements..."></textarea>
                                            @error('release_notes') <div class="text-danger small">{{ $message }}</div> @enderror
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <div class="form-check">
                                                <input type="checkbox" wire:model="is_active" class="form-check-input" id="is_active">
                                                <label class="form-check-label" for="is_active">Active</label>
                                            </div>
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <div class="form-check">
                                                <input type="checkbox" wire:model="is_force_update" class="form-check-input" id="is_force_update">
                                                <label class="form-check-label" for="is_force_update">Force Update</label>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <div class="modal-footer">
                                <button type="button" wire:click="cancel" class="btn btn-secondary">Cancel</button>
                                <button type="button" wire:click="save" class="btn btn-primary">
                                    {{ $editing_id ? 'Update' : 'Create' }}
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                @endif

                <!-- Table -->
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead class="table-dark">
                                <tr>
                                    <th>Platform</th>
                                    <th>Version</th>
                                    <th>Version Code</th>
                                    <th>Status</th>
                                    <th>Force Update</th>
                                    <th>Created</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($app_versions as $app_version)
                                <tr>
                                    <td>
                                        <span class="badge {{ $app_version->platform === 'android' ? 'bg-success' : 'bg-info' }}">
                                            {{ ucfirst($app_version->platform) }}
                                        </span>
                                    </td>
                                    <td><strong>{{ $app_version->version }}</strong></td>
                                    <td>{{ $app_version->version_code }}</td>
                                    <td>
                                        <button wire:click="toggleActive({{ $app_version->id }})" class="btn btn-sm {{ $app_version->is_active ? 'btn-success' : 'btn-danger' }}">
                                            {{ $app_version->is_active ? 'Active' : 'Inactive' }}
                                        </button>
                                    </td>
                                    <td>
                                        <button wire:click="toggleForceUpdate({{ $app_version->id }})" class="btn btn-sm {{ $app_version->is_force_update ? 'btn-warning' : 'btn-secondary' }}">
                                            {{ $app_version->is_force_update ? 'Yes' : 'No' }}
                                        </button>
                                    </td>
                                    <td>{{ $app_version->created_at->format('M d, Y') }}</td>
                                    <td>
                                        <button wire:click="edit({{ $app_version->id }})" class="btn btn-sm btn-primary me-1">
                                            <i class="fas fa-edit"></i> Edit
                                        </button>
                                        <button wire:click="delete({{ $app_version->id }})" onclick="return confirm('Are you sure?')" class="btn btn-sm btn-danger">
                                            <i class="fas fa-trash"></i> Delete
                                        </button>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" class="text-center text-muted">
                                        <i class="fas fa-info-circle"></i> No app versions found.
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-center mt-3">
                        {{ $app_versions->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Version Details -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Current Active Versions</h3>
                </div>
                <div class="card-body">
                    @if($app_versions->count() > 0)
                        @php $latest_android = $app_versions->where('platform', 'android')->where('is_active', true)->sortByDesc('version_code')->first(); @endphp
                        @php $latest_ios = $app_versions->where('platform', 'ios')->where('is_active', true)->sortByDesc('version_code')->first(); @endphp
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="card border-success">
                                    <div class="card-header bg-success text-white">
                                        <h5 class="card-title mb-0">
                                            <i class="fab fa-android"></i> Android
                                        </h5>
                                    </div>
                                    <div class="card-body">
                                        @if($latest_android)
                                            <div class="row">
                                                <div class="col-6"><strong>Version:</strong></div>
                                                <div class="col-6">{{ $latest_android->version }}</div>
                                                <div class="col-6"><strong>Version Code:</strong></div>
                                                <div class="col-6">{{ $latest_android->version_code }}</div>
                                                <div class="col-6"><strong>Min Supported:</strong></div>
                                                <div class="col-6">{{ $latest_android->min_supported_version }}</div>
                                                <div class="col-6"><strong>Force Update:</strong></div>
                                                <div class="col-6">
                                                    <span class="badge {{ $latest_android->is_force_update ? 'bg-warning' : 'bg-success' }}">
                                                        {{ $latest_android->is_force_update ? 'Yes' : 'No' }}
                                                    </span>
                                                </div>
                                                @if($latest_android->download_url)
                                                <div class="col-6"><strong>Download:</strong></div>
                                                <div class="col-6">
                                                    <a href="{{ $latest_android->download_url }}" target="_blank" class="btn btn-sm btn-outline-primary">
                                                        <i class="fas fa-external-link-alt"></i> View
                                                    </a>
                                                </div>
                                                @endif
                                                @if($latest_android->release_notes)
                                                <div class="col-12 mt-2">
                                                    <strong>Release Notes:</strong>
                                                    <p class="text-muted small">{{ $latest_android->release_notes }}</p>
                                                </div>
                                                @endif
                                            </div>
                                        @else
                                            <p class="text-muted">No active Android version</p>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="card border-info">
                                    <div class="card-header bg-info text-white">
                                        <h5 class="card-title mb-0">
                                            <i class="fab fa-apple"></i> iOS
                                        </h5>
                                    </div>
                                    <div class="card-body">
                                        @if($latest_ios)
                                            <div class="row">
                                                <div class="col-6"><strong>Version:</strong></div>
                                                <div class="col-6">{{ $latest_ios->version }}</div>
                                                <div class="col-6"><strong>Version Code:</strong></div>
                                                <div class="col-6">{{ $latest_ios->version_code }}</div>
                                                <div class="col-6"><strong>Min Supported:</strong></div>
                                                <div class="col-6">{{ $latest_ios->min_supported_version }}</div>
                                                <div class="col-6"><strong>Force Update:</strong></div>
                                                <div class="col-6">
                                                    <span class="badge {{ $latest_ios->is_force_update ? 'bg-warning' : 'bg-success' }}">
                                                        {{ $latest_ios->is_force_update ? 'Yes' : 'No' }}
                                                    </span>
                                                </div>
                                                @if($latest_ios->download_url)
                                                <div class="col-6"><strong>Download:</strong></div>
                                                <div class="col-6">
                                                    <a href="{{ $latest_ios->download_url }}" target="_blank" class="btn btn-sm btn-outline-primary">
                                                        <i class="fas fa-external-link-alt"></i> View
                                                    </a>
                                                </div>
                                                @endif
                                                @if($latest_ios->release_notes)
                                                <div class="col-12 mt-2">
                                                    <strong>Release Notes:</strong>
                                                    <p class="text-muted small">{{ $latest_ios->release_notes }}</p>
                                                </div>
                                                @endif
                                            </div>
                                        @else
                                            <p class="text-muted">No active iOS version</p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    @else
                        <p class="text-muted text-center">
                            <i class="fas fa-info-circle"></i> No app versions available
                        </p>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
