<div>
    <script src="//cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>

    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  
    <!-- List all Transfer Options -->
    <div class="card">
    
        <div class="card-body">
            <!-- Button to open modal -->
            <button class="btn btn-primary" wire:click="openModal">@lang('word.AccountTransfer')</button>

            @if (session()->has('message'))
                <div class="alert alert-success mt-3">
                    {{ session('message') }}
                </div>
            @endif
        </div>
    </div>
    <div class="card mt-4">
        <div class="card-body">
        <div class="table-responsive mt-4">
            <table class="table table-border table-hover">
                <thead>
                    <tr>
                        <th> @lang('word.TransactionType')</th>
                        <th> @lang('word.TransactionAmount')</th>
                        <th> @lang('word.FromAccount')</th>
                        <th> @lang('word.ToAccount')</th>
                        <th> @lang('word.TransactionDate')</th>
                        <th> @lang('word.TransactionTime')</th>
                        {{-- @php
                            $user = Auth::user();
                            $isSuperAdmin = $user->hasRole('super-admin');
                        @endphp
                        @if ($isSuperAdmin)
                        <th>Actions</th>
                        @endif --}}
                    </tr>
                </thead>
                <tbody>
                    @foreach ($account_transactions as $transaction)
                        <tr>
                            <td>{{ ucfirst($transaction->transaction_type) }}</td>
                            <td>{{ number_format($transaction->transaction_amount, 0, '.', ',') }}  {{ $transaction->account->currency->currency_name }}</td>
                            <td>{{ $transaction->from_account->account_title }}</td>
                            <td>{{ $transaction->to_account->account_title }}</td>
                            <td>{{ $transaction->transaction_date->format('Y-m-d') }}</td>
                            <td>{{ $transaction->transaction_time }}</td>
                            {{-- @if ($isSuperAdmin)
                            <td class="text-center" style="width: 134px;">
                                <div
                                    role="group"
                                    aria-label="Row Actions"
                                    class="btn-group" >
                                   
                                     @can('update', $transaction)
                                    <a
                                        href="#" >
                                        <button
                                        wire:click="edit({{ $transaction->id }})" data-bs-toggle="modal" data-bs-target="#editTransactionModal"
                                            data-bs-toggle="tooltip"
                                            data-bs-placement="top"
                                            data-bs-custom-class="tooltip-primary"
                                            title="View"
                                            type="button"
                                            class="btn btn-icon btn-outline-primary
                                                m-1 " >
                                            <i class="fa fa-edit"></i>
                                        </button>
                                    </a>
        
                                    @endcan 
                                    
                                </div>
                            </td>
                            @endif --}}

                            {{-- <td>
                                <!-- Open Edit Modal Button -->
                                <button class="btn btn-sm btn-primary" wire:click="edit({{ $transaction->id }})" data-bs-toggle="modal" data-bs-target="#editTransactionModal">
                                    <i class="ti ti-edit text-white"></i>
                                </button>
                            </td> --}}
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        </div>
    </div>



    <!-- Modal for Account Transfer -->
    @if($showModal)
        <div class="modal fade show d-block" style="background-color: rgba(0, 0, 0, 0.5);" tabindex="-1">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">@lang('word.TransferBetweenAccounts')</h5>
                        <button type="button" class="btn-close" wire:click="closeModal"></button>
                    </div>
                    <div class="modal-body">
                        <!-- Select From Account -->
                        <div class="mb-3">
                            <label for="from_account_id" class="form-label"> @lang('word.FromAccount')</label>
                            <select id="from_account_id" class="form-select" wire:model="from_account_id">
                                <option value=""> @lang('word.FromAccount')</option>
                                @foreach($from_accounts as $account)
                                    <option value="{{ $account->id }}">{{ $account->account_title }} ({{ $account->calculateTotalBalance() }}) {{$account->currency->currency_name}}</option>
                                @endforeach
                            </select>
                            @error('from_account_id') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                       <!-- Select To Account -->
                        <div class="mb-3">
                            <label for="to_account_id" class="form-label"> @lang('word.ToAccount')</label>
                            <select id="to_account_id" class="form-select" wire:model="to_account_id">
                                <option value=""> @lang('word.ToAccount') </option>

                                @php
                                    // Create an array to hold accounts grouped by cashier
                                    $accountsGroupedByCashier = [];
                                    
                                    // Group accounts by cashier name
                                    foreach ($to_accounts as $account) {
                                        $cashier = App\Models\Cashier::where('user_id', $account->customer->user->id)->first();
                                        if ($cashier) {
                                            $accountsGroupedByCashier[$cashier->id]['name'] = $cashier->cashier_name;
                                            $accountsGroupedByCashier[$cashier->id]['accounts'][] = $account;
                                        } else {
                                            // Handle case where there is no cashier
                                            $accountsGroupedByCashier['Unknown Cashier']['name'] = 'Unknown Cashier';
                                            $accountsGroupedByCashier['Unknown Cashier']['accounts'][] = $account;
                                        }
                                    }
                                @endphp

                                @foreach($accountsGroupedByCashier as $cashierId => $group)
                                    <optgroup label="{{ $group['name'] }}">
                                        @foreach($group['accounts'] as $account)
                                            <option value="{{ $account->id }}">
                                                {{ $account->account_title }} ({{ $account->calculateTotalBalance() }}) {{$account->currency->currency_name}}
                                            </option>
                                        @endforeach
                                    </optgroup>
                                @endforeach

                            </select>
                            @error('to_account_id') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>


                        <!-- Input for Amount -->
                        <div class="mb-3">
                            <label for="transaction_amount" class="form-label"> @lang('word.TransactionAmount')</label>
                            <input type="number" id="transaction_amount" class="form-control" wire:model="transaction_amount" placeholder="<?php echo trans('word.TransactionAmount'); ?>">
                            @error('transaction_amount') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>

                        <!-- Input for Note -->
                        <div class="mb-3">
                            <label for="note" class="form-label"> @lang('word.Note')</label>
                            <textarea id="note" class="form-control" wire:model="note" ></textarea>
                            @error('note') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" wire:click="closeModal"> @lang('word.Close')</button>
                        <button type="button" class="btn btn-primary" wire:click="submit"> @lang('word.Save')</button>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>
