<div>
   <!-- Button to Open Modal for Creating New Transaction -->
    <script src="//cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>

    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  
    <button class="btn btn-primary" wire:click="openModal">@lang('word.TransactionForm')</button>

    <!-- Transactions List -->
    @if (session('success'))
        <div class="alert alert-primary alert-dismissible fade show" role="alert">
            {{ session('success') }}
        </div>
    @endif

    <div class="card mt-4">
        <div class="card-body">
            <div class="filters mb-3">
                <div class="row">
                    <!-- Account Selection -->
                    @php
                        // OPTIMIZATION: Cache this query result
                        $customer_cashiers_ids = Cache::remember('customer_cashiers_ids', 3600, function() {
                            return App\Models\Customer::where('customer_name', 'Cashiers')->pluck('id');
                        });
                    @endphp
                    <div class="col-4">
                        <label for="customer_account">@lang('word.Account') (Optional)</label>
                        @livewire('components.custom-select', [
                            'label' => '',
                            'placeholder' => __('word.SelectAccount') . ' (' . __('word.Optional') . ')',
                            'identifier' => "filters.customer_account",
                            'options' => App\Models\Account::where('customer_id', '!=', 1)
                                ->whereNotIn('customer_id', $customer_cashiers_ids)
                                ->with('customer:id,customer_name', 'currency:id,currency_name')
                                ->get()
                                ->mapWithKeys(function ($account) {
                                    return [
                                        $account->id => "({$account->currency->currency_name}) - {$account->customer->customer_name} ({$account->customer->id})"
                                    ];
                                }),
                        ], key('select-customer-account'))
                        @error('filters.customer_account') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                    <div class="col-md-3">
                        <label for="startDate">@lang('word.FromDate')</label>
                        <input type="date" id="startDate" class="form-control" wire:model.lazy="startDate">
                        @error('startDate') <span class="text-danger small">{{ $message }}</span> @enderror
                    </div>
                    <div class="col-md-3">
                        <label for="endDate">@lang('word.ToDate')</label>
                        <input type="date" id="endDate" class="form-control" wire:model.lazy="endDate">
                        @error('endDate') <span class="text-danger small">{{ $message }}</span> @enderror
                    </div>
                    <div class="col-md-1 d-flex align-items-end">
                        <button type="button" class="btn btn-primary" wire:click="$refresh" wire:loading.attr="disabled">
                            <span wire:loading.remove wire:target="$refresh">@lang('word.Search')</span>
                            <span wire:loading wire:target="$refresh">...</span>
                        </button>
                    </div>
                    <div class="col-md-1 d-flex align-items-end">
                        <button type="button" class="btn btn-secondary" wire:click="resetFilters">@lang('word.Reset')</button>
                    </div>
                </div>
                
                <!-- Filter Status Display -->
                <div class="row mt-2">
                    <div class="col-12">
                        <small class="text-muted">
                            @if($filters['customer_account'])
                                <span class="badge bg-info me-1">Account: Selected</span>
                            @else
                                <span class="badge bg-secondary me-1">Account: All</span>
                            @endif
                            
                            @if($startDate && $endDate)
                                @if($startDate === $endDate)
                                    <span class="badge bg-primary me-1">Date: {{ $startDate }}</span>
                                @else
                                    <span class="badge bg-primary me-1">Date Range: {{ $startDate }} to {{ $endDate }}</span>
                                @endif
                            @elseif($startDate)
                                <span class="badge bg-primary me-1">From: {{ $startDate }}</span>
                            @elseif($endDate)
                                <span class="badge bg-primary me-1">To: {{ $endDate }}</span>
                            @else
                                <span class="badge bg-secondary me-1">Date: All</span>
                            @endif
                            
                            <span class="badge bg-success me-1">Results: {{ $account_transactions->total() }} transactions</span>
                        </small>
                    </div>
                </div>
            </div>
    
            @php
                $user = Auth::user();
                $isSuperAdmin = $user->hasRole('super-admin');
            @endphp

            <div class="table-responsive mt-4">
                @if($account_transactions->count() > 0)
                    <table class="table table-border table-hover" id="transactionTable">
                        <thead>
                            <tr>
                                <th>@lang('word.TransactionType')</th>
                                <th>@lang('word.ClientName')</th>
                                <th>@lang('word.TransactionAmount')</th>
                                <th>@lang('word.Fee')</th>
                                <th>@lang('word.Balance')</th>
                                <th>@lang('word.TransactionDate')</th>
                                <th>@lang('word.TransactionTime')</th>
                                <th>بۆ حسابی</th>
                                <th>@lang('word.PersonName')</th>
                                <th>@lang('word.Note')</th>
                                <th class="no-print">@lang('word.Actions')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $customer_balance = 0;
                                $currency_name = '';
                                $previous_balance = 0;
                            @endphp
                            @foreach ($account_transactions as $transaction)
                            @if ($transaction->from_account->customer->id == 1 || $transaction->from_account->customer->customer_name == 'Cashiers')
                                @continue
                            @endif

                            @php
                                $currency_name = $transaction->account->currency->currency_name;
                                $previous_balance = $customer_balance;
                                $transaction_amount = $transaction->transaction_amount;
                                
                                // OPTIMIZATION: Use the already loaded fees relationship
                                $transaction_fee = $transaction->fees->sum('fee_amount') ?? 0; 
                            
                                if ($transaction->transaction_type == 'deposit') {
                                    $net_amount = $transaction_amount - $transaction_fee;
                                    $customer_balance += $net_amount;
                                } elseif (in_array($transaction->transaction_type, ['transfer', 'withdrawal'])) {
                                    $total_deduction = $transaction_amount + $transaction_fee;
                                    $customer_balance -= $total_deduction;
                                }
                            
                                $balance_change = $customer_balance - $previous_balance;
                            @endphp
                            <tr>
                                <td>
                                    @if($transaction->transaction_type == 'deposit')
                                        {{ __('word.Deposit') }}
                                    @elseif($transaction->transaction_type == 'transfer')
                                        {{ __('word.Transfer') }}
                                    @elseif($transaction->transaction_type == 'withdrawal')
                                        {{ __('word.Withdrawal') }}
                                    @endif
                                </td>
                                <td>{{ $transaction->from_account->customer->customer_name ?? 'N/A' }} ({{ $transaction->from_account->customer->id ?? 'N/A' }})</td>
                                <td>{{ number_format($transaction->transaction_amount, 0, '.', ',') }} {{ $transaction->account->currency->currency_name }}</td>
                                <td>{{ $transaction->get_fee }}</td>
                                <td>
                                    {{ number_format($customer_balance, 0, '.', ',') }} {{ $currency_name }}
                                    @if ($balance_change > 0)
                                        <span style="color: green;">▲</span>
                                    @elseif ($balance_change < 0)
                                        <span style="color: red;">▼</span>
                                    @endif
                                </td>
                                <td>{{ $transaction->transaction_date->format('Y-m-d') }}</td>
                                <td>{{ $transaction->transaction_time }}</td>
                                <td>{{ $transaction->to_account->customer->customer_name ?? 'N/A' }}</td>
                                <td>{{ $transaction->person_name ?? '-' }}</td>
                                <td>{{ $transaction->note }}</td>
                                <td class="text-center no-print">
                                    <div class="btn-group" role="group" aria-label="Row Actions">
                                        @can('update', $transaction)
                                            <a target="_blank" href="{{ route('invoice', [$transaction->id]) }}">
                                                <button type="button" class="btn btn-icon btn-outline-dark m-1">
                                                    <i class="fa fa-print"></i>
                                                </button>
                                            </a>
                                        @endcan

                                        @php
                                        $model = "AccountTransaction";
                                        @endphp
                                        <a href="{{ url('/upload/'.$model.'/'.$transaction->id) }}">
                                            <button data-bs-toggle="tooltip" data-bs-placement="top" data-bs-custom-class="tooltip-dark" title="File" type="button" class="btn btn-icon btn-outline-info m-1">
                                                <i class="fa fa-file"></i>
                                            </button>
                                        </a>
                                        
                                        @if ($isSuperAdmin)
                                            <!-- OPTIMIZATION: Add loading state to edit button -->
                                            <button 
                                                data-bs-toggle="tooltip"
                                                data-bs-placement="top"
                                                data-bs-custom-class="tooltip-primary"
                                                title="Edit"
                                                type="button"
                                                class="btn btn-icon btn-outline-primary m-1"
                                                wire:click="editTransaction('{{ $transaction->transaction_group_id }}')"
                                                wire:loading.attr="disabled"
                                                wire:target="editTransaction">
                                                <i class="fa fa-edit" wire:loading.remove wire:target="editTransaction"></i>
                                                <div class="spinner-border spinner-border-sm" role="status" wire:loading wire:target="editTransaction">
                                                    <span class="visually-hidden">Loading...</span>
                                                </div>
                                            </button>

                                            @if($transaction->transaction_group_id) 
                                                <button 
                                                    wire:click="deleteTransaction('{{ $transaction->transaction_group_id }}')"
                                                    data-bs-toggle="tooltip"
                                                    data-bs-placement="top"
                                                    data-bs-custom-class="tooltip-dark"
                                                    title="{{ trans('word.Delete') }}"
                                                    type="button"
                                                    class="btn btn-icon btn-outline-danger m-1"
                                                    onclick="confirm('{{ trans('word.ConfirmDelete') }}') || event.stopImmediatePropagation()">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            @endif
                                        @endif
                                    </div>
                                </td>
                            </tr>
                            @endforeach

                            <tr>
                                <td colspan="4" class="text-end"><strong>{{ __('کۆی گشتی') }}</strong></td>
                                <td><strong>{{ number_format($customer_balance, 0, '.', ',') }} {{ $currency_name }}</strong></td>
                                <td colspan="6"></td>
                            </tr>
                        </tbody>
                    </table>
                    
                    <div class="d-flex justify-content-between align-items-center mt-4">
                        <div>
                            <small class="text-muted">
                                Showing {{ $account_transactions->firstItem() }} to {{ $account_transactions->lastItem() }} 
                                of {{ $account_transactions->total() }} transactions
                            </small>
                        </div>
                        <div>
                            {{ $account_transactions->links(data: ['scrollTo' => false]) }}
                        </div>
                    </div>
                @else
                    <div class="alert alert-info text-center">
                        <i class="fa fa-info-circle me-2"></i>
                        <strong>No transactions found</strong>
                        <p class="mb-0 mt-2">
                            @if($filters['customer_account'] || $startDate || $endDate)
                                Try adjusting your filters or 
                                <button type="button" class="btn btn-link p-0" wire:click="resetFilters">reset filters</button>
                                to see all transactions.
                            @else
                                No transactions are available at the moment.
                            @endif
                        </p>
                    </div>
                @endif
            </div>
        </div>
    </div>
    
    <!-- Print Script -->
    <script>
        document.getElementById('printButton').addEventListener('click', function () {
            const printContents = document.getElementById('transactionTable').outerHTML;
            const originalContents = document.body.innerHTML;
    
            // Temporarily replace the body content with the table for printing
            document.body.innerHTML = `<style>
                .no-print { display: none !important; }
                table { width: 100%; border-collapse: collapse; }
                table th, table td { border: 1px solid #ddd; padding: 8px; }
            </style>${printContents}`;
    
            // Trigger print
            window.print();
    
            // Restore the original body content
            document.body.innerHTML = originalContents;
            window.location.reload(); // Reload the page to reinitialize JavaScript
        });
    </script>
    

    <!-- OPTIMIZED Edit Modal - Show loading state -->
    @if($showEditModal)
        <div class="modal fade show d-block" tabindex="-1" role="dialog">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">نوێکردنەوەی جولە</h5>
                        <button type="button" class="btn btn-primary close" wire:click="$set('showEditModal', false)">
                            &times;
                        </button>
                    </div>
                    <div class="modal-body">
                        <!-- Show loading spinner while data is being loaded -->
                        <div wire:loading wire:target="editTransaction" class="text-center p-4">
                            <div class="spinner-border" role="status">
                                <span class="visually-hidden">Loading...</span>
                            </div>
                            <p class="mt-2">Loading transaction data...</p>
                        </div>

                        <!-- Form content (hidden while loading) -->
                        <div wire:loading.remove wire:target="editTransaction">
                            <form wire:submit.prevent="updateTransaction">
                                <div class="form-group">
                                    <label>جۆری جولە</label>
                                    <select class="form-control" wire:model="editTransactionType">
                                        <option value="deposit">@lang('word.Deposit')</option>
                                        <option value="withdrawal">@lang('word.Withdrawal')</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label>@lang('word.TransactionAmount')</label>
                                    <input type="text" x-mask:dynamic="$money($input, '.', ',', 4)" class="form-control" wire:model="editTransactionAmount">
                                </div>

                                @if(!empty($transactionFees) && count($transactionFees) > 0)
                                    <div class="form-group">
                                        <label>@lang('word.Fee')</label>
                                        <input type="text" class="form-control" wire:model="editTransactionFeeAmount">
                                    </div>
                                @endif

                                <h6>جولە پەیوەندیدارەکان:</h6>
                                <ul class="list-group">
                                    @if($transactions)
                                        @foreach ($transactions as $transaction)
                                            <li class="list-group-item">
                                                <strong>ژمارەیئ جولە:</strong> # {{ $transaction->id }} <br>
                                                <strong>لە حسابی:</strong> {{ optional($transaction->from_account->customer)->customer_name ?? '-' }} <br>
                                                <strong>لۆ حسابی:</strong> {{ optional($transaction->to_account->customer)->customer_name ?? '-' }}
                                            </li>
                                        @endforeach
                                    @endif
                                </ul>

                                <button type="submit" class="btn btn-success mt-2" wire:loading.attr="disabled" wire:target="updateTransaction">
                                    <span wire:loading.remove wire:target="updateTransaction">@lang('word.Save')</span>
                                    <span wire:loading wire:target="updateTransaction">Saving...</span>
                                </button>
                                <button type="button" class="btn btn-secondary mt-2" wire:click="$set('showEditModal', false)">@lang('word.Close')</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show"></div>
    @endif  


    <!-- Modal for Account Transfer -->
    @if($showModal)
        <div class="modal fade show d-block" style="background-color: rgba(0, 0, 0, 0.5);" tabindex="-1">
            <div class="modal-dialog modal-lg"> <!-- Add modal-lg or modal-xl here -->
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">@lang('word.TransactionForm')</h5>
                        <button type="button" class="btn-close" wire:click="closeModal"></button>
                    </div>
                    
                    <div class="modal-body">
                        <div class="row">

                             <!-- Transaction Amount -->
                             <div class="col-6">
                                <div class="form-group text-center">
                                    <input placeholder="<?php echo trans('word.NameCustomerIf'); ?>" type="text" id="create_person_name" class="form-control" wire:model="create_person_name">
                                    @error('create_person_name') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                            </div>

                              <!-- My Get Fee Amount -->
                              <div class="col-6">
                                <div class="form-group text-center">
                                    <input placeholder="<?php echo trans('word.MyFee'); ?>" x-mask:dynamic="$money($input, '.', ',', 4)" type="text" id="create_get_fee" class="form-control" wire:model="create_get_fee">
                                    @error('create_get_fee') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                            </div>
                            
                            <!-- Account Selection -->
                            @php
                                $customer_cashiers_ids = App\Models\Customer::where('customer_name', 'Cashiers')->pluck('id'); // Use pluck to get an array of IDs
                            @endphp
                            <div class="col-6 ">
                                @livewire('components.custom-select', [
                                    'label' => __('word.Account'),
                                    'placeholder' => __('word.Account'),
                                    'identifier' => "filters.account",
                                    'options' => App\Models\Account::where('customer_id', '!=', 1)
                                        ->whereNotIn('customer_id', $customer_cashiers_ids)
                                        ->get() // Get the full collection with relationships
                                        ->mapWithKeys(function ($account) {
                                            return [
                                                $account->id => "({$account->currency->currency_name}) - {$account->customer->customer_name} ({$account->customer->id})"
                                            ];
                                        }),
                                ], key('select-account'))
                                @error('filters.account') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
                            
                            <!-- Transaction Type -->
                            <div class="col-6 mb-3">
                                <label for="transaction_type" class="form-label"> @lang('word.TransactionType')</label>
                                <select wire:model="create_transaction_type" class="form-control" id="transaction_type">
                                    @foreach($transactionTypes as $type)
                                        <option value="{{ $type }}">
                                            @if($type == 'deposit')
                                            {{ __('word.Deposit') }}
                                            @elseif($type == 'withdrawal')
                                            {{ __('word.Withdrawal') }}
                                            @elseif($type == 'transfer')
                                            {{ __('word.Transfer') }}
                                            @endif
                                        </option>
                                    @endforeach
                                </select>
                                @error('create_transaction_type') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>

                            <!-- Transaction Amount -->
                            <div class="col-6 mb-3">
                                <label for="transaction_amount" class="form-label"> @lang('word.TransactionAmount') 
                                    {{-- <b class="text-danger"> ({{convertNumberToWordsKurdishSorani($create_transaction_amount) }})</b> --}}
                                </label>
                                <input x-mask:dynamic="$money($input, '.', ',', 4)" type="text" wire:model="create_transaction_amount" class="form-control" id="transaction_amount">
                                @error('create_transaction_amount') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>

                             <!-- Transaction Fee -->
                             <div class="col-6 mb-3">
                                <label for="transaction_fee" class="form-label"> @lang('word.Fee')</label>
                                <input type="text" x-mask:dynamic="$money($input, '.', ',', 4)" wire:model="create_transaction_fee" class="form-control" id="transaction_fee">
                                @error('create_transaction_fee') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>

                            <!-- File Upload -->
                            <div class="col-12 mb-3">
                                <label for="file" class="form-label">@lang('word.File')</label>
                                <input type="file" class="form-control" wire:model="file" id="file" accept="image/*">
                                @error('file') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>

                            <!-- Note -->
                            <div class="col-12 mb-3">
                                <label for="note" class="form-label"> @lang('word.Note')</label>
                                <textarea wire:model="create_note" class="form-control" id="note"></textarea>
                                @error('create_note') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
                        </div>

                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" wire:click="closeModal"> @lang('word.Close')</button>
                        <button wire:click="saveCreate" type="submit" class="btn btn-primary"> @lang('word.Save')</button>
                    </div>
                </div>
            </div>
        </div>
    @endif




</div>
