
<div>
  <script src="//cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
  <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  <style>
    :root {
      --usd-color: #dc3545;
      --iqd-color: #198754;
      --border-radius: 8px;
    }
    
    .card {
      border-radius: var(--border-radius);
      box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
      transition: all 0.3s ease;
      margin-bottom: 1.5rem;
      border: none;
    }
    
    .card:hover {
      box-shadow: 0 10px 15px rgba(0, 0, 0, 0.1);
    }
    
    .card-header {
      border-radius: var(--border-radius) var(--border-radius) 0 0 !important;
      font-weight: 600;
    }
    
    .usd-card .card-header {
      background-color: var(--usd-color);
      color: white;
    }
    
    .iqd-card .card-header {
      background-color: var(--iqd-color);
      color: white;
    }
    
    .transaction-button {
      width: 100%;
      padding: 12px 20px;
      border: 1px solid #817c19;
      background-color: transparent;
      color: #817c19;
      cursor: pointer;
      border-radius: var(--border-radius);
      transition: all 0.3s ease;
      font-weight: bold;
    }
    
    .transaction-button.active {
      background-color: #817c19;
      color: white;
    }
    
    .action-button {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      gap: 0.5rem;
      padding: 0.5rem 1rem;
      border-radius: var(--border-radius);
      transition: all 0.3s ease;
      text-decoration: none;
      font-weight: 500;
    }
    
    .action-button-usd {
      background-color: rgba(220, 53, 69, 0.1);
      color: var(--usd-color);
      border: 1px solid var(--usd-color);
    }
    
    .action-button-usd:hover {
      background-color: var(--usd-color);
      color: white;
    }
    
    .action-button-iqd {
      background-color: rgba(25, 135, 84, 0.1);
      color: var(--iqd-color);
      border: 1px solid var(--iqd-color);
    }
    
    .action-button-iqd:hover {
      background-color: var(--iqd-color);
      color: white;
    }
    
    .custom-badge {
      font-size: 16px;
      padding: 8px 15px;
      border-radius: 20px;
      display: inline-block;
      margin: 5px;
    }
    
    .table {
      width: 100%;
      margin-bottom: 1rem;
      border-collapse: separate;
      border-spacing: 0;
    }
    
    .table th {
      background-color: #f8f9fa;
      font-weight: 600;
      vertical-align: middle;
    }
    
    .table-hover tbody tr:hover {
      background-color: rgba(0, 0, 0, 0.02);
    }
    
    .table td, .table th {
      vertical-align: middle;
      padding: 0.75rem;
    }
    
    .table-container {
      border-radius: var(--border-radius);
      overflow: hidden;
    }
    
    .form-control {
      border-radius: var(--border-radius);
      padding: 0.75rem;
    }
    
    .btn {
      border-radius: var(--border-radius);
      padding: 0.5rem 1.5rem;
      transition: all 0.3s ease;
    }
    
    .modal-content {
      border-radius: var(--border-radius);
      border: none;
    }
    
    .modal-header {
      border-radius: var(--border-radius) var(--border-radius) 0 0;
    }
    
    .account-section {
      margin-bottom: 2rem;
    }
    
    .section-title {
      margin-bottom: 1.5rem;
      position: relative;
      display: flex;
      align-items: center;
      justify-content: center;
    }
    
    .currency-badge {
      padding: 8px 16px;
      border-radius: 20px;
      color: white;
      font-weight: 600;
      display: inline-block;
    }
    
    .currency-badge-usd {
      background-color: var(--usd-color);
    }
    
    .currency-badge-iqd {
      background-color: var(--iqd-color);
    }
    
    .balance-change-up {
      color: green;
      font-weight: bold;
    }
    
    .balance-change-down {
      color: red;
      font-weight: bold;
    }
    
    .total-footer {
      background-color: #f8f9fa;
      font-weight: bold;
    }
    
    .print-btn {
      background-color: transparent;
      border: 1px solid #212529;
      color: #212529;
      border-radius: 4px;
    }
    
    .print-btn:hover {
      background-color: #212529;
      color: white;
    }
    
    .digital-currency-section {
      background-color: #f8f9fa;
      border-radius: var(--border-radius);
      padding: 1rem;
      margin-top: 1rem;
    }
    
    .currency-radio {
      margin-bottom: 0.5rem;
    }
    
    /* Required field styling */
    .required-field {
      border-left: 3px solid #dc3545;
    }
    
    .required-field:focus {
      border-color: #dc3545;
      box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25);
    }
    
    /* Disabled button styling */
    .btn:disabled {
      opacity: 0.6;
      cursor: not-allowed;
    }
    
    .btn:disabled:hover {
      transform: none;
      box-shadow: none;
    }
    
    /* Warning alert styling */
    .alert-warning {
      background-color: #fff3cd;
      border-color: #ffeaa7;
      color: #856404;
    }
  </style>


  <!-- Customer Selection Card -->
  <div class="row justify-content-center mb-4">
        <div class="col-6">
            <div class="card shadow-sm border-0">
                <div class="card-header bg-white border-bottom-0 pt-4">
                    <h5 class="card-title mb-0 fw-bold">
                        <i class="fa fa-users text-primary me-2"></i> {{ __('word.Customer') }}
                    </h5>
                </div>
                <div class="card-body">
                    @livewire('components.custom-select', [
                        'label' => __('word.Customer'),
                        'placeholder' => __('word.Customer'),
                        'identifier' => "filters.customer",
                        'options' =>  collect($customerOptions),
                    ],
                    key('select-customer'))
                    <small class="text-muted mt-1 d-block">
                        <i class="fa fa-info-circle me-1"></i>
                        ئەم خانەیە پێویستە بۆ دروستکردنی ترەنزەکشن
                    </small>
                    @error('filters.customer') <span class="text-danger small">{{ $message }}</span> @enderror
                    @if(!$filters['customer'])
                        <div class="alert alert-warning mt-2" style="font-size: 12px;">
                            <i class="fas fa-exclamation-triangle me-1"></i>
                            <strong>تێبینی:</strong> دەبێت موشتەرێک هەڵبژێردرێت پێش ئەوەی ترەنزەکشنێک دروست بکرێت
                        </div>
                    @endif
                    
                    @if ($filters['customer'])
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <a target="_blank" href="{{ route('show_customer', $selectedCustomer) }}" 
                                class="btn btn-outline-primary w-100 rounded-3 py-2">
                                <i class="fa fa-bank me-2"></i> کشف حساب
                            </a>
                        </div>
                         <div class="col-sm-6 mb-2">
                              <button wire:click="openConvertSellModal" type="button" class="btn btn-outline-danger w-100">
                                <i class="fa fa-exchange me-2"></i> کڕین و فرۆشتنی دۆلار
                              </button>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    
        <div class="col-6">
            <div class="card shadow-sm border-0">
                <div class="card-header bg-white border-bottom-0 pt-4">
                    <h5 class="card-title mb-0 fw-bold">
                        <i class="fa fa-calendar text-primary me-2"></i> فلتەر
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-4">
                            <label class="form-label">لە بەرواری</label>
                            <input type="date" 
                                class="form-control" 
                                wire:model.live="startDate">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">تا بەرواری</label>
                            <input type="date" 
                                class="form-control" 
                                wire:model.live="endDate">
                        </div>
                        <div class="col-md-4 d-flex align-items-end">
                            <button type="button" 
                                    class="btn btn-outline-secondary"
                                    wire:click="resetDateFilter">
                                <i class="fa fa-refresh me-1"></i> سفر کردنەوە بۆ ٣ ڕۆژ
                            </button>
                        </div>
                    </div>
                    <div class="mt-2">
                        <small class="text-muted">
                            <i class="fa fa-info-circle me-1"></i>
                           پیشاندانی داتا لە {{ $startDate }} بۆ {{ $endDate }}
                        </small>
                    </div>
                </div>
            </div>
        </div>
    </div>

  <!-- Modal for Currency Exchange -->
  @if($showConvertSellModal)
  <div class="modal fade show d-block" style="background-color: rgba(0, 0, 0, 0.5); " tabindex="-1">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">کڕین و فرۆشتنی دۆلار</h5>
          <button type="button" class="btn-close" wire:click="closeConvertSellModal"></button>
        </div>
        <div class="modal-body">
          <!-- Transaction Type Selection -->
          <div class="row mb-4">
            <div class="col-md-6 mb-3">
              <button type="button" class="transaction-button {{ $transaction_type === 'sell' ? 'active' : '' }}" wire:click="$set('transaction_type', 'sell')">
                <i class="fa fa-arrow-right me-2"></i> پێی دەفرۆشم
              </button>
            </div>
            <div class="col-md-6 mb-3">
              <button type="button" class="transaction-button {{ $transaction_type === 'buy' ? 'active' : '' }}" wire:click="$set('transaction_type', 'buy')">
                <i class="fa fa-arrow-left me-2"></i> لێی دەکڕم
              </button>
            </div>
            @error('transaction_type') <div class="col-12"><span class="text-danger">{{ $message }}</span></div> @enderror
          </div>

          <div class="row">
            <div class="col-md-6 mb-3">
              <div class="form-group">
                <label class="form-label fw-bold">بڕی پارەکە بنوسە بۆ گۆڕین</label>
                <input type="text" x-mask:dynamic="$money($input, '.', ',', 4)" wire:model.live="amountToConvert" class="form-control">
                @error('amountToConvert') <span class="text-danger">{{ $message }}</span> @enderror
              </div>
            </div>
            <div class="col-md-6 mb-3">
              <div class="form-group">
                <label class="form-label fw-bold">ڕێژەی گۆڕین بنوسە</label>
                <input type="text" x-mask:dynamic="$money($input, '.', ',', 4)" wire:model.live="rate" class="form-control">
                @error('rate') <span class="text-danger">{{ $message }}</span> @enderror
              </div>
            </div>
          </div>
          
          <div class="row">
            <div class="col-md-6 mb-3">
              <label class="form-label fw-bold">هەڵبژاردنی گۆڕین</label>
              <div class="d-flex gap-4 mt-2">
                <div class="form-check">
                  <input type="radio" class="form-check-input" id="multiply" wire:model.live="operationType" value="multiply">
                  <label class="form-check-label" for="multiply">جاران</label>
                </div>
                <div class="form-check">
                  <input type="radio" class="form-check-input" id="divide" wire:model.live="operationType" value="divide">
                  <label class="form-check-label" for="divide">دابەش</label>
                </div>
              </div>
              @error('operationType') <span class="text-danger">{{ $message }}</span> @enderror
            </div>
            <div class="col-md-6 mb-3">
              <div class="form-group">
                <label class="form-label fw-bold">تێبینی</label>
                <textarea wire:model="convert_note" class="form-control" rows="3"></textarea>
                @error('convert_note') <span class="text-danger">{{ $message }}</span> @enderror
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" wire:click="closeConvertSellModal">@lang('word.Close')</button>
          <button wire:click="saveConvert" type="submit" class="btn btn-primary">
            <i class="fa fa-save me-2"></i> @lang('word.Save')
          </button>
        </div>
      </div>
    </div>
  </div>
  @endif

  <!-- Main Content -->
  <div class="row">
    <!-- USD Section -->
    <div class="col-lg-6">
      <div class="account-section">
        <div class="section-title text-center">
          <span class="currency-badge currency-badge-usd">
            <i class="fa fa-dollar-sign me-2"></i> حسابی دۆلار
          </span>
          
          @if($this->filters['customer'])
            @if($destinationUSDAccount != null)
              <a  href="{{ route('accounts.show', ['account' => $destinationUSDAccount, 'openModal' => 1]) }}" class="ms-3 action-button action-button-usd">
                <i class="fa fa-exchange"></i> گواستنەوەی پارە
              </a>
            @else
              <div class="alert alert-warning mt-2">موشتەری حسابی بە دۆلار نیە.</div>
            @endif
          @endif
        </div>

        <!-- USD Transaction Form -->
        <div class="card usd-card">
          <div class="card-body">
            <div class="row">
              <div class="col-md-6 mb-3">
                <div class="form-group">
                    <label for="create_person_name" class="form-label">@lang('word.NameCustomerIf')</label>
                  <input placeholder="<?php echo trans('word.NameCustomerIf'); ?>" type="text" id="create_person_name" class="form-control" wire:model="create_person_name">
                  @error('create_person_name') <span class="text-danger">{{ $message }}</span> @enderror
                </div>
              </div>

              <div class="col-md-6 mb-3">
                <label for="transaction_type" class="form-label">@lang('word.TransactionType')</label>
                <select wire:model="create_transaction_type" class="form-control" id="transaction_type">
                  @foreach($transactionTypes as $type)
                    <option value="{{ $type }}">
                      @if($type == 'deposit')
                        {{ __('word.Deposit') }}
                      @elseif($type == 'withdrawal')
                        {{ __('word.Withdrawal') }}
                      @elseif($type == 'transfer')
                        {{ __('word.Transfer') }}
                      @endif
                    </option>
                  @endforeach
                </select>
                @error('create_transaction_type') <span class="text-danger">{{ $message }}</span> @enderror
              </div>

              <div class="col-md-6 mb-3">
                <label for="transaction_amount" class="form-label">@lang('word.TransactionAmount')</label>
                <input x-mask:dynamic="$money($input, '.', ',', 4)" type="text" wire:model="create_transaction_amount" class="form-control" id="transaction_amount">
                @error('create_transaction_amount') <span class="text-danger">{{ $message }}</span> @enderror
              </div>

              <div class="col-md-6 mb-3">
                <label for="file" class="form-label">@lang('word.File')</label>
                <input type="file" class="form-control" wire:model="file" id="file" accept="image/*">
                @error('file') <span class="text-danger">{{ $message }}</span> @enderror
              </div>

              <div class="col-12 mb-3">
                <label for="note" class="form-label">@lang('word.Note')</label>
                <textarea wire:model="create_note" class="form-control" id="note" rows="3"></textarea>
                @error('create_note') <span class="text-danger">{{ $message }}</span> @enderror
              </div>
            </div>

            <button wire:click="saveCreateUSD" type="submit" class="btn btn-danger" {{ !$filters['customer'] ? 'disabled' : '' }}>
              <i class="fa fa-save me-2"></i> @lang('word.Save')
            </button>
          </div>
        </div>

        <!-- USD Transactions Table -->
        <div class="card mt-4 usd-card">
          <div class="card-header text-center">
            <i class="fa fa-history me-2"></i> حەرەکەکانی دۆلار
          </div>
          <div class="card-body p-0">
            <div class="table-responsive">
              <table class="table table-hover">
                <thead>
                  <tr>
                    <th>@lang('word.TransactionType')</th>
                    <th>@lang('word.TransactionAmount')</th>
                    <th>@lang('word.Fee')</th>
                    <th>@lang('word.Balance')</th>
                    <th>@lang('word.Date')</th>
                    <th></th>
                  </tr>
                </thead>
                <tbody>
                  @php
                    $customer_balance = 0;
                    $currency_name = '';
                  @endphp
                  @if ($USDAccount)
                    @php
                      $previous_balance = 0;
                    @endphp
                    @forelse ($USDAccount->relatedTransactions
                      ->filter(fn($transaction) => $transaction->transaction_type !== 'fee')
                      as $transaction)
                      @php
                        $currency_name = $transaction->account->currency->currency_name;
                        $previous_balance = $customer_balance;
                        $transaction_amount = $transaction->transaction_amount;
                        $transaction_fee = $transaction->fees->sum('fee_amount') ?? 0;
                        
                        if ($transaction->transaction_type == 'deposit') {
                          $net_amount = $transaction_amount - $transaction_fee;
                          $customer_balance += $net_amount;
                        } elseif (in_array($transaction->transaction_type, ['transfer', 'withdrawal'])) {
                          $total_deduction = $transaction_amount + $transaction_fee;
                          $customer_balance -= $total_deduction;
                        }
                        
                        $balance_change = $customer_balance - $previous_balance;
                      @endphp
                      <tr>
                        <td>
                          @if($transaction->transaction_type == 'deposit')
                            <span class="badge bg-success">{{ __('word.Deposit') }}</span>
                          @elseif($transaction->transaction_type == 'withdrawal')
                            <span class="badge bg-danger">{{ __('word.Withdrawal') }}</span>
                          @elseif($transaction->transaction_type == 'transfer')
                            <span class="badge bg-primary">{{ __('word.Transfer') }}</span>
                          @endif
                        </td>
                        <td>{{ number_format($transaction->transaction_amount, 0, '.', ',') }}</td>
                        <td>{{ $transaction->get_fee }}</td>
                        <td>
                          {{ number_format($customer_balance, 0, '.', ',') }}
                          @if ($balance_change > 0)
                            <span class="balance-change-up">▲</span>
                          @elseif ($balance_change < 0)
                            <span class="balance-change-down">▼</span>
                          @endif
                        </td>
                        <td>{{ $transaction->transaction_time }} - {{ $transaction->transaction_date->format('Y-m-d') }}</td>
                        <td>
                          <a target="_blank" href="{{ route('invoice', [$transaction->id]) }}" class="btn btn-sm print-btn">
                            <i class="fa fa-print"></i>
                          </a>
                        </td>
                      </tr>
                    @empty
                      <tr>
                        <td colspan="6" class="text-center">@lang('word.Empty')</td>
                      </tr>
                    @endforelse
                  @else
                    <tr>
                      <td colspan="6" class="text-center">@lang('word.NoAccountSelected')</td>
                    </tr>
                  @endif
                </tbody>
                <tfoot>
                  <tr class="total-footer">
                    <td colspan="3" class="text-end"><strong>{{ __('کۆی گشتی') }}</strong></td>
                    <td><strong>{{ number_format($customer_balance, 0, '.', ',') }} {{ $currency_name }}</strong></td>
                    <td colspan="2"></td>
                  </tr>
                </tfoot>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
    
    <!-- IQD Section -->
    <div class="col-lg-6">
      <div class="account-section">
        <div class="section-title text-center">
          <span class="currency-badge currency-badge-iqd">
            <i class="fa fa-money-bill-wave me-2"></i> حسابی دینار
          </span>
          
          @if($this->filters['customer'])
            @if($destinationIQDAccount != null)
              <a  href="{{ route('accounts.show', ['account' => $destinationIQDAccount, 'openModal' => 1]) }}" class="ms-3 action-button action-button-iqd">
                <i class="fa fa-exchange"></i> گواستنەوەی پارە
              </a>
            @else
              <div class="alert alert-warning mt-2">موشتەری حسابی بە دینار نیە.</div>
            @endif
          @endif
        </div>

        <!-- IQD Transaction Form -->
        <div class="card iqd-card">
          <div class="card-body">
            <div class="row">
              <div class="col-md-6 mb-3">
                <div class="form-group">
                    <label for="create_person_name_IQD" class="form-label">@lang('word.NameCustomerIf')</label>
                  <input placeholder="<?php echo trans('word.NameCustomerIf'); ?>" type="text" id="create_person_name_IQD" class="form-control" wire:model="create_person_name_IQD">
                  @error('create_person_name_IQD') <span class="text-danger">{{ $message }}</span> @enderror
                </div>
              </div>

              <div class="col-md-6 mb-3">
                <label for="transaction_type_IQD" class="form-label">@lang('word.TransactionType')</label>
                <select wire:model="create_transaction_type_IQD" class="form-control" id="transaction_type_IQD">
                  @foreach($transactionTypes as $type)
                    <option value="{{ $type }}">
                      @if($type == 'deposit')
                        {{ __('word.Deposit') }}
                      @elseif($type == 'withdrawal')
                        {{ __('word.Withdrawal') }}
                      @elseif($type == 'transfer')
                        {{ __('word.Transfer') }}
                      @endif
                    </option>
                  @endforeach
                </select>
                @error('create_transaction_type_IQD') <span class="text-danger">{{ $message }}</span> @enderror
              </div>

              <div class="col-md-6 mb-3">
                <label for="transaction_amount_IQD" class="form-label">@lang('word.TransactionAmount')</label>
                <input x-mask:dynamic="$money($input, '.', ',', 4)" type="text" wire:model="create_transaction_amount_IQD" class="form-control" id="transaction_amount_IQD">
                @error('create_transaction_amount_IQD') <span class="text-danger">{{ $message }}</span> @enderror
              </div>

              <div class="col-md-6 mb-3">
                <div class="form-check form-switch mt-4">
                  <input class="form-check-input" type="checkbox" id="showDigitalCurrency" wire:model.live="showDigitalCurrency">
                  <label class="form-check-label" for="showDigitalCurrency">دیجیتال</label>
                </div>
              
                @if ($showDigitalCurrency)
                  <div class="digital-currency-section mt-2">
                    <div class="row">
                      @foreach ($digitalCurrencies as $index => $currency)
                        <div class="col-6">
                          <div class="form-check currency-radio">
                            <input type="radio" id="currency_{{ $currency->id }}" 
                                   wire:model="selectedDigitalCurrency"
                                   value="{{ $currency->id }}" 
                                   class="form-check-input">
                            <label for="currency_{{ $currency->id }}" class="form-check-label">
                              {{ $currency->currency_name }}
                            </label>
                          </div>
                        </div>
                      @endforeach
                    </div>
                  </div>
                @endif
              
                @error('selectedDigitalCurrency') 
                  <span class="text-danger">{{ $message }}</span> 
                @enderror
              </div>

              <div class="col-md-6 mb-3">
                <label for="file_IQD" class="form-label">@lang('word.File')</label>
                <input type="file" class="form-control" wire:model="file_IQD" id="file_IQD" accept="image/*">
                @error('file_IQD') <span class="text-danger">{{ $message }}</span> @enderror
              </div>

              <div class="col-md-6 mb-3">
                <label for="note_IQD" class="form-label">@lang('word.Note')</label>
                <textarea wire:model="create_note_IQD" class="form-control" id="note_IQD" rows="3"></textarea>
                @error('create_note_IQD') <span class="text-danger">{{ $message }}</span> @enderror
              </div>
            </div>

            <button wire:click="saveCreateIQD" type="submit" class="btn btn-success" {{ !$filters['customer'] ? 'disabled' : '' }}>
              <i class="fa fa-save me-2"></i> @lang('word.Save')
            </button>
          </div>
        </div>

        <!-- IQD Transactions Table -->
        <div class="card mt-4 iqd-card">
          <div class="card-header text-center">
            <i class="fa fa-history me-2"></i> حەرەکەکانی دینار
          </div>
          <div class="card-body p-0">
            <div class="table-responsive">
              <table class="table table-hover">
                <thead>
                  <tr>
                    <th>@lang('word.TransactionType')</th>
                    <th>@lang('word.TransactionAmount')</th>
                    <th>@lang('word.Fee')</th>
                    <th>@lang('word.Balance')</th>
                    <th>@lang('word.Date')</th>
                    <th></th>
                  </tr>
                </thead>
                <tbody>
                  @php
                    $customer_balance = 0;
                    $currency_name = '';
                  @endphp
                  @if ($IQDAccount)
                    @forelse ($IQDAccount->relatedTransactions
                      ->filter(fn($transaction) => $transaction->transaction_type !== 'fee')
                      as $transaction)
                      @php
                        $currency_name = $transaction->account->currency->currency_name;
                        $previous_balance = $customer_balance;
                        $transaction_amount = $transaction->transaction_amount;
                        $transaction_fee = $transaction->fees->sum('fee_amount') ?? 0;
                        
                        if ($transaction->transaction_type == 'deposit') {
                          $net_amount = $transaction_amount - $transaction_fee;
                          $customer_balance += $net_amount;
                        } elseif (in_array($transaction->transaction_type, ['transfer', 'withdrawal'])) {
                          $total_deduction = $transaction_amount + $transaction_fee;
                          $customer_balance -= $total_deduction;
                        }
                        
                        $balance_change = $customer_balance - $previous_balance;
                      @endphp
                      <tr>
                        <td>
                          @if($transaction->transaction_type == 'deposit')
                            <span class="badge bg-success">{{ __('word.Deposit') }}</span>
                          @elseif($transaction->transaction_type == 'withdrawal')
                            <span class="badge bg-danger">{{ __('word.Withdrawal') }}</span>
                          @elseif($transaction->transaction_type == 'transfer')
                            <span class="badge bg-primary">{{ __('word.Transfer') }}</span>
                          @endif
                        </td>
                        <td>{{ number_format($transaction->transaction_amount, 0, '.', ',') }}</td>
                        <td>{{ $transaction->get_fee }}</td>
                        <td>
                          {{ number_format($customer_balance, 0, '.', ',') }}
                          @if ($balance_change > 0)
                            <span class="balance-change-up">▲</span>
                          @elseif ($balance_change < 0)
                            <span class="balance-change-down">▼</span>
                          @endif
                        </td>
                        <td>{{ $transaction->transaction_time }} - {{ $transaction->transaction_date->format('Y-m-d') }}</td>
                        <td>
                          <a target="_blank" href="{{ route('invoice', [$transaction->id]) }}" class="btn btn-sm print-btn">
                            <i class="fa fa-print"></i>
                          </a>
                        </td>
                    </tr>
                    @empty
                      <tr>
                        <td colspan="6" class="text-center">@lang('word.Empty')</td>
                      </tr>
                    @endforelse
                  @else
                    <tr>
                      <td colspan="6" class="text-center">@lang('word.NoAccountSelected')</td>
                    </tr>
                  @endif
                </tbody>
                <tfoot>
                  <tr class="total-footer">
                    <td colspan="3" class="text-end"><strong>{{ __('کۆی گشتی') }}</strong></td>
                    <td><strong>{{ number_format($customer_balance, 0, '.', ',') }} {{ $currency_name }}</strong></td>
                    <td colspan="2"></td>
                  </tr>
                </tfoot>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<script>
document.addEventListener('livewire:init', () => {
    // Function to check if customer is selected
    function checkCustomerSelection() {
        const customerSelect = document.querySelector('[wire\\:model="filters.customer"]');
        const usdButton = document.querySelector('button[wire\\:click="saveCreateUSD"]');
        const iqdButton = document.querySelector('button[wire\\:click="saveCreateIQD"]');
        
        if (customerSelect && usdButton && iqdButton) {
            const hasCustomer = customerSelect.value && customerSelect.value !== '';
            
            // Enable/disable buttons based on customer selection
            usdButton.disabled = !hasCustomer;
            iqdButton.disabled = !hasCustomer;
            
            // Add visual feedback
            if (!hasCustomer) {
                usdButton.title = 'دەبێت موشتەرێک هەڵبژێردرێت';
                iqdButton.title = 'دەبێت موشتەرێک هەڵبژێردرێت';
            } else {
                usdButton.title = '';
                iqdButton.title = '';
            }
        }
    }
    
    // Check on initial load
    checkCustomerSelection();
    
    // Check when customer selection changes
    Livewire.hook('message.processed', (message, component) => {
        checkCustomerSelection();
    });
    
    // Also check on DOM updates
    Livewire.hook('morph.updated', (el) => {
        checkCustomerSelection();
    });
    
    // Add click event listeners to prevent submission without customer
    document.addEventListener('click', function(e) {
        if (e.target.matches('button[wire\\:click="saveCreateUSD"], button[wire\\:click="saveCreateIQD"]')) {
            const customerSelect = document.querySelector('[wire\\:model="filters.customer"]');
            if (!customerSelect || !customerSelect.value || customerSelect.value === '') {
                e.preventDefault();
                e.stopPropagation();
                
                // Show alert
                if (typeof toastr !== 'undefined') {
                    toastr.warning('دەبێت موشتەرێک هەڵبژێردرێت پێش ئەوەی ترەنزەکشنێک دروست بکرێت', 'تێبینی');
                } else {
                    alert('دەبێت موشتەرێک هەڵبژێردرێت پێش ئەوەی ترەنزەکشنێک دروست بکرێت');
                }
                
                // Highlight the customer field
                if (customerSelect) {
                    customerSelect.style.borderColor = '#dc3545';
                    customerSelect.style.boxShadow = '0 0 0 0.2rem rgba(220, 53, 69, 0.25)';
                    
                    // Remove highlight after 3 seconds
                    setTimeout(() => {
                        customerSelect.style.borderColor = '';
                        customerSelect.style.boxShadow = '';
                    }, 3000);
                }
            }
        }
    });
});
</script>

